/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.aca.algox.costcalc.AcaResultFinalResultVO;

public class ActCarryNoMainDetailCalcFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta srcMeta;
    private Map<Long, Map<Long, AcaResultFinalResultVO>> calcCostobjectFinalResultMap;

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public ActCarryNoMainDetailCalcFunction(RowMeta rowMeta, Map<Long, Map<Long, AcaResultFinalResultVO>> calcCostobjectFinalResultMap) {
        this.srcMeta = rowMeta;
        this.calcCostobjectFinalResultMap = calcCostobjectFinalResultMap;
    }

    public void reduce(Iterable<RowX> iter, Collector col) {
        ArrayList iterRows = Lists.newArrayList();
        for (RowX row : iter) {
            iterRows.add(row);
        }
        if (iterRows.isEmpty()) {
            return;
        }
        Long mainCostObjectId = ((RowX)iterRows.get(0)).getLong(this.srcMeta.getFieldIndex("mainCostObjectId"));
        if (!this.calcCostobjectFinalResultMap.containsKey(mainCostObjectId)) {
            return;
        }
        Map<Long, AcaResultFinalResultVO> resultVoMaps = this.calcCostobjectFinalResultMap.get(mainCostObjectId);
        HashMap costObjectRowsMap = Maps.newHashMapWithExpectedSize((int)resultVoMaps.size());
        for (RowX row : iterRows) {
            Long costObjectId = row.getLong(this.srcMeta.getFieldIndex("costObjectId"));
            costObjectRowsMap.computeIfAbsent(costObjectId, t -> Lists.newArrayList()).add(row);
        }
        if (!costObjectRowsMap.containsKey(mainCostObjectId) || ((List)costObjectRowsMap.get(mainCostObjectId)).isEmpty()) {
            return;
        }
        for (RowX row : iterRows) {
            col.collect(row);
        }
    }
}

