/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.LogUtils;

public class ActNoDetailResultSaveFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 8750794000883579691L;
    private static final Log logger = LogFactory.getLog(ActNoDetailResultSaveFunction.class);
    private RowMeta srcMeta;
    private ActCostCalcArgs args;

    public ActNoDetailResultSaveFunction(RowMeta rowMeta, ActCostCalcArgs args) {
        this.srcMeta = rowMeta;
        this.args = args;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList iterRows = Lists.newArrayList();
        for (RowX row : iterable) {
            iterRows.add(row);
        }
        if (iterRows.isEmpty()) {
            return;
        }
        boolean closestatus = false;
        Long mainCostObjectId = ((RowX)iterRows.get(0)).getLong(this.srcMeta.getFieldIndex("mainCostObjectId"));
        Long costCenterId = ((RowX)iterRows.get(0)).getLong(this.srcMeta.getFieldIndex("costcenter"));
        for (RowX row : iterRows) {
            if (!mainCostObjectId.equals(row.getLong(this.srcMeta.getFieldIndex("costObjectId")))) continue;
            costCenterId = row.getLong(this.srcMeta.getFieldIndex("costcenter"));
            Boolean closeSt = row.getBoolean(this.srcMeta.getFieldIndex("closestatus"));
            if (closeSt == null) continue;
            closestatus = closeSt;
        }
        DynamicObject calcResult = this.createCalcResultBill(costCenterId, mainCostObjectId);
        DynamicObjectCollection entryEntity = calcResult.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (RowX row : iterRows) {
            this.map(row, entryEntity, seq, closestatus);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcResult});
    }

    public int map(RowX row, DynamicObjectCollection entryEntity, int seq, boolean closestatus) {
        Long costObjectId = row.getLong(this.srcMeta.getFieldIndex("costObjectId"));
        BigDecimal proPlanQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("proPlanQty")));
        BigDecimal proFinQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("proFinQty")));
        BigDecimal proPdStartQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pdStartQty")));
        BigDecimal proPdStartAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pdStartAmt")));
        BigDecimal proPdSumQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pdSumQty")));
        BigDecimal totalPdSumAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pdSumAmt")));
        BigDecimal proYearSumInputQty = this.args.isFirstPeriod() ? BigDecimal.ZERO : BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("yearSumInputQty")));
        BigDecimal totalYearPdSumAmt = this.args.isFirstPeriod() ? BigDecimal.ZERO : BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("yearSumInputAmt")));
        BigDecimal proYearSumFinishQty = this.args.isFirstPeriod() ? BigDecimal.ZERO : BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("yearSumFinishQty")));
        BigDecimal totalYearSumComAmt = this.args.isFirstPeriod() ? BigDecimal.ZERO : BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("yearSumFinishAmt")));
        BigDecimal proStartAdjQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("startadjqty")));
        BigDecimal totalPdStartAdjAmt = BigDecimal.ZERO;
        BigDecimal proEndAdjQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("endadjqty")));
        BigDecimal sumComQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("sumComQty"))).subtract(proEndAdjQty);
        sumComQty = sumComQty.add(proFinQty);
        BigDecimal sumComAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("sumComAmt")));
        proYearSumFinishQty = proYearSumFinishQty.subtract(proEndAdjQty).add(proFinQty);
        DynamicObject sumEntry = entryEntity.addNew();
        sumEntry.set(seq, (Object)seq++);
        sumEntry.set("type", (Object)"finalResult");
        sumEntry.set("relacostobject", (Object)costObjectId);
        sumEntry.set("relaproducttype", (Object)row.getString(this.srcMeta.getFieldIndex("producttype")));
        sumEntry.set("pdstartqty", (Object)proPdStartQty);
        sumEntry.set("pdstartamount", (Object)proPdStartAmt);
        sumEntry.set("startadjqty", (Object)proStartAdjQty);
        sumEntry.set("startadjamt", (Object)totalPdStartAdjAmt);
        sumEntry.set("pdcurrqty", (Object)proPlanQty);
        sumEntry.set("pdcurramount", (Object)BigDecimal.ZERO);
        sumEntry.set("pdsumqty", (Object)proPlanQty.add(proPdSumQty));
        sumEntry.set("pdsumamount", (Object)totalPdSumAmt);
        sumEntry.set("yearpdsumqty", (Object)proYearSumInputQty.add(proPlanQty));
        sumEntry.set("yearpdsumamount", (Object)totalYearPdSumAmt);
        sumEntry.set("currcomqty", (Object)proFinQty);
        sumEntry.set("currcomamount", (Object)BigDecimal.ZERO);
        BigDecimal proIntryQty = proPdStartQty.add(proStartAdjQty).add(proPlanQty).subtract(proFinQty);
        if (closestatus) {
            proIntryQty = BigDecimal.ZERO;
        }
        if (row.getBigDecimal(this.srcMeta.getFieldIndex("pdEndCheckQty")) != null) {
            proIntryQty = row.getBigDecimal(this.srcMeta.getFieldIndex("pdEndCheckQty"));
        }
        sumEntry.set("pdendqty", (Object)proIntryQty);
        sumEntry.set("pdendamount", (Object)proPdStartAmt.add(totalPdStartAdjAmt));
        sumEntry.set("endadjqty", (Object)proEndAdjQty);
        sumEntry.set("endadjamt", (Object)BigDecimal.ZERO);
        sumEntry.set("sumcomqty", (Object)sumComQty);
        sumEntry.set("sumcomamount", (Object)sumComAmt);
        if (sumComQty.compareTo(BigDecimal.ZERO) != 0 && sumComAmt.compareTo(BigDecimal.ZERO) > 0) {
            sumEntry.set("sumcomunitcost", (Object)sumComAmt.divide(sumComQty, this.args.getPriceScale(), 4));
        }
        sumEntry.set("yearsumcomqty", (Object)proYearSumFinishQty);
        sumEntry.set("yearsumcomamount", (Object)totalYearSumComAmt);
        if (proYearSumFinishQty.compareTo(BigDecimal.ZERO) != 0 && proYearSumFinishQty.compareTo(BigDecimal.ZERO) > 0) {
            sumEntry.set("yearsumcomunitcost", (Object)totalYearSumComAmt.divide(proYearSumFinishQty, this.args.getPriceScale(), 4));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) && this.args.getDebugColVal().equals(String.valueOf(costObjectId))) {
            LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format("ActNoDetailResult-save-final:PD_START_QTY %s,PD_START_AMOUNT %s,PD_START_ADJQTY %s,PD_START_ADJAMOUNT %s,PD_CURR_QTY %s,PD_CURR_AMOUNT %s,PD_SUM_QTY %s,PD_SUM_AMOUNT %s,CURR_COM_QTY %s,CURR_COM_AMOUNT %s,PD_END_QTY %s,PD_END_AMOUNT %s,PD_END_ADJQTY %s,PD_END_ADJAMOUNT %s,SUM_COM_QTY %s,SUM_COM_AMOUNT %s,YEAR_SUM_COM_QTY %s,YEAR_SUM_COM_AMOUNT %s", sumEntry.get("pdstartqty"), sumEntry.get("pdstartamount"), sumEntry.get("startadjqty"), sumEntry.get("startadjamt"), sumEntry.get("pdcurrqty"), sumEntry.get("pdcurramount"), sumEntry.get("pdsumqty"), sumEntry.get("pdsumamount"), sumEntry.get("currcomqty"), sumEntry.get("currcomamount"), sumEntry.get("pdendqty"), sumEntry.get("pdendamount"), sumEntry.get("endadjqty"), sumEntry.get("endadjamt"), sumEntry.get("sumcomqty"), sumEntry.get("sumcomamount"), sumEntry.get("yearsumcomqty"), sumEntry.get("yearsumcomamount")));
        }
        return seq;
    }

    private DynamicObject createCalcResultBill(Long costCenterId, Long mainCostObjectId) {
        DynamicObject calcResult = BusinessDataServiceHelper.newDynamicObject((String)"aca_calcresult");
        calcResult.set("calcreport", (Object)this.args.getCalcReportId());
        calcResult.set("billno", (Object)ID.genStringId());
        calcResult.set("billstatus", (Object)"A");
        calcResult.set("org", (Object)this.args.getOrgId());
        calcResult.set("costaccount", (Object)this.args.getCostAccountId());
        calcResult.set("currency", (Object)this.args.getCurrencyId());
        calcResult.set("bizdate", (Object)TimeServiceHelper.now());
        calcResult.set("period", (Object)this.args.getPeriodId());
        calcResult.set("costcenter", (Object)costCenterId);
        calcResult.set("costobject", (Object)mainCostObjectId);
        Date date = TimeServiceHelper.now();
        Long userId = RequestContext.get().getCurrUserId();
        calcResult.set("billstatus", (Object)"C");
        calcResult.set("createtime", (Object)date);
        calcResult.set("auditdate", (Object)date);
        calcResult.set("modifytime", (Object)date);
        calcResult.set("creator_id", (Object)userId);
        calcResult.set("modifier_id", (Object)userId);
        calcResult.set("auditor_id", (Object)userId);
        return calcResult;
    }
}

