/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.function;

import java.util.ArrayList;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.aca.algox.costcalc.common.ActCalcHelper;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;

public class MatAutoAllocAmtFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(MatAutoAllocAmtFunction.class);
    private ActCostCalcArgs args;
    private int totalBatch;

    public MatAutoAllocAmtFunction(ActCostCalcArgs args, int totalBatch) {
        this.args = args;
        this.totalBatch = totalBatch;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        ArrayList<Long> matColIds = new ArrayList<Long>(1024);
        int batch = -1;
        for (RowX row : rows) {
            matColIds.add(row.getLong(this.sourceRowMeta.getFieldIndex("id")));
            if (batch != -1) continue;
            batch = row.getInteger(this.sourceRowMeta.getFieldIndex("groupId"));
        }
        try {
            long start = System.currentTimeMillis();
            ActCalcHelper.batchDealMatAlloc(this.args, matColIds, batch, this.totalBatch);
            logger.info("\u6750\u6599\u81ea\u52a8\u5206\u914d\u5f53\u524d\u6279\u6570\uff1a{}\uff0c\u603b\u6279\u6570\uff1a{}\uff0c\u8017\u65f6\uff1a{}", new Object[]{batch, this.totalBatch, System.currentTimeMillis() - start});
        }
        catch (Exception ex) {
            logger.error("\u6750\u6599\u5206\u914d\u66f4\u65b0\u91d1\u989d\u62a5\u9519", (Throwable)ex);
            throw ex;
        }
    }
}

