/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costtranfer;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.Collector;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.macc.aca.algox.costtranfer.FinishCostTranFerSaveFunction;
import kd.macc.aca.algox.enums.AcaMutexEnum;
import kd.macc.aca.algox.utils.AcaMutexHelper;
import kd.macc.aca.algox.utils.CostaccountHelper;
import kd.macc.aca.algox.utils.DataSetXHelper;
import kd.macc.aca.algox.utils.PeriodHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import org.apache.commons.lang3.StringUtils;

public class FinishCostTranFerImportHelper {
    private static final Log logger = LogFactory.getLog(FinishCostTranFerImportHelper.class);
    private static final String REPAIR_NO = "-BC";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean finishCostTranFerImport(Long orgId, Long costaccountId, Long periodId, StringBuilder infoMsg) {
        logger.info("\u5b8c\u5de5\u6210\u672c\u7ed3\u8f6c\u5355-\u5f15\u5165\u6570\u636e\u5f00\u59cb");
        String lockErrStr = null;
        try {
            lockErrStr = AcaMutexHelper.requireMutex(AcaMutexEnum.IMP_TRANSFER, costaccountId);
            if (StringUtils.isNotEmpty((CharSequence)lockErrStr)) {
                infoMsg.append(lockErrStr);
                boolean bl = true;
                return bl;
            }
            Long start = System.currentTimeMillis();
            FinishCostTranFerImportHelper.deleteBill(orgId, costaccountId, periodId);
            DataSet calcResultDs = FinishCostTranFerImportHelper.queryCalcResultData(orgId, costaccountId, periodId);
            int pricePricise = CostaccountHelper.getCurrencyPriciseByCostaccountId(costaccountId);
            DataSet calResultCopy = calcResultDs.copy();
            HashSet<Long> subElementSet = new HashSet<Long>(64);
            HashSet<Long> sourceEntryIdSet = new HashSet<Long>(64);
            final HashSet<Long> sourceIdSet = new HashSet<Long>(64);
            for (Row row : calResultCopy) {
                sourceEntryIdSet.add(row.getLong("sourcebillentry"));
                sourceIdSet.add(row.getLong("sourcebill"));
                subElementSet.add(row.getLong("subelement"));
            }
            HashSet needGenIds = Sets.newHashSetWithExpectedSize((int)10);
            HashMap sourceIdToSeq = Maps.newHashMapWithExpectedSize((int)10);
            DataSet existsCalcResultDs = FinishCostTranFerImportHelper.queryExistBill(orgId, costaccountId, periodId, sourceIdSet, needGenIds, sourceIdToSeq);
            Map<Long, String> sourceIdToSeqMap = FinishCostTranFerImportHelper.dealBillNo(sourceIdToSeq);
            DataSet subEleToEleDs = FinishCostTranFerImportHelper.getSubEleToEleDs(subElementSet);
            DataSet costRecordDs = FinishCostTranFerImportHelper.getCalCostRecordSubEntity(costaccountId, periodId, sourceEntryIdSet);
            DataSet factUnitDs = FinishCostTranFerImportHelper.getFactDs(orgId, costaccountId, periodId);
            JobSession session = AlgoX.createSession((String)"costTranFerImport");
            DataSetX calcResultDsX = session.fromInput((Input)new DataSetInput(calcResultDs));
            DataSetX costRecordDsX = session.fromInput((Input)new DataSetInput(costRecordDs));
            DataSetX subEleToEleDsX = session.fromInput((Input)new DataSetInput(subEleToEleDs));
            DataSetX existsCalcResultDsX = session.fromInput((Input)new DataSetInput(existsCalcResultDs));
            DataSetX factUnitDsX = session.fromInput((Input)new DataSetInput(factUnitDs));
            JoinDataSetX calcReverseResultDsx = null;
            if (!needGenIds.isEmpty()) {
                DataSet reverseCalcResultDs = FinishCostTranFerImportHelper.getReverseCalcResult(orgId, costaccountId, periodId, needGenIds);
                DataSet reverseCostRecordDs = FinishCostTranFerImportHelper.getReverseCostrecordInfo(orgId, costaccountId, periodId, needGenIds);
                DataSetX reverseCalcResultDsX = session.fromInput((Input)new DataSetInput(reverseCalcResultDs));
                DataSetX reverseCostRecordDsX = session.fromInput((Input)new DataSetInput(reverseCostRecordDs));
                reverseCostRecordDsX = reverseCostRecordDsX.addFields(new Field[]{new Field("isvoucher", (DataType)DataType.BooleanType)}, new Object[]{Boolean.FALSE});
                reverseCalcResultDsX = reverseCalcResultDsX.groupBy(new String[]{"costcenter", "sourcebill", "sourcebillentry", "costobject", "sub_material", "subelement", "invoutsourcetype"}).max("qty").sum("amount");
                reverseCostRecordDsX = reverseCostRecordDsX.groupBy(new String[]{"bizbillentryid"}).reduceGroup(new GroupReduceFunction(){

                    public RowMeta getResultRowMeta() {
                        return this.sourceRowMeta;
                    }

                    public void reduce(Iterable<RowX> rows, Collector cols) {
                        boolean i = true;
                        for (RowX row : rows) {
                            if (!i) continue;
                            cols.collect(row);
                            break;
                        }
                    }
                });
                reverseCalcResultDsX = reverseCalcResultDsX.leftJoin(subEleToEleDsX).on("subelement", "subelement").select(reverseCalcResultDsX.getRowMeta().getFieldNames(), new String[]{"element"});
                calcReverseResultDsx = reverseCalcResultDsX.leftJoin(reverseCostRecordDsX).on("sourcebill", "bizbillid").on("sourcebillentry", "bizbillentryid").select(new String[]{"costobject", "sub_material", "subelement", "element", "qty", "amount", "invoutsourcetype", "sourcebill", "sourcebillentry", "costcenter"}, reverseCostRecordDsX.getRowMeta().getFieldNames());
                calcReverseResultDsx = calcReverseResultDsx.filter("amount!=0");
                calcReverseResultDsx = calcReverseResultDsx.map(new MapFunction(){
                    private static final long serialVersionUID = 1L;

                    public RowMeta getResultRowMeta() {
                        return this.sourceRowMeta;
                    }

                    public RowX map(RowX paramRowX) {
                        BigDecimal amount = paramRowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("amount"));
                        if (amount != null && amount.compareTo(BigDecimal.ZERO) != 0) {
                            paramRowX.set(this.sourceRowMeta.getFieldIndex("amount"), (Object)amount.negate());
                        }
                        return paramRowX;
                    }
                });
            }
            existsCalcResultDsX = existsCalcResultDsX.filter(new FilterFunction(){

                public boolean test(RowX row) {
                    Long sourcebill = row.getLong(this.sourceRowMeta.getFieldIndex("sourcebill"));
                    return sourceIdSet.contains(sourcebill);
                }
            });
            calcResultDsX = DataSetXHelper.union(calcResultDsX, existsCalcResultDsX);
            calcResultDsX = calcResultDsX.groupBy(new String[]{"costcenter", "sourcebill", "sourcebillentry", "costobject", "sub_material", "subelement", "invoutsourcetype"}).max("qty").sum("amount");
            calcResultDsX = calcResultDsX.leftJoin(subEleToEleDsX).on("subelement", "subelement").select(calcResultDsX.getRowMeta().getFieldNames(), new String[]{"element"});
            if (!"1".equals(CadBgParamUtils.getCadBgParamForString((String)"transferImpAmtZoGen", (String)"0"))) {
                calcResultDsX = calcResultDsX.filter("amount!=0");
            }
            calcResultDsX = calcResultDsX.leftJoin(costRecordDsX).on("sourcebill", "bizbillid").on("sourcebillentry", "bizbillentryid").select(new String[]{"costobject", "sub_material", "subelement", "element", "qty", "amount", "invoutsourcetype", "sourcebill", "sourcebillentry", "costcenter"}, costRecordDsX.getRowMeta().getFieldNames());
            if (calcReverseResultDsx != null) {
                calcResultDsX = DataSetXHelper.union(calcResultDsX, calcReverseResultDsx);
            }
            calcResultDsX = calcResultDsX.leftJoin(factUnitDsX).on("sourcebillentry", "sourcebillentry").select(calcResultDsX.getRowMeta().getFieldNames(), new String[]{"factbillno", "colunit", "srccostcenter"});
            boolean checkTransfer = "0".equals(CadBgParamUtils.getCadBgParamForString((String)"checkTransferImpAmt", (String)"1"));
            DataSetX resultDsx = calcResultDsX.orderBy(new String[]{"factbillno"}).groupBy(new String[]{"sourcebill"}).reduceGroup((GroupReduceFunction)new FinishCostTranFerSaveFunction(sourceIdToSeqMap, pricePricise, checkTransfer));
            DataSetOutput calcInResultSet = new DataSetOutput(resultDsx.getRowMeta());
            resultDsx.output((Output)calcInResultSet);
            try {
                session.commit(2, TimeUnit.HOURS);
            }
            catch (Exception e) {
                logger.error("\u5f15\u5165\u5b8c\u5de5\u6210\u672c\u7ed3\u8f6c\u5355\u51fa\u73b0\u62a5\u9519\uff1a", (Throwable)e);
                throw e;
            }
            logger.info("\u5b8c\u5de5\u6210\u672c\u7ed3\u8f6c\u5355-\u5f15\u5165\u6570\u636e\u7ed3\u675f\uff0c\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
            DataSet resultDs = session.readDataSet(calcInResultSet.getId());
            boolean bl = FinishCostTranFerImportHelper.genInfoMsg(resultDs, infoMsg);
            return bl;
        }
        finally {
            if (StringUtils.isEmpty((CharSequence)lockErrStr)) {
                AcaMutexHelper.releaseMutex(AcaMutexEnum.IMP_TRANSFER, costaccountId);
            }
        }
    }

    private static DataSet getFactDs(Long orgId, Long costaccountId, Long periodId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("appnum", "=", (Object)"aca");
        DynamicObject periodDyn = PeriodHelper.getPeriod(periodId);
        if (periodDyn != null) {
            filter.and("bookdate", ">=", (Object)periodDyn.getDate("begindate"));
            filter.and("bookdate", "<=", (Object)periodDyn.getDate("enddate"));
        }
        DataSet factned = QueryServiceHelper.queryDataSet((String)"fact", (String)"cad_factnedoutputbill", (String)"sourcebillentry,baseunit colunit,costcenter.id srccostcenter,billno factbillno", (QFilter[])filter.toArray(), null);
        return factned.groupBy(new String[]{"sourcebillentry", "factbillno"}).max("colunit").max("srccostcenter").finish();
    }

    private static DataSet getReverseCalcResult(Long orgId, Long costaccountId, Long periodId, Set<Long> needGenIds) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costaccountId);
        filter.and("period", "=", (Object)periodId);
        filter.and("id", "in", needGenIds);
        return QueryServiceHelper.queryDataSet((String)"FINISHCOSTTRANFER", (String)"aca_finishcosttranfer", (String)"entry.costcenter costcenter,entry.relacostobject costobject,entry.sourcebillentry sourcebillentry,sourcebill,entry.material sub_material,entry.subentrycostelement.subelement subelement,entry.subentrycostelement.invoutsourcetype invoutsourcetype,entry.baseqty qty,entry.subentrycostelement.sub_actualcost amount", (QFilter[])filter.toArray(), null);
    }

    private static DataSet getReverseCostrecordInfo(Long orgId, Long costaccountId, Long periodId, Set<Long> needGenIds) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costaccountId);
        filter.and("period", "=", (Object)periodId);
        filter.and("id", "in", needGenIds);
        String selectField = "sourcecalid as id,org calorg,costaccount,billno,calbilltype,billtype,biztype,invscheme,localcurrency,period,bookdate,adminorg,bizdate,'' as fivouchernum,'' as tempvouchernum,'' as dischargevouchernum,'' as carryovervouchernum,'' as feevouchernum,'C' as billstatus,entry.material as material,entry.mversion as mversion,entry.auxpty as assist,entry.lot as lot,entry.baseunit as baseunit,entry.baseqty as baseqty,entry.actualcost as actualcost,entry.warehouse as warehouse,entry.location as location,entry.invtype as invtype,entry.invstatus as invstatus,entry.ownertype as ownertype,entry.owner as owner,entry.calrange as calrange,entry.accounttype as accounttype,sourcebill as bizbillid ,entry.sourcebillentry as bizbillentryid,entry.caldimension as caldimension,entry.unitactualcost as unitactualcost";
        return QueryServiceHelper.queryDataSet((String)"FINISHCOSTTRANFER", (String)"aca_finishcosttranfer", (String)selectField, (QFilter[])filter.toArray(), null);
    }

    private static DataSet queryExistBill(Long orgId, Long costaccountId, Long periodId, Set<Long> sourceIdSet, Set<Long> needGenIds, Map<Long, Set<String>> sourceIdToSeq) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costaccountId);
        filter.and("period", "=", (Object)periodId);
        DataSet calcResult = QueryServiceHelper.queryDataSet((String)"FINISHCOSTTRANFER", (String)"aca_finishcosttranfer", (String)"id,billno,entry.costcenter costcenter,entry.relacostobject costobject,entry.sourcebillentry sourcebillentry,sourcebill,entry.material sub_material,entry.subentrycostelement.subelement subelement,entry.subentrycostelement.invoutsourcetype invoutsourcetype,entry.baseqty qty,0-entry.subentrycostelement.sub_actualcost amount", (QFilter[])filter.toArray(), null);
        DataSet dsCopy = calcResult.copy();
        for (Row row : dsCopy) {
            Long sourcebill = row.getLong("sourcebill");
            String billno = row.getString("billno");
            if (!sourceIdSet.contains(sourcebill)) {
                needGenIds.add(row.getLong("id"));
            }
            sourceIdToSeq.computeIfAbsent(sourcebill, t -> new HashSet(10)).add(billno);
        }
        return calcResult;
    }

    private static Map<Long, String> dealBillNo(Map<Long, Set<String>> sourceIdToSeq) {
        HashMap sourceIdToSeqMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Map.Entry<Long, Set<String>> entry : sourceIdToSeq.entrySet()) {
            String newBillNo;
            Set<String> billNos = entry.getValue();
            String maxNo = null;
            for (String billNo : billNos) {
                if (maxNo != null && billNo.compareTo(maxNo) <= 0) continue;
                maxNo = billNo;
            }
            int seq = 0;
            String srcBillNo = "";
            if (maxNo == null) {
                srcBillNo = "";
            } else if (!maxNo.contains(REPAIR_NO)) {
                srcBillNo = maxNo;
            } else {
                srcBillNo = maxNo.substring(0, maxNo.lastIndexOf(REPAIR_NO));
                String seqStr = maxNo.substring(maxNo.lastIndexOf(REPAIR_NO), maxNo.length()).replace(REPAIR_NO, "");
                seq = Integer.parseInt(seqStr);
            }
            if (srcBillNo.length() > 74) {
                srcBillNo = srcBillNo.substring(0, 74);
            }
            while (billNos.contains(newBillNo = String.format("%s%s%s", srcBillNo, REPAIR_NO, StringUtils.leftPad((String)String.valueOf(++seq), (int)3, (char)'0')))) {
            }
            sourceIdToSeqMap.put(entry.getKey(), newBillNo);
        }
        return sourceIdToSeqMap;
    }

    private static boolean genInfoMsg(DataSet resultDs, StringBuilder infoMsg) {
        String info;
        int sucSize = 0;
        int failSize = 0;
        StringBuilder errMsg = new StringBuilder();
        for (Row row : resultDs) {
            String type = row.getString("type");
            if ("1".equals(type)) {
                ++sucSize;
                continue;
            }
            ++failSize;
            errMsg.append(row.getString("msg"));
        }
        if (sucSize > 0 || failSize == 0) {
            info = String.format(ResManager.loadKDString((String)"\u5f15\u5165\u6210\u529f%s\u6761\u6570\u636e\u3002", (String)"FinishCostTranFerImportHelper_0", (String)"macc-aca-algox", (Object[])new Object[0]), sucSize);
            infoMsg.append(info);
        }
        if (failSize > 0) {
            info = String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25%s\u6761\u6570\u636e\u3002", (String)"FinishCostTranFerImportHelper_1", (String)"macc-aca-algox", (Object[])new Object[0]), failSize);
            infoMsg.append(info);
            infoMsg.append((CharSequence)errMsg);
        }
        return failSize > 0;
    }

    private static void deleteBill(Long orgId, Long costaccountId, Long periodId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costaccountId);
        filter.and("period", "=", (Object)periodId);
        filter.and("creatvoucher", "=", (Object)Boolean.FALSE);
        int delete = DeleteServiceHelper.delete((String)"aca_finishcosttranfer", (QFilter[])filter.toArray());
        logger.info("\u5b8c\u5de5\u6210\u672c\u7ed3\u8f6c\u5355-\u8986\u76d6\u5f15\u5165\uff0c\u6210\u529f\u5220\u9664{}\u6761\u6570\u636e\u3002", (Object)delete);
    }

    private static DataSet queryCalcResultData(Long orgId, Long costaccountId, Long periodId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costaccountId);
        filter.and("period", "=", (Object)periodId);
        boolean isElement = CostaccountHelper.getCostElementByCostAccount(costaccountId);
        if (isElement && "1".equals(CadBgParamUtils.getCadBgParamForString((String)"comTransferImporter", (String)"0"))) {
            isElement = false;
        }
        filter.and("inventoryentryentity.carrytype", "=", (Object)(isElement ? "B" : "A"));
        return QueryServiceHelper.queryDataSet((String)"importDataByHand", (String)"aca_calcresult", (String)"costcenter,inventoryentryentity.sourcebill as sourcebill,inventoryentryentity.sourcebillentry as sourcebillentry,inventoryentryentity.invcostobject as costobject,inventoryentryentity.invcostobject.material as sub_material,inventoryentryentity.inventorysubelement as subelement,inventoryentryentity.inventoryqty as qty,inventoryentryentity.inventoryamount as amount,inventoryentryentity.invoutsourcetype as invoutsourcetype", (QFilter[])filter.toArray(), null).filter("sourcebill != 0");
    }

    private static DataSet getCalCostRecordSubEntity(Long costaccountId, Long periodId, Set<Long> sourceEntryIdSet) {
        QFilter filter = new QFilter("costaccount", "=", (Object)costaccountId);
        filter.and("period", "=", (Object)periodId);
        filter.and("entry.bizbillentryid", "in", sourceEntryIdSet);
        String selectField = "id,calorg,costaccount,billno,calbilltype,billtype,biztype,invscheme,localcurrency,period,bookdate,adminorg,bizdate,isvoucher,fivouchernum,tempvouchernum,dischargevouchernum,carryovervouchernum,feevouchernum,billstatus,entry.material as material,entry.mversion as mversion,entry.assist as assist,entry.lot as lot,entry.baseunit as baseunit,entry.baseqty as baseqty,entry.actualcost as actualcost,entry.warehouse as warehouse,entry.location as location,entry.invtype as invtype,entry.invstatus as invstatus,entry.ownertype as ownertype,entry.owner as owner,entry.calrange as calrange,entry.accounttype as accounttype,bizbillid ,entry.bizbillentryid as bizbillentryid,entry.caldimension as caldimension,entry.unitactualcost as unitactualcost";
        return QueryServiceHelper.queryDataSet((String)"getCalCostRecordSubEntity", (String)"cal_costrecord_subentity", (String)selectField, (QFilter[])filter.toArray(), null);
    }

    private static DataSet getSubEleToEleDs(Set<Long> subElementSet) {
        return QueryServiceHelper.queryDataSet((String)"getMapToSubEleToEle", (String)"cad_elementdetail", (String)"element,subelement", (QFilter[])new QFilter[]{new QFilter("subelement", "in", subElementSet)}, null);
    }
}

