/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costtranfer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.cad.common.helper.OperationResultHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class FinishCostTranFerSaveFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    Map<Long, String> sourceIdToSeqMap = null;
    private int pricePricise = 4;
    private boolean isSumDetailAmt = false;
    private RowMeta rowMeta = new RowMeta(new String[]{"type", "msg"}, new DataType[]{DataType.StringType, DataType.StringType});

    public FinishCostTranFerSaveFunction(Map<Long, String> sourceIdToSeqMap, int pricePricise, boolean isSumDetailAmt) {
        this.sourceIdToSeqMap = sourceIdToSeqMap;
        this.pricePricise = pricePricise;
        this.isSumDetailAmt = isSumDetailAmt;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector cols) {
        OperationResult operateResult;
        ArrayList listRows = Lists.newArrayList();
        for (RowX row : iterable) {
            listRows.add(row);
        }
        if (listRows.isEmpty()) {
            return;
        }
        String billstatus = ((RowX)listRows.get(0)).getString(this.sourceRowMeta.getFieldIndex("billstatus"));
        String billno = ((RowX)listRows.get(0)).getString(this.sourceRowMeta.getFieldIndex("billno"));
        String factbillno = ((RowX)listRows.get(0)).getString(this.sourceRowMeta.getFieldIndex("factbillno"));
        if (StringUtils.isEmpty((String)billstatus)) {
            cols.collect(this.getReturnRow("0", String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%s \u5f15\u5165\u5931\u8d25\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5bf9\u5e94\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"FinishCostTranFerSaveFunction_0", (String)"macc-aca-algox", (Object[])new Object[0]), factbillno)));
            return;
        }
        if (!"C".equals(billstatus)) {
            cols.collect(this.getReturnRow("0", String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%s \u5f15\u5165\u5931\u8d25\uff0c\u5bf9\u5e94\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5c1a\u672a\u5ba1\u6838\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"FinishCostTranFerSaveFunction_1", (String)"macc-aca-algox", (Object[])new Object[0]), billno)));
            return;
        }
        Long bizbillentryid = ((RowX)listRows.get(0)).getLong(this.sourceRowMeta.getFieldIndex("bizbillentryid"));
        if (CadEmptyUtils.isEmpty((Long)bizbillentryid)) {
            cols.collect(this.getReturnRow("0", String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%s \u5f15\u5165\u5931\u8d25\uff0c\u5bf9\u5e94\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"FinishCostTranFerSaveFunction_2", (String)"macc-aca-algox", (Object[])new Object[0]), factbillno)));
            return;
        }
        DynamicObject finishCostData = this.addBillHeadData((RowX)listRows.get(0));
        HashMap sourcebillEntryToDyn = Maps.newHashMapWithExpectedSize((int)10);
        for (RowX row : listRows) {
            this.generteDetailRow(finishCostData, row, sourcebillEntryToDyn);
        }
        if (this.sourceIdToSeqMap.containsKey(((RowX)listRows.get(0)).getLong(this.sourceRowMeta.getFieldIndex("sourcebill"))) || this.isSumDetailAmt) {
            this.calcDynActAmt(finishCostData);
        }
        if (!(operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"aca_finishcosttranfer", (DynamicObject[])new DynamicObject[]{finishCostData}, (OperateOption)OperateOption.create())).isSuccess()) {
            String errorInfo = OperationResultHelper.errorMsgHandle((OperationResult)operateResult);
            cols.collect(this.getReturnRow("0", errorInfo));
            return;
        }
        cols.collect(this.getReturnRow("1", null));
    }

    private void calcDynActAmt(DynamicObject finishCostData) {
        DynamicObjectCollection entrys = finishCostData.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            BigDecimal actAmt = BigDecimal.ZERO;
            DynamicObjectCollection subentrycostelements = entry.getDynamicObjectCollection("subentrycostelement");
            for (DynamicObject subEntry : subentrycostelements) {
                actAmt = actAmt.add(BigDecimalUtil.getOrZero(subEntry.getBigDecimal("sub_actualcost")));
            }
            entry.set("actualcost", (Object)actAmt);
            BigDecimal baseqty = BigDecimalUtil.getOrZero(entry.getBigDecimal("baseqty"));
            BigDecimal unitactualcost = BigDecimal.ZERO;
            if (baseqty.compareTo(BigDecimal.ZERO) != 0 && (unitactualcost = actAmt.divide(baseqty, this.pricePricise, RoundingMode.HALF_UP)).compareTo(BigDecimal.ZERO) < 0) {
                unitactualcost = BigDecimal.ZERO;
            }
            entry.set("unitactualcost", (Object)unitactualcost);
        }
    }

    private RowX getReturnRow(String type, String msg) {
        RowX row = new RowX(2);
        row.set(0, (Object)type);
        if ("0".equals(type)) {
            row.set(1, (Object)msg);
        }
        return row;
    }

    private void generteDetailRow(DynamicObject finishCostData, RowX row, Map<Long, DynamicObject> sourcebillEntryToDyn) {
        Long sourcebillentry = row.getLong(this.sourceRowMeta.getFieldIndex("sourcebillentry"));
        if (CadEmptyUtils.isEmpty((Long)sourcebillentry)) {
            return;
        }
        DynamicObject entry = sourcebillEntryToDyn.get(sourcebillentry);
        if (entry == null) {
            DynamicObjectCollection entrys = finishCostData.getDynamicObjectCollection("entry");
            entry = entrys.addNew();
            entry.set("material", row.get(this.sourceRowMeta.getFieldIndex("material")));
            entry.set("mversion", row.get(this.sourceRowMeta.getFieldIndex("mversion")));
            entry.set("auxpty", row.get(this.sourceRowMeta.getFieldIndex("assist")));
            entry.set("lot", row.get(this.sourceRowMeta.getFieldIndex("lot")));
            entry.set("baseunit", (Object)this.getBaseUnit(row));
            entry.set("baseqty", row.get(this.sourceRowMeta.getFieldIndex("baseqty")));
            entry.set("actualcost", row.get(this.sourceRowMeta.getFieldIndex("actualcost")));
            entry.set("warehouse", row.get(this.sourceRowMeta.getFieldIndex("warehouse")));
            entry.set("location", row.get(this.sourceRowMeta.getFieldIndex("location")));
            entry.set("invtype", row.get(this.sourceRowMeta.getFieldIndex("invtype")));
            entry.set("invstatus", row.get(this.sourceRowMeta.getFieldIndex("invstatus")));
            entry.set("ownertype", row.get(this.sourceRowMeta.getFieldIndex("ownertype")));
            entry.set("owner", row.get(this.sourceRowMeta.getFieldIndex("owner")));
            entry.set("calrange", row.get(this.sourceRowMeta.getFieldIndex("calrange")));
            entry.set("accounttype", row.get(this.sourceRowMeta.getFieldIndex("accounttype")));
            entry.set("caldimension", row.get(this.sourceRowMeta.getFieldIndex("caldimension")));
            entry.set("costcenter", row.get(this.sourceRowMeta.getFieldIndex("costcenter")));
            entry.set("unitactualcost", row.get(this.sourceRowMeta.getFieldIndex("unitactualcost")));
            entry.set("relacostobject", row.get(this.sourceRowMeta.getFieldIndex("costobject")));
            entry.set("sourcebillentry", (Object)sourcebillentry);
            entry.set("srccostcenter", (Object)row.getLong(this.sourceRowMeta.getFieldIndex("srccostcenter")));
            sourcebillEntryToDyn.put(sourcebillentry, entry);
        }
        DynamicObjectCollection subentrycostelements = entry.getDynamicObjectCollection("subentrycostelement");
        this.addSubEntryData(subentrycostelements, row);
    }

    private Long getBaseUnit(RowX row) {
        Long unit = row.getLong(this.sourceRowMeta.getFieldIndex("colunit"));
        if (CadEmptyUtils.isEmpty((Long)unit)) {
            unit = row.getLong(this.sourceRowMeta.getFieldIndex("baseunit"));
        }
        return unit;
    }

    private void addSubEntryData(DynamicObjectCollection subentrycostelements, RowX row) {
        Long sub_material;
        Long subelement = row.getLong(this.sourceRowMeta.getFieldIndex("subelement"));
        String invoutsourcetype = row.getString(this.sourceRowMeta.getFieldIndex("invoutsourcetype"));
        DynamicObject subentrycostelement = subentrycostelements.addNew();
        subentrycostelement.set("subelement", (Object)subelement);
        if (!CadEmptyUtils.isEmpty((Long)subelement)) {
            subentrycostelement.set("element", (Object)row.getString(this.sourceRowMeta.getFieldIndex("element")));
        }
        if (!CadEmptyUtils.isEmpty((Long)(sub_material = row.getLong(this.sourceRowMeta.getFieldIndex("sub_material"))))) {
            subentrycostelement.set("sub_baseunit", (Object)this.getBaseUnit(row));
        }
        BigDecimal qty = row.getBigDecimal(this.sourceRowMeta.getFieldIndex("qty"));
        BigDecimal amount = row.getBigDecimal(this.sourceRowMeta.getFieldIndex("amount"));
        subentrycostelement.set("sub_baseqty", (Object)qty);
        subentrycostelement.set("sub_actualcost", (Object)amount);
        subentrycostelement.set("sub_currency", row.get(this.sourceRowMeta.getFieldIndex("localcurrency")));
        subentrycostelement.set("invoutsourcetype", (Object)invoutsourcetype);
        if (!CadEmptyUtils.isEmpty((BigDecimal)qty) && !CadEmptyUtils.isEmpty((BigDecimal)amount)) {
            BigDecimal unitactualcost = amount.divide(qty, this.pricePricise, RoundingMode.HALF_UP);
            if (unitactualcost.compareTo(BigDecimal.ZERO) < 0) {
                unitactualcost = BigDecimal.ZERO;
            }
            subentrycostelement.set("sub_unitactualcost", (Object)unitactualcost);
        }
    }

    private DynamicObject addBillHeadData(RowX row) {
        String voucher;
        DynamicObject finishCostData = BusinessDataServiceHelper.newDynamicObject((String)"aca_finishcosttranfer");
        finishCostData.set("org", (Object)row.getLong(this.sourceRowMeta.getFieldIndex("calorg")));
        finishCostData.set("costaccount", (Object)row.getLong(this.sourceRowMeta.getFieldIndex("costaccount")));
        Long sourcebill = row.getLong(this.sourceRowMeta.getFieldIndex("sourcebill"));
        String billno = row.getString(this.sourceRowMeta.getFieldIndex("billno"));
        if (this.sourceIdToSeqMap.containsKey(sourcebill)) {
            billno = this.sourceIdToSeqMap.get(sourcebill);
        }
        if (billno != null && billno.length() > 80) {
            billno = billno.substring(0, 80);
        }
        finishCostData.set("billno", (Object)billno);
        finishCostData.set("sourcecalid", row.get(this.sourceRowMeta.getFieldIndex("id")));
        finishCostData.set("costobject", row.get(this.sourceRowMeta.getFieldIndex("costobject")));
        finishCostData.set("calbilltype", row.get(this.sourceRowMeta.getFieldIndex("calbilltype")));
        finishCostData.set("billtype", row.get(this.sourceRowMeta.getFieldIndex("billtype")));
        finishCostData.set("biztype", row.get(this.sourceRowMeta.getFieldIndex("biztype")));
        finishCostData.set("invscheme", (Object)row.getLong(this.sourceRowMeta.getFieldIndex("invscheme")));
        finishCostData.set("localcurrency", (Object)row.getLong(this.sourceRowMeta.getFieldIndex("localcurrency")));
        finishCostData.set("period", (Object)row.getLong(this.sourceRowMeta.getFieldIndex("period")));
        finishCostData.set("bookdate", row.get(this.sourceRowMeta.getFieldIndex("bookdate")));
        finishCostData.set("adminorg", (Object)row.getLong(this.sourceRowMeta.getFieldIndex("adminorg")));
        finishCostData.set("bizdate", row.get(this.sourceRowMeta.getFieldIndex("bizdate")));
        finishCostData.set("sourcebill", (Object)sourcebill);
        finishCostData.set("billstatus", (Object)"C");
        finishCostData.set("creator", (Object)RequestContext.get().getCurrUserId());
        finishCostData.set("createtime", (Object)new Date());
        Boolean isvoucher = row.getBoolean(this.sourceRowMeta.getFieldIndex("isvoucher"));
        if (isvoucher.booleanValue() && !this.sourceIdToSeqMap.containsKey(sourcebill) && StringUtils.isNotEmpty((String)(voucher = this.getVoucher(row)))) {
            finishCostData.set("sourcevoucher", (Object)true);
            finishCostData.set("creatvoucher", (Object)false);
            finishCostData.set("vouchernum", (Object)voucher);
        }
        return finishCostData;
    }

    private String getVoucher(RowX row) {
        int length;
        StringBuilder stringBuilder = new StringBuilder();
        String fivouchernum = row.getString(this.sourceRowMeta.getFieldIndex("fivouchernum"));
        String tempvouchernum = row.getString(this.sourceRowMeta.getFieldIndex("tempvouchernum"));
        String dischargevouchernum = row.getString(this.sourceRowMeta.getFieldIndex("dischargevouchernum"));
        String carryovervouchernum = row.getString(this.sourceRowMeta.getFieldIndex("carryovervouchernum"));
        String feevouchernum = row.getString(this.sourceRowMeta.getFieldIndex("feevouchernum"));
        if (!StringUtils.isEmpty((String)fivouchernum)) {
            stringBuilder.append(fivouchernum).append(",");
        }
        if (!StringUtils.isEmpty((String)tempvouchernum)) {
            stringBuilder.append(tempvouchernum).append(",");
        }
        if (!StringUtils.isEmpty((String)dischargevouchernum)) {
            stringBuilder.append(dischargevouchernum).append(",");
        }
        if (!StringUtils.isEmpty((String)carryovervouchernum)) {
            stringBuilder.append(carryovervouchernum).append(",");
        }
        if (!StringUtils.isEmpty((String)feevouchernum)) {
            stringBuilder.append(feevouchernum).append(",");
        }
        if ((length = stringBuilder.length()) > 255) {
            return stringBuilder.substring(0, 255);
        }
        return length > 1 ? stringBuilder.substring(0, length - 1) : "";
    }
}

