/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.realtime.action;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.constants.TerminalCalcCheck;
import kd.macc.aca.algox.costcalc.action.AbstractActCalcAction;
import kd.macc.aca.algox.realtime.RealTimeCostCalcArgs;
import kd.macc.aca.algox.realtime.function.RealTimeCalcFunctionHelper;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.aca.algox.utils.LogUtils;
import kd.macc.aca.algox.utils.MatAllocImportHelper;
import kd.macc.aca.algox.utils.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import kd.macc.cad.common.utils.DateUtils;
import net.sf.json.JSONSerializer;

public class RealTimeCollectAction
extends AbstractActCalcAction {
    private static final Log logger = LogFactory.getLog(RealTimeCollectAction.class);
    private RealTimeCostCalcArgs args;

    @Override
    protected void doExecute() {
        this.args = this.getContext().getRealTimeInputArgs();
        String type = this.args.getType();
        HashMap<String, Object> collectParamMap = new HashMap<String, Object>();
        Date startDate = null;
        if ("0".equals(type)) {
            DynamicObject period = PeriodHelper.getPeriod(this.args.getPeriodId());
            Date endDate = new Date();
            if (this.args.getReCalc().booleanValue()) {
                startDate = period.getDate("begindate");
                endDate = period.getDate("enddate");
            } else {
                QFilter schemeFilter = new QFilter("orgentry.org", "=", (Object)this.args.getOrgId());
                schemeFilter.and("entryentity.autoexecoper", "=", (Object)TerminalCalcCheck.REALTIMECALC);
                List schemeIds = QueryServiceHelper.queryPrimaryKeys((String)"sca_autoexecsheme", (QFilter[])schemeFilter.toArray(), null, (int)-1);
                QFilter logFilter = new QFilter("executeresult", "=", (Object)"1");
                logFilter.and("scheme", "in", (Object)schemeIds);
                logFilter.and("subentryentity.org", "=", (Object)this.args.getOrgId());
                logFilter.and("subentryentity.costaccount", "=", (Object)this.args.getCostAccountId());
                DataSet rows = QueryServiceHelper.queryDataSet((String)"getschemelog", (String)"sca_schemelog", (String)"id,starttime", (QFilter[])logFilter.toArray(), (String)"starttime desc", (int)1);
                for (Row row : rows) {
                    startDate = row.getDate("starttime");
                }
                if (startDate == null || startDate.getTime() > period.getDate("enddate").getTime() || startDate.getTime() < period.getDate("begindate").getTime()) {
                    startDate = period.getDate("begindate");
                }
                if (endDate.getTime() >= period.getDate("enddate").getTime()) {
                    endDate = period.getDate("enddate");
                }
            }
            this.args.setStartDate(DateUtils.getDayStartTime((Date)startDate));
            this.args.setEndDate(endDate);
            collectParamMap.put("startDate", DateUtils.getDayStartTime((Date)startDate));
            collectParamMap.put("endDate", endDate);
        } else if ("1".equals(type)) {
            collectParamMap.put("startDate", this.args.getStartDate());
            collectParamMap.put("endDate", this.args.getEndDate());
        }
        collectParamMap.put("matCostType", this.args.getMatCostType());
        HashSet<Long> costObjectIds = new HashSet<Long>(16);
        long orgId = this.args.getOrgId();
        List<Long> orgCostcenters = this.getOrgCostcenter(orgId);
        ArrayList costObjectProBillIds = Lists.newArrayList();
        this.costObjectImport(collectParamMap, orgId, orgCostcenters);
        if ("C".equals(this.args.getCalcType())) {
            this.buildCostObjectAndProBill(costObjectProBillIds, costObjectIds);
        }
        this.orderEntryImport(collectParamMap, costObjectProBillIds, orgId, Collections.singleton(this.args.getCostAccountId()));
        if ("R".equals(this.args.getCalcType())) {
            QFilter filter = new QFilter("org", "=", (Object)this.args.getOrgId());
            filter.and("appnum", "=", (Object)"aca");
            filter.and("bookdate", ">=", (Object)this.args.getStartDate());
            filter.and("bookdate", "<", (Object)this.args.getEndDate());
            QFilter auditQFilter = new QFilter("billstatus", "=", (Object)"C");
            DataSet factOutBillDs = QueryServiceHelper.queryDataSet((String)"getCostObject", (String)"cad_factnedoutputbill", (String)"entryentity.costobject costobject", (QFilter[])new QFilter[]{filter, auditQFilter}, null);
            factOutBillDs.forEach(s -> costObjectIds.add(s.getLong("costobject")));
        }
        if (CadEmptyUtils.isEmpty(costObjectIds)) {
            String errorTip = ResManager.loadKDString((String)"\u672c\u6b21\u8ba1\u7b97\u8303\u56f4\u5185\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"RealTimeCollectAction_2", (String)"macc-aca-algox", (Object[])new Object[0]);
            RealTimeCalcFunctionHelper.insertCalcErrorInfo(this.args.getCalcLogId(), (Long)0L, errorTip, "2");
            this.args.setCalc(false);
            this.getResultManager().getRealTimeResult().setErrorTip(errorTip);
            return;
        }
        HashMap<Long, Long> sideJoinToMainMap = new HashMap<Long, Long>(16);
        QFilter qFilter = new QFilter("id", "in", costObjectIds);
        DataSet mainCostObjectDs = QueryServiceHelper.queryDataSet((String)"getmaincostobject", (String)"cad_costobject", (String)"id,producttype,mainproobj", (QFilter[])qFilter.toArray(), null);
        HashSet<Long> mainCostObjectIds = new HashSet<Long>(16);
        for (Row row : mainCostObjectDs) {
            long costObjectId = row.getLong("id");
            long mainCostObjectId = row.getLong("mainproobj");
            if ("C".equals(row.getString("producttype"))) {
                mainCostObjectIds.add(costObjectId);
                continue;
            }
            if (CadEmptyUtils.isEmpty((Long)mainCostObjectId)) continue;
            mainCostObjectIds.add(mainCostObjectId);
            sideJoinToMainMap.put(costObjectId, mainCostObjectId);
        }
        this.args.setCalcCostObjectSet(mainCostObjectIds);
        this.calcMfgPlanCost(costObjectIds, sideJoinToMainMap);
    }

    private void buildCostObjectAndProBill(List<Long> costObjectProBillIds, Set<Long> costObjectIds) {
        QFilter filter = new QFilter("org", "=", (Object)this.args.getOrgId());
        filter.and("biztype", "=", (Object)"RO");
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        DataSet costObjectResult = QueryServiceHelper.queryDataSet((String)"getCostObjectInfo", (String)"cad_costobject", (String)"id,probill,isoutsource", (QFilter[])filter.toArray(), null);
        HashSet<Long> proBillIds = new HashSet<Long>(16);
        HashSet<Long> omBillIds = new HashSet<Long>(16);
        for (Row row : costObjectResult.copy()) {
            if (row.getBoolean("isoutsource").booleanValue()) {
                omBillIds.add(row.getLong("probill"));
                continue;
            }
            proBillIds.add(row.getLong("probill"));
        }
        QFilter pomQFilter = new QFilter("treeentryentity.id", "in", proBillIds);
        QFilter closeFilter = new QFilter("treeentryentity.bizstatus", "=", (Object)"C");
        closeFilter.and("treeentryentity.closebookdate", ">=", (Object)this.args.getStartDate());
        closeFilter.and("treeentryentity.closebookdate", "<", (Object)this.args.getEndDate());
        DataSet closePomDs = QueryServiceHelper.queryDataSet((String)"getMftOrder", (String)"pom_mftorder", (String)"treeentryentity.id as probill", (QFilter[])new QFilter[]{pomQFilter, closeFilter}, null);
        if (!CadEmptyUtils.isEmpty(omBillIds)) {
            QFilter omQFilter = new QFilter("treeentryentity.id", "in", omBillIds);
            DataSet closeOmDs = QueryServiceHelper.queryDataSet((String)"getOmMftOrder", (String)"om_mftorder", (String)"treeentryentity.id as probill", (QFilter[])new QFilter[]{omQFilter, closeFilter}, null);
            closePomDs = closePomDs.union(closeOmDs);
        }
        DataSet dealCostObjectDs = costObjectResult.join(closePomDs, JoinType.INNER).on("probill", "probill").select(new String[]{"id", "probill"}).finish();
        for (Row row : dealCostObjectDs) {
            costObjectProBillIds.add(row.getLong("probill"));
            costObjectIds.add(row.getLong("id"));
        }
    }

    private void calcMfgPlanCost(Set<Long> costObjectIds, Map<Long, Long> sideJoinToMainMap) {
        HashSet<String> sourceBillKey = new HashSet<String>();
        this.clearExpiredMfgRateResult(sourceBillKey, costObjectIds);
        QFilter qFilter = new QFilter("org", "=", (Object)this.args.getOrgId());
        Date nowDate = new Date();
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)nowDate);
        dateFilter.and("expdate", ">", (Object)nowDate);
        String mfgCostCalcType = this.args.getMfgCostCalcType();
        QFilter typeQFilter = new QFilter("calctype", "=", (Object)mfgCostCalcType);
        DataSet allMfgFeeRateDs = QueryServiceHelper.queryDataSet((String)"getMfgFeeRate", (String)"aca_mfgplanfeerate", (String)"id,org,costaccount,currency,costcenter,calctype,entryentity.resource resource,entryentity.material material,entryentity.expenseitem expenseitem,entryentity.element element,entryentity.subelement subelement,entryentity.rate rate,attentryentity.attelement attelement,attentryentity.attsubelement attsubelement,attentryentity.attrate attrate", (QFilter[])new QFilter[]{qFilter, typeQFilter, dateFilter}, null);
        ArrayList<DynamicObject> feeResultList = new ArrayList<DynamicObject>();
        DataSet planMfgFeeRateDs = null;
        qFilter.and("bookdate", ">=", (Object)this.args.getStartDate());
        qFilter.and("bookdate", "<", (Object)this.args.getEndDate());
        if (!CadEmptyUtils.isEmpty(costObjectIds)) {
            qFilter.and("entryentity.costobject", "in", costObjectIds);
        }
        if ("F".equals(mfgCostCalcType)) {
            DataSet factnedOutputDs = QueryServiceHelper.queryDataSet((String)"getfactnedoutputbill", (String)"cad_factnedoutputbill", (String)"sourcebill billid,sourcebillentry billentryid,srcbilltype,org,costcenter,bookdate,material,entryentity.costobject costobject,entryentity.qty qty", (QFilter[])qFilter.toArray(), null);
            HashSet entryIds = new HashSet(128);
            factnedOutputDs.copy().forEach(s -> entryIds.add(s.getLong("billentryid")));
            QFilter recordQFilter = new QFilter("costaccount", "=", (Object)this.args.getCostAccountId());
            recordQFilter.and("entry.bizbillentryid", "in", entryIds);
            DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)"calCostRecord", (String)"cal_costrecord_subentity", (String)"auditdate,billno,bizbillid as srcBillId,entry.bizbillentryid as srcEntryId", (QFilter[])recordQFilter.toArray(), null);
            factnedOutputDs = factnedOutputDs.leftJoin(costRecordDs).on("billid", "srcBillId").on("billentryid", "srcEntryId").select(factnedOutputDs.getRowMeta().getFieldNames(), new String[]{"auditdate", "billno"}).finish();
            DataSet factMfgFeeRate = allMfgFeeRateDs.leftJoin(factnedOutputDs).on("org", "org").on("costcenter", "costcenter").on("material", "material").select(allMfgFeeRateDs.getRowMeta().getFieldNames(), new String[]{"billid", "billentryid", "billno", "costcenter as factcostcenter", "bookdate", "auditdate", "costobject", "qty * rate amount", "qty * attrate attamount"}).finish();
            DataSet factCostCenterMfgFeeRate = factMfgFeeRate.filter("factcostcenter != 0 and factcostcenter is not null");
            DataSet factOrgMfgFeeRate = factMfgFeeRate.filter("factcostcenter == 0 or factcostcenter is null");
            factOrgMfgFeeRate = factOrgMfgFeeRate.leftJoin(factnedOutputDs).on("org", "org").on("material", "material").select(allMfgFeeRateDs.getRowMeta().getFieldNames(), new String[]{"billid", "billentryid", "billno", "costcenter as factcostcenter", "bookdate", "auditdate", "costobject", "qty * rate amount", "qty * attrate attamount"}).finish();
            planMfgFeeRateDs = DataSetUtils.union((DataSet)factOrgMfgFeeRate, (DataSet)factCostCenterMfgFeeRate);
            planMfgFeeRateDs = planMfgFeeRateDs.addNullField("resource");
        } else if ("R".equals(mfgCostCalcType)) {
            DataSet resourceDs = QueryServiceHelper.queryDataSet((String)"getresourcebill", (String)"sca_resourceuse", (String)"srcbillid billid,srcentryid billentryid,srcbilltype,org,costcenter,bookdate,resource,entryentity.costobject costobject,entryentity.workhour workhour,entryentity.facthour facthour", (QFilter[])qFilter.toArray(), null);
            HashMap billEntryIdMap = new HashMap(16);
            resourceDs.copy().forEach(s -> billEntryIdMap.computeIfAbsent(s.getString("srcbilltype"), p -> new ArrayList(10)).add(s.getLong("billid")));
            DataSet allSourceDs = null;
            for (Map.Entry entry : billEntryIdMap.entrySet()) {
                DataSet sourceDs;
                QFilter idQFilter = new QFilter("id", "in", entry.getValue());
                String entityNumber = (String)entry.getKey();
                if (CadEmptyUtils.isEmpty((String)entityNumber)) {
                    DataSet reportBillDs = QueryServiceHelper.queryDataSet((String)"getreportBill", (String)"sfc_processreportbill", (String)"id,billno,auditdate", (QFilter[])idQFilter.toArray(), null);
                    DataSet adjustDs = QueryServiceHelper.queryDataSet((String)"getadjustBillNo", (String)"sfc_reportresource_adjust", (String)"id,billno,auditdate", (QFilter[])idQFilter.toArray(), null);
                    DataSet mftOrderDs = QueryServiceHelper.queryDataSet((String)"getmftorderBillNo", (String)"pom_mftorderreport", (String)"id,billno,auditdate", (QFilter[])idQFilter.toArray(), null);
                    DataSet processDs = QueryServiceHelper.queryDataSet((String)"getprocessBillNo", (String)"om_processreport", (String)"id,billno,auditdate", (QFilter[])idQFilter.toArray(), null);
                    sourceDs = reportBillDs.union(adjustDs).union(mftOrderDs).union(processDs);
                } else {
                    sourceDs = QueryServiceHelper.queryDataSet((String)"getSourceBillNo", (String)((String)entry.getKey()), (String)"id,billno,auditdate", (QFilter[])idQFilter.toArray(), null);
                }
                if (allSourceDs == null) {
                    allSourceDs = sourceDs;
                    continue;
                }
                allSourceDs = allSourceDs.union(sourceDs).distinct();
            }
            resourceDs = allSourceDs != null ? resourceDs.join(allSourceDs, JoinType.LEFT).on("billid", "id").select(resourceDs.getRowMeta().getFieldNames(), new String[]{"billno", "auditdate"}).finish() : resourceDs.addNullField(new String[]{"billno", "auditdate"});
            resourceDs = resourceDs.select("billid,billentryid,billno,auditdate,org,costcenter,bookdate,resource,costobject,workhour,case when workhour=10 then facthour*60 when workhour=8 then facthour/60 else facthour end qty");
            DataSet resourceMfgFeeRate = allMfgFeeRateDs.leftJoin(resourceDs).on("org", "org").on("costcenter", "costcenter").on("resource", "resource").select(allMfgFeeRateDs.getRowMeta().getFieldNames(), new String[]{"billid", "billentryid", "billno", "auditdate", "costcenter as factcostcenter", "bookdate", "costobject", "qty * rate amount", "qty * attrate attamount"}).finish();
            DataSet resourceCostCenterMfgFeeRate = resourceMfgFeeRate.filter("factcostcenter != 0 and factcostcenter is not null");
            DataSet resourceOrgMfgFeeRate = resourceMfgFeeRate.filter("factcostcenter == 0 or factcostcenter is null");
            resourceOrgMfgFeeRate = resourceOrgMfgFeeRate.leftJoin(resourceDs).on("org", "org").on("resource", "resource").select(allMfgFeeRateDs.getRowMeta().getFieldNames(), new String[]{"billid", "billentryid", "billno", "auditdate", "costcenter as factcostcenter", "bookdate", "costobject", "qty * rate amount", "qty * attrate attamount"}).finish();
            planMfgFeeRateDs = DataSetUtils.union((DataSet)resourceOrgMfgFeeRate, (DataSet)resourceCostCenterMfgFeeRate);
        }
        this.createMfgFeeResult(planMfgFeeRateDs, mfgCostCalcType, feeResultList, nowDate, sourceBillKey, sideJoinToMainMap);
        if (!CadEmptyUtils.isEmpty(feeResultList)) {
            SaveServiceHelper.save((DynamicObject[])feeResultList.toArray(new DynamicObject[0]));
        }
    }

    private void clearExpiredMfgRateResult(Set<String> sourceBillKey, Set<Long> costObjectIds) {
        if (this.args.getOrgId() != 0L && !AcaAlgoxEmptyOrZeroUtils.isEmpty(this.args.getCostAccountId())) {
            boolean isReCalc = this.args.getReCalc();
            QFilter filter = new QFilter("org", "=", (Object)this.args.getOrgId());
            filter.and("costaccount", "=", (Object)this.args.getCostAccountId());
            filter.and("period", "=", (Object)this.args.getPeriodId());
            filter.and("costobject", "in", costObjectIds);
            filter.and("bookdate", ">=", (Object)this.args.getStartDate());
            filter.and("bookdate", "<=", (Object)this.args.getEndDate());
            HashSet<Long> ids = new HashSet<Long>();
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"rateresult", (String)"aca_mfgplanfeeresult", (String)"id,sourcebillid,sourcebillentryid", (QFilter[])new QFilter[]{filter}, null);
            Object object = null;
            try {
                StringBuilder sb = new StringBuilder();
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    ids.add(row.getLong("id"));
                    if (isReCalc) continue;
                    sb.append(row.getLong("sourcebillid")).append("@").append(row.getLong("sourcebillentryid"));
                    sourceBillKey.add(sb.toString());
                    sb.setLength(0);
                }
            }
            catch (Throwable sb) {
                object = sb;
                throw sb;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable sb) {
                            ((Throwable)object).addSuppressed(sb);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            if (!isReCalc) {
                return;
            }
            LogUtils.logInfo(this.getContext().getRealTimeInputArgs().getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u6807\u8bc6\u5386\u53f2\u5236\u9020\u8d39\u7528\u8ba1\u5212\u7ed3\u679c\u5355\uff0c\u5171\u53d6\u51fa\u5355\u636e%1$s\u5f20\uff0c\u53d6\u6570\u6761\u4ef6\uff1a%2$s", (String)"RealTimeCollectAction_1", (String)"macc-aca-algox", (Object[])new Object[0]), ids.size(), filter.toString()));
            if (!ids.isEmpty()) {
                ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(ids.size());
                for (Long id : ids) {
                    SqlParameter[] params = new SqlParameter[]{new SqlParameter("org", -5, (Object)999999L), new SqlParameter("id", -5, (Object)id)};
                    paramsList.add(params);
                }
                DB.executeBatch((DBRoute)new DBRoute("cal"), (String)"update t_aca_mfgplanfeeresult set forgid = ? where fid = ?", paramsList);
            }
        }
    }

    private void createMfgFeeResult(DataSet planMfgFeeRateDs, String calcType, List<DynamicObject> feeResultList, Date nowDate, Set<String> sourceBillKey, Map<Long, Long> sideJoinToMainMap) {
        if (planMfgFeeRateDs == null) {
            return;
        }
        for (Row row : planMfgFeeRateDs) {
            BigDecimal attAmount;
            Long costObjectId = row.getLong("costobject");
            if (CadEmptyUtils.isEmpty((Long)costObjectId)) continue;
            Long srcBillId = row.getLong("billid");
            Long srcBillEntryId = row.getLong("billentryid");
            if (CadEmptyUtils.isEmpty((Long)srcBillEntryId)) {
                srcBillEntryId = srcBillId;
            }
            if (sourceBillKey.contains(srcBillId + "@" + srcBillEntryId)) continue;
            long mainCostObjectId = sideJoinToMainMap.containsKey(costObjectId) ? sideJoinToMainMap.get(costObjectId).longValue() : costObjectId.longValue();
            BigDecimal amount = row.getBigDecimal("amount");
            if (amount != null && BigDecimal.ZERO.compareTo(amount) != 0) {
                DynamicObject feeResult = BusinessDataServiceHelper.newDynamicObject((String)"aca_mfgplanfeeresult");
                feeResult.set("org", (Object)row.getLong("org"));
                feeResult.set("costaccount", (Object)row.getLong("costaccount"));
                feeResult.set("period", (Object)this.args.getPeriodId());
                feeResult.set("currency", (Object)row.getLong("currency"));
                feeResult.set("costcenter", (Object)row.getLong("factcostcenter"));
                feeResult.set("bookdate", (Object)row.getDate("bookdate"));
                feeResult.set("expenseitem", (Object)row.getLong("expenseitem"));
                feeResult.set("element", (Object)row.getLong("element"));
                feeResult.set("subelement", (Object)row.getLong("subelement"));
                feeResult.set("costobject", (Object)mainCostObjectId);
                feeResult.set("amount", (Object)amount);
                feeResult.set("planrateid", (Object)row.getLong("id"));
                feeResult.set("createtime", (Object)nowDate);
                feeResult.set("calctype", (Object)calcType);
                feeResult.set("sourcebillno", (Object)row.getString("billno"));
                feeResult.set("sourcebillid", (Object)srcBillId);
                feeResult.set("sourcebillentryid", (Object)srcBillEntryId);
                feeResult.set("syncauditdate", (Object)row.getDate("auditdate"));
                feeResult.set("resource", (Object)row.getLong("resource"));
                feeResultList.add(feeResult);
            }
            if ((attAmount = row.getBigDecimal("attamount")) == null || BigDecimal.ZERO.compareTo(attAmount) == 0 || CadEmptyUtils.isEmpty((Long)row.getLong("attelement"))) continue;
            DynamicObject attFeeResult = BusinessDataServiceHelper.newDynamicObject((String)"aca_mfgplanfeeresult");
            attFeeResult.set("org", (Object)row.getLong("org"));
            attFeeResult.set("costaccount", (Object)row.getLong("costaccount"));
            attFeeResult.set("period", (Object)this.args.getPeriodId());
            attFeeResult.set("currency", (Object)row.getLong("currency"));
            attFeeResult.set("costcenter", (Object)row.getLong("factcostcenter"));
            attFeeResult.set("bookdate", (Object)row.getDate("bookdate"));
            attFeeResult.set("expenseitem", (Object)row.getLong("expenseitem"));
            attFeeResult.set("element", (Object)row.getLong("attelement"));
            attFeeResult.set("subelement", (Object)row.getLong("attsubelement"));
            attFeeResult.set("costobject", (Object)mainCostObjectId);
            attFeeResult.set("amount", (Object)attAmount);
            attFeeResult.set("planrateid", (Object)row.getLong("id"));
            attFeeResult.set("createtime", (Object)nowDate);
            attFeeResult.set("calctype", (Object)calcType);
            attFeeResult.set("sourcebillno", (Object)row.getString("billno"));
            attFeeResult.set("sourcebillid", (Object)srcBillId);
            attFeeResult.set("sourcebillentryid", (Object)srcBillEntryId);
            attFeeResult.set("syncauditdate", (Object)row.getDate("auditdate"));
            attFeeResult.set("resource", (Object)row.getLong("resource"));
            feeResultList.add(attFeeResult);
        }
    }

    private void orderEntryImport(Map<String, Object> collectParamMap, List<Long> costobjectProbillIds, Long orgId, Set<Long> accounts) {
        List<Long> orgCostcenters = this.getOrgCostcenter(orgId);
        ArrayList<Long> manuOrgs = new ArrayList<Long>(10);
        this.plannAndImport(collectParamMap, costobjectProbillIds, orgId, orgCostcenters, manuOrgs);
        this.factnAndImport(collectParamMap, costobjectProbillIds, orgId, orgCostcenters, manuOrgs);
        this.resourceAndImport(collectParamMap, costobjectProbillIds, orgId, orgCostcenters, manuOrgs);
        this.matUseAndImport(collectParamMap, costobjectProbillIds, orgId, orgCostcenters, manuOrgs);
        this.matAllocAuto(collectParamMap, costobjectProbillIds, orgId, accounts);
    }

    private List<Long> getOrgCostcenter(Long orgId) {
        ArrayList costcenterIds = Lists.newArrayList();
        QFilter filter = new QFilter("accountorg", "=", (Object)orgId);
        filter.and("orgduty", "=", (Object)4L);
        DataSet costCenterDs = QueryServiceHelper.queryDataSet((String)"costcenter", (String)"bos_costcenter", (String)"id", (QFilter[])filter.toArray(), null);
        for (Row row : costCenterDs) {
            costcenterIds.add(row.getLong("id"));
        }
        return costcenterIds;
    }

    private void costObjectImport(Map<String, Object> collectParamMap, Long orgId, List<Long> costcenterIds) {
        Object result = DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"costObjectService", (String)"importCostObject", (Object[])new Object[]{collectParamMap, null, orgId, costcenterIds, null, "aca", null});
        logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u6821\u9a8c\u5e76\u505a\u5f52\u96c6\u5904\u7406\u7ed3\u679c:" + result);
    }

    private List<Long> getCostObjectProbillIds(Set<Long> costobjectIds) {
        QFilter filter = new QFilter("id", "in", costobjectIds);
        filter.and("sotype", "=", (Object)"PB");
        filter.and("billstatus", "=", (Object)"C");
        DynamicObjectCollection costobjects = QueryServiceHelper.query((String)"cad_costobject", (String)"probill", (QFilter[])filter.toArray());
        HashSet<Long> probillids = new HashSet<Long>(16);
        for (DynamicObject costobject : costobjects) {
            probillids.add(costobject.getLong("probill"));
        }
        return new ArrayList<Long>(probillids);
    }

    private void plannAndImport(Map<String, Object> collectParamMap, List<Long> mftorderentryids, Long orgId, List<Long> costcenterIds, List<Long> manuOrgs) {
        Object result = DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"plannedOutputService", (String)"importPlannedOut", (Object[])new Object[]{collectParamMap, orgId, costcenterIds, new ArrayList<Long>(mftorderentryids), manuOrgs, "aca", null});
        Map map = (Map)result;
        if ("mutex".equals(map.get("type"))) {
            this.args.setCalc(false);
            throw new KDBizException((String)map.get("msg"));
        }
        logger.info("\u8ba1\u5212\u751f\u4ea7\u6570\u91cf\u6821\u9a8c\u5e76\u505a\u5f52\u96c6\u5904\u7406\u7ed3\u679c:" + result);
    }

    private void factnAndImport(Map<String, Object> collectParamMap, List<Long> mftorderentryids, Long orgId, List<Long> costcenterIds, List<Long> manuOrgs) {
        Object result = DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"factnedOutPutService", (String)"importCompletion", (Object[])new Object[]{collectParamMap, mftorderentryids, orgId, costcenterIds, manuOrgs, "aca", null});
        Map map = (Map)result;
        if ("mutex".equals(map.get("type"))) {
            this.args.setCalc(false);
            throw new KDBizException((String)map.get("msg"));
        }
        logger.info("\u5b8c\u5de5\u5165\u5e93\u6570\u91cf\u6821\u9a8c\u5e76\u505a\u5f52\u96c6\u5904\u7406\u7ed3\u679c:" + result);
    }

    private void resourceAndImport(Map<String, Object> collectParamMap, List<Long> mftorderentryids, Long orgId, List<Long> costcenterIds, List<Long> manuOrgs) {
        Object result = DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"resourceUseService", (String)"importResourceUse", (Object[])new Object[]{collectParamMap, mftorderentryids, orgId, costcenterIds, manuOrgs, "aca", null});
        Map map = (Map)result;
        if ("mutex".equals(map.get("type"))) {
            this.args.setCalc(false);
            throw new KDBizException((String)map.get("msg"));
        }
        logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u6821\u9a8c\u5e76\u505a\u5f52\u96c6\u5904\u7406\u7ed3\u679c:" + result);
    }

    private void matUseAndImport(Map<String, Object> collectParamMap, List<Long> mftorderentryids, Long orgId, List<Long> costcenterIds, List<Long> manuOrgs) {
        Object result = DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"matUseService", (String)"importMatUse", (Object[])new Object[]{collectParamMap, mftorderentryids, orgId, costcenterIds, manuOrgs, "aca", "aca_matusecollect", null});
        Map map = (Map)result;
        if ("mutex".equals(map.get("type"))) {
            this.args.setCalc(false);
            throw new KDBizException((String)map.get("msg"));
        }
        logger.info("\u6750\u6599\u8017\u7528\u6821\u9a8c\u5e76\u505a\u5f52\u96c6\u5904\u7406\u7ed3\u679c:" + result);
    }

    private void matAllocAuto(Map<String, Object> collectParamMap, List<Long> mftorderentryids, Long orgId, Set<Long> accounts) {
        OperateOption op = OperateOption.create();
        op.setVariableValue("accounts", JSONSerializer.toJSON(accounts).toString());
        op.setVariableValue("orgId", String.valueOf(orgId));
        Map<String, String> result = MatAllocImportHelper.importByWIP(collectParamMap, mftorderentryids, op);
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u7684\u81ea\u52a8\u5f15\u5165\u5904\u7406\u7ed3\u679c:" + result);
    }
}

