/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.realtime.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.costcalc.ActCostCalcDataInputFactory;
import kd.macc.aca.algox.costcalc.action.AbstractActCalcAction;
import kd.macc.aca.algox.costcalc.action.ActCalcCallCalOutException;
import kd.macc.aca.algox.costcalc.common.ActCalcHelper;
import kd.macc.aca.algox.realtime.RealTimeCostCalcArgs;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.LogUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class RealTimeMaterialAction
extends AbstractActCalcAction {
    private static final Log logger = LogFactory.getLog(RealTimeMaterialAction.class);

    @Override
    protected void doExecute() {
        RealTimeCostCalcArgs args = this.getContext().getRealTimeInputArgs();
        if (!args.getCalc()) {
            return;
        }
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("bizdate", ">=", (Object)args.getStartDate());
        filter.and("bizdate", "<", (Object)args.getEndDate());
        if (!CadEmptyUtils.isEmpty(args.getCalcCostObjectSet())) {
            filter.and("entryentity.costobejctentry", "in", args.getCalcCostObjectSet());
        }
        QFilter accountQFilter = new QFilter("costaccount", "=", (Object)args.getCostAccountId());
        QFilter statusQFilter = new QFilter("allocstatus", "=", (Object)"2");
        DataSet tmpDataSet = QueryServiceHelper.queryDataSet((String)"getMatAllocMaterial", (String)"aca_matalloc", (String)"isreturnitem,material,matcollect", (QFilter[])new QFilter[]{filter, accountQFilter, statusQFilter}, null);
        HashSet allMatIdSet = new HashSet(128);
        HashSet<Long> matIdSet = new HashSet<Long>(128);
        HashSet<Long> matAllocIds = new HashSet<Long>(128);
        HashSet<Long> returnMatIdSet = new HashSet<Long>(128);
        tmpDataSet.forEach(s -> {
            long materialId = s.getLong("material");
            if (s.getBoolean("isreturnitem").booleanValue()) {
                returnMatIdSet.add(materialId);
            } else {
                matIdSet.add(materialId);
            }
            allMatIdSet.add(materialId);
            matAllocIds.add(s.getLong("matcollect"));
        });
        QFilter qFilter = new QFilter("calorg", "=", (Object)args.getOrgId());
        qFilter.and("costaccount", "=", (Object)args.getCostAccountId());
        qFilter.and("entry.material", "in", allMatIdSet);
        qFilter.and("entry.accounttype", "in", (Object)new String[]{"C", "E"});
        DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)"getCostRecord", (String)"cal_costrecord_subentity", (String)"entry.material material", (QFilter[])qFilter.toArray(), null);
        HashSet realTimeMatIds = new HashSet(128);
        costRecordDs.forEach(s -> realTimeMatIds.add(s.getLong("material")));
        if (!CadEmptyUtils.isEmpty(realTimeMatIds)) {
            logger.info("\u6392\u9664\u8ba1\u4ef7\u65b9\u6cd5\u4e3a\u5b9e\u65f6\u7684\u7269\u6599\u4e2a\u6570\uff1a{}", (Object)realTimeMatIds.size());
            returnMatIdSet.removeAll(realTimeMatIds);
            matIdSet.removeAll(realTimeMatIds);
        }
        args.setMatAllocIds(matAllocIds);
        ActCostCalcDataInputFactory datainputFactory = new ActCostCalcDataInputFactory();
        if (!CadEmptyUtils.isEmpty(matIdSet)) {
            boolean acaCalcOutParallel = datainputFactory.getCalcConcurrencyMode();
            Map<String, Object> commonParam = datainputFactory.buildCalcOutCostCommonParam("A", acaCalcOutParallel);
            this.calculatOutService(args, matIdSet, commonParam);
        }
        if (!CadEmptyUtils.isEmpty(returnMatIdSet)) {
            this.updateCostFromCostPriceService(args, returnMatIdSet);
        }
        RealTimeMaterialAction.autoMatAllocNew(args, matAllocIds);
    }

    private void updateCostFromCostPriceService(RealTimeCostCalcArgs args, Set<Long> matIdSet) {
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, ResManager.loadKDString((String)"index%s\u3010\u8fd4\u5de5\u7269\u6599\u66f4\u65b0\u4ef7\u683cupdateCostFromCostPrice\u3011\u5f00\u59cb", (String)"RealTimeMaterialAction_0", (String)"macc-aca-algox", (Object[])new Object[0]));
        long start = System.currentTimeMillis();
        HashMap<Long, Set<Long>> bizParam = new HashMap<Long, Set<Long>>();
        bizParam.put(args.getCostAccountId(), matIdSet);
        HashMap<String, String> commonParam = new HashMap<String, String>();
        commonParam.put("priceobject", "K");
        commonParam.put("entityobject", "cal_out_calculate");
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CostPrice4CostRecordService", (String)"updateCostFromCostPrice", (Object[])new Object[]{bizParam, commonParam});
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u8fd4\u5de5\u7269\u6599\u66f4\u65b0\u4ef7\u683cupdateCostFromCostPrice\u3011\u7ed3\u675f\uff0c\u8017\u65f6\uff1a%s", (String)"RealTimeMaterialAction_1", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start));
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u8fd4\u5de5\u7269\u6599\u66f4\u65b0\u4ef7\u683cupdateCostFromCostPrice\u3011\u7ed3\u675f\uff0c\u8fd4\u56de\u503c\uff1a%s", (String)"RealTimeMaterialAction_2", (String)"macc-aca-algox", (Object[])new Object[0]), result));
        if (result != null && result.get("success") != null && "0".equals(result.get("success").toString())) {
            String tipMsg = ResManager.loadKDString((String)"\u8fd4\u5de5\u7269\u6599\u66f4\u65b0\u4ef7\u683c\u5931\u8d25\uff1a%s", (String)"RealTimeMaterialAction_3", (String)"macc-aca-algox", (Object[])new Object[0]);
            tipMsg = String.format(tipMsg, result.get("msg"));
            LogUtils.logError(args.getGetLogUniqueKey(), logger, tipMsg);
            throw new KDBizException(tipMsg);
        }
    }

    private void calculatOutService(RealTimeCostCalcArgs args, Set<Long> matIdSet, Map<String, Object> commonParam) {
        long start;
        try {
            Map failMatInfosMap;
            start = System.currentTimeMillis();
            ArrayList bizParamList = new ArrayList();
            HashMap<String, Object> bizParam = new HashMap<String, Object>();
            bizParam.put("costaccount", args.getCostAccountId());
            bizParam.put("materials", matIdSet);
            bizParamList.add(bizParam);
            Map result = null;
            try (TXHandle h = TX.notSupported();){
                result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"calx", (String)"CalculateOutService", (String)"calculateOutForResult", (Object[])new Object[]{commonParam, bizParamList});
            }
            if (result != null && result.get("failMatInfos") != null && (failMatInfosMap = (Map)result.get("failMatInfos")).size() > 0) {
                Date startTime = (Date)result.get("startTime");
                Date endTime = (Date)result.get("endTime");
                throw new ActCalcCallCalOutException("", failMatInfosMap, startTime, endTime);
            }
        }
        catch (Exception e) {
            logger.error("\u3010\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u51fa\u5e93\u6838\u7b97calculateOut\u3011\u5931\u8d25\u3002", (Throwable)e);
            throw new ActCalcCallCalOutException(e.getMessage(), null, null, null);
        }
        logger.info("\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u51fa\u5e93\u6838\u7b97\u6210\u529f\uff0c\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
    }

    private static DataSet getCalCostRecordDs(RealTimeCostCalcArgs args, Set<Long> sourceBillEntryIds) {
        QFilter filter = new QFilter("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("entry.bizbillentryid", "in", sourceBillEntryIds);
        String selectFields = "costaccount as costAccountId,calorg as orgId,bizbillid as srcBillId,entry.bizbillentryid as srcEntryId,entry.material.masterid as matId,entry.mversion as matVerId,entry.assist as matAuxId,entry.actualcost as actCost,entry.unitactualcost as unitActCost";
        selectFields = selectFields + ",0L as elementId,0L as subElementId,0 as subUnitActCost,0 as subActCost";
        return QueryServiceHelper.queryDataSet((String)"calCostRecord", (String)"cal_costrecord_subentity", (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    private static DynamicObject[] getMatAllocDsByCollectId(RealTimeCostCalcArgs args, Set<Long> matUseCollectEntryIdSet) {
        QFilter filter = new QFilter("matcollect", "in", matUseCollectEntryIdSet);
        filter.and(new QFilter("costaccount", "=", (Object)args.getCostAccountId()));
        return BusinessDataServiceHelper.load((String)"aca_matalloc", (String)"id,matcollect,material.id,useamount,useqty,entryentity.id,entryentity.qty,entryentity.allocvalue,entryentity.amount,entryentity.subentryentity.id", (QFilter[])filter.toArray());
    }

    public static void autoMatAllocNew(RealTimeCostCalcArgs args, Set<Long> matAllocIds) {
        List partArrIds = Lists.partition(new ArrayList<Long>(matAllocIds), (int)10000);
        for (List matColIds : partArrIds) {
            DataSet matCollectDataSet = ActCalcHelper.getMatCollectDs(matColIds);
            DataSet matCollectDataSetCopy = matCollectDataSet.copy();
            HashSet sourceBillEntryIds = Sets.newHashSetWithExpectedSize((int)128);
            HashSet matUseCollectEntryIdSet = Sets.newHashSetWithExpectedSize((int)128);
            for (Row row : matCollectDataSetCopy) {
                sourceBillEntryIds.add(row.getLong("srcEntryId"));
                matUseCollectEntryIdSet.add(row.getLong("entryId"));
            }
            DataSet costRecordDs = RealTimeMaterialAction.getCalCostRecordDs(args, sourceBillEntryIds);
            DataSet allocDataSet = matCollectDataSet.leftJoin(costRecordDs).on("srcBillId", "srcBillId").on("srcEntryId", "srcEntryId").select(matCollectDataSet.getRowMeta().getFieldNames(), new String[]{"actCost", "unitActCost", "elementId", "subElementId", "subUnitActCost", "subActCost"}).finish();
            HashMap actCostMap = Maps.newHashMap();
            for (Row row : allocDataSet) {
                String key = String.format("%s@%s", row.getString("entryId"), row.getString("matId"));
                actCostMap.put(key, new BigDecimal[]{BigDecimalUtil.getOrZero(row.getBigDecimal("unitActCost")), BigDecimalUtil.getOrZero(row.getBigDecimal("actCost"))});
            }
            DynamicObject[] allocDynArr = RealTimeMaterialAction.getMatAllocDsByCollectId(args, matUseCollectEntryIdSet);
            ArrayList<Object[]> updateHeadList = new ArrayList<Object[]>();
            ArrayList<Object[]> updateEntryList = new ArrayList<Object[]>();
            ArrayList<Object[]> insertSubEntryList = new ArrayList<Object[]>();
            for (DynamicObject dyo : allocDynArr) {
                String key = String.format("%s@%s", dyo.getLong("matcollect"), dyo.getLong("material.id"));
                BigDecimal[] actCostArr = (BigDecimal[])actCostMap.get(key);
                if (actCostArr == null) continue;
                Long headId = dyo.getLong("id");
                BigDecimal actCost = actCostArr[1].setScale(args.getAmtScale(), RoundingMode.HALF_UP);
                BigDecimal unitActCost = actCostArr[0].setScale(args.getPriceScale(), RoundingMode.HALF_UP);
                DynamicObjectCollection entryColl = dyo.getDynamicObjectCollection("entryentity");
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryColl)) continue;
                updateHeadList.add(new Object[]{actCost, headId});
                if (entryColl.size() == 1) {
                    ((DynamicObject)entryColl.get(0)).set("amount", (Object)actCost);
                } else {
                    BigDecimal totalAllocVal = BigDecimal.ZERO;
                    for (DynamicObject entry : entryColl) {
                        totalAllocVal = totalAllocVal.add(BigDecimalUtil.getOrZero(entry.getBigDecimal("allocvalue")));
                    }
                    BigDecimal diff = actCost;
                    BigDecimal tmpQty = null;
                    DynamicObject diffEntry = null;
                    if (totalAllocVal.compareTo(BigDecimal.ZERO) == 0) {
                        BigDecimal useQty = BigDecimalUtil.getOrZero(dyo.getBigDecimal("useqty"));
                        if (BigDecimal.ZERO.compareTo(useQty) == 0) continue;
                        for (DynamicObject entry : entryColl) {
                            BigDecimal qty = BigDecimalUtil.getOrZero(entry.getBigDecimal("qty"));
                            BigDecimal amt = qty.divide(useQty, 10, RoundingMode.HALF_UP).multiply(actCost).setScale(args.getAmtScale(), RoundingMode.HALF_UP);
                            if (tmpQty == null || qty.compareTo(tmpQty) > 0) {
                                tmpQty = qty;
                                diffEntry = entry;
                            }
                            entry.set("amount", (Object)amt);
                            diff = diff.subtract(amt);
                        }
                    } else {
                        for (DynamicObject entry : entryColl) {
                            BigDecimal allocvalue = BigDecimalUtil.getOrZero(entry.getBigDecimal("allocvalue"));
                            BigDecimal amt = allocvalue.divide(totalAllocVal, 10, RoundingMode.HALF_UP).multiply(actCost).setScale(args.getAmtScale(), RoundingMode.HALF_UP);
                            if (tmpQty == null || allocvalue.compareTo(tmpQty) > 0) {
                                tmpQty = allocvalue;
                                diffEntry = entry;
                            }
                            entry.set("amount", (Object)amt);
                            diff = diff.subtract(amt);
                        }
                    }
                    if (diff.compareTo(BigDecimal.ZERO) != 0 && diffEntry != null) {
                        diffEntry.set("amount", (Object)diffEntry.getBigDecimal("amount").add(diff));
                    }
                }
                for (DynamicObject entry : entryColl) {
                    BigDecimal allocAmt = BigDecimalUtil.getOrZero(entry.getBigDecimal("amount"));
                    Long entryId = entry.getLong("id");
                    updateEntryList.add(new Object[]{allocAmt, unitActCost, entryId});
                }
            }
            DBRoute route = new DBRoute("cal");
            String updateHeadSql = "update t_sca_matalloc set fuseamount=?  where fid= ? ";
            String updateEntrySql = "update t_sca_matallocentry set famount=?,fprice=? where fentryid = ?";
            String insertSubEntrySql = "insert into t_sca_matallocsubentry(fdetailid,fentryid,felementid,fsubelementid,fstandardcost,fstandardamt) values(?,?,?,?,?,?)";
            if (!updateHeadList.isEmpty()) {
                ActCalcHelper.doExecuteBatch(updateHeadList, route, updateHeadSql);
            }
            if (!updateEntryList.isEmpty()) {
                ActCalcHelper.doExecuteBatch(updateEntryList, route, updateEntrySql);
            }
            if (insertSubEntryList.isEmpty()) continue;
            ActCalcHelper.doExecuteBatch(insertSubEntryList, route, insertSubEntrySql);
        }
    }
}

