/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.realtime.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.aca.algox.costcalc.common.ProextraPriceVo;
import kd.macc.aca.algox.realtime.RealTimeCostCalcArgs;
import kd.macc.aca.algox.realtime.RealTimeDebugInfoMsgHandler;
import kd.macc.aca.algox.realtime.RealTimeResultFinalResultVO;
import kd.macc.aca.algox.realtime.function.RealTimeCalcFunctionHelper;
import kd.macc.aca.algox.utils.BigDecimalUtil;

public class RealTimeCalcJoinSideAllocFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta srcMeta;
    private RealTimeCostCalcArgs args;
    private Map<Long, Map<Long, RealTimeResultFinalResultVO>> calcCostobjectFinalResultMap;
    private Map<String, List<ProextraPriceVo>> proextraPriceMap;
    private Map<String, String> allocTypeMap;
    private Map<String, BigDecimal[]> weightMap;
    private Map<Long, String> subElementTypeMap = Maps.newHashMapWithExpectedSize((int)8);
    private Map<Long, Long> subElementMap = Maps.newHashMapWithExpectedSize((int)8);
    private RealTimeDebugInfoMsgHandler msgHander = null;

    public RealTimeCalcJoinSideAllocFunction(RowMeta rowMeta, RealTimeCostCalcArgs args, Map<String, List<ProextraPriceVo>> proextraPriceMap, Map<Long, Map<Long, RealTimeResultFinalResultVO>> calcCostobjectFinalResultMap, Map<String, String> allocTypeMap, Map<String, BigDecimal[]> weightMap, RealTimeDebugInfoMsgHandler msgHander) {
        this.srcMeta = rowMeta;
        this.args = args;
        this.calcCostobjectFinalResultMap = calcCostobjectFinalResultMap;
        this.proextraPriceMap = proextraPriceMap;
        this.allocTypeMap = allocTypeMap;
        this.weightMap = weightMap;
        this.msgHander = msgHander;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public void reduce(Iterable<RowX> iter, Collector collector) {
        Map<Long, RealTimeResultFinalResultVO> resultVoMaps;
        ArrayList mainRows = Lists.newArrayList();
        for (RowX row : iter) {
            row.set(this.srcMeta.getFieldIndex("finTempQty"), (Object)BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("finQty"))));
            mainRows.add(row);
        }
        if (mainRows.isEmpty()) {
            return;
        }
        Long costObjectId = ((RowX)mainRows.get(0)).getLong(this.srcMeta.getFieldIndex("costObjectId"));
        if (!this.calcCostobjectFinalResultMap.containsKey(costObjectId)) {
            return;
        }
        boolean isCostobjectDebug = RealTimeCalcFunctionHelper.isCostobjectDebug(this.args, costObjectId);
        StringBuilder debugMsg = null;
        if (isCostobjectDebug) {
            debugMsg = new StringBuilder();
            debugMsg.append(ResManager.loadKDString((String)"\u4e3b\u8054\u5206\u644a\uff1a\n", (String)"RealTimeCalcJoinSideAllocFunction_0", (String)"macc-aca-algox", (Object[])new Object[0]));
        }
        if ((resultVoMaps = this.calcCostobjectFinalResultMap.get(costObjectId)).size() == 1 || !RealTimeCalcFunctionHelper.isContainsProductFactned(resultVoMaps)) {
            for (RowX row : mainRows) {
                collector.collect(row);
            }
            if (isCostobjectDebug && this.msgHander != null && debugMsg != null) {
                this.msgHander.dealInfoMsg(debugMsg.toString());
            }
            return;
        }
        try {
            List<RowX> sideRows = this.calcSideProductCost(mainRows, resultVoMaps, isCostobjectDebug, debugMsg);
            List<RowX> joinRows = this.calcMainJoinProductCost(mainRows, resultVoMaps);
            for (RowX row : mainRows) {
                collector.collect(row);
            }
            for (RowX row : sideRows) {
                collector.collect(row);
            }
            for (RowX row : joinRows) {
                collector.collect(row);
            }
        }
        catch (Exception ex) {
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append("Exceptoin").append(ex.getMessage());
            }
            throw ex;
        }
        finally {
            if (isCostobjectDebug && this.msgHander != null && debugMsg != null) {
                this.msgHander.dealInfoMsg(debugMsg.toString());
            }
        }
    }

    private Map<RowX, Map<Long, BigDecimal>> calcJoinFixValue(List<RowX> mainRows, Map<Long, RealTimeResultFinalResultVO> resultVoMaps) {
        HashMap<Long, List> subEleRowMaps = new HashMap<Long, List>(10);
        for (RowX mainRow : mainRows) {
            Long subElementId = mainRow.getLong(this.srcMeta.getFieldIndex("subElementId"));
            subEleRowMaps.computeIfAbsent(subElementId, t -> new ArrayList(10)).add(mainRow);
        }
        HashMap<RowX, Map<Long, BigDecimal>> rowFixAmtMap = new HashMap<RowX, Map<Long, BigDecimal>>(10);
        for (Map.Entry subEleEntry : subEleRowMaps.entrySet()) {
            Map<Long, BigDecimal[]> groupCostobjFixedMap = RealTimeCalcFunctionHelper.getGroupCostObjectFixedAmt(resultVoMaps, this.weightMap, (Long)subEleEntry.getKey());
            if (groupCostobjFixedMap == null || groupCostobjFixedMap.isEmpty()) continue;
            for (Map.Entry<Long, RealTimeResultFinalResultVO> entry : resultVoMaps.entrySet()) {
                Map cbFixAmtMap;
                Object row2;
                BigDecimal qty = entry.getValue().getProFinQty();
                if (qty.compareTo(BigDecimal.ZERO) == 0 || "B".equals(entry.getValue().getProductType()) || !groupCostobjFixedMap.containsKey(entry.getKey())) continue;
                BigDecimal fixedAmt = groupCostobjFixedMap.get(entry.getKey())[1];
                if (((List)subEleEntry.getValue()).size() <= 1) continue;
                BigDecimal totalAmt = BigDecimal.ZERO;
                for (Object row2 : (List)subEleEntry.getValue()) {
                    totalAmt = totalAmt.add(BigDecimalUtil.getOrZero(row2.getBigDecimal(this.srcMeta.getFieldIndex("finAmt"))));
                }
                HashMap rowRadioMap = Maps.newHashMapWithExpectedSize((int)10);
                row2 = ((List)subEleEntry.getValue()).iterator();
                while (row2.hasNext()) {
                    RowX row3 = (RowX)row2.next();
                    if (totalAmt == null || totalAmt.compareTo(BigDecimal.ZERO) == 0) {
                        rowRadioMap.put(row3, BigDecimal.ONE.divide(new BigDecimal(((List)subEleEntry.getValue()).size()), 10, 4));
                        continue;
                    }
                    BigDecimal finAmt = BigDecimalUtil.getOrZero(row3.getBigDecimal(this.srcMeta.getFieldIndex("finAmt")));
                    rowRadioMap.put(row3, finAmt.divide(totalAmt, 10, 4));
                }
                BigDecimal diff = fixedAmt;
                RowX maxRow = null;
                for (RowX row4 : (List)subEleEntry.getValue()) {
                    BigDecimal radio = (BigDecimal)rowRadioMap.get(row4);
                    if (radio == null) {
                        radio = BigDecimal.ZERO;
                    }
                    BigDecimal allocAmt = fixedAmt.multiply(radio).setScale(this.args.getAmtScale(), RoundingMode.HALF_UP);
                    diff = diff.subtract(allocAmt);
                    rowFixAmtMap.computeIfAbsent(row4, t -> new HashMap()).put(entry.getKey(), allocAmt);
                    if (maxRow == null) {
                        maxRow = row4;
                        continue;
                    }
                    Map cbFixAmtMap2 = (Map)rowFixAmtMap.get(maxRow);
                    if (cbFixAmtMap2 == null || !cbFixAmtMap2.containsKey(entry.getKey()) || allocAmt.compareTo((BigDecimal)cbFixAmtMap2.get(entry.getKey())) <= 0) continue;
                    maxRow = row4;
                }
                if (diff.compareTo(BigDecimal.ZERO) == 0 || maxRow == null || (cbFixAmtMap = (Map)rowFixAmtMap.get(maxRow)) == null || !cbFixAmtMap.containsKey(entry.getKey())) continue;
                cbFixAmtMap.put(entry.getKey(), ((BigDecimal)cbFixAmtMap.get(entry.getKey())).add(diff));
            }
        }
        return rowFixAmtMap;
    }

    private List<RowX> calcMainJoinProductCost(List<RowX> mainRows, Map<Long, RealTimeResultFinalResultVO> resultVoMaps) {
        ArrayList joinRows = Lists.newArrayList();
        if (!RealTimeCalcFunctionHelper.isContainsProductFacted(resultVoMaps, "A")) {
            return joinRows;
        }
        Map<RowX, Map<Long, BigDecimal>> rowFixAmtMap = this.calcJoinFixValue(mainRows, resultVoMaps);
        for (RowX mainRow : mainRows) {
            boolean isContainElseFact;
            Long subElementId = mainRow.getLong(this.srcMeta.getFieldIndex("subElementId"));
            String mftOrderNo = mainRow.getString(this.srcMeta.getFieldIndex("mftOrderNo"));
            Long mainCostObjectId = mainRow.getLong(this.srcMeta.getFieldIndex("costObjectId"));
            Integer subMatUnitPrecision = mainRow.getInteger(this.srcMeta.getFieldIndex("subMatUnitPrecision"));
            if (subMatUnitPrecision == null) {
                subMatUnitPrecision = 0;
            }
            Map<Long, BigDecimal> groupCostobjWeightMap = RealTimeCalcFunctionHelper.getGroupCostObjectWeight(resultVoMaps, this.allocTypeMap, this.weightMap, subElementId);
            Map<Long, BigDecimal[]> groupCostobjFixedMap = RealTimeCalcFunctionHelper.getGroupCostObjectFixedAmt(resultVoMaps, this.weightMap, subElementId);
            if (groupCostobjFixedMap != null && !groupCostobjFixedMap.isEmpty() && !(isContainElseFact = this.fixedAmtCal(resultVoMaps, mainRow, groupCostobjFixedMap, joinRows, subMatUnitPrecision, rowFixAmtMap))) continue;
            BigDecimal totalMuilt = BigDecimal.ZERO;
            BigDecimal maxMuilt = null;
            boolean isAllFinQtyZero = true;
            boolean isContainJoinFact = false;
            boolean isContainMainFact = false;
            for (Map.Entry<Long, RealTimeResultFinalResultVO> entry : resultVoMaps.entrySet()) {
                BigDecimal qty;
                if ("B".equals(entry.getValue().getProductType()) || !groupCostobjWeightMap.containsKey(entry.getKey()) || (qty = entry.getValue().getProFinQty()).compareTo(BigDecimal.ZERO) == 0) continue;
                if ("A".equals(entry.getValue().getProductType())) {
                    isContainJoinFact = true;
                } else if ("C".equals(entry.getValue().getProductType())) {
                    isContainMainFact = true;
                }
                if (groupCostobjFixedMap != null && groupCostobjFixedMap.containsKey(entry.getKey())) continue;
                isAllFinQtyZero = false;
                BigDecimal weight = groupCostobjWeightMap.get(entry.getKey());
                BigDecimal multi = qty.multiply(weight);
                totalMuilt = totalMuilt.add(multi);
                if (maxMuilt != null && maxMuilt.compareTo(multi.abs()) >= 0) continue;
                maxMuilt = multi.abs();
            }
            if (totalMuilt.compareTo(BigDecimal.ZERO) == 0 && maxMuilt != null) {
                totalMuilt = maxMuilt;
            }
            if (totalMuilt.compareTo(BigDecimal.ZERO) == 0 && !isAllFinQtyZero) {
                DynamicObject costObjectDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)mainCostObjectId, (String)"cad_costobject", (String)"costcenter,name");
                DynamicObject subElementDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)subElementId, (String)"cad_subelement", (String)"name");
                String errStr = String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u4ea7\u54c1\u5b8c\u5de5\u6bd4\u4f8b\u5206\u914d\u5931\u8d25\uff0c\u3010\u2211\u4e3b\u4ea7\u54c1\u5b8c\u5de5\u5165\u5e93\u6570\u91cf*\u6743\u91cd+\u2211\u8054\u4ea7\u54c1\u5b8c\u5de5\u5165\u5e93\u6570\u91cf*\u6743\u91cd=0\u3011\uff0c\u5de5\u5355\u7f16\u53f7\u3010%1$s\u3011\uff0c\u6210\u672c\u5bf9\u8c61\u3010%2$s\u3011\uff0c\u5b50\u8981\u7d20\u3010%3$s\u3011\u3002", (String)"RealTimeCalcJoinSideAllocFunction_1", (String)"macc-aca-algox", (Object[])new Object[0]), mftOrderNo, costObjectDyo != null ? costObjectDyo.getString("name") : "", subElementDyo != null ? subElementDyo.getString("name") : "");
                RealTimeCalcFunctionHelper.insertCalcErrorInfo(this.args.getCalcLogId(), (Long)(costObjectDyo != null ? costObjectDyo.getLong("costcenter.id") : 0L), errStr);
                return joinRows;
            }
            BigDecimal mainJoinFinQty = BigDecimalUtil.getOrZero(mainRow.getBigDecimal(this.srcMeta.getFieldIndex("finQty")));
            BigDecimal mainJoinFinAmt = BigDecimalUtil.getOrZero(mainRow.getBigDecimal(this.srcMeta.getFieldIndex("finAmt")));
            BigDecimal diffFinQty = mainJoinFinQty;
            BigDecimal diffFinAmt = mainJoinFinAmt;
            RowX allocMaxRow = null;
            for (Map.Entry<Long, RealTimeResultFinalResultVO> entry : resultVoMaps.entrySet()) {
                if ("B".equals(entry.getValue().getProductType()) || !groupCostobjWeightMap.containsKey(entry.getKey()) || CollectionUtils.isEmpty(entry.getValue().getCostcenterFinQtyMap()) || groupCostobjFixedMap != null && groupCostobjFixedMap.containsKey(entry.getKey())) continue;
                BigDecimal qty = entry.getValue().getProFinQty();
                BigDecimal weight = groupCostobjWeightMap.get(entry.getKey());
                BigDecimal multi = qty.multiply(weight);
                BigDecimal radio = BigDecimal.ZERO;
                if (totalMuilt.compareTo(BigDecimal.ZERO) != 0) {
                    radio = multi.divide(totalMuilt, 10, RoundingMode.HALF_UP);
                }
                BigDecimal allocAmt = radio.multiply(mainJoinFinAmt).setScale(this.args.getAmtScale(), RoundingMode.HALF_UP);
                BigDecimal allocQty = radio.multiply(mainJoinFinQty).setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP);
                diffFinQty = diffFinQty.subtract(allocQty);
                diffFinAmt = diffFinAmt.subtract(allocAmt);
                if ("C".equals(entry.getValue().getProductType())) {
                    mainRow.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)allocAmt);
                    mainRow.set(this.sourceRowMeta.getFieldIndex("finQty"), (Object)allocQty);
                    if (allocMaxRow != null && allocMaxRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("finAmt")).compareTo(allocAmt) >= 0) continue;
                    allocMaxRow = mainRow;
                    continue;
                }
                RowX joinRow = this.getProductRow(mainRow, entry.getKey(), entry.getValue(), true, false);
                joinRow.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)allocAmt);
                joinRow.set(this.sourceRowMeta.getFieldIndex("finQty"), (Object)allocQty);
                if (allocMaxRow == null || allocMaxRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("finAmt")).compareTo(allocAmt) < 0) {
                    allocMaxRow = joinRow;
                }
                joinRows.add(joinRow);
            }
            if (diffFinQty.compareTo(BigDecimal.ZERO) != 0 && allocMaxRow != null) {
                allocMaxRow.set(this.sourceRowMeta.getFieldIndex("finQty"), (Object)allocMaxRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("finQty")).add(diffFinQty));
            }
            if (diffFinAmt.compareTo(BigDecimal.ZERO) != 0 && allocMaxRow != null) {
                allocMaxRow.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)allocMaxRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("finAmt")).add(diffFinAmt));
            }
            if (isContainMainFact || !isContainJoinFact) continue;
            mainRow.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)BigDecimal.ZERO);
            mainRow.set(this.sourceRowMeta.getFieldIndex("finQty"), (Object)BigDecimal.ZERO);
        }
        return joinRows;
    }

    private boolean fixedAmtCal(Map<Long, RealTimeResultFinalResultVO> resultVoMaps, RowX mainRow, Map<Long, BigDecimal[]> groupCostobjFixedMap, List<RowX> joinRows, Integer subMatUnitPrecision, Map<RowX, Map<Long, BigDecimal>> rowFixAmtMap) {
        BigDecimal mainJoinFinQty = BigDecimalUtil.getOrZero(mainRow.getBigDecimal(this.srcMeta.getFieldIndex("finQty")));
        BigDecimal mainJoinFinAmt = BigDecimalUtil.getOrZero(mainRow.getBigDecimal(this.srcMeta.getFieldIndex("finAmt")));
        BigDecimal fixedAmtFinQty = mainJoinFinQty;
        BigDecimal fixedAmtFinAmt = mainJoinFinAmt;
        boolean isContainElseFact = false;
        for (Map.Entry<Long, RealTimeResultFinalResultVO> entry : resultVoMaps.entrySet()) {
            BigDecimal qty = entry.getValue().getProFinQty();
            if (qty.compareTo(BigDecimal.ZERO) == 0 || "B".equals(entry.getValue().getProductType())) continue;
            if (!groupCostobjFixedMap.containsKey(entry.getKey())) {
                isContainElseFact = true;
                continue;
            }
            BigDecimal fixedAmt = groupCostobjFixedMap.get(entry.getKey())[1];
            Map<Long, BigDecimal> cbFixAmtMap = rowFixAmtMap.get(mainRow);
            if (cbFixAmtMap != null && cbFixAmtMap.containsKey(entry.getKey())) {
                fixedAmt = cbFixAmtMap.get(entry.getKey());
            }
            BigDecimal fixedFinQty = BigDecimal.ZERO;
            if (fixedAmt.compareTo(BigDecimal.ZERO) != 0 && mainJoinFinAmt.compareTo(BigDecimal.ZERO) != 0 && mainJoinFinQty.compareTo(BigDecimal.ZERO) != 0) {
                fixedFinQty = fixedAmt.divide(mainJoinFinAmt, 10, 4).multiply(mainJoinFinQty).setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP);
            }
            RowX joinRow = this.getProductRow(mainRow, entry.getKey(), entry.getValue(), true, false);
            joinRow.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)fixedAmt);
            joinRow.set(this.sourceRowMeta.getFieldIndex("finQty"), (Object)fixedFinQty);
            joinRows.add(joinRow);
            fixedAmtFinQty = fixedAmtFinQty.subtract(fixedFinQty);
            fixedAmtFinAmt = fixedAmtFinAmt.subtract(fixedAmt);
        }
        if (!isContainElseFact) {
            mainRow.set(this.sourceRowMeta.getFieldIndex("inQty"), (Object)mainRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("inQty")).add(fixedAmtFinQty));
            mainRow.set(this.sourceRowMeta.getFieldIndex("inAmt"), (Object)mainRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("inAmt")).add(fixedAmtFinAmt));
            mainRow.set(this.sourceRowMeta.getFieldIndex("finQty"), (Object)BigDecimal.ZERO);
            mainRow.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)BigDecimal.ZERO);
        } else {
            mainRow.set(this.sourceRowMeta.getFieldIndex("finQty"), (Object)fixedAmtFinQty);
            mainRow.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)fixedAmtFinAmt);
        }
        return isContainElseFact;
    }

    private List<RowX> calcSideProductCost(List<RowX> mainRows, Map<Long, RealTimeResultFinalResultVO> resultVoMaps, boolean isCostobjectDebug, StringBuilder debugMsg) {
        DynamicObject costObjectDyo;
        ArrayList colRows = Lists.newArrayList();
        boolean isOutSource = false;
        if (!RealTimeCalcFunctionHelper.isContainsProductFacted(resultVoMaps, "B")) {
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append("NotContainsSideProductFacted").append("\n");
            }
            return colRows;
        }
        boolean isOnlySideFactned = RealTimeCalcFunctionHelper.isOnlySideFactned(resultVoMaps);
        if (isCostobjectDebug && debugMsg != null) {
            debugMsg.append("OnlySideFactned").append(isOnlySideFactned).append("\n");
        }
        BigDecimal sideTotalAmt = BigDecimal.ZERO;
        BigDecimal curInAmt = BigDecimal.ZERO;
        BigDecimal curFinAmt = BigDecimal.ZERO;
        Long mainCostObjectId = mainRows.get(0).getLong(this.srcMeta.getFieldIndex("costObjectId"));
        HashMap elementCalcRowsMap = Maps.newHashMapWithExpectedSize((int)16);
        RowX baseRow = null;
        int i = 0;
        for (RowX rowX : mainRows) {
            if (i == 0) {
                baseRow = rowX;
            }
            ++i;
            Long elementId = rowX.getLong(this.srcMeta.getFieldIndex("elementId"));
            Long subElementId = rowX.getLong(this.srcMeta.getFieldIndex("subElementId"));
            this.subElementMap.put(subElementId, elementId);
            String outsourcetype = rowX.getString(this.srcMeta.getFieldIndex("outsourcetype"));
            Map map = elementCalcRowsMap.computeIfAbsent(subElementId, t -> Maps.newHashMapWithExpectedSize((int)2));
            map.computeIfAbsent(outsourcetype, t -> Lists.newArrayList()).add(rowX);
            curInAmt = curInAmt.add(BigDecimalUtil.getOrZero(rowX.getBigDecimal(this.srcMeta.getFieldIndex("calcAmt"))));
            curFinAmt = curFinAmt.add(BigDecimalUtil.getOrZero(rowX.getBigDecimal(this.srcMeta.getFieldIndex("finAmt"))));
        }
        for (Map.Entry entry : resultVoMaps.entrySet()) {
            RealTimeResultFinalResultVO resultVo = (RealTimeResultFinalResultVO)entry.getValue();
            if (resultVo.getOutsource() != null) {
                isOutSource = resultVo.getOutsource();
            }
            if (!"B".equals(resultVo.getProductType()) || resultVo.getCostcenterFinQtyMap() == null) continue;
            Map<Long, BigDecimal> sideSubElementCostMap = this.getSideSubElementCostMap(resultVo);
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append("sideElementMap:\n");
                for (Map.Entry<Long, BigDecimal> entry2 : sideSubElementCostMap.entrySet()) {
                    debugMsg.append(entry2.getKey()).append("->").append(entry2.getValue() == null ? "0" : entry2.getValue().toPlainString());
                }
            }
            for (Map.Entry<Long, BigDecimal> entry3 : sideSubElementCostMap.entrySet()) {
                entry3.setValue(entry3.getValue().setScale(this.args.getAmtScale(), 4));
                sideTotalAmt = sideTotalAmt.add(entry3.getValue());
            }
            colRows.addAll(this.calcSideSubElementCost(sideSubElementCostMap, elementCalcRowsMap, (Long)entry.getKey(), resultVo, baseRow, isOutSource, isOnlySideFactned, isCostobjectDebug, debugMsg));
            mainRows.clear();
            for (Map.Entry<Long, BigDecimal> entry4 : elementCalcRowsMap.entrySet()) {
                for (Map.Entry detailMap : ((Map)((Object)entry4.getValue())).entrySet()) {
                    mainRows.addAll((Collection)detailMap.getValue());
                }
            }
        }
        if (isOnlySideFactned) {
            if (sideTotalAmt.compareTo(curInAmt) >= 0) {
                costObjectDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)mainCostObjectId, (String)"cad_costobject", (String)"costcenter,name");
                String string = String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u526f\u5206\u914d\u6263\u51cf\u526f\u4ea7\u54c1\u5931\u8d25\uff0c\u526f\u4ea7\u54c1\u7684\u5b9a\u989d\u6210\u672c\u4e4b\u548c>=\u4ea7\u54c1\u6295\u5165\u6210\u672c\uff0c\u4e3b\u4ea7\u54c1\u6210\u672c\u5bf9\u8c61\u201c%1$s\u201d ,\u5dee\u989d\u4e3a\u201c%2$s\u201d\u3002", (String)"RealTimeCalcJoinSideAllocFunction_2", (String)"macc-aca-algox", (Object[])new Object[0]), costObjectDyo != null ? costObjectDyo.getString("name") : "", BigDecimalUtil.toString(sideTotalAmt.subtract(curInAmt)));
                RealTimeCalcFunctionHelper.insertCalcErrorInfo(this.args.getCalcLogId(), (Long)(costObjectDyo != null ? costObjectDyo.getLong("costcenter.id") : 0L), string);
            }
        } else if (sideTotalAmt.compareTo(curFinAmt) >= 0) {
            costObjectDyo = BusinessDataServiceHelper.loadSingle((Object)mainCostObjectId, (String)"cad_costobject", (String)"name,costcenter");
            String string = String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u526f\u5206\u914d\u6263\u51cf\u526f\u4ea7\u54c1\u5931\u8d25\uff0c\u526f\u4ea7\u54c1\u7684\u5b9a\u989d\u6210\u672c\u4e4b\u548c>=\u5b8c\u5de5\u4ea7\u54c1\u6210\u672c\uff0c\u4e3b\u4ea7\u54c1\u6210\u672c\u5bf9\u8c61\u201c%1$s\u201d\uff0c\u5dee\u989d\u4e3a\u201c%2$s\u201d\u3002", (String)"RealTimeCalcJoinSideAllocFunction_3", (String)"macc-aca-algox", (Object[])new Object[0]), costObjectDyo != null ? costObjectDyo.getString("name") : "", BigDecimalUtil.toString(sideTotalAmt.subtract(curFinAmt)));
            RealTimeCalcFunctionHelper.insertCalcErrorInfo(this.args.getCalcLogId(), (Long)(costObjectDyo != null ? costObjectDyo.getLong("costcenter.id") : 0L), string);
        }
        return colRows;
    }

    private List<RowX> calcSideSubElementCost(Map<Long, BigDecimal> sideSubElementCostMap, Map<Long, Map<String, List<RowX>>> elementCalcRowsMap, Long costobjectId, RealTimeResultFinalResultVO resultVo, RowX baseRow, boolean isOutSource, boolean isOnlySideFactned, boolean isCostobjectDebug, StringBuilder debugMsg) {
        ArrayList sideRows = Lists.newArrayList();
        for (Map.Entry<Long, BigDecimal> entry : sideSubElementCostMap.entrySet()) {
            Long subelementId = entry.getKey();
            Long elementId = this.subElementMap.get(subelementId);
            if (!elementCalcRowsMap.containsKey(subelementId)) {
                if (isCostobjectDebug && debugMsg != null) {
                    debugMsg.append("Not has elementCalcRows:").append(subelementId).append("\n");
                }
                String subElementType = this.subElementTypeMap.get(subelementId);
                String outSourceType = "";
                if (isOutSource) {
                    outSourceType = "001".equals(subElementType) || "002".equals(subElementType) ? "D" : "A";
                }
                RowX mainRow = this.getProductRow(baseRow, costobjectId, resultVo, false, true);
                mainRow.set(this.sourceRowMeta.getFieldIndex("outsourcetype"), (Object)outSourceType);
                if (isOnlySideFactned) {
                    mainRow.set(this.sourceRowMeta.getFieldIndex("inAmt"), (Object)entry.getValue().negate());
                } else {
                    mainRow.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)entry.getValue().negate());
                }
                mainRow.set(this.sourceRowMeta.getFieldIndex("elementId"), (Object)elementId);
                mainRow.set(this.sourceRowMeta.getFieldIndex("subElementId"), (Object)subelementId);
                ArrayList newMainRows = Lists.newArrayList();
                newMainRows.add(mainRow);
                HashMap outsourceTypeMap = Maps.newHashMapWithExpectedSize((int)4);
                outsourceTypeMap.put(outSourceType, newMainRows);
                elementCalcRowsMap.put(subelementId, outsourceTypeMap);
                RowX newRow = this.getProductRow(baseRow, costobjectId, resultVo, true, true);
                newRow.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)entry.getValue());
                newRow.set(this.sourceRowMeta.getFieldIndex("elementId"), (Object)elementId);
                newRow.set(this.sourceRowMeta.getFieldIndex("subElementId"), (Object)subelementId);
                sideRows.add(newRow);
                continue;
            }
            Map<String, List<RowX>> outSourceTypeRowMap = elementCalcRowsMap.get(subelementId);
            List<Object> splitRows = Lists.newArrayList();
            if (isOutSource) {
                if (outSourceTypeRowMap.containsKey("A")) {
                    splitRows = outSourceTypeRowMap.get("A");
                } else {
                    boolean i = false;
                    for (Map.Entry<String, List<RowX>> outsourceEntry : outSourceTypeRowMap.entrySet()) {
                        if (i) continue;
                        splitRows = outsourceEntry.getValue();
                        break;
                    }
                }
            } else {
                for (Map.Entry<String, List<RowX>> outsourceEntry : outSourceTypeRowMap.entrySet()) {
                    splitRows.addAll((Collection)outsourceEntry.getValue());
                }
            }
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append("Has elementCalcRows:").append(subelementId).append("\n");
            }
            this.sideProductAlloc(splitRows, sideRows, isOnlySideFactned, entry.getValue(), costobjectId, resultVo, isCostobjectDebug, debugMsg);
        }
        return sideRows;
    }

    private void sideProductAlloc(List<RowX> splitRows, List<RowX> sideRows, boolean isOnlySideFactned, BigDecimal fixAmt, Long costobjectId, RealTimeResultFinalResultVO resultVo, boolean isCostobjectDebug, StringBuilder debugMsg) {
        if (splitRows.size() == 1) {
            RowX mainRow;
            Integer subMatUnitPrecision;
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append("Only one Row").append("\n");
            }
            if ((subMatUnitPrecision = (mainRow = splitRows.get(0)).getInteger(this.srcMeta.getFieldIndex("subMatUnitPrecision"))) == null) {
                subMatUnitPrecision = 0;
            }
            BigDecimal calcFinAmt = this.getProductRowFinAmt(mainRow, isOnlySideFactned);
            BigDecimal calcFinQty = this.getProductRowFinQty(mainRow, isOnlySideFactned);
            BigDecimal sideFinQty = BigDecimal.ZERO;
            if (calcFinQty.compareTo(BigDecimal.ZERO) != 0 && calcFinAmt.compareTo(BigDecimal.ZERO) != 0) {
                sideFinQty = fixAmt.divide(calcFinAmt, 10, 4).multiply(calcFinQty).setScale((int)subMatUnitPrecision, 4);
            }
            if (isOnlySideFactned) {
                mainRow.set(this.sourceRowMeta.getFieldIndex("inAmt"), (Object)calcFinAmt.subtract(fixAmt));
                mainRow.set(this.sourceRowMeta.getFieldIndex("inQty"), (Object)calcFinQty.subtract(sideFinQty));
            } else {
                mainRow.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)calcFinAmt.subtract(fixAmt));
                mainRow.set(this.sourceRowMeta.getFieldIndex("finQty"), (Object)calcFinQty.subtract(sideFinQty));
            }
            RowX newRow = this.getProductRow(mainRow, costobjectId, resultVo, true, false);
            newRow.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)fixAmt);
            newRow.set(this.sourceRowMeta.getFieldIndex("finQty"), (Object)sideFinQty);
            sideRows.add(newRow);
        } else {
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append(splitRows.size()).append(" Rows").append("\n");
            }
            BigDecimal totalFinAmt = BigDecimal.ZERO;
            BigDecimal maxAbsFinAmt = BigDecimal.ZERO;
            for (RowX srow : splitRows) {
                BigDecimal calcFinAmt = this.getProductRowFinAmt(srow, isOnlySideFactned);
                totalFinAmt = totalFinAmt.add(calcFinAmt);
                if (calcFinAmt.abs().compareTo(maxAbsFinAmt) <= 0) continue;
                maxAbsFinAmt = calcFinAmt.abs();
            }
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append("totalFinAmt=").append(totalFinAmt.toPlainString()).append("maxAbsFinAmt=").append(maxAbsFinAmt.toPlainString()).append("fixAmt=").append(fixAmt.toPlainString()).append("\n");
            }
            if (totalFinAmt.compareTo(BigDecimal.ZERO) == 0) {
                totalFinAmt = maxAbsFinAmt;
            }
            BigDecimal remainAmt = fixAmt;
            RowX maxMainRow = null;
            RowX maxSideRow = null;
            for (RowX srow : splitRows) {
                BigDecimal calcFinAmt = this.getProductRowFinAmt(srow, isOnlySideFactned);
                BigDecimal radio = BigDecimal.ZERO;
                radio = totalFinAmt.compareTo(BigDecimal.ZERO) != 0 ? calcFinAmt.divide(totalFinAmt, 10, 4) : BigDecimal.ONE.divide(new BigDecimal(splitRows.size()), 10, 4);
                BigDecimal allocValue = radio.multiply(fixAmt).setScale(this.args.getAmtScale(), 4);
                remainAmt = remainAmt.subtract(allocValue);
                Integer subMatUnitPrecision = srow.getInteger(this.srcMeta.getFieldIndex("subMatUnitPrecision"));
                if (subMatUnitPrecision == null) {
                    subMatUnitPrecision = 0;
                }
                BigDecimal calcFinQty = this.getProductRowFinQty(srow, isOnlySideFactned);
                BigDecimal calcTempFinQty = this.getProductRowTempFinQty(srow, isOnlySideFactned);
                BigDecimal sideFinQty = BigDecimal.ZERO;
                if (calcFinQty.compareTo(BigDecimal.ZERO) != 0 && calcTempFinQty.compareTo(BigDecimal.ZERO) != 0 && calcFinAmt.compareTo(BigDecimal.ZERO) != 0) {
                    sideFinQty = allocValue.divide(calcFinAmt, 10, 4).multiply(calcTempFinQty).setScale((int)subMatUnitPrecision, 4);
                }
                if (isOnlySideFactned) {
                    srow.set(this.sourceRowMeta.getFieldIndex("inAmt"), (Object)calcFinAmt.subtract(allocValue));
                    srow.set(this.sourceRowMeta.getFieldIndex("inQty"), (Object)calcFinQty.subtract(sideFinQty));
                } else {
                    srow.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)calcFinAmt.subtract(allocValue));
                    srow.set(this.sourceRowMeta.getFieldIndex("finQty"), (Object)calcFinQty.subtract(sideFinQty));
                }
                RowX newRow = this.getProductRow(srow, costobjectId, resultVo, true, false);
                newRow.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)allocValue);
                newRow.set(this.sourceRowMeta.getFieldIndex("finQty"), (Object)sideFinQty);
                if (isCostobjectDebug && debugMsg != null) {
                    debugMsg.append("finAmt=").append(allocValue == null ? "0" : allocValue.toPlainString()).append("finQty=").append(sideFinQty == null ? "0" : sideFinQty.toPlainString()).append("\n");
                }
                sideRows.add(newRow);
                if (maxSideRow != null && maxSideRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("finAmt")).compareTo(allocValue) >= 0) continue;
                maxSideRow = newRow;
                maxMainRow = srow;
            }
            if (remainAmt.compareTo(BigDecimal.ZERO) != 0) {
                if (maxMainRow != null) {
                    maxMainRow.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)maxMainRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("finAmt")).subtract(remainAmt));
                }
                if (maxSideRow != null) {
                    maxSideRow.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)maxSideRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("finAmt")).add(remainAmt));
                }
            }
        }
    }

    private BigDecimal getProductRowFinQty(RowX row, boolean isOnlySideFactned) {
        if (isOnlySideFactned) {
            BigDecimal pdStartAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pdStartQty")));
            BigDecimal amount = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("qty")));
            return pdStartAmt.add(amount);
        }
        return BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("finQty")));
    }

    private BigDecimal getProductRowTempFinQty(RowX row, boolean isOnlySideFactned) {
        if (isOnlySideFactned) {
            BigDecimal pdStartAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pdStartQty")));
            BigDecimal amount = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("qty")));
            return pdStartAmt.add(amount);
        }
        return BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("finTempQty")));
    }

    private BigDecimal getProductRowFinAmt(RowX row, boolean isOnlySideFactned) {
        if (isOnlySideFactned) {
            return BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("calcAmt")));
        }
        return BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("finAmt")));
    }

    private Map<Long, BigDecimal> getSideSubElementCostMap(RealTimeResultFinalResultVO resultVo) {
        HashMap sideSubElementCostMap = Maps.newHashMapWithExpectedSize((int)8);
        for (Map.Entry<Long, BigDecimal> csEntry : resultVo.getCostcenterFinQtyMap().entrySet()) {
            String matKey = String.format("%s@%s@%s", resultVo.getMatId(), resultVo.getMatVerId(), resultVo.getMatAuxId());
            String manuOrg = "0";
            Long costcenterId = csEntry.getKey();
            List<ProextraPriceVo> sidePriceDyo = RealTimeCalcFunctionHelper.getsidePriceDyo(this.proextraPriceMap, matKey, String.valueOf(costcenterId), manuOrg);
            if (sidePriceDyo == null) {
                Long materialId = Long.valueOf(matKey.substring(0, matKey.indexOf("@")));
                DynamicObject costCenterDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)costcenterId, (String)"bos_costcenter", (String)"id,name");
                DynamicObject materialDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)materialId, (String)"bd_material", (String)"name");
                String errMsg = String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u526f\u5206\u914d\u6263\u51cf\u526f\u4ea7\u54c1\u5931\u8d25\uff0c\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u7269\u6599\u201c%2$s\u201d\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7269\u6599\u5b9a\u989d\u6210\u672c\u4ef7\u76ee\u8868\u6570\u636e\u3002", (String)"RealTimeCalcJoinSideAllocFunction_4", (String)"macc-aca-algox", (Object[])new Object[0]), costCenterDyo == null ? " " : costCenterDyo.getString("name"), materialDyo == null ? " " : materialDyo.getString("name"));
                RealTimeCalcFunctionHelper.insertCalcErrorInfo(this.args.getCalcLogId(), (Long)(costCenterDyo != null ? costCenterDyo.getLong("id") : 0L), errMsg);
                return sideSubElementCostMap;
            }
            for (ProextraPriceVo tmpEntry : sidePriceDyo) {
                BigDecimal sidePrice = BigDecimalUtil.getOrZero(tmpEntry.getPrice());
                Long subElementId = tmpEntry.getSubelement();
                Long elementId = tmpEntry.getElement();
                String subElementType = tmpEntry.getSubelementType();
                this.subElementTypeMap.put(subElementId, subElementType);
                this.subElementMap.put(subElementId, elementId);
                BigDecimal cost = sidePrice.multiply(csEntry.getValue()).setScale(this.args.getAmtScale(), RoundingMode.HALF_UP);
                if (sideSubElementCostMap.containsKey(subElementId)) {
                    cost = cost.add((BigDecimal)sideSubElementCostMap.get(subElementId));
                }
                sideSubElementCostMap.put(subElementId, cost);
            }
        }
        return sideSubElementCostMap;
    }

    private RowX getProductRow(RowX baseRow, Long costobjectId, RealTimeResultFinalResultVO resultVo, boolean isSetProduct, boolean isSetDetail) {
        RowX newRow = baseRow.copy();
        if (isSetProduct) {
            newRow.set(this.sourceRowMeta.getFieldIndex("costObjectId"), (Object)costobjectId);
            newRow.set(this.sourceRowMeta.getFieldIndex("productType"), (Object)resultVo.getProductType());
            newRow.set(this.sourceRowMeta.getFieldIndex("matId"), (Object)resultVo.getMatId());
            newRow.set(this.sourceRowMeta.getFieldIndex("matVerId"), (Object)resultVo.getMatVerId());
            newRow.set(this.sourceRowMeta.getFieldIndex("matAuxId"), (Object)resultVo.getMatAuxId());
        }
        if (isSetDetail) {
            newRow.set(this.sourceRowMeta.getFieldIndex("subMatId"), (Object)0L);
            newRow.set(this.sourceRowMeta.getFieldIndex("subMatVerId"), (Object)0L);
            newRow.set(this.sourceRowMeta.getFieldIndex("subMatAuxId"), (Object)0L);
            newRow.set(this.sourceRowMeta.getFieldIndex("isMfg"), (Object)1);
            newRow.set(this.sourceRowMeta.getFieldIndex("outsourcetype"), (Object)"");
        }
        newRow.set(this.sourceRowMeta.getFieldIndex("pdStartQty"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("pdStartAmt"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("qty"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("amount"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("finQty"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("inQty"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("inAmt"), (Object)BigDecimal.ZERO);
        return newRow;
    }
}

