/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.realtime.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.login.utils.StringUtils;
import kd.macc.aca.algox.realtime.RealTimeCostCalcArgs;
import kd.macc.aca.algox.utils.AcaDataSetXLogUtil;
import kd.macc.aca.algox.utils.BigDecimalUtil;

public class RealTimeCalcJoinSideDetailFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RealTimeCostCalcArgs args;

    public RealTimeCalcJoinSideDetailFunction(RealTimeCostCalcArgs args) {
        this.args = args;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iter, Collector cols) {
        List<RowX> rowXList = AcaDataSetXLogUtil.getListFromIterable(iter);
        int finQtyIndex = this.sourceRowMeta.getFieldIndex("finQty");
        int finAmtIndex = this.sourceRowMeta.getFieldIndex("finAmt");
        String subElementType = rowXList.get(0).getString(this.sourceRowMeta.getFieldIndex("subElementType"));
        for (RowX rowx : rowXList) {
            if (rowx.getBigDecimal(finAmtIndex) == null) continue;
            rowx.set(finAmtIndex, (Object)rowx.getBigDecimal(finAmtIndex).setScale(this.args.getAmtScale(), RoundingMode.HALF_UP));
        }
        if (("001".equals(subElementType) || "002".equals(subElementType)) && rowXList.get(0).getBigDecimal(finAmtIndex) != null) {
            HashMap costObjectStCostMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap stProQtyMap = Maps.newHashMapWithExpectedSize((int)16);
            for (RowX rowx : rowXList) {
                Long costobjectId = rowx.getLong(this.sourceRowMeta.getFieldIndex("costObjectId"));
                Long srcEntryId = rowx.getLong(this.sourceRowMeta.getFieldIndex("srcEntryId"));
                String productType = rowx.getString(this.sourceRowMeta.getFieldIndex("productType"));
                Long srcBillId = rowx.getLong(this.sourceRowMeta.getFieldIndex("srcBillId"));
                String groupField = rowx.getString(this.sourceRowMeta.getFieldIndex("groupfield"));
                Long groupCategoryId = rowx.getLong(this.sourceRowMeta.getFieldIndex("groupcategoryid"));
                Object[] objectArray = new Object[6];
                objectArray[0] = srcBillId;
                objectArray[1] = srcEntryId;
                objectArray[2] = costobjectId;
                objectArray[3] = productType;
                objectArray[4] = StringUtils.isEmpty((String)groupField) ? " " : groupField;
                Object object = objectArray[5] = groupCategoryId == null ? Long.valueOf(0L) : groupCategoryId;
                String key = String.format("%s@%s@%s@%s@%s@%s", objectArray);
                if (costObjectStCostMap.containsKey(key)) continue;
                costObjectStCostMap.put(key, rowx.getBigDecimal(this.sourceRowMeta.getFieldIndex("cost")));
                stProQtyMap.put(srcEntryId, rowx.getBigDecimal(this.sourceRowMeta.getFieldIndex("proFinQty")));
            }
            if (costObjectStCostMap.size() == 1) {
                for (RowX rowx : rowXList) {
                    Integer subMatUnitPrecision = rowx.getInteger(this.sourceRowMeta.getFieldIndex("subMatUnitPrecision"));
                    if (subMatUnitPrecision == null) {
                        subMatUnitPrecision = 0;
                    }
                    rowx.set(finQtyIndex, (Object)BigDecimalUtil.getOrZero(rowx.getBigDecimal(finQtyIndex)).setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP));
                    cols.collect(rowx);
                }
            } else {
                this.conversionDetail(rowXList, costObjectStCostMap, stProQtyMap, cols);
            }
        } else {
            for (RowX rowx : rowXList) {
                rowx.set(finQtyIndex, (Object)BigDecimal.ZERO);
                rowx.set(finAmtIndex, (Object)rowx.getBigDecimal(this.sourceRowMeta.getFieldIndex("cost")));
                cols.collect(rowx);
            }
        }
    }

    private void conversionDetail(List<RowX> rowXList, Map<String, BigDecimal> costObjectCostMap, Map<Long, BigDecimal> stProQtyMap, Collector cols) {
        int finQtyIndex = this.sourceRowMeta.getFieldIndex("finQty");
        int finAmtIndex = this.sourceRowMeta.getFieldIndex("finAmt");
        List<RowX> allocRowXs = this.getAllocRowxs(rowXList);
        Map<String, BigDecimal> costobjectAllocRadioMap = this.getCostobjectAllocRadio(costObjectCostMap);
        ArrayList colloctorRowx = Lists.newArrayList();
        for (RowX rowx : allocRowXs) {
            RowX maxRow = null;
            BigDecimal qtyDiff = BigDecimalUtil.getOrZero(rowx.getBigDecimal(finQtyIndex));
            BigDecimal amtDiff = BigDecimalUtil.getOrZero(rowx.getBigDecimal(finAmtIndex));
            Integer subMatUnitPrecision = rowx.getInteger(this.sourceRowMeta.getFieldIndex("subMatUnitPrecision"));
            if (subMatUnitPrecision == null) {
                subMatUnitPrecision = 0;
            }
            for (Map.Entry<String, BigDecimal> entry : costobjectAllocRadioMap.entrySet()) {
                RowX targetRow = rowx.copy();
                BigDecimal qty = BigDecimalUtil.getOrZero(targetRow.getBigDecimal(finQtyIndex));
                BigDecimal amt = BigDecimalUtil.getOrZero(targetRow.getBigDecimal(finAmtIndex));
                amt = amt.multiply(entry.getValue()).setScale(this.args.getAmtScale(), RoundingMode.HALF_UP);
                qty = qty.multiply(entry.getValue()).setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP);
                qtyDiff = qtyDiff.subtract(qty);
                amtDiff = amtDiff.subtract(amt);
                if (maxRow == null || maxRow.getBigDecimal(finAmtIndex).compareTo(amt) < 0) {
                    maxRow = targetRow;
                }
                targetRow.set(finQtyIndex, (Object)qty);
                targetRow.set(finAmtIndex, (Object)amt);
                String[] keys = entry.getKey().split("@");
                targetRow.set(this.sourceRowMeta.getFieldIndex("srcBillId"), (Object)Long.valueOf(keys[0]));
                targetRow.set(this.sourceRowMeta.getFieldIndex("srcEntryId"), (Object)Long.valueOf(keys[1]));
                targetRow.set(this.sourceRowMeta.getFieldIndex("costObjectId"), (Object)Long.valueOf(keys[2]));
                targetRow.set(this.sourceRowMeta.getFieldIndex("productType"), (Object)keys[3]);
                targetRow.set(this.sourceRowMeta.getFieldIndex("groupfield"), (Object)keys[4]);
                targetRow.set(this.sourceRowMeta.getFieldIndex("groupcategoryid"), (Object)Long.parseLong(keys[5]));
                targetRow.set(this.sourceRowMeta.getFieldIndex("proFinQty"), (Object)stProQtyMap.get(Long.valueOf(keys[1])));
                colloctorRowx.add(targetRow);
            }
            if (qtyDiff.compareTo(BigDecimal.ZERO) != 0 && maxRow != null) {
                maxRow.set(finQtyIndex, (Object)maxRow.getBigDecimal(finQtyIndex).add(qtyDiff));
            }
            if (amtDiff.compareTo(BigDecimal.ZERO) == 0 || maxRow == null) continue;
            maxRow.set(finAmtIndex, (Object)maxRow.getBigDecimal(finAmtIndex).add(amtDiff));
        }
        for (RowX rowx : colloctorRowx) {
            cols.collect(rowx);
        }
    }

    private List<RowX> getAllocRowxs(List<RowX> rowXList) {
        Long calcCostobjectId = null;
        HashSet matIds = Sets.newHashSetWithExpectedSize((int)16);
        ArrayList allocRowXs = Lists.newArrayList();
        for (RowX rowx : rowXList) {
            Long costobjectId = rowx.getLong(this.sourceRowMeta.getFieldIndex("costObjectId"));
            if (calcCostobjectId == null) {
                calcCostobjectId = costobjectId;
            }
            String key = String.format("%s@%s@%s", rowx.getLong(this.sourceRowMeta.getFieldIndex("subMatId")), rowx.getLong(this.sourceRowMeta.getFieldIndex("subMatVerId")), rowx.getLong(this.sourceRowMeta.getFieldIndex("subMatAuxId")));
            if (!costobjectId.equals(calcCostobjectId) || !matIds.add(key)) continue;
            allocRowXs.add(rowx);
        }
        return allocRowXs;
    }

    private Map<String, BigDecimal> getCostobjectAllocRadio(Map<String, BigDecimal> costObjectCostMap) {
        HashMap costobjectAllocRadioMap = Maps.newHashMapWithExpectedSize((int)16);
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal maxValue = null;
        for (Map.Entry<String, BigDecimal> entry : costObjectCostMap.entrySet()) {
            totalAmt = totalAmt.add(entry.getValue());
            if (maxValue != null && maxValue.compareTo(entry.getValue().abs()) >= 0) continue;
            maxValue = entry.getValue().abs();
        }
        if (totalAmt.compareTo(BigDecimal.ZERO) == 0 && ((totalAmt = maxValue) == null || totalAmt.compareTo(BigDecimal.ZERO) == 0)) {
            for (Map.Entry<String, BigDecimal> entry : costObjectCostMap.entrySet()) {
                costobjectAllocRadioMap.put(entry.getKey(), BigDecimal.ZERO);
            }
            return costobjectAllocRadioMap;
        }
        for (Map.Entry<String, BigDecimal> entry : costObjectCostMap.entrySet()) {
            costobjectAllocRadioMap.put(entry.getKey(), entry.getValue().divide(totalAmt, 10, RoundingMode.HALF_UP));
        }
        return costobjectAllocRadioMap;
    }
}

