/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.realtime.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.aca.algox.realtime.RealTimeCostCalcArgs;
import kd.macc.aca.algox.realtime.RealTimeResultFinalResultVO;
import kd.macc.aca.algox.realtime.function.RealTimeCalcFunctionHelper;
import kd.macc.aca.algox.utils.BigDecimalUtil;

public class RealTimeCarryForwardCalcFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta srcMeta;
    private RealTimeCostCalcArgs args;
    private Map<Long, Map<Long, RealTimeResultFinalResultVO>> calcCostobjectFinalResultMap;

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public RealTimeCarryForwardCalcFunction(RowMeta rowMeta, RealTimeCostCalcArgs args, Map<Long, Map<Long, RealTimeResultFinalResultVO>> calcCostobjectFinalResultMap) {
        this.srcMeta = rowMeta;
        this.calcCostobjectFinalResultMap = calcCostobjectFinalResultMap;
        this.args = args;
    }

    public void reduce(Iterable<RowX> iter, Collector col) {
        ArrayList rows = Lists.newArrayList();
        boolean headFlag = false;
        boolean detailFlag = false;
        boolean preFlag = false;
        for (RowX row : iter) {
            rows.add(row);
        }
        int i = 0;
        Long costObjectId = 0L;
        Long costCenterId = 0L;
        boolean isHasFinQty = false;
        boolean isAllReCalcTypeRow = true;
        for (RowX row : rows) {
            String rowType;
            if (i == 0) {
                costObjectId = row.getLong(this.srcMeta.getFieldIndex("costObjectId"));
                costCenterId = row.getLong(this.srcMeta.getFieldIndex("costCenterId"));
                BigDecimal pdStartQty = BigDecimal.ZERO;
                BigDecimal proPlanQty = BigDecimal.ZERO;
                if (this.calcCostobjectFinalResultMap.get(costObjectId) != null) {
                    for (Map.Entry<Long, RealTimeResultFinalResultVO> entry : this.calcCostobjectFinalResultMap.get(costObjectId).entrySet()) {
                        RealTimeResultFinalResultVO value = entry.getValue();
                        proPlanQty = proPlanQty.add(value.getProPlanQty());
                        if (!CollectionUtils.isEmpty(value.getCostcenterFinQtyMap())) {
                            isHasFinQty = true;
                        }
                        pdStartQty = pdStartQty.add(value.getPdStartQty());
                    }
                }
                if (isHasFinQty) {
                    headFlag = true;
                }
                if (pdStartQty.compareTo(BigDecimal.ZERO) > 0) {
                    headFlag = true;
                }
                if (pdStartQty.compareTo(BigDecimal.ZERO) != 0 && proPlanQty.compareTo(BigDecimal.ZERO) == 0) {
                    preFlag = true;
                }
            }
            BigDecimal qty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("qty")));
            BigDecimal amount = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("amount")));
            BigDecimal pdStartAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pdStartAmt")));
            if (qty.compareTo(BigDecimal.ZERO) != 0 || amount.compareTo(BigDecimal.ZERO) != 0) {
                detailFlag = true;
            }
            if (!"1".equals(rowType = row.getString(this.srcMeta.getFieldIndex("rowtype")))) {
                isAllReCalcTypeRow = false;
            }
            if (pdStartAmt.compareTo(BigDecimal.ZERO) != 0) {
                detailFlag = true;
            }
            ++i;
        }
        if (isHasFinQty && !detailFlag) {
            DynamicObject costCenterDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)costCenterId, (String)"bos_costcenter", (String)"id,name");
            DynamicObject costObjectDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)costObjectId, (String)"cad_costobject", (String)"name");
            String errStr = String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u6210\u672c\u5bf9\u8c61\u201c%2$s\u201d\u6295\u5165\u6210\u672c\u4e3a0\uff0c\u5b58\u5728\u5b8c\u5de5\u5165\u5e93\u5355\u6570\u636e\u3002", (String)"RealTimeCarryForwardCalcFunction_0", (String)"macc-aca-algox", (Object[])new Object[0]), this.getDynName(costCenterDyo), this.getDynName(costObjectDyo));
            RealTimeCalcFunctionHelper.insertCalcErrorInfo(this.args.getCalcLogId(), (Long)(costCenterDyo != null ? costCenterDyo.getLong("id") : 0L), errStr, "1");
            return;
        }
        if (!isHasFinQty && isAllReCalcTypeRow) {
            return;
        }
        if (preFlag && !detailFlag) {
            return;
        }
        if (headFlag || detailFlag) {
            for (RowX row : rows) {
                col.collect(row);
            }
        }
    }

    private String getDynName(DynamicObject obj) {
        if (obj == null) {
            return "";
        }
        return obj.getString("name");
    }
}

