/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.realtime.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.aca.algox.costcalc.common.ProextraPriceVo;
import kd.macc.aca.algox.realtime.RealTimeCostCalcArgs;
import kd.macc.aca.algox.realtime.RealTimeResultFinalResultVO;
import kd.macc.aca.algox.realtime.function.RealTimeCalcFunctionHelper;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.LogUtils;

public class RealTimeInCalcFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 8750794000883579691L;
    private static final Log logger = LogFactory.getLog(RealTimeInCalcFunction.class);
    private RowMeta srcMeta;
    private RealTimeCostCalcArgs args;
    private Map<Long, Map<Long, RealTimeResultFinalResultVO>> calcCostobjectFinalResultMap;
    private Map<String, List<ProextraPriceVo>> proextraPriceMap;

    public RealTimeInCalcFunction(RowMeta rowMeta, RealTimeCostCalcArgs args, Map<String, List<ProextraPriceVo>> proextraPriceMap, Map<Long, Map<Long, RealTimeResultFinalResultVO>> calcCostobjectFinalResultMap) {
        this.srcMeta = rowMeta;
        this.args = args;
        this.calcCostobjectFinalResultMap = calcCostobjectFinalResultMap;
        this.proextraPriceMap = proextraPriceMap;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList listRows = Lists.newArrayList();
        for (RowX row : iterable) {
            listRows.add(row);
        }
        if (listRows.isEmpty()) {
            return;
        }
        RowX row = (RowX)listRows.get(0);
        Long mainCostObjectId = row.getLong(this.srcMeta.getFieldIndex("mainCostObjectId"));
        Long costObjectId = row.getLong(this.srcMeta.getFieldIndex("costObjectId"));
        if (!this.calcCostobjectFinalResultMap.containsKey(mainCostObjectId)) {
            return;
        }
        if (!this.calcCostobjectFinalResultMap.get(mainCostObjectId).containsKey(costObjectId)) {
            return;
        }
        if (listRows.size() == 1) {
            ((RowX)listRows.get(0)).set(this.sourceRowMeta.getFieldIndex("cost"), (Object)((RowX)listRows.get(0)).getBigDecimal(this.sourceRowMeta.getFieldIndex("finAmt")));
        } else {
            RealTimeResultFinalResultVO resultVo = this.calcCostobjectFinalResultMap.get(mainCostObjectId).get(costObjectId);
            if (!"B".equals(resultVo.getProductType())) {
                this.mainJoinFactedCalc(listRows, resultVo);
            } else {
                this.sideFactedCalc(listRows, resultVo);
            }
        }
        for (RowX lRow : listRows) {
            collector.collect(lRow);
        }
    }

    private void sideFactedCalc(List<RowX> listRows, RealTimeResultFinalResultVO resultVo) {
        int i = 0;
        BigDecimal diffFinAmt = BigDecimal.ZERO;
        RowX maxRow = null;
        for (RowX row : listRows) {
            if (i == 0) {
                diffFinAmt = row.getBigDecimal(this.srcMeta.getFieldIndex("finAmt"));
            }
            ++i;
            BigDecimal proFinQty = row.getBigDecimal(this.srcMeta.getFieldIndex("proFinQty"));
            Long costcenterId = row.getLong(this.srcMeta.getFieldIndex("factedCostCenterId"));
            Long subElementId = row.getLong(this.srcMeta.getFieldIndex("subElementId"));
            BigDecimal sideSubElementPrice = this.getSubElementPrice(resultVo, costcenterId, subElementId);
            BigDecimal cost = proFinQty.multiply(sideSubElementPrice).setScale(this.args.getAmtScale(), RoundingMode.HALF_UP);
            row.set(this.srcMeta.getFieldIndex("cost"), (Object)cost);
            if (maxRow == null || maxRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("cost")).compareTo(cost) < 0) {
                maxRow = row;
            }
            diffFinAmt = diffFinAmt.subtract(cost);
        }
        if (diffFinAmt.compareTo(BigDecimal.ZERO) != 0 && maxRow != null) {
            maxRow.set(this.sourceRowMeta.getFieldIndex("cost"), (Object)maxRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("cost")).add(diffFinAmt));
        }
    }

    private BigDecimal getSubElementPrice(RealTimeResultFinalResultVO resultVo, Long costcenterId, Long subElementId) {
        BigDecimal sideSubElementPrice = BigDecimal.ZERO;
        String matKey = String.format("%s@%s@%s", resultVo.getMatId(), resultVo.getMatVerId(), resultVo.getMatAuxId());
        String manuOrg = "0";
        List<ProextraPriceVo> sidePriceDyo = RealTimeCalcFunctionHelper.getsidePriceDyo(this.proextraPriceMap, matKey, String.valueOf(costcenterId), manuOrg);
        if (sidePriceDyo == null) {
            return sideSubElementPrice;
        }
        for (ProextraPriceVo tmpEntry : sidePriceDyo) {
            if (!subElementId.equals(tmpEntry.getSubelement())) continue;
            sideSubElementPrice = sideSubElementPrice.add(BigDecimalUtil.getOrZero(tmpEntry.getPrice()));
        }
        return sideSubElementPrice;
    }

    private void mainJoinFactedCalc(List<RowX> listRows, RealTimeResultFinalResultVO resultVo) {
        BigDecimal totalQty = BigDecimal.ZERO;
        BigDecimal tmpQty = BigDecimal.ZERO;
        BigDecimal finAmt = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal proCalcQty = BigDecimal.ZERO;
        Long costObjectId = 0L;
        Long subElementId = 0L;
        Long costCenterId = 0L;
        RowX fillDiffRow = null;
        int i = 0;
        for (RowX row : listRows) {
            BigDecimal proFinQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("proFinQty")));
            if (proFinQty.abs().compareTo(tmpQty.abs()) > 0) {
                tmpQty = proFinQty;
                fillDiffRow = row;
            }
            if (i == 0) {
                finAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("finAmt")));
                amount = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("calcAmt")));
                proCalcQty = resultVo.getPdCalcQty();
                costObjectId = row.getLong(this.srcMeta.getFieldIndex("costObjectId"));
                subElementId = row.getLong(this.srcMeta.getFieldIndex("subElementId"));
                costCenterId = row.getLong(this.srcMeta.getFieldIndex("costCenterId"));
            }
            totalQty = totalQty.add(proFinQty);
            ++i;
            if (!StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) || !this.args.getDebugColVal().equals(String.valueOf(costObjectId))) continue;
            LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u5355\u6210\u672c\u8ba1\u7b97 setup1:fields %1$s,values %2$s", (String)"RealTimeInCalcFunction_0", (String)"macc-aca-algox", (Object[])new Object[0]), Arrays.toString(this.srcMeta.getFieldNames()), row));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) && this.args.getDebugColVal().equals(String.valueOf(costObjectId))) {
            LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u5355\u6210\u672c\u8ba1\u7b97 setup2:totalQty %1$s,finAmt %2$s,amount %3$s,proPlanQty %4$s,subElementId %5$s,fillDiffRow %6$s", (String)"RealTimeInCalcFunction_1", (String)"macc-aca-algox", (Object[])new Object[0]), totalQty, finAmt, amount, proCalcQty, subElementId, fillDiffRow));
        }
        BigDecimal unitCost = null;
        if (totalQty.compareTo(BigDecimal.ZERO) == 0) {
            if (proCalcQty.compareTo(BigDecimal.ZERO) == 0) {
                DynamicObject costCenterDyo = BusinessDataServiceHelper.loadSingle((Object)costCenterId, (String)"bos_costcenter", (String)"id,name");
                DynamicObject costCostObjetDyo = BusinessDataServiceHelper.loadSingle((Object)costObjectId, (String)"cad_costobject", (String)"name");
                DynamicObject subElementDyo = BusinessDataServiceHelper.loadSingle((Object)subElementId, (String)"cad_subelement", (String)"name");
                String errStr = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u5165\u5e93\u6210\u672c\u5931\u8d25\uff0c\u5f53\u671f\u6210\u672c\u5bf9\u8c61\u5b8c\u5de5\u6570\u91cf\u5408\u8ba1\u4e3a0\uff0c\u4e14\u671f\u672b\u5728\u4ea7\u6570\u91cf\u5408\u8ba1\u4e3a0\u3002", (String)"RealTimeInCalcFunction_2", (String)"macc-aca-algox", (Object[])new Object[0]), costCenterDyo != null ? costCenterDyo.getString("name") : "", costCostObjetDyo != null ? costCostObjetDyo.getString("name") : "", subElementDyo != null ? subElementDyo.getString("name") : "");
                RealTimeCalcFunctionHelper.insertCalcErrorInfo(this.args.getCalcLogId(), (Long)(costCenterDyo != null ? costCenterDyo.getLong("id") : 0L), errStr);
                return;
            }
            unitCost = amount.divide(proCalcQty, this.args.getPriceScale(), RoundingMode.HALF_UP);
        } else {
            unitCost = finAmt.divide(totalQty, this.args.getPriceScale(), RoundingMode.HALF_UP);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) && this.args.getDebugColVal().equals(String.valueOf(costObjectId))) {
            LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u5355\u6210\u672c\u8ba1\u7b97 setup3:unitCost %s", (String)"RealTimeInCalcFunction_3", (String)"macc-aca-algox", (Object[])new Object[0]), unitCost));
        }
        BigDecimal diffAmt = finAmt;
        for (RowX row : listRows) {
            BigDecimal proFinQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("proFinQty")));
            BigDecimal cost = proFinQty.multiply(unitCost).setScale(this.args.getAmtScale(), RoundingMode.HALF_UP);
            row.set(this.srcMeta.getFieldIndex("cost"), (Object)cost);
            diffAmt = diffAmt.subtract(cost);
            if (!StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) || !this.args.getDebugColVal().equals(String.valueOf(costObjectId))) continue;
            LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u5355\u6210\u672c\u8ba1\u7b97 setup4:cost %1$s row %2$s", (String)"RealTimeInCalcFunction_4", (String)"macc-aca-algox", (Object[])new Object[0]), cost, row));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) && this.args.getDebugColVal().equals(String.valueOf(costObjectId))) {
            LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u5355\u6210\u672c\u8ba1\u7b97 setup5:diffAmt %s", (String)"RealTimeInCalcFunction_5", (String)"macc-aca-algox", (Object[])new Object[0]), diffAmt));
        }
        if (diffAmt.compareTo(BigDecimal.ZERO) != 0 && fillDiffRow != null) {
            BigDecimal cost = fillDiffRow.getBigDecimal(this.srcMeta.getFieldIndex("cost"));
            cost = cost.add(diffAmt);
            fillDiffRow.set(this.srcMeta.getFieldIndex("cost"), (Object)cost);
        }
    }
}

