/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.realtime.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.aca.algox.realtime.RealTimeCostCalcArgs;
import kd.macc.aca.algox.realtime.RealTimeDebugInfoMsgHandler;
import kd.macc.aca.algox.realtime.RealTimeResultFinalResultVO;
import kd.macc.aca.algox.realtime.function.RealTimeCalcFunctionHelper;
import kd.macc.aca.algox.utils.BigDecimalUtil;

public class RealTimeInCostCalcFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 4078799106560892878L;
    private RowMeta srcMeta;
    private RealTimeCostCalcArgs args;
    private Map<String, String> proallocstdMap;
    private Map<String, BigDecimal> equivalentMap;
    private Map<Long, Map<Long, RealTimeResultFinalResultVO>> calcCostobjectFinalResultMap;
    private Map<String, String> allocTypeMap;
    private Map<String, BigDecimal[]> weightMap;
    private RealTimeDebugInfoMsgHandler msgHander = null;
    private String inventoryMode;

    public RealTimeInCostCalcFunction(RowMeta rowMeta, RealTimeCostCalcArgs args, Map<String, String> proallocstdMap, Map<String, BigDecimal> equivalentMap, Map<Long, Map<Long, RealTimeResultFinalResultVO>> calcCostobjectFinalResultMap, Map<String, String> allocTypeMap, Map<String, BigDecimal[]> weightMap, String inventoryMode, RealTimeDebugInfoMsgHandler msgHander) {
        this.srcMeta = rowMeta;
        this.args = args;
        this.proallocstdMap = proallocstdMap;
        this.equivalentMap = equivalentMap;
        this.calcCostobjectFinalResultMap = calcCostobjectFinalResultMap;
        this.inventoryMode = inventoryMode;
        this.allocTypeMap = allocTypeMap;
        this.weightMap = weightMap;
        this.msgHander = msgHander;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public void reduce(Iterable<RowX> iter, Collector collector) {
        ArrayList rows = Lists.newArrayList();
        for (RowX row : iter) {
            row.set(this.srcMeta.getFieldIndex("mainCostObjectId"), (Object)row.getLong(this.srcMeta.getFieldIndex("costObjectId")));
            rows.add(row);
        }
        if (rows.isEmpty()) {
            return;
        }
        RowX row = (RowX)rows.get(0);
        Long costObjectId = row.getLong(this.srcMeta.getFieldIndex("costObjectId"));
        if (!this.calcCostobjectFinalResultMap.containsKey(costObjectId)) {
            return;
        }
        if (!this.calcCostobjectFinalResultMap.get(costObjectId).containsKey(costObjectId)) {
            return;
        }
        StringBuilder debugMsg = null;
        boolean isCostobjectDebug = RealTimeCalcFunctionHelper.isCostobjectDebug(this.args, costObjectId);
        if (isCostobjectDebug) {
            debugMsg = new StringBuilder();
            debugMsg.append(ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u8ba1\u7b97\uff1a\n", (String)"RealTimeInCostCalcFunction_0", (String)"macc-aca-algox", (Object[])new Object[0]));
        }
        this.wipMatCheckQtyDeal(rows, isCostobjectDebug, debugMsg);
        Map<Long, RealTimeResultFinalResultVO> resultVos = this.calcCostobjectFinalResultMap.get(costObjectId);
        ArrayList colRows = Lists.newArrayList();
        for (RowX itRow : rows) {
            RowX colRow = this.map(itRow, resultVos, isCostobjectDebug, debugMsg);
            if (colRow == null) continue;
            colRows.add(colRow);
        }
        if (isCostobjectDebug && this.msgHander != null && debugMsg != null) {
            this.msgHander.dealInfoMsg(debugMsg.toString());
        }
        for (RowX itRow : colRows) {
            collector.collect(itRow);
        }
    }

    private void wipMatCheckQtyDeal(List<RowX> rows, boolean isCostobjectDebug, StringBuilder debugMsg) {
        BigDecimal inventValue;
        HashMap matRowsMap = Maps.newHashMapWithExpectedSize((int)2);
        for (RowX rowX : rows) {
            inventValue = rowX.getBigDecimal(this.srcMeta.getFieldIndex("inventValue"));
            if (inventValue == null || BigDecimal.ZERO.compareTo(inventValue) == 0) continue;
            Long costCenterId = rowX.getLong(this.srcMeta.getFieldIndex("costCenterId"));
            Long subElementId = rowX.getLong(this.srcMeta.getFieldIndex("subElementId"));
            String allocStd = RealTimeCalcFunctionHelper.getProductAllocStd(this.proallocstdMap, this.args.getCostAccountId(), costCenterId, subElementId);
            if (!"4".equals(allocStd)) continue;
            Long materialId = rowX.getLong(this.srcMeta.getFieldIndex("subMatId"));
            matRowsMap.computeIfAbsent(materialId, t -> Lists.newArrayList()).add(rowX);
        }
        for (Map.Entry entry : matRowsMap.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append(ResManager.loadKDString((String)"\u5206\u914d\u6807\u51c6\u4e3a\u6309\u5728\u4ea7\u6750\u6599\u5206\u914d\u65f6\uff0c\u5982\u679c\u51fa\u73b0\u76f8\u540c\u7269\u6599\uff0c\u4e0d\u540c\u5b50\u8981\u7d20\uff0c\u9700\u8981\u6309\u6295\u5165\u6bd4\u4f8b\u5206\u914d\u4e00\u4e0b\u5728\u4ea7\u6570\u91cf\u3002\n", (String)"RealTimeInCostCalcFunction_1", (String)"macc-aca-algox", (Object[])new Object[0]));
            }
            inventValue = ((RowX)((List)entry.getValue()).get(0)).getBigDecimal(this.srcMeta.getFieldIndex("inventValue"));
            BigDecimal totalQty = BigDecimal.ZERO;
            BigDecimal maxAbsQty = null;
            for (RowX row : (List)entry.getValue()) {
                BigDecimal pdStartQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pdStartQty")));
                BigDecimal qty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("qty")));
                BigDecimal calcQty = pdStartQty.add(qty);
                totalQty = totalQty.add(calcQty);
                if (maxAbsQty != null && maxAbsQty.compareTo(calcQty.abs()) >= 0) continue;
                maxAbsQty = calcQty.abs();
            }
            if (totalQty.compareTo(BigDecimal.ZERO) == 0 && maxAbsQty != null) {
                totalQty = maxAbsQty;
            }
            if (totalQty.compareTo(BigDecimal.ZERO) == 0) continue;
            RowX maxRow = null;
            BigDecimal diffVal = inventValue;
            for (RowX row : (List)entry.getValue()) {
                Integer subMatUnitPrecision = row.getInteger(this.srcMeta.getFieldIndex("subMatUnitPrecision"));
                if (subMatUnitPrecision == null) {
                    subMatUnitPrecision = 0;
                }
                BigDecimal pdStartQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pdStartQty")));
                BigDecimal qty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("qty")));
                BigDecimal calcQty = pdStartQty.add(qty);
                BigDecimal rowInvVal = calcQty.divide(totalQty, 10, RoundingMode.HALF_UP).multiply(inventValue).setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP);
                diffVal = diffVal.subtract(rowInvVal);
                row.set(this.srcMeta.getFieldIndex("inventValue"), (Object)rowInvVal);
                if (maxRow != null && maxRow.getBigDecimal(this.srcMeta.getFieldIndex("inventValue")).compareTo(rowInvVal) >= 0) continue;
                maxRow = row;
            }
            if (diffVal.compareTo(BigDecimal.ZERO) == 0 || maxRow == null) continue;
            maxRow.set(this.srcMeta.getFieldIndex("inventValue"), (Object)maxRow.getBigDecimal(this.srcMeta.getFieldIndex("inventValue")).add(diffVal));
        }
    }

    public RowX map(RowX row, Map<Long, RealTimeResultFinalResultVO> productGroupCostObjMap, boolean isCostobjectDebug, StringBuilder debugMsg) {
        Long costCenterId = row.getLong(this.srcMeta.getFieldIndex("costCenterId"));
        Long costObjectId = row.getLong(this.srcMeta.getFieldIndex("costObjectId"));
        Long materialId = row.getLong(this.srcMeta.getFieldIndex("matId"));
        Long subElementId = row.getLong(this.srcMeta.getFieldIndex("subElementId"));
        BigDecimal pdStartQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pdStartQty")));
        BigDecimal pdStartAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pdStartAmt")));
        BigDecimal qty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("qty")));
        BigDecimal amount = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("amount")));
        BigDecimal finQty = BigDecimal.ZERO;
        BigDecimal finAmt = BigDecimal.ZERO;
        BigDecimal intQty = BigDecimal.ZERO;
        BigDecimal intAmt = BigDecimal.ZERO;
        String allocStd = RealTimeCalcFunctionHelper.getProductAllocStd(this.proallocstdMap, this.args.getCostAccountId(), costCenterId, subElementId);
        if (isCostobjectDebug && debugMsg != null) {
            debugMsg.append(String.format("costCenterId=%s,materialId=%s,subElementId=%s,allocStd=%s %n", costCenterId, materialId, subElementId, allocStd));
        }
        if (StringUtils.isEmpty((String)allocStd)) {
            DynamicObject costCenterDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)costCenterId, (String)"bos_costcenter", (String)"id,name");
            DynamicObject subElementDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)subElementId, (String)"cad_subelement", (String)"name");
            String errStr = String.format(ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u5206\u914d\u5931\u8d25\uff0c\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\u672a\u627e\u5230\u201c\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6\u201d\u3002", (String)"RealTimeInCostCalcFunction_2", (String)"macc-aca-algox", (Object[])new Object[0]), this.getDynName(costCenterDyo), this.getDynName(subElementDyo));
            RealTimeCalcFunctionHelper.insertCalcErrorInfo(this.args.getCalcLogId(), (Long)(costCenterDyo != null ? costCenterDyo.getLong("id") : 0L), errStr);
            return null;
        }
        Integer subMatUnitPrecision = row.getInteger(this.srcMeta.getFieldIndex("subMatUnitPrecision"));
        if (subMatUnitPrecision == null) {
            subMatUnitPrecision = 0;
        }
        BigDecimal proIntrQty = RealTimeCalcFunctionHelper.getMainAndJoinProEndQty(productGroupCostObjMap);
        BigDecimal proFinQty = RealTimeCalcFunctionHelper.getMainAndJoinProFinQty(productGroupCostObjMap);
        BigDecimal calcQty = pdStartQty.add(qty);
        BigDecimal calcAmt = pdStartAmt.add(amount).setScale(this.args.getAmtScale(), 4);
        if (proFinQty.compareTo(BigDecimal.ZERO) == 0) {
            intQty = calcQty;
            intAmt = calcAmt;
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append("proFinQty=0 \n");
            }
        } else if ("0".equals(allocStd) || proIntrQty.compareTo(BigDecimal.ZERO) <= 0) {
            finQty = calcQty.setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP);
            finAmt = calcAmt;
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append("allocStd=0 or proIntrQty=").append(proIntrQty.toPlainString()).append("\n");
            }
        } else if ("1".equals(allocStd) || "2".equals(allocStd)) {
            BigDecimal tmpA;
            BigDecimal equivalent = BigDecimal.ONE;
            if ("2".equals(allocStd)) {
                equivalent = RealTimeCalcFunctionHelper.getCostobjectEquivalent(this.equivalentMap, this.args.getCostAccountId(), costCenterId, costObjectId, subElementId);
                if (isCostobjectDebug && debugMsg != null) {
                    debugMsg.append("equivalent=").append(equivalent == null ? "null" : equivalent.toPlainString()).append("\n");
                }
                if (equivalent == null) {
                    DynamicObject costCenterDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)costCenterId, (String)"bos_costcenter", (String)"id,name");
                    DynamicObject costObjectDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)costObjectId, (String)"cad_costobject", (String)"name");
                    DynamicObject subElementDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)subElementId, (String)"cad_subelement", (String)"name");
                    String errStr = String.format(ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u5206\u914d\u5931\u8d25\uff0c\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u6210\u672c\u5bf9\u8c61\u201c%2$s\u201d\u5b50\u8981\u7d20\u201c%3$s\u201d\u672a\u8bbe\u7f6e\u7ea6\u5f53\u7cfb\u6570\u3002", (String)"RealTimeInCostCalcFunction_3", (String)"macc-aca-algox", (Object[])new Object[0]), this.getDynName(costCenterDyo), this.getDynName(costObjectDyo), this.getDynName(subElementDyo));
                    RealTimeCalcFunctionHelper.insertCalcErrorInfo(this.args.getCalcLogId(), (Long)(costCenterDyo != null ? costCenterDyo.getLong("id") : 0L), errStr);
                    return null;
                }
            }
            if (RealTimeCalcFunctionHelper.isContainsJoinProduct(productGroupCostObjMap)) {
                Map<Long, BigDecimal> groupCostobjWeightMap = RealTimeCalcFunctionHelper.getGroupCostObjectWeight(productGroupCostObjMap, this.allocTypeMap, this.weightMap, subElementId);
                proFinQty = BigDecimal.ZERO;
                proIntrQty = BigDecimal.ZERO;
                for (Map.Entry<Long, RealTimeResultFinalResultVO> entry : productGroupCostObjMap.entrySet()) {
                    if ("B".equals(entry.getValue().getProductType()) || !groupCostobjWeightMap.containsKey(entry.getKey())) continue;
                    proFinQty = proFinQty.add(entry.getValue().getProFinQty().multiply(groupCostobjWeightMap.get(entry.getKey())));
                    proIntrQty = proIntrQty.add(entry.getValue().getPdEndQty().multiply(groupCostobjWeightMap.get(entry.getKey())));
                }
                if (isCostobjectDebug && debugMsg != null) {
                    debugMsg.append("mainJoin:proFinQty=").append(proFinQty.toPlainString()).append(",proIntrQty=").append(proIntrQty.toPlainString()).append("\n");
                }
            }
            if ((tmpA = proIntrQty.multiply(equivalent).add(proFinQty)).compareTo(BigDecimal.ZERO) == 0) {
                DynamicObject costCenterDyo = BusinessDataServiceHelper.loadSingle((Object)costCenterId, (String)"bos_costcenter", (String)"id,name");
                DynamicObject subElementDyo = BusinessDataServiceHelper.loadSingle((Object)subElementId, (String)"cad_subelement", (String)"name");
                DynamicObject costObjectDyo = BusinessDataServiceHelper.loadSingle((Object)costObjectId, (String)"cad_costobject", (String)"name");
                String errStr = String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3:%1$s ,\u5b50\u8981\u7d20: %2$s , \u6210\u672c\u6838\u7b97\u5bf9\u8c61 :%3$s , \u671f\u672b\u5728\u4ea7\u54c1\u6570\u91cf*\u7ea6\u5f53\u7cfb\u6570+\u5b8c\u5de5\u5165\u5e93\u6570\u91cf=0\u3002", (String)"RealTimeInCostCalcFunction_4", (String)"macc-aca-algox", (Object[])new Object[0]), this.getDynName(costCenterDyo), this.getDynName(subElementDyo), this.getDynName(costObjectDyo));
                RealTimeCalcFunctionHelper.insertCalcErrorInfo(this.args.getCalcLogId(), (Long)(costCenterDyo != null ? costCenterDyo.getLong("id") : 0L), errStr);
                return null;
            }
            BigDecimal ratio = proFinQty.divide(tmpA, 10, 4);
            finQty = calcQty.multiply(ratio).setScale((int)subMatUnitPrecision, 4);
            finAmt = calcAmt.multiply(ratio).setScale(this.args.getAmtScale(), 4);
            intQty = calcQty.subtract(finQty);
            intAmt = calcAmt.subtract(finAmt);
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append("FinishCalc:tmpA=").append(tmpA.toPlainString()).append(",ratio=").append(ratio.toPlainString()).append(",finQty=").append(finQty.toPlainString()).append(",finAmt=").append(finAmt.toPlainString()).append("\n");
            }
        } else if ("3".equals(allocStd)) {
            BigDecimal stockQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("stockqty")));
            BigDecimal useQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("useqty")));
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append("ASSEMBLY:stockQty=").append(stockQty.toPlainString()).append(",useQty=").append(useQty.toPlainString()).append("\n");
            }
            if (calcQty.compareTo(BigDecimal.ZERO) == 0 || stockQty.compareTo(BigDecimal.ZERO) == 0) {
                intQty = calcQty;
                intAmt = calcAmt;
            } else {
                BigDecimal matPrice = calcAmt.divide(calcQty, 10, 4);
                BigDecimal unitFinUseRate = useQty.divide(stockQty, 10, 4);
                finQty = unitFinUseRate.multiply(proFinQty).setScale((int)subMatUnitPrecision, 4);
                finAmt = finQty.multiply(matPrice).setScale(this.args.getAmtScale(), 4);
                intQty = calcQty.subtract(finQty);
                intAmt = calcAmt.subtract(finAmt);
            }
        } else if ("4".equals(allocStd)) {
            if (StringUtils.isEmpty((String)this.inventoryMode)) {
                this.inventoryMode = "qty";
            }
            BigDecimal inventValue = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("inventValue")));
            if ("amount".equals(this.inventoryMode)) {
                intAmt = inventValue;
                finAmt = calcAmt.subtract(intAmt);
                if (calcQty.compareTo(BigDecimal.ZERO) != 0) {
                    if (calcAmt.compareTo(BigDecimal.ZERO) == 0) {
                        DynamicObject dyCostCenter = BusinessDataServiceHelper.loadSingleFromCache((Object)costCenterId, (String)"bos_costcenter", (String)"id,name");
                        DynamicObject dyCostObject = BusinessDataServiceHelper.loadSingleFromCache((Object)costObjectId, (String)"cad_costobject", (String)"name");
                        DynamicObject dyMaterial = BusinessDataServiceHelper.loadSingleFromCache((Object)materialId, (String)"bd_material", (String)"name");
                        String errStr = String.format(ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u5206\u914d\u5931\u8d25\uff0c\u6210\u672c\u4e2d\u5fc3\u3010%1$s\u3011\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3010%2$s\u3011\u7269\u6599\u3010 %3$s\u3011 , \u5404\u660e\u7ec6\u6750\u6599\u7684\u6295\u5165\u7684\u603b\u91d1\u989d\u201c%4$s\u201d\u6216\u5404\u660e\u7ec6\u6750\u6599\u6295\u5165\u7684\u603b\u6570\u91cf\u201c%5$s\u201d\u4e0d\u80fd\u7b49\u4e8e0\u3002", (String)"RealTimeInCostCalcFunction_5", (String)"macc-aca-algox", (Object[])new Object[0]), this.getDynName(dyCostCenter), this.getDynName(dyCostObject), this.getDynName(dyMaterial), BigDecimalUtil.toString(calcAmt), BigDecimalUtil.toString(calcQty));
                        RealTimeCalcFunctionHelper.insertCalcErrorInfo(this.args.getCalcLogId(), (Long)(dyCostCenter != null ? dyCostCenter.getLong("id") : 0L), errStr);
                        return null;
                    }
                    intQty = intAmt.divide(calcAmt.divide(calcQty, 10, 4), (int)subMatUnitPrecision, 4);
                    finQty = calcQty.subtract(intQty);
                }
            } else if ("qty".equals(this.inventoryMode)) {
                intQty = inventValue.setScale((int)subMatUnitPrecision, 4);
                finQty = calcQty.subtract(intQty);
                if (isCostobjectDebug && debugMsg != null) {
                    debugMsg.append("WIPMATCHECK:intQty=").append(intQty.toPlainString()).append(",finQty=").append(finQty.toPlainString()).append("\n");
                }
                if (calcQty.compareTo(BigDecimal.ZERO) == 0) {
                    intAmt = calcAmt;
                } else {
                    BigDecimal price = calcAmt.divide(calcQty, 10, 4);
                    intAmt = intQty.multiply(price).setScale(this.args.getAmtScale(), 4);
                    finAmt = calcAmt.subtract(intAmt);
                }
            }
        } else if ("5".equals(allocStd)) {
            BigDecimal unitQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("unitQty")));
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append("BOM:unitQty=").append(unitQty.toPlainString()).append("\n");
            }
            if (calcQty.compareTo(BigDecimal.ZERO) == 0) {
                intQty = calcQty;
                intAmt = calcAmt;
            } else {
                BigDecimal subMatUnitCost = calcAmt.divide(calcQty, 10, 4);
                finQty = unitQty.multiply(proFinQty).setScale((int)subMatUnitPrecision, 4);
                finAmt = finQty.multiply(subMatUnitCost).setScale(this.args.getAmtScale(), 4);
                intQty = calcQty.subtract(finQty);
                intAmt = calcAmt.subtract(finAmt);
            }
        }
        row.set(this.srcMeta.getFieldIndex("finQty"), (Object)finQty);
        row.set(this.srcMeta.getFieldIndex("finAmt"), (Object)finAmt.setScale(this.args.getAmtScale(), 4));
        row.set(this.srcMeta.getFieldIndex("inQty"), (Object)intQty);
        row.set(this.srcMeta.getFieldIndex("inAmt"), (Object)intAmt.setScale(this.args.getAmtScale(), 4));
        row.set(this.srcMeta.getFieldIndex("calcAmt"), (Object)calcAmt);
        return row;
    }

    private String getDynName(DynamicObject obj) {
        if (obj == null) {
            return "";
        }
        return obj.getString("name");
    }
}

