/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.CommitTimeoutException;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.RunningTimeoutException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.report.function.ProBehaviorSumFunction;
import kd.macc.aca.algox.report.function.ProPriceAndRateCalFunction;
import kd.macc.aca.algox.utils.DataSetXHelper;
import kd.macc.aca.algox.utils.MaterialGroupHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ProCostBehaviorAnalRptAlgoxService {
    private static final Log logger = LogFactory.getLog(ProCostBehaviorAnalRptAlgoxService.class);
    public static RowMeta targetRowMeta = new RowMeta(new Field[0]);

    protected String getAlgoKey(String methodName) {
        return this.getClass().getName() + "." + methodName;
    }

    public DataSet getCostTypeDataSet(List<QFilter> queryFilter) {
        String selectFlelds = "material.id product, auxproperty, matvers, entryentity.element.id element, entryentity.element.number elementnumber, entryentity.subelement.id subelementid, entryentity.subelement.number subelement, entryentity.subelement.name subelementname, entryentity.subelement.costbehavior costbehavior, entryentity.qty qty, entryentity.price price, entryentity.stdprice standardprice";
        return QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getCostTypeDataSet"), (String)"cad_calcsimulationresult", (String)selectFlelds, (QFilter[])queryFilter.toArray(new QFilter[0]), null);
    }

    public DataSet resultDataDeal(DataSet infoDs, DataSet costTypeDs, Boolean onlyMaterialType) {
        JobSession session = AlgoX.createSession((String)"ProCostBehaviorAnal_rDD");
        DataSetX inputDs = session.fromInput((Input)new DataSetInput(infoDs));
        DataSetX resultDs = null;
        DataSetX productDs = inputDs.distinct(new String[]{"billno", "period", "materialgroup", "materialgroupnumber", "product", "auxpty", "version", "baseunit", "unit", "sourcebillentry", "storageqty", "invoutsourcetype", "precision"}).groupBy(new String[]{"period", "materialgroup", "materialgroupnumber", "product", "auxpty", "version", "baseunit", "unit", "precision"}).sum("storageqty");
        DataSetX detailDs = inputDs.groupBy(new String[]{"period", "materialgroup", "materialgroupnumber", "product", "auxpty", "version", "baseunit", "unit", "costbehavior", "element", "elementnumber", "subelementid", "subelement", "subelementname", "precision"}).sum("storagecost").addFields(new Field[]{new Field("ordernum", (DataType)DataType.IntegerType), new Field("datatype", (DataType)DataType.StringType), new Field("standardprice", (DataType)DataType.BigDecimalType), new Field("standardcost", (DataType)DataType.BigDecimalType), new Field("diffcost", (DataType)DataType.BigDecimalType), new Field("diffprice", (DataType)DataType.BigDecimalType)}, new Object[]{0, "subelement", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        if (costTypeDs != null) {
            DataSetX inputCostTypeDs = session.fromInput((Input)new DataSetInput(costTypeDs));
            DataSetX costTypeDeailDs = inputCostTypeDs.groupBy(new String[]{"product", "auxproperty", "matvers", "elementnumber", "element", "subelementid", "subelement", "subelementname", "costbehavior"}).sum("standardprice");
            DataSetX proDataDs = productDs.join(costTypeDeailDs).on("product", "product").on("auxpty", "auxproperty").on("version", "matvers").select(new String[]{"period", "materialgroup", "materialgroupnumber", "product", "auxpty", "version", "baseunit", "unit", "precision"}, new String[]{"costbehavior", "element", "elementnumber", "subelementid", "subelement", "subelementname", "standardprice"}).addFields(new Field[]{new Field("ordernum", (DataType)DataType.IntegerType), new Field("datatype", (DataType)DataType.StringType), new Field("storagecost", (DataType)DataType.BigDecimalType), new Field("standardcost", (DataType)DataType.BigDecimalType), new Field("diffcost", (DataType)DataType.BigDecimalType), new Field("diffprice", (DataType)DataType.BigDecimalType)}, new Object[]{0, "subelement", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
            detailDs = DataSetXHelper.union(detailDs, proDataDs).groupBy(new String[]{"period", "materialgroup", "materialgroupnumber", "product", "auxpty", "version", "baseunit", "unit", "costbehavior", "element", "elementnumber", "subelementid", "subelement", "subelementname", "precision", "ordernum", "datatype"}).sum("standardprice").sum("storagecost").sum("standardcost").sum("diffcost").sum("diffprice");
        }
        if (onlyMaterialType.booleanValue()) {
            DataSetX detailMatDs = detailDs.groupBy(new String[]{"period", "materialgroup", "materialgroupnumber", "costbehavior", "element", "subelementid", "subelement", "elementnumber", "subelementname", "ordernum", "datatype", "standardcost", "precision", "diffcost", "diffprice"}).sum("storagecost").sum("standardprice");
            DataSetX finalMatDs = productDs.groupBy(new String[]{"period", "materialgroup"}).sum("storageqty");
            DataSetX behaviorDs = detailMatDs.groupBy(new String[]{"period", "materialgroup", "costbehavior"}).reduceGroup((GroupReduceFunction)new ProBehaviorSumFunction(detailMatDs.getRowMeta(), Boolean.FALSE));
            DataSetX producDs = behaviorDs.groupBy(new String[]{"period", "materialgroup"}).reduceGroup((GroupReduceFunction)new ProBehaviorSumFunction(detailMatDs.getRowMeta(), Boolean.TRUE));
            resultDs = DataSetXHelper.union(producDs, behaviorDs);
            resultDs = DataSetXHelper.union(resultDs, detailMatDs);
            resultDs = resultDs.leftJoin(finalMatDs).on("period", "period").on("materialgroup", "materialgroup").select(new String[]{"period", "materialgroup", "materialgroupnumber", "costbehavior", "element", "precision", "elementnumber", "subelementid", "subelement", "subelementname", "storagecost", "ordernum", "datatype", "standardprice", "standardcost", "diffcost", "diffprice"}, new String[]{"storageqty"}).addFields(new Field[]{new Field("price", (DataType)DataType.BigDecimalType), new Field("rate", (DataType)DataType.StringType)}, new Object[]{BigDecimal.ZERO, ""});
            resultDs = resultDs.groupBy(new String[]{"period", "materialgroup"}).reduceGroup((GroupReduceFunction)new ProPriceAndRateCalFunction(resultDs.getRowMeta())).orderBy(new String[]{"period asc", "materialgroupnumber asc", "ordernum asc", "elementnumber asc"});
        } else {
            detailDs = detailDs.leftJoin(productDs).on("product", "product").on("auxpty", "auxpty").on("version", "version").on("period", "period").select(new String[]{"period", "materialgroup", "materialgroupnumber", "product", "auxpty", "version", "baseunit", "precision", "unit", "costbehavior", "element", "elementnumber", "subelementid", "subelement", "subelementname", "storagecost", "ordernum", "datatype", "standardcost", "diffcost", "diffprice", "standardprice"}, new String[]{"storageqty"}).orderBy(new String[]{"storageqty desc"});
            DataSetX behaviorDs = detailDs.groupBy(new String[]{"period", "materialgroup", "product", "auxpty", "version", "costbehavior"}).reduceGroup((GroupReduceFunction)new ProBehaviorSumFunction(detailDs.getRowMeta(), Boolean.FALSE));
            DataSetX producDs = behaviorDs.groupBy(new String[]{"period", "materialgroup", "product", "auxpty", "version"}).reduceGroup((GroupReduceFunction)new ProBehaviorSumFunction(detailDs.getRowMeta(), Boolean.TRUE));
            resultDs = DataSetXHelper.union(producDs, behaviorDs);
            resultDs = DataSetXHelper.union(resultDs, detailDs).addFields(new Field[]{new Field("price", (DataType)DataType.BigDecimalType), new Field("rate", (DataType)DataType.StringType)}, new Object[]{BigDecimal.ZERO, ""});
            resultDs = resultDs.groupBy(new String[]{"period", "materialgroup", "product", "auxpty", "version"}).reduceGroup((GroupReduceFunction)new ProPriceAndRateCalFunction(resultDs.getRowMeta())).orderBy(new String[]{"period desc", "materialgroupnumber asc", "product asc", "auxpty asc", "version asc", "ordernum asc", "elementnumber asc"});
        }
        DataSetOutput resultSet = new DataSetOutput(resultDs.getRowMeta());
        String resultId = resultSet.getId();
        resultDs.output((Output)resultSet);
        try {
            session.commit(60, TimeUnit.MINUTES);
        }
        catch (CommitTimeoutException e) {
            throw e;
        }
        catch (RunningTimeoutException e) {
            throw e;
        }
        return session.readDataSet(resultId);
    }

    public DataSet getDataSetResult(List<QFilter> queryFilter, Boolean onlyMaterialType, Long cost_type_id, DynamicObject materialGrpStd, DynamicObjectCollection mulMaterialGroup, boolean viewSubitem, String calRecordName) {
        long time = System.currentTimeMillis();
        DataSet dataSetInfo = this.getProCostDataSetInfo(queryFilter, mulMaterialGroup, materialGrpStd, viewSubitem);
        DataSet dataSetCostType = this.getQueryDataSetCostType(cost_type_id, viewSubitem, calRecordName);
        logger.info("\u4ea7\u54c1\u6210\u672c\u6027\u6001\u5206\u6790\u83b7\u53d6\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        DataSet dataSetResult = this.resultDataDeal(dataSetInfo, dataSetCostType, onlyMaterialType);
        logger.info("\u4ea7\u54c1\u6210\u672c\u6027\u6001\u5206\u6790algox\u5904\u7406\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        return dataSetResult;
    }

    private DataSet getQueryDataSetCostType(Long cost_type_id, boolean viewSubitem, String calRecordName) {
        if (cost_type_id == 0L) {
            return null;
        }
        ArrayList<QFilter> queryFilter = new ArrayList<QFilter>(16);
        queryFilter.add(new QFilter("costtype", "=", (Object)cost_type_id));
        if (!CadEmptyUtils.isEmpty((String)calRecordName)) {
            queryFilter.add(new QFilter("calcrecord.name", "=", (Object)calRecordName));
        } else {
            QFilter recordFilter = new QFilter("calcrecord", "is null", null).or(new QFilter("calcrecord", "<=", (Object)0L));
            queryFilter.add(recordFilter);
        }
        if (viewSubitem) {
            queryFilter.add(new QFilter("entryentity.datatype", "in", (Object)new String[]{"2", "3"}));
        } else {
            queryFilter.add(new QFilter("entryentity.datatype", "in", (Object)new String[]{"2", "4"}));
        }
        queryFilter.add(new QFilter("ismaindata", "=", (Object)1));
        DataSet dataSet = this.getCostTypeDataSet(queryFilter);
        return dataSet;
    }

    private DataSet getProCostDataSetInfo(List<QFilter> queryFilter, DynamicObjectCollection mulMaterialGroup, DynamicObject materialGrpStd, boolean viewSubitem) {
        String selectInvFields = "billno, period, inventoryentryentity.invcostobject.material.id product, inventoryentryentity.invcostobject.auxpty auxpty, inventoryentryentity.invcostobject.bomversion version, inventoryentryentity.invcostobject.material.baseunit unit, inventoryentryentity.invcostobject.material.baseunit baseunit, inventoryentryentity.invcostobject.material.baseunit.precision precision,inventoryentryentity.sourcebillentry sourcebillentry, inventoryentryentity.inventoryqty storageqty, inventoryentryentity.inventorysubelement.costbehavior costbehavior, inventoryentryentity.inventorysubelement.id subelementid, inventoryentryentity.inventorysubelement.number subelement, inventoryentryentity.inventorysubelement.name subelementname, inventoryentryentity.inventoryamount storagecost, inventoryentryentity.invoutsourcetype invoutsourcetype";
        QFilter qFilter = new QFilter("inventoryentryentity.invproducttype", "in", (Object)new String[]{"A", "B", "C"});
        if (viewSubitem) {
            queryFilter.add(new QFilter("inventoryentryentity.carrytype", "=", (Object)"B"));
        } else {
            queryFilter.add(new QFilter("inventoryentryentity.carrytype", "!=", (Object)"B"));
        }
        queryFilter.add(qFilter);
        DataSet invDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getProCostDataSetInfo"), (String)"aca_calcresult", (String)selectInvFields, (QFilter[])queryFilter.toArray(new QFilter[0]), null);
        DataSet elementDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getProCostDataSetInfo"), (String)"cad_elementdetail", (String)"subelement, element, element.number elementnumber", null, null);
        DataSet dataSet = invDataSet.leftJoin(elementDataSet).on("subelementid", "subelement").select(new String[]{"billno", "period", "sourcebillentry", "product", "auxpty", "invoutsourcetype", "version", "baseunit", "unit", "storageqty", "costbehavior", "subelementid", "subelement", "subelementname", "precision", "storagecost"}, new String[]{"element", "elementnumber"}).finish();
        DataSet materialDataSet = MaterialGroupHelper.getClassifiedMaterialDataSet(mulMaterialGroup, false, materialGrpStd);
        dataSet = dataSet.join(materialDataSet).on("product", "material").select(dataSet.getRowMeta().getFieldNames(), new String[]{"materialgroup", "materialgroupnumber"}).finish();
        return dataSet;
    }
}

