/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.report.function.MatTypeDataDealFunction;
import kd.macc.aca.algox.report.function.ProUnitCostComCalcFunction;
import kd.macc.aca.algox.report.function.ProUnitCostComFunction;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.DataSetHelper;
import kd.macc.aca.algox.utils.MaterialGroupHelper;
import org.apache.commons.lang.StringUtils;

public class ProUnitCostComRptAlgoxService {
    private static final Log logger = LogFactory.getLog(ProUnitCostComRptAlgoxService.class);
    private static final String[] dsResultAddFields = new String[]{"materialnumber", "materialname", "element", "elemumber", "elemname", "convamt", "convqty", "convproqty", "cmpconvamt", "cmpconvqty", "cmpconvproqty", "hidebaseunit", "subelement", "subnumber", "material", "matnumber", "prounitcount", "prounitcost", "unitprice", "unitcount", "totalcount", "procmpunitcount", "procmpunitcost", "cmpunitprice", "cmpunitcount", "cmptotalcount", "materialid", "type", "subcurrency", "hidematerial", "convsubmatver", "convsubauxpty"};
    private static final String[] dsResultMaterialTypeAddFields = new String[]{"materialnumber", "materialname", "element", "elemumber", "elemname", "convamt", "convqty", "convproqty", "cmpconvamt", "cmpconvqty", "cmpconvproqty", "hidebaseunit", "subelement", "subnumber", "material", "matnumber", "prounitcount", "prounitcost", "unitprice", "unitcount", "totalcount", "procmpunitcount", "procmpunitcost", "cmpunitprice", "cmpunitcount", "cmptotalcount", "materialid", "type", "subcurrency", "hidematerial", "convsubmatver", "convsubauxpty", "longnumber", "materialgroupnumber", "materialgroupname"};

    public DataSet getDataSetResult(DynamicObjectCollection mulMaterialGroup, DynamicObject materialGrpStd, Map<String, String> dynamicColumnMap, Map<String, Object> params, DynamicObject materialGroup) {
        long time = System.currentTimeMillis();
        HashMap<String, String> matTypeMap = new HashMap<String, String>(16);
        DataSet dataSetInfo = this.getProUnitCostDataSetInfo(params, mulMaterialGroup, materialGrpStd, materialGroup, matTypeMap);
        logger.info("\u4ea7\u54c1\u5355\u4f4d\u6210\u672c\u5bf9\u6bd4\u67e5\u8be2\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        Boolean isShowSubElement = (Boolean)params.get("isShowSubElement");
        Boolean isShowMaterialDetail = (Boolean)params.get("isShowMaterialDetail");
        Boolean onlyMaterialType = (Boolean)params.get("onlyMaterialType");
        int showCount = (Integer)params.get("showCount");
        DataSet dataSetResult = null;
        dataSetResult = onlyMaterialType != false ? this.resultMatTypeDataDeal(dataSetInfo, dynamicColumnMap, isShowSubElement, isShowMaterialDetail, matTypeMap, showCount) : this.resultDataDeal(dataSetInfo, dynamicColumnMap, isShowSubElement, isShowMaterialDetail);
        logger.info("\u4ea7\u54c1\u5355\u4f4d\u6210\u672c\u5bf9\u6bd4\u62a5\u8868algox\u5904\u7406\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        return dataSetResult;
    }

    private DataSet getProUnitCostDataSetInfo(Map<String, Object> params, DynamicObjectCollection mulMaterialGroup, DynamicObject materialGrpStd, DynamicObject materialGroup, Map<String, String> matTypeMap) {
        List baseFilter = (List)params.get("baseFilter");
        List cmpFilter = (List)params.get("cmpFilter");
        String selectInvFields = "billno,period,entryentity.type type,currency as subcurrency,entryentity.relacostobject relacostobject,entryentity.relacostobject.material materialid,entryentity.relacostobject.material.number as materialnumber,entryentity.relacostobject.material.name as materialname,entryentity.element as element,entryentity.element.number as elemumber,entryentity.element.name as elemname,entryentity.subelement as subelement,entryentity.subelement.number as subnumber,entryentity.submaterial as hidematerial,entryentity.submaterial.baseunit as hidebaseunit,entryentity.submaterial material,entryentity.submaterial.number as matnumber,entryentity.submatversion as convsubmatver,entryentity.subauxpty as convsubauxpty,";
        String qtyAndAmtBase = "entryentity.currcomamount as convamt,entryentity.currcomqty as convqty,0 as cmpconvamt,0 as cmpconvqty";
        String qtyAndAmtCmp = "0 as convamt,0 as convqty,entryentity.currcomamount as cmpconvamt,entryentity.currcomqty as cmpconvqty";
        String baseInvFields = selectInvFields + qtyAndAmtBase;
        String cmpInvFields = selectInvFields + qtyAndAmtCmp;
        DataSet baseDataSet = this.getQueryCalcResultDataSet(baseInvFields, baseFilter).filter("convqty>0");
        DataSet cmpDataSet = this.getQueryCalcResultDataSet(cmpInvFields, cmpFilter).filter("cmpconvqty>0");
        DataSet dataSet = DataSetHelper.union(baseDataSet, cmpDataSet);
        Boolean onlyMaterialType = (Boolean)params.get("onlyMaterialType");
        if (onlyMaterialType.booleanValue()) {
            Integer level = (Integer)params.get("level");
            Long orgId = (Long)params.get("orgId");
            mulMaterialGroup = new DynamicObjectCollection();
            if (materialGroup != null) {
                mulMaterialGroup.add((Object)materialGroup);
            }
            mulMaterialGroup = this.getMaterialGroup(materialGrpStd, materialGroup, level, matTypeMap, orgId);
            DataSet materialDataSet = MaterialGroupHelper.getClassifiedMaterialDataSet(mulMaterialGroup, false, materialGrpStd);
            dataSet = dataSet.join(materialDataSet).on("materialid", "material").select(dataSet.getRowMeta().getFieldNames(), new String[]{"materialgroupnumber", "longnumber", "materialgroupname"}).finish();
        } else {
            dataSet = dataSet.addFields(new String[]{"''", "''", "''"}, new String[]{"materialgroupnumber", "longnumber", "materialgroupname"});
        }
        return dataSet.filter("elemumber is not null and subnumber is not null");
    }

    private DataSet getQueryCalcResultDataSet(String fields, List<QFilter> filter) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getDataSetInfo"), (String)"aca_calcresult", (String)fields, (QFilter[])filter.toArray(new QFilter[0]), null);
        DataSet detailDataSet = dataSet.filter("type = 'detail'");
        DataSet finalDataSet = dataSet.filter("type = 'finalResult'").select(new String[]{"billno", "period", "relacostobject", "materialid", "convqty convproqty", "cmpconvqty cmpconvproqty"});
        DataSet result = detailDataSet.join(finalDataSet).on("billno", "billno").on("period", "period").on("relacostobject", "relacostobject").on("materialid", "materialid").select(detailDataSet.getRowMeta().getFieldNames(), new String[]{"convproqty", "cmpconvproqty"}).finish();
        return result;
    }

    private DynamicObjectCollection getMaterialGroup(DynamicObject materialGrpStd, DynamicObject materialGroup, Integer level, Map<String, String> matTypeMap, Long orgId) {
        ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
        createOrgIds.add(orgId);
        QFilter groupFilter = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialGrpStd.getLong("id"), false});
        int size = level;
        String longNumberDLM = MaterialGroupHelper.getLongNumberDLM();
        if (materialGroup != null) {
            String groupLongNum = materialGroup.getString("longnumber");
            size = level + groupLongNum.split(longNumberDLM).length - 1;
            QFilter levelFilter = new QFilter("longnumber", "like", (Object)(groupLongNum + longNumberDLM + "%"));
            levelFilter.or(new QFilter("longnumber", "=", (Object)groupLongNum));
            groupFilter.and(levelFilter);
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_materialgroup", (String)"id,number,name,standard,longnumber,isleaf", (QFilter[])groupFilter.toArray(), (String)"number asc");
        HashSet<Long> ids = new HashSet<Long>(50);
        for (DynamicObject obj : dynamicObjects) {
            String longnumber = obj.getString("longnumber");
            int tempSize = longnumber.split(longNumberDLM).length;
            Boolean isLeaf = obj.getBoolean("isleaf");
            if (tempSize != size && (tempSize >= size || !isLeaf.booleanValue())) continue;
            ids.add(obj.getLong("id"));
            String number = obj.getString("number");
            String name = obj.getString("name");
            matTypeMap.put(longnumber, number + " / " + name);
        }
        QFilter idsFilter = new QFilter("id", "in", ids);
        return QueryServiceHelper.query((String)"bd_materialgroup", (String)"id,number,name,standard,longnumber,isleaf", (QFilter[])idsFilter.toArray(), (String)"number asc");
    }

    private DataSet resultMatTypeDataDeal(DataSet dataSetInfo, Map<String, String> dynamicColumnMap, Boolean isShowSubElement, Boolean isShowMaterialDetail, Map<String, String> matTypeMap, int showCount) {
        DataSet dataSet = this.getDataSet(matTypeMap, dataSetInfo, dynamicColumnMap, showCount);
        DataSet convQtyDataSet = dataSet.groupBy(new String[]{"billno", "longnumber", "relacostobject", "convproqty", "cmpconvproqty"}).finish();
        convQtyDataSet = convQtyDataSet.groupBy(new String[]{"longnumber"}).sum("convproqty").sum("cmpconvproqty").finish();
        dataSet = this.buildMatDataSetLevel(dataSet, isShowSubElement, isShowMaterialDetail);
        dataSet = dataSet.join(convQtyDataSet).on("longnumber", "longnumber").select(dataSet.getRowMeta().getFieldNames(), new String[]{"convproqty", "cmpconvproqty"}).finish();
        convQtyDataSet = convQtyDataSet.addField("'A'", "groupField").groupBy(new String[]{"groupField"}).sum("convproqty").sum("cmpconvproqty").finish();
        BigDecimal totalConvProQty = BigDecimal.ZERO;
        BigDecimal totalCmpConvProQty = BigDecimal.ZERO;
        for (Row row : convQtyDataSet) {
            totalConvProQty = row.getBigDecimal("convproqty");
            totalCmpConvProQty = row.getBigDecimal("cmpconvproqty");
        }
        DataSet unitCountDataSet = dataSet.copy();
        JobSession session = AlgoX.createSession((String)"ProUnitCostComRpt_rMTDD");
        DataSetInput processingAllocInput = new DataSetInput(dataSet);
        DataSetX dataSetX = session.fromInput((Input)processingAllocInput);
        dataSetX = this.dataSetXAddField(dataSetX, dynamicColumnMap);
        dataSetX = dataSetX.map((MapFunction)new ProUnitCostComCalcFunction(totalConvProQty, totalCmpConvProQty));
        dataSetX = dataSetX.groupBy(new String[]{"element", "subelement", "type"}).reduceGroup((GroupReduceFunction)new ProUnitCostComFunction(dataSetX.getRowMeta(), totalConvProQty, totalCmpConvProQty, "longnumber"));
        DataSetOutput dataSetOutput = new DataSetOutput(dataSetX.getRowMeta());
        String resultId = dataSetOutput.getId();
        dataSetX.output((Output)dataSetOutput);
        session.commit(60, TimeUnit.MINUTES);
        DataSet result = session.readDataSet(resultId);
        result = this.buildSubTotal(result, unitCountDataSet, dynamicColumnMap, true);
        result = result.orderBy(new String[]{"orderfield asc", "elemumber asc", "subnumber asc", "matnumber asc"});
        return result;
    }

    private DataSet getDataSet(Map<String, String> matTypeMap, DataSet dataSetInfo, Map<String, String> dynamicColumnMap, int showCount) {
        JobSession session = AlgoX.createSession((String)"ProUnitCostComRpt_gDs");
        DataSetInput processingAllocInput = new DataSetInput(dataSetInfo);
        DataSetX dataSetX = session.fromInput((Input)processingAllocInput);
        dataSetX = dataSetX.map((MapFunction)new MatTypeDataDealFunction(matTypeMap));
        DataSetOutput dataSetOutput = new DataSetOutput(dataSetX.getRowMeta());
        String resultId = dataSetOutput.getId();
        dataSetX.output((Output)dataSetOutput);
        session.commit(60, TimeUnit.MINUTES);
        DataSet dataSet = session.readDataSet(resultId);
        DataSet dataSetCopy = dataSet.copy();
        dataSetCopy = dataSetCopy.groupBy(new String[]{"longnumber", "materialgroupnumber", "materialgroupname"}).finish().orderBy(new String[]{"materialgroupnumber asc"});
        Iterator iterator = dataSetCopy.iterator();
        ArrayList<String> numberList = new ArrayList<String>(10);
        while (iterator.hasNext()) {
            Row next = (Row)iterator.next();
            String number = next.getString("materialgroupnumber");
            String name = next.getString("materialgroupname");
            String longnumber = next.getString("longnumber");
            numberList.add(String.format("'%s'", longnumber));
            String numbers = longnumber.replaceAll("[^A-Za-z0-9 ]", "0");
            dynamicColumnMap.put(number + " / " + name, numbers);
            if (numberList.size() != showCount) continue;
            break;
        }
        if (numberList.size() > 0) {
            return dataSet.filter("longnumber in (" + StringUtils.join(numberList, (String)",") + ")");
        }
        return dataSet.filter("1 = 2");
    }

    public DataSet resultDataDeal(DataSet dataSet, Map<String, String> dynamicColumnMap, Boolean isShowSubElement, Boolean isShowMaterialDetail) {
        logger.info("\u5f00\u59cb\u8fdb\u884c\u6570\u636e\u5904\u7406");
        DataSet convQtyDataSet = dataSet.groupBy(new String[]{"billno", "materialid", "materialnumber", "relacostobject", "convproqty", "cmpconvproqty"}).finish();
        convQtyDataSet = convQtyDataSet.groupBy(new String[]{"materialnumber"}).sum("convproqty").sum("cmpconvproqty").finish();
        this.buildDynamicColumn(dataSet.copy(), dynamicColumnMap);
        dataSet = this.buildDataSetLevel(dataSet, isShowSubElement, isShowMaterialDetail);
        dataSet = dataSet.join(convQtyDataSet).on("materialnumber", "materialnumber").select(dataSet.getRowMeta().getFieldNames(), new String[]{"convproqty", "cmpconvproqty"}).finish();
        convQtyDataSet = convQtyDataSet.addField("'A'", "groupField").groupBy(new String[]{"groupField"}).sum("convproqty").sum("cmpconvproqty").finish();
        BigDecimal totalConvProQty = BigDecimal.ZERO;
        BigDecimal totalCmpConvProQty = BigDecimal.ZERO;
        for (Row row : convQtyDataSet) {
            totalConvProQty = row.getBigDecimal("convproqty");
            totalCmpConvProQty = row.getBigDecimal("cmpconvproqty");
        }
        DataSet unitCountDataSet = dataSet.copy();
        JobSession session = AlgoX.createSession((String)"ProUnitCostComRpt_rDD");
        DataSetInput processingAllocInput = new DataSetInput(dataSet);
        DataSetX dataSetX = session.fromInput((Input)processingAllocInput);
        dataSetX = this.dataSetXAddField(dataSetX, dynamicColumnMap);
        dataSetX = dataSetX.map((MapFunction)new ProUnitCostComCalcFunction(totalConvProQty, totalCmpConvProQty));
        dataSetX = dataSetX.groupBy(new String[]{"element", "subelement", "type"}).reduceGroup((GroupReduceFunction)new ProUnitCostComFunction(dataSetX.getRowMeta(), totalConvProQty, totalCmpConvProQty, "materialnumber"));
        DataSetOutput dataSetOutput = new DataSetOutput(dataSetX.getRowMeta());
        String resultId = dataSetOutput.getId();
        dataSetX.output((Output)dataSetOutput);
        session.commit(60, TimeUnit.MINUTES);
        DataSet result = session.readDataSet(resultId);
        result = this.buildSubTotal(result, unitCountDataSet, dynamicColumnMap, false);
        result = result.orderBy(new String[]{"orderfield asc", "elemumber asc", "subnumber asc", "matnumber asc"});
        return result;
    }

    private DataSet buildDataSetLevel(DataSet dataSet, Boolean isShowSubElement, Boolean isShowMaterialDetail) {
        DataSet subElementDataSet;
        DataSet elementDataSet;
        if (!isShowSubElement.booleanValue() && !isShowMaterialDetail.booleanValue()) {
            dataSet = dataSet.groupBy(new String[]{"materialnumber", "materialname", "subcurrency", "element", "elemumber", "elemname"}).sum("convamt").sum("convqty").sum("cmpconvamt").sum("cmpconvqty").finish();
            dataSet = dataSet.addFields(new String[]{"0", "null", "0", "0", "0", "null", "0", "0"}, new String[]{"subelement", "subnumber", "material", "hidematerial", "hidebaseunit", "matnumber", "convsubmatver", "convsubauxpty"});
            dataSet = dataSet.addField("'A'", "type");
        }
        if (isShowSubElement.booleanValue() && !isShowMaterialDetail.booleanValue()) {
            elementDataSet = dataSet.groupBy(new String[]{"materialnumber", "materialname", "subcurrency", "element", "elemumber", "elemname"}).sum("convamt").sum("convqty").sum("cmpconvamt").sum("cmpconvqty").finish();
            elementDataSet = elementDataSet.addFields(new String[]{"0", "null", "0", "0", "0", "null", "0", "0"}, new String[]{"subelement", "subnumber", "material", "hidematerial", "hidebaseunit", "matnumber", "convsubmatver", "convsubauxpty"});
            elementDataSet = elementDataSet.addField("'A'", "type");
            subElementDataSet = dataSet.groupBy(new String[]{"materialnumber", "materialname", "subcurrency", "element", "elemumber", "elemname", "subelement", "subnumber"}).sum("convamt").sum("convqty").sum("cmpconvamt").sum("cmpconvqty").finish();
            subElementDataSet = subElementDataSet.addFields(new String[]{"0", "0", "0", "null", "0", "0"}, new String[]{"material", "hidematerial", "hidebaseunit", "matnumber", "convsubmatver", "convsubauxpty"});
            subElementDataSet = subElementDataSet.addField("'B'", "type");
            dataSet = DataSetHelper.union(elementDataSet, subElementDataSet);
        }
        if (isShowMaterialDetail.booleanValue()) {
            elementDataSet = dataSet.groupBy(new String[]{"materialnumber", "materialname", "subcurrency", "element", "elemumber", "elemname"}).sum("convamt").sum("convqty").sum("cmpconvamt").sum("cmpconvqty").finish();
            elementDataSet = elementDataSet.addFields(new String[]{"0", "null", "0", "0", "0", "null", "0", "0"}, new String[]{"subelement", "subnumber", "material", "hidematerial", "hidebaseunit", "matnumber", "convsubmatver", "convsubauxpty"});
            elementDataSet = elementDataSet.addField("'A'", "type");
            subElementDataSet = dataSet.groupBy(new String[]{"materialnumber", "materialname", "subcurrency", "element", "elemumber", "elemname", "subelement", "subnumber"}).sum("convamt").sum("convqty").sum("cmpconvamt").sum("cmpconvqty").finish();
            subElementDataSet = subElementDataSet.addFields(new String[]{"0", "0", "0", "null", "0", "0"}, new String[]{"material", "hidematerial", "hidebaseunit", "matnumber", "convsubmatver", "convsubauxpty"});
            subElementDataSet = subElementDataSet.addField("'B'", "type");
            DataSet materialDataSet = dataSet.filter("material !=0").groupBy(new String[]{"materialnumber", "materialname", "subcurrency", "element", "elemumber", "elemname", "subelement", "subnumber", "material", "hidematerial", "hidebaseunit", "matnumber", "convsubmatver", "convsubauxpty"}).sum("convamt").sum("convqty").sum("cmpconvamt").sum("cmpconvqty").finish();
            materialDataSet = materialDataSet.addField("'C'", "type");
            dataSet = DataSetHelper.union(DataSetHelper.union(elementDataSet, subElementDataSet), materialDataSet);
        }
        return dataSet;
    }

    private DataSet buildMatDataSetLevel(DataSet dataSet, Boolean isShowSubElement, Boolean isShowMaterialDetail) {
        DataSet subElementDataSet;
        DataSet elementDataSet;
        if (!isShowSubElement.booleanValue() && !isShowMaterialDetail.booleanValue()) {
            dataSet = dataSet.groupBy(new String[]{"longnumber", "materialgroupnumber", "materialgroupname", "subcurrency", "element", "elemumber", "elemname"}).sum("convamt").sum("convqty").sum("cmpconvamt").sum("cmpconvqty").finish();
            dataSet = dataSet.addFields(new String[]{"0", "null", "0", "0", "0", "null", "0", "0"}, new String[]{"subelement", "subnumber", "material", "hidematerial", "hidebaseunit", "matnumber", "convsubmatver", "convsubauxpty"});
            dataSet = dataSet.addField("'A'", "type");
        }
        if (isShowSubElement.booleanValue() && !isShowMaterialDetail.booleanValue()) {
            elementDataSet = dataSet.groupBy(new String[]{"longnumber", "materialgroupnumber", "materialgroupname", "subcurrency", "element", "elemumber", "elemname"}).sum("convamt").sum("convqty").sum("cmpconvamt").sum("cmpconvqty").finish();
            elementDataSet = elementDataSet.addFields(new String[]{"0", "null", "0", "0", "0", "null", "0", "0"}, new String[]{"subelement", "subnumber", "material", "hidematerial", "hidebaseunit", "matnumber", "convsubmatver", "convsubauxpty"});
            elementDataSet = elementDataSet.addField("'A'", "type");
            subElementDataSet = dataSet.groupBy(new String[]{"longnumber", "materialgroupnumber", "materialgroupname", "subcurrency", "element", "elemumber", "elemname", "subelement", "subnumber"}).sum("convamt").sum("convqty").sum("cmpconvamt").sum("cmpconvqty").finish();
            subElementDataSet = subElementDataSet.addFields(new String[]{"0", "0", "0", "null", "0", "0"}, new String[]{"material", "hidematerial", "hidebaseunit", "matnumber", "convsubmatver", "convsubauxpty"});
            subElementDataSet = subElementDataSet.addField("'B'", "type");
            dataSet = DataSetHelper.union(elementDataSet, subElementDataSet);
        }
        if (isShowMaterialDetail.booleanValue()) {
            elementDataSet = dataSet.groupBy(new String[]{"longnumber", "materialgroupnumber", "materialgroupname", "subcurrency", "element", "elemumber", "elemname"}).sum("convamt").sum("convqty").sum("cmpconvamt").sum("cmpconvqty").finish();
            elementDataSet = elementDataSet.addFields(new String[]{"0", "null", "0", "0", "0", "null", "0", "0"}, new String[]{"subelement", "subnumber", "material", "hidematerial", "hidebaseunit", "matnumber", "convsubmatver", "convsubauxpty"});
            elementDataSet = elementDataSet.addField("'A'", "type");
            subElementDataSet = dataSet.groupBy(new String[]{"longnumber", "materialgroupnumber", "materialgroupname", "subcurrency", "element", "elemumber", "elemname", "subelement", "subnumber"}).sum("convamt").sum("convqty").sum("cmpconvamt").sum("cmpconvqty").finish();
            subElementDataSet = subElementDataSet.addFields(new String[]{"0", "0", "0", "null", "0", "0"}, new String[]{"material", "hidematerial", "hidebaseunit", "matnumber", "convsubmatver", "convsubauxpty"});
            subElementDataSet = subElementDataSet.addField("'B'", "type");
            DataSet materialDataSet = dataSet.filter("material !=0").groupBy(new String[]{"longnumber", "materialgroupnumber", "materialgroupname", "subcurrency", "element", "elemumber", "elemname", "subelement", "subnumber", "material", "hidematerial", "hidebaseunit", "matnumber", "convsubmatver", "convsubauxpty"}).sum("convamt").sum("convqty").sum("cmpconvamt").sum("cmpconvqty").finish();
            materialDataSet = materialDataSet.addField("'C'", "type");
            dataSet = DataSetHelper.union(DataSetHelper.union(elementDataSet, subElementDataSet), materialDataSet);
        }
        return dataSet;
    }

    private DataSet buildSubTotal(DataSet result, DataSet unitCountDataSet, Map<String, String> dynamicColumnMap, Boolean onlymaterialtype) {
        DataSet finish = result.copy().groupBy(new String[]{"subcurrency"}).finish();
        Long subCurrency = 1L;
        Iterator rowIterator = finish.iterator();
        if (rowIterator.hasNext()) {
            subCurrency = ((Row)rowIterator.next()).getLong("subcurrency");
        }
        result = result.addField("'a'", "orderfield");
        StringJoiner costProp = new StringJoiner(",");
        StringJoiner cmpCostProp = new StringJoiner(",");
        StringJoiner countProp = new StringJoiner(",");
        StringJoiner cmpCountProp = new StringJoiner(",");
        for (Map.Entry<String, String> entry : dynamicColumnMap.entrySet()) {
            costProp.add("cost" + entry.getValue());
            cmpCostProp.add("cmpcost" + entry.getValue());
            countProp.add("count" + entry.getValue());
            cmpCountProp.add("cmpcount" + entry.getValue());
        }
        String proString = costProp.toString();
        String[] costFields = proString.split(",");
        String proCmpString = cmpCostProp.toString();
        String[] costCmpFields = proCmpString.split(",");
        String countString = countProp.toString();
        String[] countFields = countString.split(",");
        String countCmpString = cmpCountProp.toString();
        String[] countCmpFields = countCmpString.split(",");
        if (!proString.equals("")) {
            BigDecimal bigDecimal;
            DataSet temp;
            DataSet dsResult = result.filter("subelement ==0").groupBy(new String[]{"elemumber"}).sum("unitcost").sum("totalcost").sum("cmpunitcost").sum("cmptotalcost").finish();
            for (String field : costFields) {
                DataSet dataSet = result.filter("subelement ==0").groupBy(new String[]{"elemumber"}).sum(field).finish();
                dsResult = dsResult.join(dataSet).on("elemumber", "elemumber").select(dsResult.getRowMeta().getFieldNames(), new String[]{field}).finish();
            }
            for (String field : costCmpFields) {
                DataSet dataSet = result.filter("subelement ==0").groupBy(new String[]{"elemumber"}).sum(field).finish();
                dsResult = dsResult.join(dataSet).on("elemumber", "elemumber").select(dsResult.getRowMeta().getFieldNames(), new String[]{field}).finish();
            }
            dsResult = dsResult.addField("'0'", "groupField");
            DataSet dataSet = dsResult.groupBy(new String[]{"groupField"}).sum("unitcost").sum("totalcost").sum("cmpunitcost").sum("cmptotalcost").finish();
            for (String string : costFields) {
                temp = dsResult.groupBy(new String[]{"groupField"}).sum(string).finish();
                dataSet = dataSet.join(temp).on("groupField", "groupField").select(dataSet.getRowMeta().getFieldNames(), new String[]{string}).finish();
            }
            for (String string : costCmpFields) {
                temp = dsResult.groupBy(new String[]{"groupField"}).sum(string).finish();
                dataSet = dataSet.join(temp).on("groupField", "groupField").select(dataSet.getRowMeta().getFieldNames(), new String[]{string}).finish();
            }
            dsResult = dataSet.select(proString + ",unitcost,totalcost," + proCmpString + ",cmpunitcost,cmptotalcost");
            String[] dsResultAddFieldValues = new String[]{"'null'", "null", "0", ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"ProUnitCostComRptAlgoxService_3", (String)"macc-aca-algox", (Object[])new Object[0]), "null", "0.00", "0.00", "0.00", "0.00", "0.00", "0.00", "0", "0", "null", "0", "null", "0.00", "0.00", "0.00", "0.00", "0.00", "0.00", "0.00", "0.00", "0.00", "0.00", "0", "null", subCurrency.toString(), "0", "null", "null"};
            String[] addFields = dsResultAddFields;
            String groupField = "materialnumber";
            if (onlymaterialtype.booleanValue()) {
                dsResultAddFieldValues = new String[]{"'null'", "null", "0", ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"ProUnitCostComRptAlgoxService_3", (String)"macc-aca-algox", (Object[])new Object[0]), "null", "0.00", "0.00", "0.00", "0.00", "0.00", "0.00", "0", "0", "null", "0", "null", "0.00", "0.00", "0.00", "0.00", "0.00", "0.00", "0.00", "0.00", "0.00", "0.00", "0", "null", subCurrency.toString(), "0", "null", "null", "null", "null", "null"};
                addFields = dsResultMaterialTypeAddFields;
                groupField = "longnumber";
            }
            dsResult = dsResult.addFields(dsResultAddFieldValues, addFields);
            for (String field : countFields) {
                dsResult = dsResult.addField("0.00", field);
            }
            for (String field : countCmpFields) {
                dsResult = dsResult.addField("0.00", field);
            }
            dsResult = dsResult.addField("'b'", "orderfield");
            result = DataSetHelper.union(result, dsResult);
            DataSet dataSet2 = unitCountDataSet.filter("type == 'A'").groupBy(new String[]{groupField}).max("convproqty").max("cmpconvproqty").sum("convamt").sum("cmpconvamt").finish();
            HashMap<String, Object> map = new HashMap<String, Object>();
            Iterator iterator = dataSet2.iterator();
            BigDecimal totalCount = BigDecimal.ZERO;
            BigDecimal cmpTotalCount = BigDecimal.ZERO;
            BigDecimal totalCost = BigDecimal.ZERO;
            BigDecimal cmpTotalCost = BigDecimal.ZERO;
            while (iterator.hasNext()) {
                Row next = (Row)iterator.next();
                BigDecimal convproqty = BigDecimalUtil.getOrZero(next.getBigDecimal("convproqty"));
                BigDecimal cmpconvproqty = BigDecimalUtil.getOrZero(next.getBigDecimal("cmpconvproqty"));
                String[] convamt = BigDecimalUtil.getOrZero(next.getBigDecimal("convamt"));
                BigDecimal cmpconvamt = BigDecimalUtil.getOrZero(next.getBigDecimal("cmpconvamt"));
                map.put("count" + next.getString(groupField).replaceAll("[^A-Za-z0-9 ]", "0"), convproqty);
                map.put("cmpcount" + next.getString(groupField).replaceAll("[^A-Za-z0-9 ]", "0"), cmpconvproqty);
                map.put("cost" + next.getString(groupField).replaceAll("[^A-Za-z0-9 ]", "0"), convamt);
                map.put("cmpcost" + next.getString(groupField).replaceAll("[^A-Za-z0-9 ]", "0"), cmpconvamt);
                totalCount = totalCount.add(convproqty);
                cmpTotalCount = cmpTotalCount.add(cmpconvproqty);
                totalCost = totalCost.add((BigDecimal)convamt);
                cmpTotalCost = cmpTotalCost.add(cmpconvamt);
            }
            DataSet filter = result.filter(ResManager.loadKDString((String)"elemumber == '\u5408\u8ba1'", (String)"ProUnitCostComRptAlgoxService_4", (String)"macc-aca-algox", (Object[])new Object[0]));
            String[] fieldNames = filter.getRowMeta().getFieldNames();
            StringJoiner fields = new StringJoiner(",");
            for (String fieldName : fieldNames) {
                if (fieldName.equals("elemumber") || fieldName.equals("elemname") || fieldName.startsWith("cost") || fieldName.startsWith("count") || fieldName.startsWith("cmpcost") || fieldName.startsWith("cmpcount") || fieldName.equals("unitcost") || fieldName.equals("totalcost") || fieldName.equals("unitcount") || fieldName.equals("cmpunitcost") || fieldName.equals("cmptotalcost") || fieldName.equals("cmpunitcount")) continue;
                fields.add(fieldName);
            }
            DataSet select = filter.select(fields.toString());
            select = select.addFields(new String[]{"null", ResManager.loadKDString((String)"'\u5b8c\u5de5\u4ea7\u91cf'", (String)"ProUnitCostComRptAlgoxService_5", (String)"macc-aca-algox", (Object[])new Object[0]), totalCost.toPlainString(), "0.00", cmpTotalCost.toPlainString(), "0.00", totalCount.toPlainString(), cmpTotalCount.toPlainString()}, new String[]{"elemumber", "elemname", "unitcost", "totalcost", "cmpunitcost", "cmptotalcost", "unitcount", "cmpunitcount"});
            for (String costField : costFields) {
                bigDecimal = (BigDecimal)map.get(costField);
                select = select.addField(bigDecimal.toString(), costField);
            }
            for (String costField : costCmpFields) {
                bigDecimal = (BigDecimal)map.get(costField);
                select = select.addField(bigDecimal.toString(), costField);
            }
            for (String countField : countFields) {
                bigDecimal = (BigDecimal)map.get(countField);
                select = select.addField(bigDecimal.toString(), countField);
            }
            for (String countField : countCmpFields) {
                bigDecimal = (BigDecimal)map.get(countField);
                select = select.addField(bigDecimal.toString(), countField);
            }
            select = select.addField("'c'", "orderfield");
            result = DataSetHelper.union(result, select);
        }
        return result;
    }

    private DataSetX dataSetXAddField(DataSetX dataSetX, Map<String, String> dynamicColumnMap) {
        dataSetX = dataSetX.addFields(new Field[]{new Field("prounitcount", (DataType)DataType.BigDecimalType), new Field("prounitcost", (DataType)DataType.BigDecimalType), new Field("procmpunitcount", (DataType)DataType.BigDecimalType), new Field("procmpunitcost", (DataType)DataType.BigDecimalType), new Field("unitprice", (DataType)DataType.BigDecimalType), new Field("cmpunitprice", (DataType)DataType.BigDecimalType), new Field("unitcount", (DataType)DataType.BigDecimalType), new Field("totalcount", (DataType)DataType.BigDecimalType), new Field("unitcost", (DataType)DataType.BigDecimalType), new Field("totalcost", (DataType)DataType.BigDecimalType), new Field("cmpunitcount", (DataType)DataType.BigDecimalType), new Field("cmptotalcount", (DataType)DataType.BigDecimalType), new Field("cmpunitcost", (DataType)DataType.BigDecimalType), new Field("cmptotalcost", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        for (Map.Entry<String, String> entry : dynamicColumnMap.entrySet()) {
            dataSetX = dataSetX.addFields(new Field[]{new Field("count" + entry.getValue(), (DataType)DataType.BigDecimalType), new Field("cmpcount" + entry.getValue(), (DataType)DataType.BigDecimalType), new Field("cost" + entry.getValue(), (DataType)DataType.BigDecimalType), new Field("cmpcost" + entry.getValue(), (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        }
        return dataSetX;
    }

    private void buildDynamicColumn(DataSet dataSet, Map<String, String> dynamicColumnMap) {
        dataSet = dataSet.groupBy(new String[]{"materialnumber", "materialname"}).finish();
        dataSet = dataSet.orderBy(new String[]{"materialnumber asc"});
        for (Row next : dataSet) {
            String number = next.getString("materialnumber");
            String name = next.getString("materialname");
            String numbers = number.replaceAll("[^A-Za-z0-9 ]", "0");
            dynamicColumnMap.put(number + " / " + name, numbers);
        }
    }

    protected String getAlgoKey(String methodName) {
        return "ProUnitCostComRpt_" + methodName;
    }
}

