/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.report.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.aca.algox.utils.BigDecimalUtil;

public class ProPriceAndRateCalFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta = null;

    public ProPriceAndRateCalFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        Iterator<RowX> it = rows.iterator();
        BigDecimal storagecostTotal = BigDecimal.ZERO;
        ArrayList targetRows = Lists.newArrayList();
        while (it.hasNext()) {
            RowX row = it.next();
            if ("product".equals(row.getString(this.rowMeta.getFieldIndex("datatype")))) {
                storagecostTotal = BigDecimalUtil.getOrZero(row.getBigDecimal(this.rowMeta.getFieldIndex("storagecost")));
            }
            targetRows.add(row);
        }
        int precision = 0;
        for (RowX row : targetRows) {
            BigDecimal storageCost = BigDecimalUtil.getOrZero(row.getBigDecimal(this.rowMeta.getFieldIndex("storagecost")));
            BigDecimal storageQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.rowMeta.getFieldIndex("storageqty")));
            precision = row.getInteger(this.rowMeta.getFieldIndex("precision"));
            BigDecimal price = BigDecimalUtil.getDevideCal(storageCost, storageQty, precision);
            row.set(this.rowMeta.getFieldIndex("price"), (Object)price);
            String rate = "";
            if (storagecostTotal.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal ratio = storageCost.multiply(BigDecimal.valueOf(100L)).divide(storagecostTotal, 2, 4);
                rate = ratio + "%";
            }
            row.set(this.rowMeta.getFieldIndex("rate"), (Object)rate);
            BigDecimal stdPrice = BigDecimalUtil.getOrZero(row.getBigDecimal(this.rowMeta.getFieldIndex("standardprice")));
            BigDecimal standardCost = stdPrice.multiply(storageQty);
            row.set(this.rowMeta.getFieldIndex("standardcost"), (Object)standardCost);
            BigDecimal diffCost = storageCost.subtract(standardCost);
            row.set(this.rowMeta.getFieldIndex("diffcost"), (Object)diffCost);
            BigDecimal diffPrice = price.subtract(stdPrice);
            row.set(this.rowMeta.getFieldIndex("diffprice"), (Object)diffPrice);
            String costbehavior = row.getString(this.rowMeta.getFieldIndex("costbehavior"));
            switch (row.getString(this.rowMeta.getFieldIndex("datatype"))) {
                case "subelement": {
                    row.set(this.rowMeta.getFieldIndex("ordernum"), (Object)2);
                    if ("B".equals(costbehavior)) {
                        row.set(this.rowMeta.getFieldIndex("ordernum"), (Object)4);
                    }
                    row.set(this.rowMeta.getFieldIndex("costbehavior"), (Object)"");
                    break;
                }
                case "behavior": {
                    row.set(this.rowMeta.getFieldIndex("ordernum"), (Object)1);
                    if (!"B".equals(costbehavior)) break;
                    row.set(this.rowMeta.getFieldIndex("ordernum"), (Object)3);
                    break;
                }
                case "product": {
                    row.set(this.rowMeta.getFieldIndex("ordernum"), (Object)0);
                    break;
                }
            }
        }
        for (RowX row : targetRows) {
            collector.collect(row);
        }
    }
}

