/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.aca.algox.costcalc.common.ActCalcMaterial;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.utils.LogUtils;

public class AcaAlgoxMaterialLevelHelper {
    private static final Log logger = LogFactory.getLog(AcaAlgoxMaterialLevelHelper.class);
    private static final String ALGOKEY = "kd.macc.aca.algox.utils.ActMaterialLevelHelper";

    public static List<Set<ActCalcMaterial>> getMatLevelList(ActCostCalcArgs args, DataSet cacheMatDs) {
        Set<ActCalcMaterial> mats = AcaAlgoxMaterialLevelHelper.getCalcMaterial(args, cacheMatDs);
        AcaAlgoxMaterialLevelHelper.logMatLvl(args.getGetLogUniqueKey() + " -e", mats);
        if (mats.isEmpty()) {
            return null;
        }
        ArrayList<Set<ActCalcMaterial>> matLevelList = new ArrayList<Set<ActCalcMaterial>>(args.getMaxMatLevel());
        HashSet<Long> dealCurCalcMats = new HashSet<Long>();
        for (int i = args.getMaxMatLevel(); i >= 0; --i) {
            Set<ActCalcMaterial> curCalcMat = AcaAlgoxMaterialLevelHelper.getCurLevelMat(i, mats);
            if (curCalcMat == null || curCalcMat.isEmpty()) continue;
            HashSet curCalcMats = Sets.newHashSet();
            for (ActCalcMaterial mat : curCalcMat) {
                if (dealCurCalcMats.contains(mat.getMaterialId())) continue;
                curCalcMats.add(mat);
                dealCurCalcMats.add(mat.getMaterialId());
            }
            matLevelList.add(curCalcMats);
        }
        return matLevelList;
    }

    private static Set<ActCalcMaterial> getCurLevelMat(int level, Set<ActCalcMaterial> data) {
        Set<ActCalcMaterial> curCalcMat = data.stream().filter(cm -> cm.getLevel() == level).collect(Collectors.toSet());
        return curCalcMat;
    }

    private static Set<ActCalcMaterial> getCalcMaterial(ActCostCalcArgs args, DataSet cacheMatDs) {
        long start = System.currentTimeMillis();
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, ResManager.loadKDString((String)"\u4f4e\u9636\u7801\u8ba1\u7b97\u6b65\u9aa4\u4e00\uff1a\u5f00\u59cb\uff1a", (String)"AcaAlgoxMaterialLevelHelper_0", (String)"macc-aca-algox", (Object[])new Object[0]));
        Map<String, Map<String, ActCalcMaterial>> dataMap = AcaAlgoxMaterialLevelHelper.getCalcMat(args, cacheMatDs);
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u4f4e\u9636\u7801\u8ba1\u7b97\u6b65\u9aa4\u4e00\uff1a\u8017\u65f6\uff1a%s", (String)"AcaAlgoxMaterialLevelHelper_12", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, ResManager.loadKDString((String)"\u4f4e\u9636\u7801\u8ba1\u7b97\u6b65\u9aa4\u4e8c\uff1a\u5f00\u59cb\uff1a", (String)"AcaAlgoxMaterialLevelHelper_2", (String)"macc-aca-algox", (Object[])new Object[0]));
        Map<String, List<ActCalcMaterial>> keyParentValSubListMap = AcaAlgoxMaterialLevelHelper.dealLevelNew(dataMap);
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u4f4e\u9636\u7801\u8ba1\u7b97\u6b65\u9aa4\u4e8c\uff1a\u8017\u65f6\uff1a%s", (String)"AcaAlgoxMaterialLevelHelper_13", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start));
        HashSet data = Sets.newHashSetWithExpectedSize((int)3000);
        for (Map.Entry<String, Map<String, ActCalcMaterial>> entry : dataMap.entrySet()) {
            for (Map.Entry<String, ActCalcMaterial> subEntry : entry.getValue().entrySet()) {
                data.add(subEntry.getValue());
            }
        }
        start = System.currentTimeMillis();
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, ResManager.loadKDString((String)"\u4f4e\u9636\u7801\u8ba1\u7b97\u6b65\u9aa4\u4e09\uff1a\u5f00\u59cb\uff1a", (String)"AcaAlgoxMaterialLevelHelper_4", (String)"macc-aca-algox", (Object[])new Object[0]));
        AcaAlgoxMaterialLevelHelper.dealLeaf(data, keyParentValSubListMap, args.getGetLogUniqueKey());
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u4f4e\u9636\u7801\u8ba1\u7b97\u6b65\u9aa4\u4e09\uff1a\u8017\u65f6\uff1a%s", (String)"AcaAlgoxMaterialLevelHelper_14", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, ResManager.loadKDString((String)"\u4f4e\u9636\u7801\u8ba1\u7b97\u6b65\u9aa4\u56db\uff1a\u5f00\u59cb\uff1a", (String)"AcaAlgoxMaterialLevelHelper_6", (String)"macc-aca-algox", (Object[])new Object[0]));
        int maxMatLevel = AcaAlgoxMaterialLevelHelper.getMaxLevel(data);
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u4f4e\u9636\u7801\u8ba1\u7b97\u6b65\u9aa4\u56db\uff1a\u8017\u65f6\uff1a%s", (String)"AcaAlgoxMaterialLevelHelper_15", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start));
        Set<ActCalcMaterial> leafMats = AcaAlgoxMaterialLevelHelper.getLeafMat(data);
        args.setMaxMatLevel(maxMatLevel);
        start = System.currentTimeMillis();
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, ResManager.loadKDString((String)"\u4f4e\u9636\u7801\u8ba1\u7b97\u6b65\u9aa4\u4e94\uff1a\u5f00\u59cb\uff1a", (String)"AcaAlgoxMaterialLevelHelper_8", (String)"macc-aca-algox", (Object[])new Object[0]));
        AcaAlgoxMaterialLevelHelper.downLeafLevel(leafMats, maxMatLevel);
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u4f4e\u9636\u7801\u8ba1\u7b97\u6b65\u9aa4\u4e94\uff1a\u8017\u65f6\uff1a%s", (String)"AcaAlgoxMaterialLevelHelper_16", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start));
        return data;
    }

    public static void downLeafLevel(Set<ActCalcMaterial> data, int maxLevel) {
        for (ActCalcMaterial mat : data) {
            mat.setLevel(maxLevel);
        }
    }

    private static Map<String, List<ActCalcMaterial>> dealLevelNew(Map<String, Map<String, ActCalcMaterial>> dataMap) {
        HashMap keyParentValSubListMap = Maps.newHashMapWithExpectedSize((int)160);
        HashSet topMat = Sets.newHashSetWithExpectedSize((int)160);
        for (Map.Entry<String, Map<String, ActCalcMaterial>> entry : dataMap.entrySet()) {
            for (Map.Entry<String, ActCalcMaterial> subEntry : entry.getValue().entrySet()) {
                ActCalcMaterial acm = subEntry.getValue();
                if (acm.getLevel() == 0) {
                    topMat.add(acm);
                }
                if (acm.getParentId() <= 0L) continue;
                String key = acm.getParentId() + "@" + acm.getPmaterialVer() + "@" + acm.getPmaterialAuxPropId();
                keyParentValSubListMap.computeIfAbsent(key, p -> Lists.newArrayList()).add(acm);
            }
        }
        HashMap<ActCalcMaterial, Integer> matsLevels = new HashMap<ActCalcMaterial, Integer>();
        for (ActCalcMaterial mat : topMat) {
            if (!matsLevels.containsKey(mat)) {
                matsLevels.put(mat, 0);
            }
            AcaAlgoxMaterialLevelHelper.setLevel(mat, keyParentValSubListMap, matsLevels);
        }
        return keyParentValSubListMap;
    }

    private static void setLevel(ActCalcMaterial mat, Map<String, List<ActCalcMaterial>> keyParentValSubListMap, Map<ActCalcMaterial, Integer> matsLevels) {
        String key = mat.getMaterialId() + "@" + mat.getMaterialVer() + "@" + mat.getMaterialAuxPropId();
        List<ActCalcMaterial> subMats = keyParentValSubListMap.get(key);
        if (subMats == null) {
            return;
        }
        for (ActCalcMaterial calcMat : subMats) {
            if (!matsLevels.containsKey(calcMat) || matsLevels.get(calcMat) < mat.getLevel() + 1) {
                calcMat.setLevel(mat.getLevel() + 1);
                matsLevels.remove(calcMat);
                matsLevels.put(calcMat, mat.getLevel() + 1);
                if (mat.getLevel() > 30) {
                    break;
                }
            } else {
                calcMat.setLevel(matsLevels.get(calcMat));
                if (matsLevels.get(calcMat) > 30) break;
            }
            AcaAlgoxMaterialLevelHelper.setLevel(calcMat, keyParentValSubListMap, matsLevels);
        }
    }

    private static void dealLeaf(Set<ActCalcMaterial> data, Map<String, List<ActCalcMaterial>> keyParentValSubListMap, String logKey) {
        for (ActCalcMaterial mat : data) {
            String key = mat.getMaterialId() + "@" + mat.getMaterialVer() + "@" + mat.getMaterialAuxPropId();
            if (keyParentValSubListMap.get(key) == null || keyParentValSubListMap.get(key).size() <= 0) continue;
            mat.setIsleaf(false);
        }
    }

    public static Set<ActCalcMaterial> getLeafMat(Set<ActCalcMaterial> data) {
        Set<ActCalcMaterial> curCalcMat = data.stream().filter(cm -> cm.getIsleaf()).collect(Collectors.toSet());
        return curCalcMat;
    }

    public static int getMaxLevel(Set<ActCalcMaterial> data) {
        int maxLevel = 0;
        for (ActCalcMaterial calcMat : data) {
            if (calcMat.getLevel() <= maxLevel) continue;
            maxLevel = calcMat.getLevel();
        }
        return maxLevel;
    }

    private static Map<String, Map<String, ActCalcMaterial>> getCalcMat(ActCostCalcArgs args, DataSet cacheMatDs) {
        HashMap materialsHashMap = Maps.newHashMapWithExpectedSize((int)30000);
        Set<Long> costObjectIds = args.getResultCostObjectIds();
        Set<Long> costCenterIds = args.getResultCostCenterIds();
        if (cacheMatDs != null) {
            long start = System.currentTimeMillis();
            LogUtils.logInfo(args.getCalcReportId(), logger, ResManager.loadKDString((String)"\u6839\u636e\u5f53\u671f\u6750\u6599\u8017\u7528\u5206\u914d\u83b7\u53d6\u5230\u7684\u7269\u6599\u4f4e\u9636\u7801\u96c6\u5408,\u5f00\u59cb\uff1a", (String)"AcaAlgoxMaterialLevelHelper_10", (String)"macc-aca-algox", (Object[])new Object[0]));
            AcaAlgoxMaterialLevelHelper.dealCurMat(cacheMatDs, costObjectIds, costCenterIds, materialsHashMap);
            LogUtils.logInfo(args.getCalcReportId(), logger, String.format(ResManager.loadKDString((String)"\u6839\u636e\u5f53\u671f\u6750\u6599\u8017\u7528\u5206\u914d\u83b7\u53d6\u5230\u7684\u7269\u6599\u4f4e\u9636\u7801\u96c6\u5408,\u8017\u65f6%s", (String)"AcaAlgoxMaterialLevelHelper_17", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start));
        }
        return materialsHashMap;
    }

    private static Set<Long> getCostObjectIds(DataSet costObject) {
        HashSet<Long> costObjectIds = new HashSet<Long>(16);
        Iterator it = costObject.iterator();
        while (it.hasNext()) {
            costObjectIds.add(((Row)it.next()).getLong("costobject"));
        }
        return costObjectIds;
    }

    private static void dealCurMat(DataSet data, Set<Long> costObjectIds, Set<Long> costCenterIds, Map<String, Map<String, ActCalcMaterial>> materialsHashMap) {
        Iterator it = data.iterator();
        Row row = null;
        ActCalcMaterial curParentMat = null;
        Long curMatId = 0L;
        Long subMatId = 0L;
        ActCalcMaterial material = null;
        ActCalcMaterial subMaterial = null;
        while (it.hasNext()) {
            row = (Row)it.next();
            costObjectIds.add(row.getLong("costobject"));
            costCenterIds.add(row.getLong("costcenter"));
            curMatId = row.getLong("material");
            if (curMatId != 0L) {
                material = new ActCalcMaterial();
                material.setMaterialId(curMatId);
                material.setMaterialNumber(row.getString("materialnumber"));
                material.setLevel(0);
                material.setMaterialAuxPropId(row.getLong("auxpty"));
                material.setMaterialVer(row.getLong("matversion"));
                material.setCostObjectId(row.getLong("costobject"));
                curParentMat = AcaAlgoxMaterialLevelHelper.getParentMaterialWithVer(material, materialsHashMap);
                if (curParentMat != null) {
                    material = curParentMat;
                }
                if ((subMatId = row.getLong("submaterial")) != 0L) {
                    material.setIsleaf(false);
                }
                if (!AcaAlgoxMaterialLevelHelper.isSameMaterialAndVer(material, materialsHashMap)) {
                    materialsHashMap.computeIfAbsent(material.getCommonKey(), p -> Maps.newHashMapWithExpectedSize((int)16)).put(material.getUniqueKey(), material);
                }
            }
            if (subMatId == 0L || material == null) continue;
            subMaterial = new ActCalcMaterial();
            subMaterial.setParentId(curMatId);
            subMaterial.setPmaterialAuxPropId(material.getMaterialAuxPropId());
            subMaterial.setPmaterialVer(material.getMaterialVer());
            subMaterial.setMaterialId(row.getLong("submaterial"));
            subMaterial.setMaterialNumber(row.getString("submaterialnumber"));
            subMaterial.setMaterialAuxPropId(row.getLong("subauxpty"));
            subMaterial.setMaterialVer(row.getLong("submatversion"));
            subMaterial.setLevel(material.getLevel() + 1);
            if (AcaAlgoxMaterialLevelHelper.isSameMaterialAndVer(subMaterial, materialsHashMap)) continue;
            materialsHashMap.computeIfAbsent(subMaterial.getCommonKey(), p -> Maps.newHashMapWithExpectedSize((int)16)).put(subMaterial.getUniqueKey(), subMaterial);
        }
    }

    private static ActCalcMaterial getParentMaterialWithVer(ActCalcMaterial material, Map<String, Map<String, ActCalcMaterial>> materialsHashMap) {
        Map map = materialsHashMap.computeIfAbsent(material.getCommonKey(), p -> Maps.newHashMapWithExpectedSize((int)16));
        for (Map.Entry entry : map.entrySet()) {
            ActCalcMaterial getMaterial = (ActCalcMaterial)entry.getValue();
            if (getMaterial == null || getMaterial.getParentId() <= 0L) continue;
            return getMaterial;
        }
        return null;
    }

    private static boolean isSameMaterialAndVer(ActCalcMaterial material, Map<String, Map<String, ActCalcMaterial>> materialsHashMap) {
        ActCalcMaterial getMaterial = (ActCalcMaterial)materialsHashMap.computeIfAbsent(material.getCommonKey(), p -> Maps.newHashMapWithExpectedSize((int)16)).get(material.getUniqueKey());
        if (getMaterial != null) {
            if (material.getIsleaf() != getMaterial.getIsleaf()) {
                getMaterial.setIsleaf(false);
            }
            material = getMaterial;
            return true;
        }
        return false;
    }

    private static void logMatLvl(String logUniqueKey, Set<ActCalcMaterial> set) {
        StringBuilder sb = new StringBuilder(2000);
        int index = 0;
        for (ActCalcMaterial mat : set) {
            sb.append(",").append(mat.toString());
            if (++index <= 100) continue;
            LogUtils.logInfo(logUniqueKey, logger, sb.toString());
            index = 0;
            sb.setLength(0);
        }
        LogUtils.logInfo(logUniqueKey, logger, sb.toString());
    }
}

