/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AcaAlgoxTimeUtils {
    protected static final Log logger = LogFactory.getLog(AcaAlgoxTimeUtils.class);
    public static final String DATE_TO_STRING_DETAIAL_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public static Date getDeFaultExpDate() {
        return AcaAlgoxTimeUtils.parseDate("2999-12-31 23:59:59");
    }

    public static Date parseDate(String dateStr) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_TO_STRING_DETAIAL_PATTERN);
        Date date = null;
        try {
            date = simpleDateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
        return date;
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = pattern != null && pattern.length() > 0 ? new SimpleDateFormat(pattern) : new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(date);
    }

    public static Date getDayEndTime(Date d) {
        if (d == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getDayStartTime(Date d) {
        if (d == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static long getSecond(Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            return 0L;
        }
        return (endTime.getTime() - startTime.getTime()) / 1000L;
    }

    public static long getMilliSecond(Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            return 0L;
        }
        return endTime.getTime() - startTime.getTime();
    }

    public static String formatSecondToTime(long second) {
        long days = second / 86400L;
        long hours = (second %= 86400L) / 3600L;
        long minutes = (second %= 3600L) / 60L;
        second %= 60L;
        if (0L < days) {
            return String.format(ResManager.loadKDString((String)"%1$s\u5929\uff0c%2$s\u5c0f\u65f6\uff0c%3$s\u5206\uff0c%4$s\u79d2", (String)"AcaAlgoxTimeUtils_6", (String)"macc-aca-algox", (Object[])new Object[0]), days, hours, minutes, second);
        }
        return String.format(ResManager.loadKDString((String)"%1$s\u5c0f\u65f6\uff0c%2$s\u5206\uff0c%3$s\u79d2 ", (String)"AcaAlgoxTimeUtils_7", (String)"macc-aca-algox", (Object[])new Object[0]), hours, minutes, second);
    }
}

