/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.utils;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.costcalc.function.ActCalcJoinSideDetailFunction;
import kd.macc.aca.algox.utils.AcaAlgoxCurrencyHelper;
import kd.macc.aca.algox.utils.BigDecimalUtil;

public class AcaThirdDataGenHelper {
    private static final Log logger = LogFactory.getLog(AcaThirdDataGenHelper.class);
    private static final String INSERT_CONVDETAIL_ENTRY_SQL = "INSERT INTO t_aca_calcresultconventry (FId,FEntryId,fseq,fconvsrcbillid,fconvsrcbillentryid,fconvcostobjectid,fconvproducttype,fconvelementid,fconvsubelementid,fconvoutsourcetype,fconvsubmatid,fconvsubmatverid,fconvsubauxptyid,fconvproqty,fconvqty,fconvamt,fconvgroupfield,fconvgroupcategoryid) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public static void genThirdData(Long orgId, Long costaccountId, Long periodId) {
        ActCostCalcArgs args = AcaThirdDataGenHelper.getActCalcArgs(costaccountId);
        if (args == null) {
            logger.error("\u672a\u83b7\u53d6\u5230\u8d26\u7c3f\u5bf9\u5e94\u7684\u7cbe\u5ea6");
            return;
        }
        DataSet calcDataSet = AcaThirdDataGenHelper.queryCalcResultTwoTabData(orgId, costaccountId, periodId);
        DataSet calcDetailDataSet = AcaThirdDataGenHelper.queryCalcResultOneTabData(orgId, costaccountId, periodId);
        DataSet ds = calcDataSet.copy().select(new String[]{"id", "costObjectId"}).distinct();
        HashMap costObjectToResultIds = Maps.newHashMap();
        for (Row row : ds) {
            costObjectToResultIds.put(row.getLong("costObjectId"), row.getLong("id"));
        }
        DataSet subElementTypeDs = QueryServiceHelper.queryDataSet((String)"#buildSubElementTypeDataSet", (String)"cad_subelement", (String)"id,type as subElementType", null, null);
        DataSet elementDataSet = QueryServiceHelper.queryDataSet((String)"getProCostDataSetInfo", (String)"cad_elementdetail", (String)"subelement, element as elementId, element.number elementnumber", null, null);
        subElementTypeDs = subElementTypeDs.join(elementDataSet).on("id", "subelement").select(new String[]{"id", "subElementType"}, new String[]{"elementId"}).finish();
        JobSession session = AlgoX.createSession((String)"cal_result_third_calc");
        DataSetX subElementTypeDsX = session.fromInput((Input)new DataSetInput(subElementTypeDs));
        DataSetX calcDataSetX = session.fromInput((Input)new DataSetInput(calcDataSet));
        DataSetX calcDetailDataSetX = session.fromInput((Input)new DataSetInput(calcDetailDataSet));
        calcDetailDataSetX = calcDetailDataSetX.groupBy(new String[]{"costCenterId", "costObjectId", "elementId", "subElementId", "outsourcetype", "subMatId", "subMatVerId", "subMatAuxId", "subMatUnitPrecision"}).sum("finQty").sum("finAmt");
        JoinDataSetX convSubDetailDataSetX = calcDataSetX.leftJoin(calcDetailDataSetX).on("costCenterId", "costCenterId").on("mainCostObjectId", "costObjectId").on("subElementId", "subElementId").on("outsourcetype", "outsourcetype").select(new String[]{"srcBillId", "srcEntryId", "costCenterId", "mainCostObjectId", "costObjectId", "productType", "subElementId", "outsourcetype", "proFinQty", "cost", "groupfield", "groupcategoryid"}, new String[]{"subMatId", "subMatVerId", "subMatAuxId", "subMatUnitPrecision", "finQty", "finAmt"});
        convSubDetailDataSetX = convSubDetailDataSetX.leftJoin(subElementTypeDsX).on("subElementId", "id").select(convSubDetailDataSetX.getRowMeta().getFieldNames(), new String[]{"subElementType", "elementId"});
        convSubDetailDataSetX = convSubDetailDataSetX.groupBy(new String[]{"costCenterId", "mainCostObjectId", "elementId", "subElementId", "outsourcetype"}).reduceGroup((GroupReduceFunction)new ActCalcJoinSideDetailFunction(args));
        DataSetOutput convSubDetailResultSet = new DataSetOutput(convSubDetailDataSetX.getRowMeta());
        convSubDetailDataSetX.output((Output)convSubDetailResultSet);
        session.commit(10, TimeUnit.HOURS);
        DataSet resultDs = session.readDataSet(convSubDetailResultSet.getId());
        AcaThirdDataGenHelper.buildCalcConversionDetail(resultDs, costObjectToResultIds);
    }

    public static void buildCalcConversionDetail(DataSet calcConversionDetailDataSet, Map<Long, Long> costObjectToResultIds) {
        calcConversionDetailDataSet = calcConversionDetailDataSet.orderBy(new String[]{"mainCostObjectId", "productType desc", "costObjectId", "srcBillId", "subElementId"});
        ArrayList<Object[]> entrys = new ArrayList<Object[]>();
        long seqCostobjectId = 0L;
        int seq = 1;
        for (Row row : calcConversionDetailDataSet) {
            Long id;
            Long mainCostObjectId = row.getLong("mainCostObjectId");
            if (seqCostobjectId != mainCostObjectId) {
                seq = 1;
                seqCostobjectId = mainCostObjectId;
            }
            if ((id = costObjectToResultIds.get(mainCostObjectId)) == null) continue;
            Object[] entry = new Object[]{id, ID.genLongId(), seq++, row.getLong("srcBillId"), row.getLong("srcEntryId"), row.getLong("costObjectId"), row.getString("productType"), row.getLong("elementId"), row.getLong("subElementId"), row.getString("outsourcetype"), row.getLong("subMatId") == null ? Long.valueOf(0L) : row.getLong("subMatId"), row.getLong("subMatVerId") == null ? Long.valueOf(0L) : row.getLong("subMatVerId"), row.getLong("subMatAuxId") == null ? Long.valueOf(0L) : row.getLong("subMatAuxId"), BigDecimalUtil.getOrZero(row.getBigDecimal("proFinQty")), BigDecimalUtil.getOrZero(row.getBigDecimal("finQty")), BigDecimalUtil.getOrZero(row.getBigDecimal("finAmt")), row.getString("groupfield"), row.getLong("groupcategoryid")};
            entrys.add(entry);
        }
        if (!CollectionUtils.isEmpty(entrys)) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)INSERT_CONVDETAIL_ENTRY_SQL, entrys);
        }
    }

    private static DataSet queryCalcResultOneTabData(Long orgId, Long costaccountId, Long periodId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costaccountId);
        filter.and("period", "=", (Object)periodId);
        filter.and("entryentity.type", "=", (Object)"detail");
        DataSet calcDetailDataSet = QueryServiceHelper.queryDataSet((String)"calcResult", (String)"aca_calcresult", (String)"costcenter costCenterId,costobject costObjectId,entryentity.element elementId,entryentity.subelement subElementId,entryentity.outsourcetype outsourcetype,entryentity.submaterial subMatId,entryentity.submatversion subMatVerId,entryentity.subauxpty subMatAuxId,entryentity.submaterial.baseunit.precision as subMatUnitPrecision,entryentity.currcomqty finQty,entryentity.currcomamount finAmt", (QFilter[])filter.toArray(), null);
        ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(calcDetailDataSet.getRowMeta().getFieldNames()));
        fieldNames.remove("subMatUnitPrecision");
        fieldNames.add("case when subMatUnitPrecision is null then 0 else subMatUnitPrecision end as subMatUnitPrecision");
        calcDetailDataSet = calcDetailDataSet.select(fieldNames.toArray(new String[0]));
        return calcDetailDataSet;
    }

    private static DataSet queryCalcResultTwoTabData(Long orgId, Long costaccountId, Long periodId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costaccountId);
        filter.and("period", "=", (Object)periodId);
        filter.and("inventoryentryentity.id", ">", (Object)0L);
        return QueryServiceHelper.queryDataSet((String)"calcResult", (String)"aca_calcresult", (String)"id,costobject mainCostObjectId,costcenter costCenterId,inventoryentryentity.sourcebill srcBillId,inventoryentryentity.sourcebillentry srcEntryId,inventoryentryentity.invcostobject costObjectId,inventoryentryentity.invproducttype productType,inventoryentryentity.inventorysubelement subElementId,inventoryentryentity.invoutsourcetype outsourcetype,inventoryentryentity.inventoryqty proFinQty,inventoryentryentity.inventoryamount cost,inventoryentryentity.groupfield groupfield,inventoryentryentity.groupcategoryid groupcategoryid", (QFilter[])filter.toArray(), null);
    }

    private static ActCostCalcArgs getActCalcArgs(Long costaccountId) {
        ActCostCalcArgs args = new ActCostCalcArgs();
        ArrayList<String> selectFields = new ArrayList<String>(4);
        selectFields.add("calorg");
        selectFields.add("costtype");
        selectFields.add("calpolicy");
        MainEntityType subCostAcctType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"cal_bd_costaccount", selectFields);
        DynamicObject costAcctObj = BusinessDataServiceHelper.loadSingleFromCache((Object)costaccountId, (DynamicObjectType)subCostAcctType);
        if (costAcctObj == null) {
            return null;
        }
        Long calpolicy = costAcctObj.getLong("calpolicy.id");
        if (calpolicy == null || Long.compare(0L, calpolicy) == 0) {
            return null;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy)});
        if (result == null) {
            return null;
        }
        DynamicObject dyo = AcaAlgoxCurrencyHelper.getCurrency(result.getLong("currency"));
        if (dyo == null) {
            return null;
        }
        args.setAmtScale(dyo.getInt("amtprecision"));
        args.setPriceScale(dyo.getInt("priceprecision"));
        return args;
    }
}

