/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.aca.algox.alloc.input.CalcDataArgs;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.aca.algox.utils.AcaAlgoxTimeUtils;
import kd.macc.aca.algox.utils.FinishCalcHelper;

public class MatCostHelper {
    private static final int MAP_INITIAL_CAPACITY = 16;

    public static DataSet getStdCost(CalcDataArgs args) {
        String alokey = "kd.macc.sca.algox.utils.MatCostHelper.getStdCost";
        QFilter commonFilter = FinishCalcHelper.getOrgAndCostCenterFilter(args);
        commonFilter.and(new QFilter("bookdate", "<=", (Object)args.getEndDate()));
        commonFilter.and(new QFilter("bookdate", ">=", (Object)args.getStartDate()));
        QFilter costObjectFilter = new QFilter("entryentity.costobject", "in", args.getCostObjects());
        QFilter billstatus = new QFilter("billstatus", "=", (Object)"C");
        DataSet finishInputQty = QueryServiceHelper.queryDataSet((String)alokey, (String)"cad_factnedoutputbill", (String)(Long.valueOf(args.getOrgId().toString()) + " orgid,costcenter.masterid costcenterid," + Long.valueOf(args.getCostAcctId().toString()) + " costaccountid," + Long.valueOf(args.getPeriodId().toString()) + " periodid,entryentity.costobject.id costobjectid,entryentity.costobject.material.masterid materialid,entryentity.costobject.bomversion.id matversionid,entryentity.costobject.auxpty.id auxptyid,entryentity.qty qty,bookdate"), (QFilter[])new QFilter[]{commonFilter, costObjectFilter, billstatus}, null);
        DynamicObject costaccountInfo = BusinessDataServiceHelper.loadSingle((Object)args.getCostAcctId(), (String)"cal_bd_costaccount");
        DynamicObject costTypeInfo = BusinessDataServiceHelper.loadSingle((Object)costaccountInfo.getLong("costtype.masterid"), (String)"cad_costtype");
        QFilter costtypeFilter = new QFilter("costtype", "=", (Object)costTypeInfo.getLong("masterid"));
        QFilter calcTypeFilter = new QFilter("entryentity.datatype", "in", (Object)new String[]{"2", "3", "4"});
        QFilter stdIsMainDataFilter = new QFilter("ismaindata", "=", (Object)1);
        DataSet calcDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.algox.finish.checker.ProductStdCostCheckAction.getCalcCostObjectDataSet", (String)"cad_calceffectiveresult", (String)"material.masterid matid,matvers.id matverId,auxproperty.id auxptyId,entryentity.submaterial.id submatid,entryentity.submatvers.id submatverId,entryentity.subauxproperty.id subauxptyId,effectdate,expdate,entryentity.element.masterid elementid,entryentity.subelement.masterid subelementid,entryentity.subelement.type subelementtype,entryentity.qty subqty,entryentity.stdprice stdprice,entryentity.datatype calcdatatype", (QFilter[])new QFilter[]{costtypeFilter, calcTypeFilter, stdIsMainDataFilter}, null);
        JoinDataSet joinDataSet = finishInputQty.join(calcDataSet, JoinType.LEFT);
        joinDataSet.on("materialid", "matid");
        joinDataSet.on("matversionid", "matverId");
        joinDataSet.on("auxptyid", "auxptyId");
        DataSet calcAllDataSet = joinDataSet.select(new String[]{"orgid", "costaccountid", "periodid", "costcenterid", "costobjectid", "qty", "bookdate"}, new String[]{"matid", "matverId", "auxptyId", "submatid", "submatverId", "subauxptyId", "effectdate", "expdate", "elementid", "subelementid", "subelementtype", "subqty", "stdprice", "calcdatatype"}).finish();
        calcAllDataSet = calcAllDataSet.select("orgid,costaccountid,periodid,costcenterid,costobjectid,matid materialid,matverId matversionid, auxptyId auxptyid,bookdate,effectdate,expdate, submatid,submatverId,subauxptyId,elementid,subelementid,subelementtype,qty*subqty stdqty,qty*stdprice stdcost,calcdatatype").where(" expdate >= bookdate and effectdate <= bookdate");
        DataSet stdCostSubData = calcAllDataSet.select("orgid,costaccountid,periodid,costcenterid,costobjectid,submatid materialid,submatverId matversionid,subauxptyId auxptyid,elementid,subelementid,subelementtype,stdqty,stdcost,'3' caltype,case when subelementtype == '001' OR subelementtype == '002' then '1' else '2' end  difftype,'2' datatype,calcdatatype,                                       0 pdstartqty,0 pdstartamount,0 pdcurrqty,0 pdcurramount,0 pdcompqty,0 pdcompanount,0 pdendqty,0 pdendamount,0 diff,0 totalqty,0 totalamount,0 totalstdqty,0 totalstdamount").where(" calcdatatype = '2' or calcdatatype = '3' ");
        DataSet stdCostCompData = calcAllDataSet.select("orgid,costaccountid,periodid,costcenterid,costobjectid,submatid materialid,submatverId matversionid,subauxptyId auxptyid,elementid,subelementid,subelementtype,stdqty,stdcost,'3' caltype,case when subelementtype == '001' OR subelementtype == '002' then '1' else '2' end  difftype,'1' datatype,calcdatatype,                                       0 pdstartqty,0 pdstartamount,0 pdcurrqty,0 pdcurramount,0 pdcompqty,0 pdcompanount,0 pdendqty,0 pdendamount,0 diff,0 totalqty,0 totalamount,0 totalstdqty,0 totalstdamount").where(" calcdatatype = '2' or calcdatatype = '4'");
        DataSet stdCostAllDataSet = stdCostSubData.union(stdCostCompData);
        GroupbyDataSet groupDataSet = stdCostAllDataSet.groupBy(new String[]{"orgid", "costaccountid", "periodid", "costcenterid", "costobjectid", "materialid", "matversionid", "auxptyid", "elementid", "subelementid", "difftype", "caltype", "datatype"});
        groupDataSet.sum("pdstartqty");
        groupDataSet.sum("pdstartamount");
        groupDataSet.sum("pdcurrqty");
        groupDataSet.sum("pdcurramount");
        groupDataSet.sum("pdcompqty");
        groupDataSet.sum("pdcompanount");
        groupDataSet.sum("pdendqty");
        groupDataSet.sum("pdendamount");
        groupDataSet.sum("diff");
        groupDataSet.sum("totalqty");
        groupDataSet.sum("totalamount");
        groupDataSet.sum("totalstdqty");
        groupDataSet.sum("totalstdamount");
        groupDataSet.sum("stdqty");
        groupDataSet.sum("stdcost");
        String seleFields = "orgid, costaccountid, costobjectid, costcenterid, periodid, elementid, subelementid, materialid, auxptyid, matversionid, datatype, difftype, caltype, stdqty, stdcost, pdstartqty, pdstartamount, pdcurrqty, pdcurramount, pdcompqty, pdcompanount, pdendqty, pdendamount, diff, totalqty, totalamount, totalstdqty, totalstdamount,0 costupdatediffamt";
        return groupDataSet.finish().select(seleFields);
    }

    public static BigDecimal getMatStdPrice(Long typeId) {
        BigDecimal stdPrice = BigDecimal.ZERO;
        if (AcaAlgoxEmptyOrZeroUtils.isEmpty(typeId)) {
            return stdPrice;
        }
        DynamicObjectCollection matCostInfos = new DynamicObjectCollection();
        QFilter filter = new QFilter("id", "=", (Object)typeId);
        if (QueryServiceHelper.exists((String)"cad_calceffectiveresult", (Object)typeId)) {
            QFilter typeFilter = new QFilter("entryentity.datatype", "=", (Object)"1");
            matCostInfos = QueryServiceHelper.query((String)"cad_calceffectiveresult", (String)"id,entryentity.qty qty,entryentity.stdprice stdprice", (QFilter[])new QFilter[]{filter, typeFilter});
        } else if (QueryServiceHelper.exists((String)"cad_matcostinfo", (Object)typeId)) {
            matCostInfos = QueryServiceHelper.query((String)"cad_matcostinfo", (String)"id,entryentity.standardcost stdprice", (QFilter[])new QFilter[]{filter});
        }
        if (AcaAlgoxEmptyOrZeroUtils.isEmpty(matCostInfos)) {
            return stdPrice;
        }
        for (DynamicObject matcCost : matCostInfos) {
            stdPrice = stdPrice.add(matcCost.getBigDecimal("stdprice"));
        }
        return stdPrice;
    }

    public static DynamicObjectCollection getMatCostInfo(String costtypeid, String materialid, String matverid, String auxptyid, Date bizDate) {
        return MatCostHelper.getMatCostInfo(costtypeid, materialid, matverid, auxptyid, bizDate, true);
    }

    public static DynamicObjectCollection getMatCostInfo(String costtypeid, String materialid, String matverid, String auxptyid, Date bizDate, boolean hasMatCostInfo) {
        if (AcaAlgoxEmptyOrZeroUtils.isEmpty(materialid) || AcaAlgoxEmptyOrZeroUtils.isEmpty(costtypeid)) {
            return null;
        }
        QFilter filter = new QFilter("costtype", "=", (Object)costtypeid);
        filter.and(new QFilter("entryentity.datatype", "in", Arrays.asList("2", "3")));
        filter.and(new QFilter("material", "=", (Object)materialid));
        if (StringUtils.isNotEmpty((String)auxptyid)) {
            filter.and(new QFilter("auxproperty", "=", (Object)auxptyid));
        }
        if (StringUtils.isNotEmpty((String)matverid)) {
            filter.and(new QFilter("matvers", "=", (Object)matverid));
        }
        QFilter bizDateFilter = null;
        if (bizDate == null) {
            bizDateFilter = new QFilter("expdate", "=", (Object)AcaAlgoxTimeUtils.getDeFaultExpDate());
        } else {
            bizDateFilter = new QFilter("effectdate", "<=", (Object)bizDate);
            bizDateFilter.and(new QFilter("expdate", ">=", (Object)bizDate));
        }
        DynamicObjectCollection matCostInfoIds = QueryServiceHelper.query((String)"cad_calceffectiveresult", (String)"id", (QFilter[])new QFilter[]{filter, bizDateFilter});
        DynamicObjectCollection matCostInfos = null;
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(matCostInfoIds)) {
            QFilter idFilter = new QFilter("id", "=", (Object)((DynamicObject)matCostInfoIds.get(0)).getLong("id"));
            QFilter dataTypeFilter = new QFilter("entryentity.datatype", "in", Arrays.asList("2", "3"));
            matCostInfos = QueryServiceHelper.query((String)"cad_calceffectiveresult", (String)"id,effectdate,expdate,entryentity.element element,entryentity.subelement subelement,entryentity.submaterial submaterial,entryentity.submatvers submatvers,entryentity.subauxproperty subauxproperty,entryentity.qty qty,entryentity.stdprice standardcost,entryentity.price stdprice", (QFilter[])new QFilter[]{idFilter, dataTypeFilter});
        } else if (hasMatCostInfo) {
            QFilter matcostFilter = new QFilter("costtype", "=", (Object)costtypeid);
            matcostFilter.and(new QFilter("material", "=", (Object)materialid));
            if (StringUtils.isNotEmpty((String)auxptyid)) {
                matcostFilter.and(new QFilter("auxpty", "=", (Object)auxptyid));
            }
            if (StringUtils.isNotEmpty((String)matverid)) {
                matcostFilter.and(new QFilter("matversion", "=", (Object)matverid));
            }
            matcostFilter.and(new QFilter("effectdate", "<=", (Object)bizDate));
            matcostFilter.and(new QFilter("expdate", ">=", (Object)bizDate));
            matCostInfos = QueryServiceHelper.query((String)"cad_matcostinfo", (String)"id,effectdate,expdate,entryentity.element element,entryentity.subelement subelement,0 submaterial,0 submatvers,0 subauxproperty,0 qty,0 stdprice,entryentity.standardcost standardcost", (QFilter[])new QFilter[]{matcostFilter, bizDateFilter});
        }
        return AcaAlgoxEmptyOrZeroUtils.isEmpty(matCostInfos) ? null : matCostInfos;
    }

    public static Map<String, Map<String, List<BigDecimal>>> getMatCostInfo(Set<Long> allocIds) {
        if (AcaAlgoxEmptyOrZeroUtils.isEmpty(allocIds)) {
            return null;
        }
        QFilter filter = new QFilter("id", "in", allocIds);
        DynamicObject[] allocInfos = BusinessDataServiceHelper.load((String)"sca_matalloc", (String)"id,org,material,matcostinfo", (QFilter[])new QFilter[]{filter});
        HashMap<String, Map<String, List<BigDecimal>>> matcostInfoMap = new HashMap<String, Map<String, List<BigDecimal>>>(16);
        HashSet<Long> calcIds = new HashSet<Long>(16);
        HashMap<String, String> matstdcostIdAndcalcId = new HashMap<String, String>(16);
        for (DynamicObject allocInfo : allocInfos) {
            if (!calcIds.contains(allocInfo.getLong("matcostinfo"))) {
                calcIds.add(allocInfo.getLong("matcostinfo"));
            }
            matstdcostIdAndcalcId.put(allocInfo.getString("matcostinfo"), allocInfo.getString("id"));
        }
        Map<String, Map<String, List<BigDecimal>>> matstdcostInfoMap = MatCostHelper.getMatCostInfo(calcIds, new String[]{"2", "3"});
        for (Map.Entry entry : matstdcostIdAndcalcId.entrySet()) {
            matcostInfoMap.put((String)entry.getValue(), matstdcostInfoMap.get(entry.getKey()));
        }
        return matcostInfoMap;
    }

    public static Map<String, Map<String, List<BigDecimal>>> getMatCostInfo(Set<Long> ids, String[] dataType) {
        DynamicObject[] matCostInfos;
        DynamicObject[] calcInfos;
        HashMap<String, Map<String, List<BigDecimal>>> matcostInfoMap = new HashMap<String, Map<String, List<BigDecimal>>>(16);
        QFilter calcFilter = new QFilter("id", "in", ids);
        calcFilter.and(new QFilter("entryentity.datatype", "in", (Object)dataType));
        for (DynamicObject calcInfo : calcInfos = BusinessDataServiceHelper.load((String)"cad_calceffectiveresult", (String)"id,entryentity.element,entryentity.subelement,entryentity.submaterial,entryentity.submatvers,entryentity.subauxproperty,entryentity.qty,entryentity.stdprice,entryentity.datatype", (QFilter[])new QFilter[]{calcFilter})) {
            String calcId = calcInfo.getString("id");
            HashMap matCalcInfo = new HashMap();
            DynamicObjectCollection calcEntryInfos = calcInfo.getDynamicObjectCollection("entryentity");
            for (DynamicObject calcEntryInfo : calcEntryInfos) {
                if (!Arrays.asList(dataType).contains(calcEntryInfo.getString("datatype"))) continue;
                StringBuilder key = new StringBuilder();
                key.append(calcEntryInfo.getLong("element.masterid")).append("@");
                key.append(calcEntryInfo.getLong("subelement.masterid")).append("@");
                key.append(calcEntryInfo.getLong("submaterial.masterid")).append("@");
                key.append(calcEntryInfo.getLong("submatvers.masterid")).append("@");
                key.append(calcEntryInfo.getLong("submatvers.masterid")).append("@");
                key.append(calcEntryInfo.getPkValue().toString()).append("@");
                ArrayList<BigDecimal> qtyandcost = new ArrayList<BigDecimal>();
                qtyandcost.add(calcEntryInfo.getBigDecimal("qty"));
                qtyandcost.add(calcEntryInfo.getBigDecimal("stdprice"));
                matCalcInfo.put(key.toString(), qtyandcost);
            }
            matcostInfoMap.put(calcId, matCalcInfo);
        }
        QFilter matcostFilter = new QFilter("id", "in", ids);
        for (DynamicObject matCostInfo : matCostInfos = BusinessDataServiceHelper.load((String)"cad_matcostinfo", (String)"id,material,matversion,auxpty,entryentity.element,entryentity.subelement,entryentity.standardcost", (QFilter[])new QFilter[]{matcostFilter})) {
            String matcostId = matCostInfo.getString("id");
            HashMap matCalcInfo = new HashMap();
            DynamicObjectCollection matCostEntryInfos = matCostInfo.getDynamicObjectCollection("entryentity");
            for (DynamicObject calcEntryInfo : matCostEntryInfos) {
                StringBuilder key = new StringBuilder();
                key.append(calcEntryInfo.getLong("element.masterid")).append("@");
                key.append(calcEntryInfo.getLong("subelement.masterid")).append("@");
                key.append(matCostInfo.getLong("material.masterid")).append("@");
                key.append(matCostInfo.getLong("matversion.id")).append("@");
                key.append(matCostInfo.getLong("auxpty.id"));
                ArrayList<BigDecimal> qtyandcost = new ArrayList<BigDecimal>();
                qtyandcost.add(BigDecimal.ZERO);
                qtyandcost.add(calcEntryInfo.getBigDecimal("standardcost"));
                matCalcInfo.put(key.toString(), qtyandcost);
            }
            matcostInfoMap.put(matcostId, matCalcInfo);
        }
        return matcostInfoMap;
    }
}

