/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PeriodHelper {
    public static DynamicObject getPeriod(Long periodId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period");
    }

    public static Long getPrePeriodId(Object periodId) {
        if (periodId == null) {
            return 0L;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)periodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", "<", (Object)currPeriod.getInt("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        QFilter pYear = new QFilter("periodyear", "<", (Object)currPeriod.getInt("periodyear"));
        pfilter.or(pYear);
        QFilter q = new QFilter("isadjustperiod", "=", (Object)false);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filterType, pfilter, q}, (String)"periodyear desc, periodnumber desc");
        if (cols.size() > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cols.get(0)).getLong("id"), (DynamicObjectType)type).getLong("id");
        }
        return 0L;
    }

    public static Map<String, Date> getPeriodBeginDateAndEndDate(DynamicObject period) {
        HashMap<String, Date> resultPeriod = new HashMap<String, Date>(16);
        Date beginDate = period.getDate("begindate");
        Date endDate = period.getDate("enddate");
        resultPeriod.put("begindate", beginDate);
        resultPeriod.put("enddate", endDate);
        return resultPeriod;
    }

    public static Date getPeriodBeginDate(Long periodId) {
        DynamicObject dyo = PeriodHelper.getPeriod(periodId);
        if (dyo != null) {
            return dyo.getDate("begindate");
        }
        return null;
    }

    public static Date getPeriodEndDate(Long periodId) {
        DynamicObject dyo = PeriodHelper.getPeriod(periodId);
        if (dyo != null) {
            return dyo.getDate("enddate");
        }
        return null;
    }

    public static DynamicObject getNextPeriod(Long curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", ">", (Object)currPeriod.getInt("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        QFilter pYear = new QFilter("periodyear", ">", (Object)currPeriod.getInt("periodyear"));
        pfilter.or(pYear);
        QFilter q = new QFilter("isadjustperiod", "=", (Object)false);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filterType, pfilter, q}, (String)"periodyear asc, periodnumber asc");
        if (cols.size() > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cols.get(0)).getLong("id"), (DynamicObjectType)type);
        }
        return null;
    }

    public static Set<Long> getCurPeriodYear(Long curPeriodId) {
        HashSet<Long> periodSet = new HashSet<Long>(10);
        if (curPeriodId == null) {
            return periodSet;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)curPeriodId, (DynamicObjectType)type);
        if (currPeriod == null) {
            return periodSet;
        }
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filter = new QFilter("periodtype.id", "=", periodtypeid);
        filter.and("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        filter.and("periodnumber", "<=", (Object)currPeriod.getInt("periodnumber"));
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])filter.toArray(), null);
        if (cols.size() > 0) {
            for (DynamicObject dyn : cols) {
                periodSet.add(dyn.getLong("id"));
            }
        }
        return periodSet;
    }

    public static Long getNextPeriodId(Long curPeriodId) {
        DynamicObject rs = PeriodHelper.getNextPeriod(curPeriodId);
        if (rs != null) {
            return rs.getLong("id");
        }
        return null;
    }

    public static boolean isFirstPeriod(Long curPeriodId) {
        DynamicObject curPeriod = QueryServiceHelper.queryOne((String)"bd_period", (String)"periodyear", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)curPeriodId)});
        if (curPeriod == null) {
            return false;
        }
        QFilter yearFilter = new QFilter("periodyear", "=", (Object)curPeriod.getInt("periodyear"));
        QFilter idFilter = new QFilter("id", "<", (Object)curPeriodId);
        return !QueryServiceHelper.exists((String)"bd_period", (QFilter[])new QFilter[]{yearFilter, idFilter});
    }
}

