/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.calc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.macc.aca.algox.utils.PeriodHelper;
import kd.macc.aca.report.calc.handle.CalcResultRptHandleFinalRow;
import kd.macc.aca.report.calc.handle.CalcResultRptHandleGroupRow;
import kd.macc.aca.report.calc.handle.CalcResultRptHandleSumRow;
import kd.macc.aca.report.calc.model.CalcResultParam;
import kd.macc.aca.report.calc.model.CalcResultRptConstants;
import kd.macc.aca.report.helper.ReportRptHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CalcResultRptSourceCf
implements IReportDataHandle {
    private final Log logger = LogFactory.getLog(CalcResultRptSourceCf.class);
    private List<String> qczcProps = Lists.newArrayList((Object[])new String[]{"pdstartqty", "pdstartamount"});
    private List<String> qczcAdjustProps = Lists.newArrayList((Object[])new String[]{"startadjqty", "startadjamt"});
    private List<String> bqInProps = Lists.newArrayList((Object[])new String[]{"pdcurrqty", "pdcurramount"});
    private List<String> ljInProps = Lists.newArrayList((Object[])new String[]{"pdsumqty", "pdsumamount"});
    private List<String> yearLjInProps = Lists.newArrayList((Object[])new String[]{"yearpdsumqty", "yearpdsumamount"});
    private List<String> qmzcProps = Lists.newArrayList((Object[])new String[]{"pdendqty", "pdendamount"});
    private List<String> qmzcAdjustProps = Lists.newArrayList((Object[])new String[]{"endadjqty", "endadjamt"});
    private List<String> bqFinishProps = Lists.newArrayList((Object[])new String[]{"currcomqty", "currcomuse", "currcomunitcost", "currcomamount"});
    private List<String> ljFinishProps = Lists.newArrayList((Object[])new String[]{"totalcomqty", "sumcomuse", "totalcomunitcost", "totalcomamount"});
    private List<String> yearLjFinishProps = Lists.newArrayList((Object[])new String[]{"yeartotalcomqty", "yearsumcomuse", "yeartotalcomunitcost", "yeartotalcomamount"});
    private List<String> hideProps = Lists.newArrayList((Object[])new String[]{"billno", "linetype", "currencyfield", "type"});
    private CalcResultParam reportParam;

    public void setupCtx(ReportDataCtx ctx) {
        this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
        this.reportParam = (CalcResultParam)ctx.getParam(CalcResultParam.class.getName());
        ctx.setShowBlockEntity(false);
        if (0 == CadBgParamUtils.getScmParamForInt((String)"acaCalcRpCBTotal", (int)1) && ctx.getShowKeyCols().contains("costobject")) {
            this.reportParam.setDimContainCostobject(true);
        }
        List<String> allkeyCols = ReportRptHelper.filterBigtableCols(ctx.getReportConf(), null);
        this.reportParam.setAllKeyCols(allkeyCols);
        boolean isNeedJd = false;
        for (String col : allkeyCols) {
            if ("element".equals(col) || "subelement".equals(col) || "elementnumber".equals(col)) {
                isNeedJd = true;
            }
            if (!isNeedJd) continue;
            if (ctx.getShowKeyCols().contains(col)) {
                this.reportParam.setShowDetail(true);
            }
            this.reportParam.getDetailCols().add(col);
        }
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
        this.configKeyCols(ctx);
    }

    private void configKeyCols(ReportDataCtx ctx) {
        Set showKeyCols = ctx.getShowKeyCols();
        showKeyCols.add("period");
        showKeyCols.add("type");
        this.reportParam.getNeedClearFields().add("type");
        for (String field : CalcResultRptConstants.ADD_NUM_FIELDS) {
            if (!ctx.getShowKeyCols().contains(field)) continue;
            ctx.getShowKeyCols().add(field + "number");
        }
        if (this.reportParam.isViewSubitem() && !CadEmptyUtils.isEmpty(this.reportParam.getSubelementIds()) && ctx.getShowKeyCols().add("subelement")) {
            this.reportParam.getNeedClearFields().add("subelement");
        }
        if (showKeyCols.contains("material")) {
            ctx.getShowKeyCols().add("unit");
        }
        if (showKeyCols.contains("submaterial")) {
            ctx.getShowKeyCols().add("submatunit");
        }
        if (!showKeyCols.contains("material") && ReportRptHelper.containKeys(showKeyCols, CalcResultRptConstants.MAT_RELA_FIELDS)) {
            ctx.getShowKeyCols().add("material");
            this.reportParam.getNeedClearFields().add("material");
        }
        if (!showKeyCols.contains("submaterial") && ReportRptHelper.containKeys(showKeyCols, CalcResultRptConstants.SUBMAT_RELA_FIELDS)) {
            ctx.getShowKeyCols().add("submaterial");
            this.reportParam.getNeedClearFields().add("submaterial");
        }
        if (ctx.getShowKeyCols().add("costobject")) {
            this.reportParam.getNeedClearFields().add("costobject");
        }
        if (ctx.getShowKeyCols().contains("closestatus")) {
            ctx.getShowKeyCols().add("closedate");
        }
        if (this.reportParam.isViewSubitem()) {
            List<String> subitemFields = ReportRptHelper.fieldsAddPreToList(CalcResultRptConstants.SUBITEM_FIELDS.toArray(new String[0]), "s");
            showKeyCols.addAll(subitemFields);
            this.reportParam.getNeedClearFields().addAll(subitemFields);
        }
        ctx.setShowKeyCols(showKeyCols);
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("union\u6570\u636e\u6e90\u65f6\uff0c\u6dfb\u52a0\u5173\u8054\u6570\u636e");
        ArrayList<String> yearPeriodFields = new ArrayList<String>(10);
        yearPeriodFields.addAll(this.yearLjInProps);
        yearPeriodFields.addAll(this.yearLjFinishProps);
        transCollector.add(new CalcResultRptHandleFinalRow(this.reportParam, ctx, yearPeriodFields));
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        super.beforeGroupData(ctx);
        ctx.setGroupPlans(null);
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("group\u5b8c\u6210\u540e\u6267\u884c\u6570\u636e\u8f6c\u6362");
        transCollector.add(new CalcResultRptHandleGroupRow(this.reportParam, ctx));
    }

    public void beforeAddSumRow(ReportDataCtx ctx) {
        this.logger.info("\u5728\u6dfb\u52a0\u6c47\u603b\u884c\u524d\u8bbe\u7f6e\u6c47\u603b\u65b9\u6848\uff0c\u6216\u8005\u5176\u4ed6\u4e0a\u4e0b\u6587\u8bbe\u7f6e");
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("\u6dfb\u52a0\u5b8c\u6c47\u603b\u884c\u540e\u6267\u884c\u7684\u6570\u636e\u8f6c\u6362");
        transCollector.add(new CalcResultRptHandleSumRow(this.reportParam, ctx));
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("\u751f\u6210\u6700\u7ec8\u7684\u6570\u636e\u5305\u540e\uff0c\u6267\u884c\u7684\u6570\u636e\u8f6c\u6362");
    }

    private List<QFilter> getFixedFilter() {
        List<Long> costCenterIds;
        ArrayList<QFilter> commonFilters = new ArrayList<QFilter>(10);
        Long orgId = this.reportParam.getOrgId();
        commonFilters.add(new QFilter("org", "=", (Object)orgId));
        Long costAccountId = this.reportParam.getCostAccountId();
        commonFilters.add(new QFilter("costaccount", "=", (Object)costAccountId));
        List<Long> periodIds = this.reportParam.getPeriodIds();
        HashSet<Long> queryPeriodIds = new HashSet<Long>(periodIds);
        if (this.reportParam.isViewtotal() && !this.reportParam.isDimContainCostobject()) {
            for (Long periodId : periodIds) {
                Set yearPeriodIds = PeriodHelper.getCurPeriodYear((Long)periodId);
                this.reportParam.getPeriodYearMap().put(periodId, yearPeriodIds);
                queryPeriodIds.addAll(yearPeriodIds);
            }
        }
        this.reportParam.setQueryPeriodIds(queryPeriodIds);
        commonFilters.add(new QFilter("period", "in", queryPeriodIds));
        List<Long> manuOrgIds = this.reportParam.getManuOrgIds();
        if (!CadEmptyUtils.isEmpty(manuOrgIds)) {
            commonFilters.add(new QFilter("costobject.manuorg", "in", manuOrgIds));
        }
        if (!CadEmptyUtils.isEmpty(costCenterIds = this.reportParam.getCostCenterIds())) {
            commonFilters.add(new QFilter("costcenter", "in", costCenterIds));
        }
        List<Long> costObjectIds = this.reportParam.getCostObjectIds();
        List<Long> materialIds = this.reportParam.getMaterialIds();
        if (costObjectIds != null || materialIds != null) {
            Set<Long> mainCostObjectIds = this.getMainCostobjectIds(commonFilters, costObjectIds, materialIds);
            this.reportParam.setMainCostObjectIds(mainCostObjectIds);
            commonFilters.add(new QFilter("qcostobject", "in", mainCostObjectIds));
        }
        if (!this.reportParam.isShowDetail()) {
            commonFilters.add(new QFilter("type", "=", (Object)"finalResult"));
        } else {
            if (!CadEmptyUtils.isEmpty(this.reportParam.getSubMaterialIds())) {
                commonFilters.add(new QFilter("submaterial", "in", this.reportParam.getSubMaterialIds()).or("type", "=", (Object)"finalResult"));
            }
            if (!CadEmptyUtils.isEmpty(this.reportParam.getSubelementIds()) && !this.reportParam.isViewSubitem()) {
                commonFilters.add(new QFilter("subelement", "in", this.reportParam.getSubelementIds()).or("type", "=", (Object)"finalResult"));
            }
        }
        return commonFilters;
    }

    private Set<Long> getMainCostobjectIds(List<QFilter> commonFilters, List<Long> costObjectIds, List<Long> materialIds) {
        DataSet dataSet;
        ArrayList<QFilter> calResultFilter = new ArrayList<QFilter>(10);
        calResultFilter.addAll(commonFilters);
        HashSet<Long> ids = new HashSet<Long>(16);
        calResultFilter.add(new QFilter("entryentity.type", "=", (Object)"finalResult"));
        if (costObjectIds != null && !costObjectIds.isEmpty()) {
            calResultFilter.add(new QFilter("entryentity.relacostobject", "in", costObjectIds));
        }
        if (materialIds != null && !materialIds.isEmpty()) {
            calResultFilter.add(new QFilter("entryentity.relacostobject.material", "in", materialIds));
        }
        if ((dataSet = QueryServiceHelper.queryDataSet((String)"costobject", (String)"aca_calcresult", (String)"costobject mainCostObjectId", (QFilter[])calResultFilter.toArray(new QFilter[0]), (String)"")) != null && dataSet.hasNext()) {
            for (Row row : dataSet) {
                ids.add(row.getLong("mainCostObjectId"));
            }
        }
        return ids;
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        this.logger.info("\u914d\u7f6e\u5217\u662f\u5426\u663e\u793a");
        ReportColumnGroup qcGroup = new ReportColumnGroup();
        qcGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u671f\u521d\u5728\u4ea7\u54c1", (String)"CalcResultRptSourceCf_1", (String)"macc-aca-report", (Object[])new Object[0])));
        qcGroup.setFieldKey("qcGroup");
        ReportColumnGroup qcAdjustGroup = new ReportColumnGroup();
        qcAdjustGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u671f\u521d\u5728\u4ea7\u54c1\u8c03\u6574", (String)"CalcResultRptSourceCf_2", (String)"macc-aca-report", (Object[])new Object[0])));
        qcAdjustGroup.setFieldKey("qcAdjustGroup");
        ReportColumnGroup bqtrGroup = new ReportColumnGroup();
        bqtrGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u6295\u5165", (String)"CalcResultRptSourceCf_3", (String)"macc-aca-report", (Object[])new Object[0])));
        bqtrGroup.setFieldKey("bqtrGroup");
        ReportColumnGroup bqwgGroup = new ReportColumnGroup();
        bqwgGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u5b8c\u5de5", (String)"CalcResultRptSourceCf_4", (String)"macc-aca-report", (Object[])new Object[0])));
        bqwgGroup.setFieldKey("bqwgGroup");
        ReportColumnGroup qmzcGroup = new ReportColumnGroup();
        qmzcGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u671f\u672b\u5728\u4ea7\u54c1", (String)"CalcResultRptSourceCf_5", (String)"macc-aca-report", (Object[])new Object[0])));
        qmzcGroup.setFieldKey("qmzcGroup");
        ReportColumnGroup qmzcAdjustGroup = new ReportColumnGroup();
        qmzcAdjustGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u671f\u672b\u5728\u4ea7\u54c1\u8c03\u6574", (String)"CalcResultRptSourceCf_6", (String)"macc-aca-report", (Object[])new Object[0])));
        qmzcAdjustGroup.setFieldKey("qmzcAdjustGroup");
        ReportColumnGroup yearInGroup = new ReportColumnGroup();
        yearInGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u6295\u5165", (String)"CalcResultRptSourceCf_7", (String)"macc-aca-report", (Object[])new Object[0])));
        yearInGroup.setFieldKey("yearInGroup");
        ReportColumnGroup yearFinishGroup = new ReportColumnGroup();
        yearFinishGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u5b8c\u5de5", (String)"CalcResultRptSourceCf_8", (String)"macc-aca-report", (Object[])new Object[0])));
        yearFinishGroup.setFieldKey("yearFinishGroup");
        ReportColumnGroup inGroup = new ReportColumnGroup();
        inGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7d2f\u8ba1\u6295\u5165", (String)"CalcResultRptSourceCf_9", (String)"macc-aca-report", (Object[])new Object[0])));
        inGroup.setFieldKey("inGroup");
        ReportColumnGroup finishGroup = new ReportColumnGroup();
        finishGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7d2f\u8ba1\u5b8c\u5de5", (String)"CalcResultRptSourceCf_10", (String)"macc-aca-report", (Object[])new Object[0])));
        finishGroup.setFieldKey("finishGroup");
        Iterator<AbstractReportColumn> iterator = cols.iterator();
        ReportColumn unitRepCol = null;
        while (iterator.hasNext()) {
            Set showQtyCols;
            ReportColumn repCol = (ReportColumn)iterator.next();
            String fieldKey = repCol.getFieldKey();
            repCol.setNoDisplayScaleZero(false);
            if ("unit".equals(fieldKey)) {
                unitRepCol = repCol;
                iterator.remove();
            }
            if (this.hideProps.contains(fieldKey)) {
                repCol.setHide(true);
            }
            if (this.qczcProps.contains(fieldKey)) {
                qcGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (this.qczcAdjustProps.contains(fieldKey)) {
                qcAdjustGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (this.bqInProps.contains(fieldKey)) {
                bqtrGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (this.bqFinishProps.contains(fieldKey)) {
                bqwgGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (this.qmzcProps.contains(fieldKey)) {
                qmzcGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (this.qmzcAdjustProps.contains(fieldKey)) {
                qmzcAdjustGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (this.yearLjInProps.contains(fieldKey)) {
                yearInGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (this.yearLjFinishProps.contains(fieldKey)) {
                yearFinishGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (this.ljInProps.contains(fieldKey)) {
                inGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (this.ljFinishProps.contains(fieldKey)) {
                finishGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if ((showQtyCols = ctx.getShowQtyCols()).contains(fieldKey)) {
                repCol.setZeroShow(false);
                if ("amount".equals(repCol.getFieldType()) || "price".equals(repCol.getFieldType())) {
                    repCol.setCurrencyField("currencyField");
                }
            }
            if (!fieldKey.contains("qty") || !showQtyCols.contains(fieldKey)) continue;
            if (ctx.getShowKeyCols().contains("unit")) {
                repCol.setMeasureUnitField("unit");
                continue;
            }
            if (!ctx.getShowKeyCols().contains("submatunit")) continue;
            repCol.setMeasureUnitField("submatunit");
        }
        if (unitRepCol != null) {
            cols.add((AbstractReportColumn)unitRepCol);
        }
        if (!qcGroup.getChildren().isEmpty()) {
            cols.add((AbstractReportColumn)qcGroup);
        }
        if (!qcAdjustGroup.getChildren().isEmpty()) {
            cols.add((AbstractReportColumn)qcAdjustGroup);
        }
        if (!bqtrGroup.getChildren().isEmpty()) {
            cols.add((AbstractReportColumn)bqtrGroup);
        }
        if (!bqwgGroup.getChildren().isEmpty()) {
            cols.add((AbstractReportColumn)bqwgGroup);
        }
        if (!qmzcGroup.getChildren().isEmpty()) {
            cols.add((AbstractReportColumn)qmzcGroup);
        }
        if (!qmzcAdjustGroup.getChildren().isEmpty()) {
            cols.add((AbstractReportColumn)qmzcAdjustGroup);
        }
        if (!yearInGroup.getChildren().isEmpty() && this.reportParam.isViewtotal()) {
            cols.add((AbstractReportColumn)yearInGroup);
        }
        if (!yearFinishGroup.getChildren().isEmpty() && this.reportParam.isViewtotal()) {
            cols.add((AbstractReportColumn)yearFinishGroup);
        }
        if (!inGroup.getChildren().isEmpty()) {
            cols.add((AbstractReportColumn)inGroup);
        }
        if (!finishGroup.getChildren().isEmpty()) {
            cols.add((AbstractReportColumn)finishGroup);
        }
        return cols;
    }
}

