/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.calc.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class CalcResultRptDealMergeFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private List<String> qtyFields = null;
    private boolean isFilterDetail;

    public CalcResultRptDealMergeFunction(List<String> qtyFields, boolean isFilterDetail) {
        this.qtyFields = qtyFields;
        this.isFilterDetail = isFilterDetail;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector cols) {
        ArrayList collectRows = Lists.newArrayList();
        RowX comRow = null;
        for (RowX row : iterable) {
            String type = row.getString(this.sourceRowMeta.getFieldIndex("type"));
            if ("finalResult".equals(type)) {
                comRow = row;
                continue;
            }
            collectRows.add(row);
        }
        if (comRow != null) {
            for (RowX row : collectRows) {
                this.setProQty(row, comRow);
            }
        }
        if (this.isFilterDetail && collectRows.isEmpty()) {
            return;
        }
        if (collectRows.isEmpty() && comRow != null) {
            this.setProQty(comRow, comRow);
            this.clearQtyVal(comRow);
            collectRows.add(comRow);
        }
        for (RowX row : collectRows) {
            cols.collect(row);
        }
    }

    private void setProQty(RowX row, RowX comRow) {
        for (String field : this.qtyFields) {
            String proField = "pro" + field;
            int index = this.sourceRowMeta.getFieldIndex(field, false);
            int sindex = this.sourceRowMeta.getFieldIndex(proField, false);
            if (index < 0 || sindex < 0) continue;
            row.set(sindex, comRow.get(index));
        }
    }

    private void clearQtyVal(RowX row) {
        for (String field : this.qtyFields) {
            int index = this.sourceRowMeta.getFieldIndex(field, false);
            if (index < 0) continue;
            row.set(index, (Object)BigDecimal.ZERO);
        }
    }
}

