/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.calc.handle;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.MapFunction;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.aca.algox.utils.DataSetXHelper;
import kd.macc.aca.report.calc.function.CalcResultRptCalcSubTotalFunction;
import kd.macc.aca.report.calc.function.CalcResultRptDealComQtyFunction;
import kd.macc.aca.report.calc.function.CalcResultRptDealMergeFunction;
import kd.macc.aca.report.calc.function.CalcResultRptTotalUnitAmtFunction;
import kd.macc.aca.report.calc.model.CalcResultParam;
import kd.macc.aca.report.calc.model.CalcResultRptConstants;
import kd.macc.aca.report.helper.ReportRptHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CalcResultRptHandleGroupRow
implements IDataXTransform {
    private ReportDataCtx ctx;
    private CalcResultParam reportParam;

    public CalcResultRptHandleGroupRow(CalcResultParam calcResultParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.reportParam = calcResultParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        Set detailShowCols = this.ctx.getShowKeyCols();
        if (this.reportParam.isShowDetail()) {
            List<String> qtyFields = ReportRptHelper.fieldsAddPreToList(CalcResultRptConstants.QTY_FIELDS.toArray(new String[0]), "pro");
            srcData = ReportRptHelper.addBigDecimalFields(srcData, qtyFields.toArray(new String[0]));
            srcData = srcData.groupBy(new String[]{"period", "costobject"}).reduceGroup((GroupReduceFunction)new CalcResultRptDealMergeFunction(CalcResultRptConstants.QTY_FIELDS, this.reportParam.isContainDetailFilter()));
            HashSet compShowCols = new HashSet(detailShowCols);
            compShowCols.removeAll(this.reportParam.getDetailCols());
            detailShowCols.removeAll(this.reportParam.getNeedClearFields());
            DataSetX detailDataDsx = ReportRptHelper.groupSumAndMaxDeal(srcData, detailShowCols.toArray(new String[0]), this.ctx.getShowQtyCols().toArray(new String[0]), null);
            detailDataDsx = detailDataDsx.addFields(new Field[]{new Field("datatype", (DataType)DataType.StringType)}, new Object[]{"6"});
            DataSetX comtDataDsx = ReportRptHelper.groupSumAndMaxDeal(srcData, compShowCols.toArray(new String[0]), null, qtyFields.toArray(new String[0]));
            if (!CadEmptyUtils.isEmpty(this.reportParam.getNeedClearFields())) {
                compShowCols.removeAll(this.reportParam.getNeedClearFields());
                comtDataDsx = ReportRptHelper.groupSumAndMaxDeal(comtDataDsx, compShowCols.toArray(new String[0]), qtyFields.toArray(new String[0]), null);
            }
            comtDataDsx = comtDataDsx.addFields(new Field[]{new Field("datatype", (DataType)DataType.StringType)}, new Object[]{"1"});
            HashSet showQtyFields = new HashSet(this.ctx.getShowQtyCols());
            showQtyFields.retainAll(CalcResultRptConstants.QTY_FIELDS);
            comtDataDsx = ReportRptHelper.addBigDecimalFields(comtDataDsx, showQtyFields.toArray(new String[0]));
            comtDataDsx = comtDataDsx.map((MapFunction)new CalcResultRptDealComQtyFunction(CalcResultRptConstants.QTY_FIELDS));
            detailDataDsx = DataSetXHelper.unionIfRowDiff((DataSetX)detailDataDsx, (DataSetX)comtDataDsx);
            srcData = detailDataDsx.groupBy(compShowCols.toArray(new String[0])).reduceGroup((GroupReduceFunction)new CalcResultRptCalcSubTotalFunction(this.reportParam.getPricePrecision(), this.ctx.getShowQtyCols()));
        } else {
            detailShowCols.removeAll(this.reportParam.getNeedClearFields());
            srcData = ReportRptHelper.groupSumAndMaxDeal(srcData, detailShowCols.toArray(new String[0]), this.ctx.getShowQtyCols().toArray(new String[0]), null);
            srcData = srcData.addFields(new Field[]{new Field("datatype", (DataType)DataType.StringType)}, new Object[]{"1"});
            srcData = srcData.map((MapFunction)new CalcResultRptTotalUnitAmtFunction(this.reportParam.getPricePrecision()));
        }
        return srcData;
    }
}

