/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.cost;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.utils.CostaccountHelper;
import kd.macc.aca.algox.utils.MaterialGroupHelper;
import kd.macc.aca.common.helper.MatBaseDataFilterHelper;
import kd.macc.aca.common.helper.PermItemCheckHelper;
import kd.macc.cad.common.constants.CommonConstant;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ReportUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import org.apache.commons.collections.CollectionUtils;

public class ProCostBehaviorAnalRptPlugin
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static String[] CLEAR_STR_MAT = new String[]{"period", "materialgroup"};
    private static String[] CLEAR_STR_ARR = new String[]{"product", "auxpty", "version", "unit", "storageqty"};
    private static String[] COST_TYPE = new String[]{"standardcost", "standardprice", "diffcost", "diffprice"};
    private static String[] PUDUCT_FILEDS = new String[]{"product", "productname", "modelnum", "auxpty", "version", "unit"};

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"calcrecord"});
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccounts");
        costAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = listShowParameter.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            List acctOrgs = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (CadEmptyUtils.isEmpty((List)acctOrgs)) {
                qFilters.add(QFilter.of((String)"1=0", (Object[])new Object[0]));
                return;
            }
            QFilter costAccountFilter = StartCostHelper.getIsinitCostAccountFilter((String)"aca");
            if (costAccountFilter == null) {
                qFilters.add(QFilter.of((String)"1=0", (Object[])new Object[0]));
                return;
            }
            costAccountFilter.and(new QFilter("calorg", "in", (Object)acctOrgs));
            qFilters.add(costAccountFilter);
        });
        BasedataEdit costcenter = (BasedataEdit)this.getControl("costcenter");
        costcenter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObjectCollection costAccounts = (DynamicObjectCollection)this.getModel().getValue("costaccounts");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccounts)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"ProCostBehaviorAnalRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Set calorg = costAccounts.stream().map(r -> r.getLong("fbasedataid.calorg.id")).collect(Collectors.toSet());
            if (calorg.size() > 0) {
                QFilter showOrgDutyFilter = new QFilter("orgduty", "=", (Object)4L);
                QFilter calorgsFilter = new QFilter("accountorg", "in", calorg);
                qFilters.add(showOrgDutyFilter);
                qFilters.add(calorgsFilter);
            }
        });
        BasedataEdit startPeriod = (BasedataEdit)this.getControl("startperiod");
        startPeriod.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObjectCollection costAccounts = (DynamicObjectCollection)this.getModel().getValue("costaccounts");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccounts)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"ProCostBehaviorAnalRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter periodFilter = this.getPeriodFilter(costAccounts);
            if (periodFilter != null) {
                ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
                List qFilters = listFilterParameter.getQFilters();
                qFilters.add(periodFilter);
            }
        });
        BasedataEdit endPeriod = (BasedataEdit)this.getControl("endperiod");
        endPeriod.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject startPer = (DynamicObject)this.getModel().getValue("startPeriod");
            if (CadEmptyUtils.isEmpty((DynamicObject)startPer)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f00\u59cb\u671f\u95f4\u3002", (String)"ProCostBehaviorAnalRptPlugin_1", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObjectCollection costAccounts = (DynamicObjectCollection)this.getModel().getValue("costaccounts");
            QFilter periodFilter = this.getPeriodFilter(costAccounts);
            if (periodFilter != null) {
                periodFilter.and(new QFilter("id", ">=", startPer.get("id")));
                ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
                List qFilters = listFilterParameter.getQFilters();
                qFilters.add(periodFilter);
            }
        });
        BasedataEdit products = (BasedataEdit)this.getControl("products");
        products.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObjectCollection costAccounts = (DynamicObjectCollection)this.getModel().getValue("costaccounts");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccounts)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"ProCostBehaviorAnalRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Set calorg = costAccounts.stream().map(r -> r.getLong("fbasedataid.calorg.id")).collect(Collectors.toSet());
            if (calorg.size() > 0) {
                DynamicObject materialgroupstandard = (DynamicObject)this.getModel().getValue("materialgrpstd");
                if (materialgroupstandard == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"ProCostBehaviorAnalRptPlugin_2", (String)"macc-aca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObjectCollection mulmaterialgroup = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup");
                ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
                List qFilters = listFilterParameter.getQFilters();
                qFilters.add(MatBaseDataFilterHelper.getBaseFilter(new ArrayList(calorg)));
                if (!CollectionUtils.isEmpty((Collection)mulmaterialgroup) || materialgroupstandard.getLong("id") != 730148448254487552L) {
                    qFilters.add(MaterialGroupHelper.getClassifiedMaterialIdFilter((DynamicObjectCollection)mulmaterialgroup, (boolean)false, (DynamicObject)materialgroupstandard));
                }
            }
        });
        BasedataEdit costType = (BasedataEdit)this.getControl("costtype");
        costType.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObjectCollection costAccounts = (DynamicObjectCollection)this.getModel().getValue("costaccounts");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccounts)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"ProCostBehaviorAnalRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject currencyObj = (DynamicObject)this.getModel().getValue("currency");
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            QFilter filter = new QFilter("id", "!=", (Object)CommonConstant.ACA_COST_TYPE_ID);
            filter.and(new QFilter("type", "=", (Object)"1"));
            filter.and(new QFilter("currency", "=", currencyObj.get("id")));
            filterParameter.setFilter(filter);
        });
        BasedataEdit materialgrpstd = (BasedataEdit)this.getControl("materialgrpstd");
        materialgrpstd.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObjectCollection costAccounts = (DynamicObjectCollection)this.getModel().getValue("costaccounts");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccounts)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"ProCostBehaviorAnalRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            List createOrgIds = costAccounts.stream().map(r -> r.getLong("fbasedataid.calorg.id")).collect(Collectors.toList());
            if (createOrgIds.size() > 0) {
                Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, Boolean.TRUE});
                QFilter idFilter = new QFilter("id", "in", (Object)ids);
                ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
                List qFilters = listFilterParameter.getQFilters();
                qFilters.add(idFilter);
            }
        });
        MulBasedataEdit mulmaterialgroup = (MulBasedataEdit)this.getControl("mulmaterialgroup");
        mulmaterialgroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject materialgrpstdObj = (DynamicObject)this.getModel().getValue("materialgrpstd");
            if (materialgrpstdObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"ProCostBehaviorAnalRptPlugin_2", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObjectCollection costAccounts = (DynamicObjectCollection)this.getModel().getValue("costaccounts");
            List createOrgIds = costAccounts.stream().map(r -> r.getLong("fbasedataid.calorg.id")).collect(Collectors.toList());
            QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialgrpstdObj.getPkValue(), false});
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(serviceResponse);
            HashMap params = new HashMap(2);
            params.put("useOrgs", createOrgIds);
            listShowParameter.setCustomParams(params);
            listShowParameter.setCustomParam("groupStandard", materialgrpstdObj.getPkValue());
            listShowParameter.setF7ClickByFilter(false);
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setViewSubItem();
    }

    private void setViewSubItem() {
        boolean viewSubitem = true;
        DynamicObjectCollection costAccountCol = this.getModel().getDataEntity().getDynamicObjectCollection("costaccounts");
        if (costAccountCol != null) {
            Set costAccIdSet = costAccountCol.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            if (!costAccIdSet.isEmpty()) {
                for (Long id : costAccIdSet) {
                    viewSubitem = viewSubitem && CostaccountHelper.getCostElementByCostAccount((long)id);
                }
            } else {
                viewSubitem = false;
            }
        } else {
            viewSubitem = false;
        }
        if (!viewSubitem) {
            this.getModel().getDataEntity().set("viewsubitem", (Object)false);
        }
        this.getView().setVisible(Boolean.valueOf(viewSubitem), new String[]{"viewsubitem"});
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        super.formatDisplayFilterField(evt);
        String str = evt.getFormatedFilterString();
        boolean viewsubitem = this.getModel().getDataEntity().getBoolean("viewsubitem");
        if (viewsubitem) {
            str = str.concat(ResManager.loadKDString((String)"; \u663e\u793a\u5206\u9879\u6570\u636e\uff1a\u662f", (String)"ProCostBehaviorAnalRptPlugin_10", (String)"macc-aca-report", (Object[])new Object[0]));
        }
        evt.setFormatedFilterString(str);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (propertyName) {
            case "costaccounts": {
                if (newValue == null) {
                    this.getModel().setValue("startperiod", null);
                    this.getModel().setValue("endperiod", null);
                    this.getModel().setValue("currency", null);
                    this.getModel().setValue("costcenter", null);
                    this.getModel().setValue("products", null);
                    this.getModel().setValue("costtype", null);
                }
                if (!(newValue instanceof DynamicObjectCollection)) break;
                DynamicObjectCollection costAccountCol = (DynamicObjectCollection)newValue;
                Set<Long> costAccIdSet = costAccountCol.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                boolean currencyCherck = this.validateCurrencyOfCostAcc(costAccIdSet, oldValue);
                boolean periodTypeCherck = this.validatePeriodTypeOfCostAcc(costAccIdSet, oldValue);
                if (!currencyCherck && !periodTypeCherck) {
                    if (oldValue instanceof DynamicObjectCollection) {
                        Set oldSet = ((DynamicObjectCollection)oldValue).stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                        oldSet.retainAll(costAccIdSet);
                        if (oldSet.size() == 0) {
                            this.getModel().setValue("costcenter", null);
                            this.getModel().setValue("products", null);
                            this.getModel().setValue("costtype", null);
                            if (costAccIdSet.size() > 0) {
                                this.setPeriodValue((Long)costAccIdSet.toArray()[0]);
                            }
                        }
                    }
                } else {
                    this.getModel().setValue("costaccounts", oldValue);
                }
                this.setCurrency();
                this.setViewSubItem();
                break;
            }
            case "endperiod": {
                Long startPeriod = this.getModel().getDataEntity().getDynamicObject("startperiod").getLong("id");
                DynamicObject endPeriodDy = this.getModel().getDataEntity().getDynamicObject("endperiod");
                if (CadEmptyUtils.isEmpty((DynamicObject)endPeriodDy)) {
                    return;
                }
                Long endPeriod = endPeriodDy.getLong("id");
                if (startPeriod <= endPeriod) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u8981\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"ProCostBehaviorAnalRptPlugin_3", (String)"macc-aca-report", (Object[])new Object[0]));
                return;
            }
            case "materialgrpstd": {
                this.getModel().setValue("mulmaterialgroup", null);
                break;
            }
            case "mulmaterialgroup": {
                this.getModel().setValue("products", null);
                break;
            }
        }
    }

    private void setCurrency() {
        DynamicObjectCollection costAccounts = (DynamicObjectCollection)this.getModel().getValue("costaccounts");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccounts)) {
            DynamicObject costAccount = ((DynamicObject)costAccounts.get(0)).getDynamicObject("fbasedataid");
            this.getModel().setValue("currency", (Object)CurrencyHelper.getCurrency((DynamicObject)costAccount));
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        ArrayList pros = Lists.newArrayList((Object[])new String[]{"costaccounts", "startperiod", "endperiod", "materialgrpstd"});
        boolean isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)pros);
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"ProCostBehaviorAnalRptPlugin_4", (String)"macc-aca-report", (Object[])new Object[0]));
            return false;
        }
        Long startPeriod = this.getModel().getDataEntity().getDynamicObject("startperiod").getLong("id");
        Long endPeriod = this.getModel().getDataEntity().getDynamicObject("endperiod").getLong("id");
        if (startPeriod > endPeriod) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u8981\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"ProCostBehaviorAnalRptPlugin_3", (String)"macc-aca-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        DynamicObjectCollection costAccounts = (DynamicObjectCollection)this.getModel().getValue("costaccounts");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccounts)) {
            return;
        }
        Set createOrgIds = costAccounts.stream().map(r -> r.getLong("fbasedataid.calorg.id")).collect(Collectors.toSet());
        if (("exportexcel".equals(operateKey) || "syncexportexcel".equals(operateKey)) && !PermItemCheckHelper.isPerm((String)"aca_procostbehavioranal", (String)"47150e89000000ac", createOrgIds)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u5f15\u51fa\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProCostBehaviorAnalRptPlugin_5", (String)"macc-aca-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void click(EventObject evt) {
        TextEdit textEdit;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit && "calcrecord".equals(key = (textEdit = (TextEdit)source).getKey())) {
            this.showSelectPage(key);
        }
    }

    private void showSelectPage(String actionId) {
        List materialIds;
        DynamicObject costtype = this.getModel().getDataEntity().getDynamicObject("costtype");
        if (costtype == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"ProCostBehaviorAnalRptPlugin_11", (String)"macc-aca-report", (Object[])new Object[0]));
            return;
        }
        ArrayList mulmaterial = Lists.newArrayList();
        DynamicObjectCollection mulMaterial = this.getModel().getDataEntity().getDynamicObjectCollection("products");
        if (mulMaterial != null && mulMaterial.size() > 0 && !CadEmptyUtils.isEmpty(materialIds = mulMaterial.stream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()))) {
            mulmaterial.addAll(materialIds);
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("cad_stdcalcrecord_text");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("costTypeId", costtype.get("id"));
        fsp.setCustomParam("materialIds", (Object)mulmaterial);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (returnDataObj instanceof Map) {
            Map returnData = (Map)returnDataObj;
            String value = String.valueOf(returnData.get("content"));
            String operateType = String.valueOf(returnData.get("operateType"));
            if ("btnok".equals(operateType)) {
                value = value.replaceAll("\n", ",");
                this.getModel().setValue(actionId, (Object)value);
            }
        } else if (returnDataObj instanceof String) {
            String value = (String)returnDataObj;
            this.getModel().setValue(actionId, (Object)value);
        }
    }

    protected QFilter getPeriodFilter(DynamicObjectCollection costAccounts) {
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccounts)) {
            return new QFilter("periodtype", ">", (Object)0L).and(new QFilter("isadjustperiod", "=", (Object)false));
        }
        Set costAccIdSet = costAccounts.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
        QFilter qfCostAccount = new QFilter("entryentity.costaccount", "in", costAccIdSet);
        DynamicObjectCollection stdCost = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.calpolicy.periodtype periodtype, entryentity.startperiod startperiod", (QFilter[])new QFilter[]{qfAppNum, qfCostAccount});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)stdCost)) {
            return new QFilter("periodtype", ">", (Object)0L).and(new QFilter("isadjustperiod", "=", (Object)false));
        }
        Long startperiod = 0L;
        for (DynamicObject obj : stdCost) {
            Long periodId = obj.getLong("startperiod");
            if (startperiod == 0L) {
                startperiod = periodId;
            }
            if (periodId >= startperiod) continue;
            startperiod = periodId;
        }
        return new QFilter("periodtype", "=", (Object)((DynamicObject)stdCost.get(0)).getLong("periodtype")).and(new QFilter("id", ">=", (Object)startperiod)).and(new QFilter("isadjustperiod", "=", (Object)false));
    }

    private void setPeriodValue(Long costAccountId) {
        DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
        this.getModel().setValue("startperiod", (Object)curPeriod);
        this.getModel().setValue("endperiod", (Object)curPeriod);
    }

    private boolean validatePeriodTypeOfCostAcc(Set<Long> costAccIdSet, Object oldValue) {
        Set periodtypeSet;
        QFilter periodfilter = new QFilter("entry.costaccount", "in", costAccIdSet);
        DynamicObjectCollection cal_sysctrlentity = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.costaccount.id acctid,entry.costaccount.name acctname, entry.calpolicy.periodtype periodtype", (QFilter[])periodfilter.toArray());
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)cal_sysctrlentity) && (periodtypeSet = cal_sysctrlentity.stream().map(r -> r.getLong("periodtype")).collect(Collectors.toSet())) != null && periodtypeSet.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u6838\u7b97\u671f\u95f4\u7c7b\u578b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"ProCostBehaviorAnalRptPlugin_6", (String)"macc-aca-report", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean validateCurrencyOfCostAcc(Set<Long> costAccIdSet, Object oldValue) {
        QFilter qFilter = new QFilter("id", "in", costAccIdSet);
        DynamicObjectCollection calpolicyCol = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calpolicy", (QFilter[])new QFilter[]{qFilter});
        Set calpolicySet = calpolicyCol.stream().map(r -> r.getLong("calpolicy")).collect(Collectors.toSet());
        if (CadEmptyUtils.isEmpty(calpolicySet)) {
            return false;
        }
        DynamicObjectCollection currencyCol = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "in", calpolicySet)});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)currencyCol)) {
            return false;
        }
        Set currencySet = currencyCol.stream().map(r -> r.getLong("currency")).collect(Collectors.toSet());
        if (currencySet != null && currencySet.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5e01\u522b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u5e01\u522b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"ProCostBehaviorAnalRptPlugin_7", (String)"macc-aca-report", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        ReportUtils.clearFileNameValue((String[])CLEAR_STR_MAT, (DynamicObjectCollection)rowData, (String[])CLEAR_STR_MAT);
        ReportUtils.clearFileNameValue((String[])CLEAR_STR_ARR, (DynamicObjectCollection)rowData, (String[])CLEAR_STR_ARR);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"ProCostBehaviorAnalRptPlugin_8", (String)"macc-aca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u4ea7\u54c1\u6210\u672c\u6027\u6001\u5206\u6790", (String)"ProCostBehaviorAnalRptPlugin_9", (String)"macc-aca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"aca_procostbehavioranal", (IDataModel)this.getModel());
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        DynamicObject costType = this.getModel().getDataEntity().getDynamicObject("costtype");
        Boolean onlyMaterialType = this.getModel().getDataEntity().getBoolean("onlymaterialtype");
        ArrayList<String> proHideFields = new ArrayList<String>(16);
        if (costType == null) {
            proHideFields.addAll(Arrays.asList(COST_TYPE));
        }
        if (onlyMaterialType.booleanValue()) {
            proHideFields.addAll(Arrays.asList(PUDUCT_FILEDS));
        }
        while (it.hasNext()) {
            ReportColumn reportColumn;
            String key;
            Object obj = it.next();
            if (!(obj instanceof ReportColumn) || !proHideFields.contains(key = (reportColumn = (ReportColumn)obj).getFieldKey())) continue;
            reportColumn.setHide(true);
        }
        this.getView().updateView("reportlistap");
    }
}

