/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.cost;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.aca.algox.utils.CostaccountHelper;
import kd.macc.aca.algox.utils.MaterialGroupHelper;
import kd.macc.aca.common.helper.AcaCostAccountHelper;
import kd.macc.aca.common.helper.MatBaseDataFilterHelper;
import kd.macc.aca.common.helper.PermItemCheckHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ReportUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import org.apache.commons.collections.CollectionUtils;

public class ProPeriodCostCmpAnalRptPlugin
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static String[] CLEAR_STR_MAT = new String[]{"materialgroup"};
    private static String[] CLEAR_PRODUCT_ARR = new String[]{"product", "auxpty", "version", "unit"};
    private static String[] PRO_STR = new String[]{"element", "elementname", "subelement", "subelementname", "material", "materialname", "matmodelnum", "matunit", "submatversion", "subauxpty", "curcomuse", "curprice", "curcomunitcost", "cmpcomuse", "cmpprice", "cmpcomunitcost"};
    private static String[] ELE_STR = new String[]{"material", "materialname", "matmodelnum", "matunit", "submatversion", "subauxpty", "curcomuse", "curprice", "curcomunitcost", "cmpcomuse", "cmpprice", "cmpcomunitcost"};
    private static String[] ONLYMAT_STR = new String[]{"product", "productname", "modelnum", "unit", "auxpty", "version"};
    private static String[] UN_MAT_STR = new String[]{"curcomunitcostview", "cmpcomunitcostview"};

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId());
        BasedataEdit orgInput = (BasedataEdit)this.getControl("org");
        orgInput.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            QFilter qfId = new QFilter("id", "in", (Object)orgIds);
            filterParameter.getQFilters().add(qfId);
        });
        BasedataEdit costcenter = (BasedataEdit)this.getControl("costcenter");
        costcenter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProPeriodCostCmpAnalRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter showOrgDutyFilter = new QFilter("orgduty", "=", (Object)4L);
            QFilter calorgsFilter = new QFilter("accountorg", "=", (Object)org.getLong("id"));
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(showOrgDutyFilter);
            qFilters.add(calorgsFilter);
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProPeriodCostCmpAnalRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            Long acctOrgId = org.getLong("id");
            qFilters.add(StartCostHelper.getEnabledCostAccountIdsFilter((Long)acctOrgId, (String)"aca"));
        });
        BasedataEdit curPeriod = (BasedataEdit)this.getControl("curperiod");
        curPeriod.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProPeriodCostCmpAnalRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"ProPeriodCostCmpAnalRptPlugin_1", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)org.getLong("id"), (Long)costAccountObj.getLong("id")));
        });
        BasedataEdit cmpPeriod = (BasedataEdit)this.getControl("cmpperiod");
        cmpPeriod.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProPeriodCostCmpAnalRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"ProPeriodCostCmpAnalRptPlugin_1", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)org.getLong("id"), (Long)costAccountObj.getLong("id")));
        });
        BasedataEdit products = (BasedataEdit)this.getControl("products");
        products.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProPeriodCostCmpAnalRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            HashSet<Long> orgSet = new HashSet<Long>(16);
            orgSet.add(org.getLong("id"));
            DynamicObject materialgroupstandard = (DynamicObject)this.getModel().getValue("materialgrpstd");
            if (materialgroupstandard == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"ProPeriodCostCmpAnalRptPlugin_2", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObjectCollection mulmaterialgroup = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup");
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(MatBaseDataFilterHelper.getBaseFilter(new ArrayList(orgSet)));
            if (!CollectionUtils.isEmpty((Collection)mulmaterialgroup) || materialgroupstandard.getLong("id") != 730148448254487552L) {
                qFilters.add(MaterialGroupHelper.getClassifiedMaterialIdFilter((DynamicObjectCollection)mulmaterialgroup, (boolean)false, (DynamicObject)materialgroupstandard));
            }
        });
        BasedataEdit materialgrpstd = (BasedataEdit)this.getControl("materialgrpstd");
        materialgrpstd.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProPeriodCostCmpAnalRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(org.getLong("id"));
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, Boolean.TRUE});
            QFilter idFilter = new QFilter("id", "in", (Object)ids);
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(idFilter);
        });
        MulBasedataEdit mulmaterialgroup = (MulBasedataEdit)this.getControl("mulmaterialgroup");
        mulmaterialgroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProPeriodCostCmpAnalRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject materialgrpstdObj = (DynamicObject)this.getModel().getValue("materialgrpstd");
            if (materialgrpstdObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"ProPeriodCostCmpAnalRptPlugin_2", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(org.getLong("id"));
            QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialgrpstdObj.getPkValue(), false});
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(serviceResponse);
            HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>(2);
            params.put("useOrgs", createOrgIds);
            listShowParameter.setCustomParams(params);
            listShowParameter.setCustomParam("groupStandard", materialgrpstdObj.getPkValue());
            listShowParameter.setF7ClickByFilter(false);
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setOrg();
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.setCostAccount();
            this.setPeriodAndCurrency();
        }
        this.setViewSubItem();
    }

    private void setViewSubItem() {
        boolean viewSubitem = false;
        DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccountObj != null) {
            Long costAccountId = costAccountObj.getLong("id");
            viewSubitem = CostaccountHelper.getCostElementByCostAccount((long)costAccountId);
        }
        if (!viewSubitem) {
            this.getModel().getDataEntity().set("viewsubitem", (Object)false);
        }
        this.getView().setVisible(Boolean.valueOf(viewSubitem), new String[]{"viewsubitem"});
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        super.formatDisplayFilterField(evt);
        String str = evt.getFormatedFilterString();
        boolean viewsubitem = this.getModel().getDataEntity().getBoolean("viewsubitem");
        if (viewsubitem) {
            str = str.concat(ResManager.loadKDString((String)"; \u663e\u793a\u5206\u9879\u6570\u636e\uff1a\u662f", (String)"ProPeriodCostCmpAnalRptPlugin_7", (String)"macc-aca-report", (Object[])new Object[0]));
        }
        evt.setFormatedFilterString(str);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "org": {
                this.setOther();
                this.setCostAccount();
                break;
            }
            case "costaccount": {
                this.setPeriodAndCurrency();
                this.setViewSubItem();
                break;
            }
            case "ismaterialdetail": {
                Boolean ismaterialdetail = (Boolean)this.getModel().getValue("ismaterialdetail");
                if (!ismaterialdetail.booleanValue()) break;
                this.getModel().setValue("iselementdetail", (Object)Boolean.TRUE);
                Boolean viewsubitem = (Boolean)this.getModel().getValue("viewsubitem");
                if (!viewsubitem.booleanValue()) break;
                this.getModel().setValue("viewsubitem", (Object)Boolean.FALSE);
                break;
            }
            case "viewsubitem": {
                Boolean viewsubitem1 = (Boolean)this.getModel().getValue("viewsubitem");
                if (!viewsubitem1.booleanValue()) break;
                this.getModel().setValue("iselementdetail", (Object)Boolean.TRUE);
                Boolean ismaterialdetail1 = (Boolean)this.getModel().getValue("ismaterialdetail");
                if (!ismaterialdetail1.booleanValue()) break;
                this.getModel().setValue("ismaterialdetail", (Object)Boolean.FALSE);
                break;
            }
            case "iselementdetail": {
                Boolean iselementdetail = (Boolean)this.getModel().getValue("iselementdetail");
                if (iselementdetail.booleanValue()) break;
                this.getModel().setValue("ismaterialdetail", (Object)Boolean.FALSE);
                this.getModel().setValue("viewsubitem", (Object)Boolean.FALSE);
                break;
            }
            case "materialgrpstd": {
                this.getModel().setValue("mulmaterialgroup", null);
                break;
            }
            case "mulmaterialgroup": {
                this.getModel().setValue("products", null);
                break;
            }
            case "onlymaterialtype": {
                Boolean onlyMaterialType = (Boolean)this.getModel().getValue("onlymaterialtype");
                if (onlyMaterialType.booleanValue()) {
                    this.getModel().setValue("ismaterialdetail", (Object)Boolean.FALSE);
                    this.getView().setEnable(Boolean.FALSE, new String[]{"ismaterialdetail"});
                    break;
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{"ismaterialdetail"});
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        ArrayList pros = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "curperiod", "cmpperiod", "materialgrpstd"});
        boolean isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)pros);
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"ProPeriodCostCmpAnalRptPlugin_3", (String)"macc-aca-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        if (("exportexcel".equals(operateKey) || "syncexportexcel".equals(operateKey)) && !PermItemCheckHelper.isPerm((String)"aca_properiodcostcmpanal", (String)"47150e89000000ac", (Long)org.getLong("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u5f15\u51fa\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProPeriodCostCmpAnalRptPlugin_4", (String)"macc-aca-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    private void setPeriodAndCurrency() {
        DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
        if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
            this.getModel().setValue("curperiod", null);
            this.getModel().setValue("cmpperiod", null);
            this.getModel().setValue("currency", null);
        } else {
            Long costAccountId = costAccountObj.getLong("id");
            DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
            if (curPeriod == null) {
                this.getModel().setValue("curperiod", null);
                this.getModel().setValue("cmpperiod", null);
                this.getModel().setValue("currency", null);
            } else {
                this.getModel().setValue("curperiod", (Object)curPeriod);
                DynamicObject prePeriodId = PeriodHelper.getPreviousPeriod((Object)curPeriod.getPkValue());
                this.getModel().setValue("cmpperiod", (Object)prePeriodId);
                this.getModel().setValue("currency", (Object)CurrencyHelper.getCurrency((DynamicObject)costAccountObj));
            }
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        ReportUtils.clearFileNameValue((String[])CLEAR_STR_MAT, (DynamicObjectCollection)rowData, (String[])CLEAR_STR_MAT);
        ReportUtils.clearFileNameValue((String[])CLEAR_PRODUCT_ARR, (DynamicObjectCollection)rowData, (String[])CLEAR_PRODUCT_ARR);
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        ArrayList<String> proHideFields = new ArrayList<String>(Arrays.asList(PRO_STR));
        ArrayList<String> eleHideFields = new ArrayList<String>(Arrays.asList(ELE_STR));
        ArrayList<String> onlyMatHideFields = new ArrayList<String>(Arrays.asList(ONLYMAT_STR));
        ArrayList<String> unMatHideFields = new ArrayList<String>(Arrays.asList(UN_MAT_STR));
        Boolean isElementDetail = this.getModel().getDataEntity().getBoolean("iselementdetail");
        Boolean isMaterialDetail = this.getModel().getDataEntity().getBoolean("ismaterialdetail");
        Boolean onlyMaterialType = this.getModel().getDataEntity().getBoolean("onlymaterialtype");
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof ReportColumn) {
                ReportColumn reportColumn = (ReportColumn)obj;
                String key = reportColumn.getFieldKey();
                if (isMaterialDetail.booleanValue()) {
                    if (unMatHideFields.contains(key)) {
                        reportColumn.setHide(true);
                    }
                } else if (!isElementDetail.booleanValue()) {
                    if (proHideFields.contains(key)) {
                        reportColumn.setHide(true);
                    }
                } else if (isElementDetail.booleanValue() && !isMaterialDetail.booleanValue() && eleHideFields.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (!onlyMaterialType.booleanValue() || !onlyMatHideFields.contains(key)) continue;
                reportColumn.setHide(true);
                continue;
            }
            if (!(obj instanceof ReportColumnGroup)) continue;
            ReportColumnGroup reportColumnGroup = (ReportColumnGroup)obj;
            List reportColumns = reportColumnGroup.getChildren();
            for (int index = 0; index < reportColumns.size(); ++index) {
                Object column = reportColumns.get(index);
                if (!(column instanceof ReportColumn)) continue;
                ReportColumn col = (ReportColumn)column;
                String key = col.getFieldKey();
                if (!isElementDetail.booleanValue()) {
                    if (!proHideFields.contains(key)) continue;
                    col.setHide(true);
                    continue;
                }
                if (!isElementDetail.booleanValue() || isMaterialDetail.booleanValue() || !eleHideFields.contains(key)) continue;
                col.setHide(true);
            }
        }
        this.getView().updateView("reportlistap");
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"ProPeriodCostCmpAnalRptPlugin_5", (String)"macc-aca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u4ea7\u54c1\u671f\u95f4\u6210\u672c\u5bf9\u6bd4\u5206\u6790", (String)"ProPeriodCostCmpAnalRptPlugin_6", (String)"macc-aca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"aca_properiodcostcmpanal", (IDataModel)this.getModel());
    }

    private void setOther() {
        this.getModel().setValue("costcenter", null);
        this.getModel().setValue("costaccount", null);
        this.getModel().setValue("curperiod", null);
        this.getModel().setValue("cmpperiod", null);
        this.getModel().setValue("products", null);
        this.getModel().setValue("currency", null);
        this.getModel().setValue("mulmaterialgroup", null);
    }

    private void setCostAccount() {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Long mainBookId = AcaCostAccountHelper.getCostAccountByAccoutOrg((Long)((DynamicObject)org).getLong("id"), (String)"aca");
        if (mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
        }
        this.getView().updateView("costaccount");
    }

    private void setOrg() {
        if (this.getModel().getValue("org") == null) {
            Long orgId = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
            if (!isAccounting) {
                return;
            }
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId());
            if (orgIds.contains(orgId)) {
                this.getModel().setValue("org", (Object)orgId);
                this.getView().updateView("org");
            }
        }
    }
}

