/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.cost;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.macc.aca.algox.common.ProPeriodCmpParam;
import kd.macc.aca.algox.report.ProPeriodCostCmpAnalRptAlgoxService;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ProPeriodCostCmpAnalRptQueryPlugin
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam param, Object object) throws Throwable {
        FilterInfo filterInfo = param.getFilter();
        ProPeriodCmpParam proPeriodCmpParam = this.getQueryFilter(filterInfo);
        DataSet dataSetResult = this.getService().getDataSetResult(proPeriodCmpParam);
        long currency = filterInfo.getLong("currency");
        if (!CadEmptyUtils.isEmpty((Long)currency)) {
            dataSetResult = dataSetResult.addField(String.valueOf(currency), "entrycurrency");
        }
        return dataSetResult;
    }

    private ProPeriodCostCmpAnalRptAlgoxService getService() {
        return new ProPeriodCostCmpAnalRptAlgoxService();
    }

    private ProPeriodCmpParam getQueryFilter(FilterInfo filterInfo) {
        DynamicObjectCollection mulMaterialGroup;
        DynamicObjectCollection products;
        ProPeriodCmpParam proPeriodCmpParam = new ProPeriodCmpParam();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        DynamicObject org = filterInfo.getDynamicObject("org");
        qFilters.add(new QFilter("org", "=", (Object)org.getLong("id")));
        DynamicObject costaccount = filterInfo.getDynamicObject("costaccount");
        qFilters.add(new QFilter("costaccount", "=", (Object)costaccount.getLong("id")));
        DynamicObject curPeriodObj = filterInfo.getDynamicObject("curperiod");
        proPeriodCmpParam.setCurPeriod(Long.valueOf(curPeriodObj.getLong("id")));
        DynamicObject cmpPeriodObj = filterInfo.getDynamicObject("cmpperiod");
        proPeriodCmpParam.setCmpPeriod(Long.valueOf(cmpPeriodObj.getLong("id")));
        DynamicObject materialGrpStd = filterInfo.getDynamicObject("materialgrpstd");
        proPeriodCmpParam.setMaterialGrpStd(materialGrpStd);
        DynamicObject costcenter = filterInfo.getDynamicObject("costcenter");
        if (costcenter != null) {
            qFilters.add(new QFilter("costcenter", "in", (Object)costcenter.getLong("id")));
        }
        if ((products = filterInfo.getDynamicObjectCollection("products")) != null) {
            List productIds = products.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            qFilters.add(new QFilter("entryentity.relacostobject.material", "in", productIds));
        }
        if ((mulMaterialGroup = filterInfo.getDynamicObjectCollection("mulmaterialgroup")) != null) {
            proPeriodCmpParam.setMulMaterialGroup(mulMaterialGroup);
        }
        proPeriodCmpParam.setIsElementDetail(Boolean.valueOf(filterInfo.getBoolean("iselementdetail")));
        proPeriodCmpParam.setIsMaterialDetail(Boolean.valueOf(filterInfo.getBoolean("ismaterialdetail")));
        proPeriodCmpParam.setOnlyMaterialType(Boolean.valueOf(filterInfo.getBoolean("onlymaterialtype")));
        proPeriodCmpParam.setViewSubitem(filterInfo.getBoolean("viewsubitem"));
        proPeriodCmpParam.setQueryFilter(qFilters);
        return proPeriodCmpParam;
    }
}

