/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.cost;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.aca.algox.utils.MaterialGroupHelper;
import kd.macc.aca.common.helper.AcaCostAccountHelper;
import kd.macc.aca.common.helper.MatBaseDataFilterHelper;
import kd.macc.aca.common.helper.PermItemCheckHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ReportUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import org.apache.commons.collections.CollectionUtils;

public class ProUnitCostComRptPlugin
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static String[] ALL_HIDE_FIELDS = new String[]{"subelement", "subelementname", "material", "materialname", "modelnum", "modelunit", "convsubmatver", "convsubauxpty"};
    private static String[] SUB_MATERIAL_HIDE_FIELDS = new String[]{"material", "materialname", "modelnum", "modelunit", "convsubmatver", "convsubauxpty"};

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        ReportUtils.clearFileNameValue((String[])new String[]{"elemumber", "elemname"}, (DynamicObjectCollection)rowData, (String[])new String[]{"elemumber", "elemname"});
        ReportUtils.clearFileNameValue((String[])new String[]{"subelement"}, (DynamicObjectCollection)rowData, (String[])new String[]{"subelement"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgInput = (BasedataEdit)this.getControl("org");
        orgInput.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            QFilter qfId = new QFilter("id", "in", (Object)orgIds);
            filterParameter.getQFilters().add(qfId);
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProUnitCostComRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            Long acctOrgId = org.getLong("id");
            qFilters.add(StartCostHelper.getEnabledCostAccountIdsFilter((Long)acctOrgId, (String)this.getView().getFormShowParameter().getAppId()));
        });
        BasedataEdit costcenter = (BasedataEdit)this.getControl("costcenter");
        costcenter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProUnitCostComRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter showOrgDutyFilter = new QFilter("orgduty", "=", (Object)4L);
            QFilter calorgsFilter = new QFilter("accountorg", "=", (Object)org.getLong("id"));
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(showOrgDutyFilter);
            qFilters.add(calorgsFilter);
        });
        BasedataEdit baseperiod = (BasedataEdit)this.getControl("baseperiod");
        baseperiod.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"ProUnitCostComRptPlugin_1", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProUnitCostComRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)org.getLong("id"), (Long)costAccountObj.getLong("id")));
        });
        BasedataEdit cmpPeriod = (BasedataEdit)this.getControl("cmpperiod");
        cmpPeriod.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"ProUnitCostComRptPlugin_1", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)org.getLong("id"), (Long)costAccountObj.getLong("id")));
        });
        BasedataEdit products = (BasedataEdit)this.getControl("products");
        products.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProUnitCostComRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            HashSet<Long> orgSet = new HashSet<Long>(16);
            orgSet.add(org.getLong("id"));
            DynamicObjectCollection mulmaterialgroup = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup");
            DynamicObject materialgroupstandard = (DynamicObject)this.getModel().getValue("materialgrpstd");
            if (materialgroupstandard == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"ProCostBehaviorAnalRptPlugin_2", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(MatBaseDataFilterHelper.getBaseFilter(new ArrayList(orgSet)));
            if (!CollectionUtils.isEmpty((Collection)mulmaterialgroup) || materialgroupstandard.getLong("id") != 730148448254487552L) {
                qFilters.add(MaterialGroupHelper.getClassifiedMaterialIdFilter((DynamicObjectCollection)mulmaterialgroup, (boolean)false, (DynamicObject)materialgroupstandard));
            }
        });
        BasedataEdit materialgrpstd = (BasedataEdit)this.getControl("materialgrpstd");
        materialgrpstd.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProUnitCostComRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(org.getLong("id"));
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, Boolean.TRUE});
            QFilter idFilter = new QFilter("id", "in", (Object)ids);
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(idFilter);
        });
        MulBasedataEdit mulmaterialgroup = (MulBasedataEdit)this.getControl("mulmaterialgroup");
        mulmaterialgroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject materialgrpstdObj = (DynamicObject)this.getModel().getValue("materialgrpstd");
            if (materialgrpstdObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"ProUnitCostComRptPlugin_2", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProUnitCostComRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(org.getLong("id"));
            QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialgrpstdObj.getPkValue(), false});
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(serviceResponse);
            HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>(2);
            params.put("useOrgs", createOrgIds);
            listShowParameter.setCustomParams(params);
            listShowParameter.setCustomParam("groupStandard", materialgrpstdObj.getPkValue());
            listShowParameter.setF7ClickByFilter(false);
        });
        BasedataEdit materialgroup = (BasedataEdit)this.getControl("materialgroup");
        materialgroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject materialgrpstdObj = (DynamicObject)this.getModel().getValue("materialgrpstd");
            if (materialgrpstdObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"ProUnitCostComRptPlugin_2", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProUnitCostComRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(org.getLong("id"));
            QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialgrpstdObj.getPkValue(), false});
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(serviceResponse);
            HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>(2);
            params.put("useOrgs", createOrgIds);
            listShowParameter.setCustomParams(params);
            listShowParameter.setCustomParam("groupStandard", materialgrpstdObj.getPkValue());
            listShowParameter.setF7ClickByFilter(false);
        });
        MulBasedataEdit subelements = (MulBasedataEdit)this.getControl("subelements");
        subelements.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObjectCollection mulelements = this.getModel().getDataEntity().getDynamicObjectCollection("elements");
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulelements)) {
                HashSet elements = new HashSet(16);
                mulelements.forEach(p -> elements.add(p.getLong("fbasedataid.id")));
                DynamicObjectCollection subElments = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement.id subelement", (QFilter[])new QFilter[]{new QFilter("element", "in", elements)});
                elements.clear();
                subElments.forEach(p -> elements.add(p.getLong("subelement")));
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", elements));
            }
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "org": {
                this.setOther();
                this.setCostAccount();
                this.setPeriodAndCurrency();
                break;
            }
            case "costaccount": {
                this.setPeriodAndCurrency();
                break;
            }
            case "materialgrpstd": {
                this.getModel().setValue("mulmaterialgroup", null);
                this.getModel().setValue("materialgroup", null);
                break;
            }
            case "isshowsubelement": {
                boolean isShowSubElement = this.getModel().getDataEntity().getBoolean("isshowsubelement");
                if (!isShowSubElement) {
                    this.getModel().setValue("isshowmaterialdetail", (Object)Boolean.FALSE);
                }
                this.getModel().setValue("subelements", null);
                this.getView().setEnable(Boolean.valueOf(isShowSubElement), new String[]{"subelements"});
                break;
            }
            case "mulmaterialgroup": {
                this.getModel().setValue("products", null);
                break;
            }
            case "isshowmaterialdetail": {
                Boolean isShow = (Boolean)this.getModel().getValue("isshowmaterialdetail");
                if (!isShow.booleanValue()) break;
                this.getModel().setValue("isshowsubelement", (Object)true);
                this.getView().setEnable(isShow, new String[]{"subelements"});
                break;
            }
            case "onlymaterialtype": {
                this.setOnlyMatTypeRelShow();
                this.setMaterilGroupValue();
                break;
            }
        }
    }

    private void setMaterilGroupValue() {
        Boolean onlymaterialtype = (Boolean)this.getModel().getValue("onlymaterialtype");
        if (onlymaterialtype.booleanValue()) {
            DynamicObjectCollection mulmaterialGroup = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup");
            if (mulmaterialGroup != null && mulmaterialGroup.size() == 1) {
                Long materialGroupId = ((DynamicObject)mulmaterialGroup.get(0)).getDynamicObject("fbasedataid").getLong("id");
                this.getModel().setValue("materialgroup", (Object)materialGroupId);
            } else {
                this.getModel().setValue("materialgroup", null);
                this.getModel().setValue("mulmaterialgroup", null);
            }
        } else {
            DynamicObject materialGroup = (DynamicObject)this.getModel().getValue("materialgroup");
            if (materialGroup != null) {
                this.getModel().setValue("mulmaterialgroup", (Object)new Object[]{materialGroup.getLong("id")});
            }
            this.getModel().setValue("materialgroup", null);
        }
    }

    private void setOnlyMatTypeRelShow() {
        Boolean onlymaterialtype = (Boolean)this.getModel().getValue("onlymaterialtype");
        this.getView().setVisible(onlymaterialtype, new String[]{"level"});
        this.getView().setVisible(Boolean.valueOf(onlymaterialtype == false), new String[]{"products"});
        this.getView().setVisible(onlymaterialtype, new String[]{"materialgroup"});
        this.getView().setVisible(Boolean.valueOf(onlymaterialtype == false), new String[]{"mulmaterialgroup"});
        if (onlymaterialtype.booleanValue()) {
            this.getModel().setValue("products", null);
        } else {
            this.getModel().setValue("level", (Object)1);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        if (("exportexcel".equals(operateKey) || "syncexportexcel".equals(operateKey)) && !PermItemCheckHelper.isPerm((String)"aca_prounitcostcomquery", (String)"47150e89000000ac", (Long)org.getLong("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4ea7\u54c1\u5355\u4f4d\u6210\u672c\u5bf9\u6bd4\u8868\uff08\u6a2a\u5411\uff09\u201d\u7684\u201c\u5f15\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProUnitCostComRptPlugin_4", (String)"macc-aca-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    private void setOther() {
        this.getModel().setValue("currency", null);
        this.getModel().setValue("costaccount", null);
        this.getModel().setValue("costcenter", null);
        this.getModel().setValue("baseperiod", null);
        this.getModel().setValue("cmpperiod", null);
        this.getModel().setValue("products", null);
        this.getModel().setValue("level", (Object)1);
        this.getModel().setValue("mulmaterialgroup", null);
        this.getModel().setValue("showcount", (Object)50);
    }

    private void setCostAccount() {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        long mainBookId = AcaCostAccountHelper.getCostAccountByAccoutOrg((Long)((DynamicObject)org).getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
        if (!CadEmptyUtils.isEmpty((Long)mainBookId)) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
        }
        this.getView().updateView("costaccount");
    }

    private void setPeriodAndCurrency() {
        DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
        if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
            this.getModel().setValue("baseperiod", null);
            this.getModel().setValue("cmpperiod", null);
            this.getModel().setValue("currency", null);
        } else {
            Long costAccountId = costAccountObj.getLong("id");
            QFilter qfOrg = new QFilter("org", "=", (Object)this.getModel().getDataEntity().getLong("org.id"));
            QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
            DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
            if (res != null) {
                Long currentPeriod = res.getLong("currentperiod");
                this.getModel().setValue("baseperiod", (Object)new Object[]{currentPeriod});
                this.getModel().setValue("cmpperiod", (Object)new Object[]{currentPeriod});
                this.getView().updateView("baseperiod");
                this.getView().updateView("cmpperiod");
            }
            this.getModel().setValue("currency", (Object)CurrencyHelper.getCurrency((DynamicObject)costAccountObj));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setOrg();
        Object costaccount = this.getModel().getValue("costaccount");
        if (costaccount == null) {
            this.setCostAccount();
            this.setPeriodAndCurrency();
            boolean isShowSubElement = this.getModel().getDataEntity().getBoolean("isshowsubelement");
            this.getView().setEnable(Boolean.valueOf(isShowSubElement), new String[]{"subelements"});
            this.setOnlyMatTypeRelShow();
        }
    }

    private void setOrg() {
        if (this.getModel().getValue("org") == null) {
            Long orgId = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
            if (!isAccounting) {
                return;
            }
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (orgIds.contains(orgId)) {
                this.getModel().setValue("org", (Object)orgId);
                this.getView().updateView("org");
                Long mainBookId = OrgHelper.getCostAccountByAccoutOrg((Long)orgId);
                if (mainBookId != 0L) {
                    this.getModel().setValue("costaccount", (Object)mainBookId);
                    this.getView().updateView("costaccount");
                }
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        ArrayList pros = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "baseperiod", "cmpperiod", "materialgrpstd"});
        boolean isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)pros);
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"ProUnitCostComRptPlugin_5", (String)"macc-aca-report", (Object[])new Object[0]));
            return false;
        }
        Boolean onlymaterialtype = (Boolean)this.getModel().getValue("onlymaterialtype");
        int showCount = (Integer)this.getModel().getValue("showcount");
        if (!onlymaterialtype.booleanValue()) {
            DynamicObjectCollection products = this.getModel().getDataEntity().getDynamicObjectCollection("products");
            HashSet<Long> productIds = new HashSet<Long>();
            for (DynamicObject product : products) {
                productIds.add(product.getDynamicObject("fbasedataid").getLong("id"));
            }
            if (showCount > 0 && productIds.size() > showCount) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea7\u54c1\u9009\u62e9\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u5c55\u793a\u6570\u91cf\u3002", (String)"ProUnitCostComRptPlugin_6", (String)"macc-aca-report", (Object[])new Object[0]));
                return false;
            }
        } else {
            Integer level = (Integer)this.getModel().getValue("level");
            if (level <= 0 || level > 20) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7c7b\u7ea7\u6b21\u8d85\u51fa\u6570\u503c\u8303\u56f4\uff1a0<\u7ea7\u6b21\u226420\u3002", (String)"ProUnitCostComRptPlugin_9", (String)"macc-aca-report", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"ProUnitCostComRptPlugin_7", (String)"macc-aca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u4ea7\u54c1\u5355\u4f4d\u6210\u672c\u5bf9\u6bd4\u8868\uff08\u6a2a\u5411\uff09", (String)"ProUnitCostComRptPlugin_10", (String)"macc-aca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"aca_prounitcostcomquery", (IDataModel)this.getModel());
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        boolean isShowSubElement = this.getModel().getDataEntity().getBoolean("isshowsubelement");
        boolean isShowMaterialDetail = this.getModel().getDataEntity().getBoolean("isshowmaterialdetail");
        ArrayList<String> proHideFields = new ArrayList<String>(10);
        if (!isShowSubElement && !isShowMaterialDetail) {
            proHideFields.addAll(Arrays.asList(ALL_HIDE_FIELDS));
        }
        if (isShowSubElement && !isShowMaterialDetail) {
            proHideFields.addAll(Arrays.asList(SUB_MATERIAL_HIDE_FIELDS));
        }
        if (proHideFields.size() > 0) {
            while (it.hasNext()) {
                ReportColumn reportColumn;
                String key;
                Object obj = it.next();
                if (!(obj instanceof ReportColumn) || !proHideFields.contains(key = (reportColumn = (ReportColumn)obj).getFieldKey())) continue;
                reportColumn.setHide(true);
            }
        }
        this.getView().updateView("reportlistap");
    }
}

