/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.cost;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CalcRptHelper;

public class SellOrderCostRptQuery
extends AbstractReportListDataPlugin {
    private static final String SALE_ORDER_PRO = "id AS saleid,org AS saleorg,billno AS salebillno,billentry.seq AS rowseq,billentry.configuredcode AS configuredcode,billentry.tracknumber AS tracknumber,billentry.materialmasterid as salemat,billentry.material AS hiddenmaterial,billentry.auxpty AS auxpty,billentry.unit AS unit,billentry.qty as qty,billentry.baseunit AS baseunit,billentry.baseqty AS baseqty,0 AS ordercost";
    private static final String PRO_ORDER_PRO = "org AS manuorg,billno AS probillno,treeentryentity.id AS probillid,treeentryentity.seq As prorowseq,treeentryentity.configuredcode AS configcode,treeentryentity.tracknumber AS tracknum,treeentryentity.taskstatus AS bizstatus,treeentryentity.material hiddenpromat,treeentryentity.material.masterid AS promat,treeentryentity.auxproperty AS proauxpty,treeentryentity.unit as probaseunit,treeentryentity.baseqty AS probaseqty,treeentryentity.beginbookdate AS transmittime,treeentryentity.endworktime AS endworktime";
    private List<String> proShowPros = Lists.newArrayList((Object[])new String[]{"manuorg", "probillno", "probillid", "prorowseq", "configcode", "tracknum", "bizstatus", "hiddenpromat", "promat", "proauxpty", "probaseunit", "probaseqty", "transmittime", "endworktime"});
    private List<String> saleShowPros = Lists.newArrayList((Object[])new String[]{"saleid", "saleorg", "salebillno", "rowseq", "configuredcode", "tracknumber", "salemat", "hiddenmaterial", "auxpty", "unit", "qty", "baseunit", "baseqty"});

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        ArrayList proShowProperties = Lists.newArrayList();
        String algoKey = ((Object)((Object)this)).getClass().getName() + ".query";
        DataSet saleDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sm_salorder", (String)SALE_ORDER_PRO, (QFilter[])new QFilter[]{this.getSaleQFilter(reportQueryParam)}, (String)"bizdate desc");
        DataSet proFinialDs = null;
        if (!this.showOrderCost(reportQueryParam).booleanValue()) {
            proShowProperties.add("ordercost");
            String showCostSql = "costobject.configuredcode AS configcode,costobject.tracknumber AS tracknum,costobject.material AS promat,entryentity.pdcurrqty AS inputqty,entryentity.pdcurramount AS inputamt,entryentity.currcomqty AS finishqty,entryentity.currcomamount AS finishAmt";
            DataSet costDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"aca_calcresult", (String)showCostSql, (QFilter[])new QFilter[]{this.getCostQFilter(reportQueryParam), new QFilter("entryentity.type", "=", (Object)"finalResult")}, (String)"");
            proFinialDs = costDataSet.groupBy(new String[]{"promat", "configcode", "tracknum"}).sum("finishamt", "ordercost").finish();
            return saleDataSet.leftJoin(proFinialDs).on("salemat", "promat").on("tracknumber", "tracknum").select(this.saleShowPros.toArray(new String[0]), proShowProperties.toArray(new String[0])).finish().orderBy(new String[]{"saleid desc"});
        }
        DataSet proDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pom_mftorder", (String)PRO_ORDER_PRO, (QFilter[])new QFilter[]{this.getProQFilter(reportQueryParam)}, (String)"");
        if (!this.showSubelement(reportQueryParam).booleanValue() && !this.showMaterialDetail(reportQueryParam).booleanValue()) {
            String showCostSql = "costobject.probill AS probillno,costobject.configuredcode AS configcode,costobject.tracknumber AS tracknumber,costobject.material AS material,entryentity.pdcurrqty AS inputqty,entryentity.pdcurramount AS inputamt,entryentity.currcomqty AS finishqty,entryentity.currcomamount AS finishAmt,entryentity.pdendqty AS pdendqty,entryentity.pdendamount AS pdendamount,entryentity.endadjqty AS endadjqty,entryentity.endadjamt AS endadjamt,period";
            DataSet costDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"aca_calcresult", (String)showCostSql, (QFilter[])new QFilter[]{this.getCostQFilter(reportQueryParam), new QFilter("entryentity.type", "=", (Object)"finalResult")}, (String)"");
            DataSet costCopyDs = costDataSet.copy();
            DataSet costSumDataSet = costCopyDs.groupBy(new String[]{"probillno", "material", "configcode", "tracknumber"}).sum("inputqty").sum("inputamt").sum("finishqty").sum("finishamt").finish();
            DataSet orderCostDataSet = costCopyDs.groupBy(new String[]{"material", "tracknumber"}).sum("finishamt", "ordercost").finish();
            DataSet finalMaxPeriodDataSet = costCopyDs.copy().groupBy(new String[]{"probillno", "material", "configcode", "tracknumber"}).maxP("period", "pdendqty+endadjqty", "pdendqty").maxP("period", "pdendamount+endadjamt", "pdendamount").finish().select(new String[]{"probillno", "material", "configcode", "tracknumber", "pdendqty", "pdendamount"});
            DataSet proCostSumDs = proDataSet.leftJoin(costSumDataSet).on("tracknum", "tracknumber").on("probillid", "probillno").select(this.proShowPros.toArray(new String[0]), new String[]{"inputqty", "inputamt", "finishqty", "finishamt"}).finish();
            this.proShowPros.addAll(Lists.newArrayList((Object[])new String[]{"inputqty", "inputamt", "finishqty", "finishamt"}));
            saleDataSet = saleDataSet.leftJoin(orderCostDataSet).on("salemat", "material").on("tracknumber", "tracknumber").select(this.saleShowPros.toArray(new String[0]), new String[]{"ordercost"}).finish();
            this.saleShowPros.add("ordercost");
            proFinialDs = proCostSumDs.leftJoin(finalMaxPeriodDataSet).on("probillid", "probillno").on("promat", "material").on("tracknum", "tracknumber").on("configcode", "configcode").select(this.proShowPros.toArray(new String[0]), new String[]{"pdendqty", "pdendamount"}).finish();
            this.proShowPros.addAll(Lists.newArrayList((Object[])new String[]{"pdendqty", "pdendamount"}));
            proShowProperties.addAll(this.proShowPros);
        } else if (this.showSubelement(reportQueryParam).booleanValue() && !this.showMaterialDetail(reportQueryParam).booleanValue()) {
            String showCostSql = "costobject.probill AS probillno,costobject.configuredcode AS configcode,costobject.tracknumber AS tracknumber,costobject.material AS material,entryentity.element AS element,entryentity.subelement AS subelement,entryentity.submaterial AS submat,entryentity.pdcurrqty AS inputqty,entryentity.pdcurramount AS inputamt,entryentity.currcomqty AS finishqty,entryentity.currcomamount AS finishAmt,entryentity.pdendqty as pdendqty,entryentity.pdendamount pdendamount,entryentity.endadjqty AS endadjqty,entryentity.endadjamt AS endadjamt,period,entryentity.type AS type";
            DataSet costDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"aca_calcresult", (String)showCostSql, (QFilter[])new QFilter[]{this.getCostQFilter(reportQueryParam)}, (String)"");
            DataSet costCopyDs = costDataSet.copy();
            DataSet costSumDataSet = costCopyDs.groupBy(new String[]{"probillno", "material", "configcode", "tracknumber", "subelement", "element"}).sum("inputqty").sum("inputamt").sum("finishqty").sum("finishamt").finish();
            DataSet orderCostDataSet = costCopyDs.filter("type='finalResult'").groupBy(new String[]{"material", "tracknumber"}).sum("finishamt", "ordercost").finish();
            saleDataSet = saleDataSet.leftJoin(orderCostDataSet).on("salemat", "material").on("tracknumber", "tracknumber").select(this.saleShowPros.toArray(new String[0]), new String[]{"ordercost"}).finish();
            this.saleShowPros.add("ordercost");
            DataSet finalMaxPeriodDataSet = costCopyDs.groupBy(new String[]{"probillno", "material", "configcode", "tracknumber", "subelement", "submat"}).maxP("period", "pdendqty+endadjqty", "pdendqty").maxP("period", "pdendamount+endadjamt", "pdendamount").finish().select(new String[]{"probillno", "material", "tracknumber", "configcode", "subelement", "submat", "pdendqty", "pdendamount"});
            finalMaxPeriodDataSet = finalMaxPeriodDataSet.groupBy(new String[]{"probillno", "material", "configcode", "tracknumber", "subelement"}).sum("pdendqty").sum("pdendamount").finish();
            DataSet proCostSumDs = proDataSet.leftJoin(costSumDataSet).on("tracknum", "tracknumber").on("probillid", "probillno").select(this.proShowPros.toArray(new String[0]), new String[]{"subelement", "element", "inputqty", "inputamt", "finishqty", "finishamt"}).finish();
            this.proShowPros.addAll(Lists.newArrayList((Object[])new String[]{"subelement", "element", "inputqty", "inputamt", "finishqty", "finishamt"}));
            proFinialDs = proCostSumDs.leftJoin(finalMaxPeriodDataSet).on("probillid", "probillno").on("promat", "material").on("configcode", "configcode").on("tracknum", "tracknumber").on("subelement", "subelement").select(this.proShowPros.toArray(new String[0]), new String[]{"pdendqty", "pdendamount"}).finish();
            this.proShowPros.addAll(Lists.newArrayList((Object[])new String[]{"pdendqty", "pdendamount"}));
            proShowProperties.addAll(this.proShowPros);
        } else if (this.showMaterialDetail(reportQueryParam).booleanValue()) {
            String showCostSql = "costobject.probill AS probillno,costobject.configuredcode AS configcode,costobject.tracknumber AS tracknumber,costobject.material AS material,entryentity.element AS element,entryentity.subelement AS subelement,entryentity.submaterial AS submat,entryentity.subauxpty AS submatauxpty,entryentity.pdcurrqty AS inputqty,entryentity.pdcurramount AS inputamt,entryentity.currcomqty AS finishqty,entryentity.currcomamount AS finishAmt,entryentity.pdendqty as pdendqty,entryentity.pdendamount pdendamount,entryentity.endadjqty AS endadjqty,entryentity.endadjamt AS endadjamt,period,entryentity.type AS type";
            DataSet costDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"aca_calcresult", (String)showCostSql, (QFilter[])new QFilter[]{this.getCostQFilter(reportQueryParam)}, (String)"");
            DataSet costCopyDs = costDataSet.copy();
            DataSet costSumDataSet = costCopyDs.groupBy(new String[]{"probillno", "material", "configcode", "tracknumber", "subelement", "element", "submat", "submatauxpty"}).sum("inputqty").sum("inputamt").sum("finishqty").sum("finishamt").finish();
            DataSet orderCostDataSet = costCopyDs.filter("type='finalResult'").groupBy(new String[]{"material", "tracknumber"}).sum("finishamt", "ordercost").finish();
            saleDataSet = saleDataSet.leftJoin(orderCostDataSet).on("salemat", "material").on("tracknumber", "tracknumber").select(this.saleShowPros.toArray(new String[0]), new String[]{"ordercost"}).finish();
            this.saleShowPros.add("ordercost");
            DataSet finalMaxPeriodDataSet = costCopyDs.groupBy(new String[]{"probillno", "material", "configcode", "tracknumber", "subelement", "element", "submat"}).maxP("period", "pdendqty+endadjqty", "pdendqty").maxP("period", "pdendamount+endadjamt", "pdendamount").finish().select(new String[]{"probillno", "material", "tracknumber", "subelement", "element", "submat", "configcode", "pdendqty", "pdendamount"});
            DataSet proCostSumDs = proDataSet.leftJoin(costSumDataSet).on("tracknum", "tracknumber").on("probillid", "probillno").select(this.proShowPros.toArray(new String[0]), new String[]{"subelement", "element", "submat", "submatauxpty", "inputqty", "inputamt", "finishqty", "finishamt"}).finish();
            this.proShowPros.addAll(Lists.newArrayList((Object[])new String[]{"subelement", "element", "submat", "submatauxpty", "inputqty", "inputamt", "finishqty", "finishamt"}));
            proFinialDs = proCostSumDs.leftJoin(finalMaxPeriodDataSet).on("probillid", "probillno").on("promat", "material").on("tracknum", "tracknumber").on("configcode", "configcode").on("subelement", "subelement").on("element", "element").on("submat", "submat").select(this.proShowPros.toArray(new String[0]), new String[]{"pdendqty", "pdendamount"}).finish();
            this.proShowPros.addAll(Lists.newArrayList((Object[])new String[]{"pdendqty", "pdendamount"}));
            proShowProperties.addAll(this.proShowPros);
        }
        return saleDataSet.leftJoin(proFinialDs).on("tracknumber", "tracknum").select(this.saleShowPros.toArray(new String[0]), proShowProperties.toArray(new String[0])).finish().orderBy(new String[]{"saleid desc"});
    }

    private Boolean showOrderCost(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        return (Boolean)CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"showordercost");
    }

    private Boolean showSubelement(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        return (Boolean)CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"showsubelement");
    }

    private Boolean showMaterialDetail(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        return (Boolean)CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"showmaterialdetail");
    }

    private QFilter getCostQFilter(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        Object val = null;
        val = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"org");
        QFilter qFilter = new QFilter("org", "=", val);
        val = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"costaccount");
        qFilter.and("costaccount", "=", val);
        val = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"ftracknumber");
        qFilter.and("costobject.tracknumber", "in", val);
        return qFilter;
    }

    private QFilter getSaleQFilter(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        Object val = null;
        val = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"fsaleorg");
        QFilter qFilter = new QFilter("billentry.salesorg", "=", val);
        val = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"fsalebillno");
        if (val != null) {
            qFilter.and("id", "in", val);
        }
        if ((val = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"fsalemat")) != null) {
            qFilter.and("billentry.materialmasterid", "in", val);
        }
        if ((val = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"ftracknumber")) != null) {
            qFilter.and("billentry.tracknumber", "in", val);
        }
        if ((val = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"salestartdate")) != null) {
            qFilter.and("bizdate", ">=", val);
        }
        if ((val = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"saleenddate")) != null) {
            Date saleEndDate = (Date)val;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(saleEndDate);
            calendar.add(5, 1);
            saleEndDate = calendar.getTime();
            qFilter.and("bizdate", "<", (Object)saleEndDate);
        }
        qFilter.and("billstatus", "=", (Object)"C");
        return qFilter;
    }

    private QFilter getProQFilter(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        Object val = null;
        val = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"ftracknumber");
        QFilter qFilter = new QFilter("treeentryentity.tracknumber", "in", val);
        val = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"fprobillno");
        if (val != null) {
            qFilter.and("treeentryentity.id", "in", val);
        }
        if ((val = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"fmaterial")) != null) {
            qFilter.and("treeentryentity.material.masterid", "in", val);
        }
        if ((val = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"prostartdate")) != null) {
            qFilter.and("treeentryentity.beginbookdate", ">=", val);
        }
        if ((val = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"proenddate")) != null) {
            Date proEndDate = (Date)val;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(proEndDate);
            calendar.add(5, 1);
            proEndDate = calendar.getTime();
            qFilter.and("treeentryentity.beginbookdate", "<", (Object)proEndDate);
        }
        if ((val = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"fmanuorg")) != null) {
            qFilter.and("org", "in", val);
        }
        qFilter.and("treeentryentity.taskstatus", "!=", (Object)"A");
        return qFilter;
    }
}

