/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.costsum;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.Tuple;
import kd.macc.aca.report.costsum.CostSumParam;
import kd.macc.aca.report.costsum.CostSunAddColParam;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostSumCalDataFunction
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private Map<String, CostSunAddColParam> paramMap;
    private CostSumParam costSumParam;
    private static final String DYNAMIC_PREFIX = "range";

    public CostSumCalDataFunction(RowMeta rowMeta, Map<String, CostSunAddColParam> paramMap, CostSumParam costSumParam) {
        this.rowMeta = rowMeta;
        this.paramMap = paramMap;
        this.costSumParam = costSumParam;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        Iterator<RowX> it = rows.iterator();
        ArrayList targetRows = Lists.newArrayList();
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalQty = BigDecimal.ZERO;
        String qtyFileName = this.costSumParam.getQtyFileName();
        String amountFileName = this.costSumParam.getAmountFileName();
        HashMap<String, Tuple> colNumDataMap = new HashMap<String, Tuple>();
        StringBuilder keyBuilder = new StringBuilder();
        while (it.hasNext()) {
            RowX row = it.next();
            long subElementId = row.getLong(this.rowMeta.getFieldIndex("subelement"));
            long submaterial = row.getLong(this.rowMeta.getFieldIndex("submaterial"));
            BigDecimal calAmount = row.getBigDecimal(this.rowMeta.getFieldIndex(amountFileName));
            BigDecimal calQty = row.getBigDecimal(this.rowMeta.getFieldIndex(qtyFileName));
            if (calAmount == null) {
                calAmount = BigDecimal.ZERO;
            }
            if (calQty == null) {
                calQty = BigDecimal.ZERO;
            }
            if (targetRows.size() < 1) {
                targetRows.add(row);
            }
            if ("finalResult".equals(row.getString(this.rowMeta.getFieldIndex("type")))) {
                totalQty = totalQty.add(calQty);
                continue;
            }
            if (CadEmptyUtils.isEmpty((Long)subElementId) && CadEmptyUtils.isEmpty((Long)submaterial)) continue;
            String colKey = keyBuilder.append(DYNAMIC_PREFIX).append(subElementId).append(submaterial).toString();
            keyBuilder.setLength(0);
            totalAmount = totalAmount.add(calAmount);
            Tuple qtyAmountTuple = (Tuple)colNumDataMap.get(colKey);
            if (qtyAmountTuple != null) {
                BigDecimal item1 = (BigDecimal)qtyAmountTuple.item1;
                BigDecimal item2 = (BigDecimal)qtyAmountTuple.item2;
                calQty = calQty.add(item1);
                calAmount = calAmount.add(item2);
            }
            colNumDataMap.put(colKey, new Tuple((Object)calQty, (Object)calAmount));
        }
        for (RowX row : targetRows) {
            BigDecimal otherAmount = BigDecimal.ZERO;
            for (Map.Entry entrySet : colNumDataMap.entrySet()) {
                String colKey = (String)entrySet.getKey();
                Tuple value = (Tuple)entrySet.getValue();
                BigDecimal amount = (BigDecimal)value.item2;
                if (this.isEmpty(amount) && this.isEmpty((BigDecimal)value.item1)) continue;
                CostSunAddColParam costSunAddColParam = this.paramMap.get(colKey);
                if (costSunAddColParam == null) {
                    otherAmount = otherAmount.add(amount);
                    continue;
                }
                row.set(this.rowMeta.getFieldIndex(colKey + "amount"), (Object)amount);
                if (!costSunAddColParam.getShowQty().booleanValue()) continue;
                row.set(this.rowMeta.getFieldIndex(colKey + "qty"), value.item1);
            }
            if (!this.isEmpty(otherAmount)) {
                row.set(this.rowMeta.getFieldIndex("rangeotheramount"), (Object)otherAmount);
            }
            row.set(this.rowMeta.getFieldIndex("baseqty"), (Object)totalQty);
            row.set(this.rowMeta.getFieldIndex("amount"), (Object)totalAmount);
            if (totalQty != null && BigDecimal.ZERO.compareTo(totalQty) != 0) {
                row.set(this.rowMeta.getFieldIndex("price"), (Object)totalAmount.divide(totalQty, 23, 4));
            }
            collector.collect(row);
        }
    }

    private boolean isEmpty(BigDecimal object) {
        return object == null || object.doubleValue() == 0.0 || "0E-10".equals(object.toString());
    }
}

