/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.costsum;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.aca.algox.utils.MaterialGroupHelper;
import kd.macc.aca.common.helper.AcaCostAccountHelper;
import kd.macc.aca.common.helper.MatBaseDataFilterHelper;
import kd.macc.aca.report.costsum.CostSumParam;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import org.apache.commons.collections.CollectionUtils;

public class CostSumRptPlugin
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        filterGrid.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String fieldName = beforeF7SelectEvent.getFieldName();
            List qFilters = beforeF7SelectEvent.getQfilters();
            Object org = this.getModel().getValue("org");
            if (fieldName.startsWith("costcenter")) {
                QFilter showOrgDutyFilter = new QFilter("orgduty", "=", (Object)4L);
                if (org != null) {
                    QFilter calorgsFilter = new QFilter("accountorg", "=", (Object)((DynamicObject)org).getLong("id"));
                    qFilters.add(calorgsFilter);
                } else {
                    List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                    QFilter calorgsFilter = new QFilter("accountorg", "in", (Object)orgIds);
                    qFilters.add(calorgsFilter);
                }
                qFilters.add(showOrgDutyFilter);
            } else if (fieldName.startsWith("costobject")) {
                if (org != null) {
                    QFilter calorgsFilter = new QFilter("org", "=", (Object)((DynamicObject)org).getLong("id"));
                    qFilters.add(calorgsFilter);
                } else {
                    List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                    QFilter calorgsFilter = new QFilter("org", "in", (Object)orgIds);
                    qFilters.add(calorgsFilter);
                }
            }
        });
        BasedataEdit orgInput = (BasedataEdit)this.getControl("org");
        orgInput.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            QFilter qfId = new QFilter("id", "in", (Object)orgIds);
            filterParameter.getQFilters().add(qfId);
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostSumRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            Long acctOrgId = org.getLong("id");
            qFilters.add(StartCostHelper.getEnabledCostAccountIdsFilter((Long)acctOrgId, (String)"aca"));
        });
        BasedataEdit costcenter = (BasedataEdit)this.getControl("mulcostcenter");
        costcenter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostSumRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter showOrgDutyFilter = new QFilter("orgduty", "=", (Object)4L);
            QFilter calorgsFilter = new QFilter("accountorg", "=", (Object)org.getLong("id"));
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(showOrgDutyFilter);
            qFilters.add(calorgsFilter);
        });
        BasedataEdit mulcostobject = (BasedataEdit)this.getControl("mulcostobject");
        mulcostobject.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            DynamicObjectCollection costcenterDy = this.getModel().getDataEntity().getDynamicObjectCollection("mulcostcenter");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostSumRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            QFilter calorgsFilter = new QFilter("org", "=", (Object)org.getLong("id"));
            qFilters.add(calorgsFilter);
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costcenterDy)) {
                List collect = costcenterDy.stream().map(costObject -> costObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                qFilters.add(new QFilter("costcenter", "in", collect));
            }
        });
        BasedataEdit startPeriod = (BasedataEdit)this.getControl("startperiod");
        startPeriod.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costAccountDy = (DynamicObject)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccountDy)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostSumRptPlugin_1", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter periodFilter = this.getPeriodFilter(costAccountDy);
            DynamicObject enablePeriod = PeriodHelper.getStartPeriod((Long)costAccountDy.getLong("id"));
            if (periodFilter != null) {
                if (enablePeriod != null) {
                    periodFilter.and(new QFilter("id", ">=", (Object)enablePeriod.getLong("id")));
                }
                ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
                List qFilters = listFilterParameter.getQFilters();
                qFilters.add(periodFilter);
            }
        });
        BasedataEdit endPeriod = (BasedataEdit)this.getControl("endperiod");
        endPeriod.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject startPer = (DynamicObject)this.getModel().getValue("startPeriod");
            if (CadEmptyUtils.isEmpty((DynamicObject)startPer)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f00\u59cb\u671f\u95f4\u3002", (String)"CostSumRptPlugin_2", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject costAccountDy = (DynamicObject)this.getModel().getValue("costaccount");
            QFilter periodFilter = this.getPeriodFilter(costAccountDy);
            if (periodFilter != null) {
                periodFilter.and(new QFilter("id", ">=", startPer.get("id")));
                ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
                List qFilters = listFilterParameter.getQFilters();
                qFilters.add(periodFilter);
            }
        });
        BasedataEdit materialgrpstd = (BasedataEdit)this.getControl("materialgrpstd");
        materialgrpstd.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostSumRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(org.getLong("id"));
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, Boolean.TRUE});
            QFilter idFilter = new QFilter("id", "in", (Object)ids);
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(idFilter);
        });
        MulBasedataEdit mulmaterialgroup = (MulBasedataEdit)this.getControl("mulmaterialgroup");
        mulmaterialgroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject materialgrpstdObj = (DynamicObject)this.getModel().getValue("materialgrpstd");
            if (materialgrpstdObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"CostSumRptPlugin_3", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostSumRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(org.getLong("id"));
            QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialgrpstdObj.getPkValue(), false});
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(serviceResponse);
            HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>(2);
            params.put("useOrgs", createOrgIds);
            listShowParameter.setCustomParams(params);
            listShowParameter.setCustomParam("groupStandard", materialgrpstdObj.getPkValue());
            listShowParameter.setF7ClickByFilter(false);
        });
        BasedataEdit mulmaterial = (BasedataEdit)this.getControl("mulmaterial");
        mulmaterial.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostSumRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            HashSet<Long> orgSet = new HashSet<Long>(16);
            orgSet.add(org.getLong("id"));
            DynamicObjectCollection mulmaterialGroup = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup");
            DynamicObject materialGroupStandard = (DynamicObject)this.getModel().getValue("materialgrpstd");
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(MatBaseDataFilterHelper.getBaseFilter(new ArrayList(orgSet)));
            if (!CollectionUtils.isEmpty((Collection)mulmaterialGroup) || materialGroupStandard.getLong("id") != 730148448254487552L) {
                qFilters.add(MaterialGroupHelper.getClassifiedMaterialIdFilter((DynamicObjectCollection)mulmaterialGroup, (boolean)false, (DynamicObject)materialGroupStandard));
            }
        });
        BasedataEdit submaterialf = (BasedataEdit)this.getControl("submaterialf");
        submaterialf.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostSumRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Long orgId = org.getLong("id");
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(MatBaseDataFilterHelper.getBaseFilter(Collections.singletonList(orgId)));
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.resetFilterGrid();
    }

    private void resetFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        String fieldName = null;
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if (!this.filterGrid(fieldName)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private boolean filterGrid(String fieldName) {
        String[] split = fieldName.split("\\.");
        HashSet<String> showPros = new HashSet<String>(16);
        showPros.add("costcenter");
        showPros.add("costobject");
        showPros.add("material");
        showPros.add("matversion");
        showPros.add("auxpty");
        return showPros.contains(split[0]);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        if (("exportexcel".equals(operateKey) || "syncexportexcel".equals(operateKey)) && !this.permItemCheck("aca_costsumquerynew", "47150e89000000ac", "aca", org.getLong("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6210\u672c\u8ba1\u7b97\u5355\uff08\u6a2a\u8868\uff09\u201d\u7684\u201c\u5f15\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostSumRptPlugin_4", (String)"macc-aca-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public boolean permItemCheck(String entityName, String permItemKey, String appId, Long orgId) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityName, (String)permItemKey);
        if (rs.hasAllOrgPerm()) {
            return true;
        }
        return rs.getHasPermOrgs().contains(orgId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "org": {
                this.setOther();
                this.setCostAccount();
                break;
            }
            case "costaccount": {
                this.setPeriodAndCurrency();
                break;
            }
            case "startperiod": {
                DynamicObject startPeriodDy = this.getModel().getDataEntity().getDynamicObject("startperiod");
                DynamicObject endPeriodDy = this.getModel().getDataEntity().getDynamicObject("endperiod");
                if (startPeriodDy == null || endPeriodDy == null) {
                    return;
                }
                if (PeriodHelper.compare2period((DynamicObject)startPeriodDy, (DynamicObject)endPeriodDy) <= 0) break;
                this.getModel().setValue("endperiod", (Object)startPeriodDy);
                break;
            }
            case "endperiod": {
                DynamicObject startPeriod = this.getModel().getDataEntity().getDynamicObject("startperiod");
                DynamicObject endPeriod = this.getModel().getDataEntity().getDynamicObject("endperiod");
                if (startPeriod == null || endPeriod == null) {
                    return;
                }
                if (PeriodHelper.compare2period((DynamicObject)startPeriod, (DynamicObject)endPeriod) <= 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u8981\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"CostSumRptPlugin_5", (String)"macc-aca-report", (Object[])new Object[0]));
                return;
            }
            case "materialgrpstd": {
                this.getModel().setValue("mulmaterialgroup", null);
                break;
            }
            case "mulmaterialgroup": {
                this.getModel().setValue("mulmaterial", null);
                break;
            }
        }
    }

    private void setOther() {
        this.getModel().setValue("mulcostcenter", null);
        this.getModel().setValue("costaccount", null);
        this.getModel().setValue("startperiod", null);
        this.getModel().setValue("endperiod", null);
        this.getModel().setValue("mulmaterial", null);
        this.getModel().setValue("currency", null);
        this.getModel().setValue("mulmaterialgroup", null);
        this.getModel().setValue("mulcostobject", null);
    }

    private void setPeriodAndCurrency() {
        DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
        if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            this.getModel().setValue("currency", null);
        } else {
            Long costAccountId = costAccountObj.getLong("id");
            DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
            this.getModel().setValue("startperiod", (Object)curPeriod);
            this.getModel().setValue("endperiod", (Object)curPeriod);
            this.getModel().setValue("currency", (Object)CurrencyHelper.getCurrency((DynamicObject)costAccountObj));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String openParamStr = (String)fsp.getCustomParam("custparam");
        if (CadEmptyUtils.isEmpty((String)openParamStr)) {
            this.setOrg();
            Object costaccount = this.getModel().getValue("costaccount");
            if (costaccount == null) {
                this.setCostAccount();
                this.setPeriodAndCurrency();
            }
        } else {
            Object costAccount;
            JSONObject calcParamJs = JSON.parseObject((String)openParamStr);
            Object org = calcParamJs.get((Object)"orgId");
            if (org != null) {
                this.getModel().setValue("org", org);
            }
            if ((costAccount = calcParamJs.get((Object)"costAccountId")) != null) {
                this.getModel().setValue("costaccount", costAccount);
            }
            this.setPeriodAndCurrency();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String openParamStr = (String)fsp.getCustomParam("custparam");
        if (!CadEmptyUtils.isEmpty((String)openParamStr)) {
            ReportFilter filter = (ReportFilter)this.getControl("reportfilterap");
            filter.search();
        }
    }

    private void setCostAccount() {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        long mainBookId = AcaCostAccountHelper.getCostAccountByAccoutOrg((Long)((DynamicObject)org).getLong("id"), (String)"aca");
        if (!CadEmptyUtils.isEmpty((Long)mainBookId)) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
        }
        this.getView().updateView("costaccount");
    }

    private void setOrg() {
        if (this.getModel().getValue("org") == null) {
            Long orgId = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
            if (!isAccounting) {
                return;
            }
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (orgIds.contains(orgId)) {
                this.getModel().setValue("org", (Object)orgId);
                this.getView().updateView("org");
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        ArrayList pros = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "startperiod", "endperiod", "materialgrpstd"});
        boolean isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)pros);
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"CostSumRptPlugin_6", (String)"macc-aca-report", (Object[])new Object[0]));
            return false;
        }
        Long startPeriod = this.getModel().getDataEntity().getDynamicObject("startperiod").getLong("id");
        Long endPeriod = this.getModel().getDataEntity().getDynamicObject("endperiod").getLong("id");
        if (startPeriod > endPeriod) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u8981\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"CostSumRptPlugin_5", (String)"macc-aca-report", (Object[])new Object[0]));
            return false;
        }
        CostSumParam costSumParam = this.buildCostSumParam(this.getModel().getDataEntity());
        this.getQueryParam().getCustomParam().put(CostSumParam.class.getName(), costSumParam);
        return super.verifyQuery(queryParam);
    }

    private CostSumParam buildCostSumParam(DynamicObject dataEntity) {
        int showcount;
        DynamicObjectCollection submaterial;
        String reportcontent;
        DynamicObjectCollection mulmaterialgroup;
        DynamicObject materialgrpstd;
        DynamicObjectCollection costObjectCollection;
        DynamicObjectCollection costcenter;
        DynamicObject currency;
        DynamicObject costAccount;
        CostSumParam costSumParam = new CostSumParam();
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
            costSumParam.setOrgId(org.getLong("id"));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObject)(costAccount = dataEntity.getDynamicObject("costaccount")))) {
            costSumParam.setCostAccountId(costAccount.getLong("id"));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObject)(currency = dataEntity.getDynamicObject("currency")))) {
            costSumParam.setCurrencyId(currency.getLong("id"));
        }
        DynamicObject startperiod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endperiod = (DynamicObject)this.getModel().getValue("endperiod");
        if (!CadEmptyUtils.isEmpty((DynamicObject)startperiod) && !CadEmptyUtils.isEmpty((DynamicObject)endperiod)) {
            costSumParam.setPeriodIds(PeriodHelper.getStart2EndAllPeriodIds((DynamicObject)startperiod, (DynamicObject)endperiod));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(costcenter = (DynamicObjectCollection)this.getModel().getValue("mulcostcenter")))) {
            costSumParam.setCostCenterId(costcenter.stream().map(costObject -> costObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(costObjectCollection = (DynamicObjectCollection)this.getModel().getValue("mulcostobject")))) {
            costSumParam.setCostObjectIds(costObjectCollection.stream().map(costObject -> costObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObject)(materialgrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd")))) {
            costSumParam.setMaterialGrpStdId(materialgrpstd.getLong("id"));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(mulmaterialgroup = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup")))) {
            costSumParam.setMulMaterialGroupId(mulmaterialgroup.stream().map(costObject -> costObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        DynamicObjectCollection mulmaterial = (DynamicObjectCollection)this.getModel().getValue("mulmaterial");
        ArrayList<Long> mulmaterialIdList = new ArrayList(10);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulmaterial)) {
            mulmaterialIdList = mulmaterial.stream().map(costObject -> costObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        }
        if (materialgrpstd != null) {
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulmaterialgroup) || CadEmptyUtils.isEmpty(mulmaterialIdList) && materialgrpstd.getLong("id") != 730148448254487552L) {
                Set classifiedMaterialId = MaterialGroupHelper.getClassifiedMaterialId((DynamicObjectCollection)mulmaterialgroup, (boolean)false, (DynamicObject)materialgrpstd);
                costSumParam.setMaterialIds(new ArrayList<Long>(classifiedMaterialId));
            } else {
                costSumParam.setMaterialIds(mulmaterialIdList);
            }
        }
        if (!CadEmptyUtils.isEmpty((String)(reportcontent = (String)this.getModel().getValue("reportcontent")))) {
            costSumParam.setReportContent(reportcontent);
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(submaterial = (DynamicObjectCollection)this.getModel().getValue("submaterialf")))) {
            costSumParam.setSubMaterialIds(submaterial.stream().map(costObject -> costObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if (!CadEmptyUtils.isEmpty((Integer)(showcount = ((Integer)this.getModel().getValue("showcount")).intValue()))) {
            costSumParam.setShowCount(showcount);
        } else {
            costSumParam.setShowCount(50);
        }
        return costSumParam;
    }

    protected QFilter getPeriodFilter(DynamicObject costAccount) {
        Long costAccId = costAccount.getLong("id");
        QFilter periodfilter = new QFilter("entry.costaccount", "=", (Object)costAccId);
        DynamicObject cal_sysctrlentity = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.costaccount.id acctid,entry.costaccount.name acctname, entry.calpolicy.periodtype periodtype", (QFilter[])periodfilter.toArray());
        if (cal_sysctrlentity == null) {
            return new QFilter("periodtype", ">", (Object)0L).and(new QFilter("isadjustperiod", "=", (Object)false));
        }
        return new QFilter("periodtype", "=", (Object)cal_sysctrlentity.getLong("periodtype")).and(new QFilter("isadjustperiod", "=", (Object)false));
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"CostSumRptPlugin_7", (String)"macc-aca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u6210\u672c\u8ba1\u7b97\u5355\uff08\u6a2a\u5411\uff09\u67e5\u8be2", (String)"CostSumRptPlugin_10", (String)"macc-aca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"aca_prosumcostquery", (IDataModel)this.getModel());
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
    }
}

