/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.feealloc;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.aca.common.constants.MfgFeeAllocCostObjectRptParam;
import kd.macc.aca.common.helper.MfgFeeAllocRptHelp;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class BaseAllocRptPlugin
extends AbstractReportFormPlugin {
    private static final String CAL_SYSCTRLENTITY = "cal_sysctrlentity";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        List<Long> orgIds = this.getCurrAccountOrg();
        BasedataEdit orgInput = (BasedataEdit)this.getControl("org");
        orgInput.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter qfId = new QFilter("id", "in", (Object)orgIds);
            List qFilters = filterParameter.getQFilters();
            qFilters.add(qfId);
        });
        BasedataEdit costaccountInput = (BasedataEdit)this.getControl("costaccount");
        costaccountInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"BaseAllocRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                ArrayList<Long> orgList = new ArrayList<Long>();
                orgList.add(org.getLong("id"));
                ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnabledCostAccountIdsFilter(orgList, (String)this.getView().getFormShowParameter().getAppId());
                List qFilters = filterParameter.getQFilters();
                qFilters.add(enabledCostAccountIdsFilter);
            }
        });
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject endperiod;
        DynamicObject beginperiod;
        DynamicObject currency;
        DynamicObject costaccount;
        MfgFeeAllocCostObjectRptParam rptParam = MfgFeeAllocRptHelp.getRptParam((ReportQueryParam)queryParam);
        boolean ispass = true;
        DynamicObject org = rptParam.getOrg();
        if (org == null) {
            ispass = false;
        }
        if ((costaccount = rptParam.getCostaccount()) == null) {
            ispass = false;
        }
        if ((currency = rptParam.getCurrency()) == null) {
            ispass = false;
        }
        if ((beginperiod = rptParam.getBeginperiod()) == null) {
            ispass = false;
        }
        if ((endperiod = rptParam.getEndperiod()) == null) {
            ispass = false;
        }
        if (!ispass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5185\u5bb9\u672a\u6309\u8981\u6c42\u586b\u5199\u3002", (String)"BaseAllocRptPlugin_1", (String)"macc-aca-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setOrg();
        this.setCostaccount();
        this.setCurrency();
        this.setPeriod();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "org": {
                this.setCostaccount();
                break;
            }
            case "costaccount": {
                this.setCurrency();
                this.setPeriod();
                break;
            }
            case "beginperiod": {
                this.setPeriodRange("begin");
                break;
            }
            case "endperiod": {
                this.setPeriodRange("end");
            }
        }
    }

    protected void setCostaccount() {
        IDataModel model = this.getModel();
        DynamicObject org = model.getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getModel().setValue("costaccount", null);
            return;
        }
        model.setValue("costaccount", (Object)StartCostHelper.getCostAccountByAccoutOrg((Long)org.getLong("id"), (String)this.getView().getFormShowParameter().getAppId()));
        this.getView().updateView("costaccount");
    }

    protected void setOrg() {
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        Long orgId = RequestContext.get().getOrgId();
        boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
        if (!isAccounting) {
            return;
        }
        model.setValue("org", (Object)orgId);
        view.updateView("org");
    }

    protected void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
        this.getView().updateView("currency");
    }

    protected void setPeriod() {
        Long costaccountId;
        QFilter costaccountQF;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (org == null || costaccount == null) {
            this.getModel().setValue("beginperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        Long orgId = org.getLong("id");
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        DynamicObjectCollection res = QueryServiceHelper.query((String)CAL_SYSCTRLENTITY, (String)"id, entry.currentperiod AS currentperiod", (QFilter[])new QFilter[]{orgQF, costaccountQF = new QFilter("entry.costaccount", "=", (Object)(costaccountId = Long.valueOf(costaccount.getLong("id"))))});
        if (res != null && res.size() > 0) {
            Long currentperiod = ((DynamicObject)res.get(0)).getLong("currentperiod");
            this.getModel().setValue("beginperiod", (Object)currentperiod);
            this.getModel().setValue("endperiod", (Object)currentperiod);
        } else {
            this.getModel().setValue("beginperiod", null);
            this.getModel().setValue("endperiod", null);
        }
        this.getView().updateView("beginperiod");
        this.getView().updateView("endperiod");
    }

    private void setPeriodRange(String flag) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject beginperiod = dataEntity.getDynamicObject("beginperiod");
        DynamicObject endperiod = dataEntity.getDynamicObject("endperiod");
        if (beginperiod == null || endperiod == null) {
            return;
        }
        if (beginperiod.getDate("begindate").compareTo(endperiod.getDate("begindate")) <= 0) {
            return;
        }
        if ("begin".equals(flag)) {
            this.getModel().setValue("endperiod", (Object)beginperiod);
        } else if ("end".equals(flag)) {
            this.getModel().setValue("beginperiod", (Object)endperiod);
        }
    }

    private List<Long> getCurrAccountOrg() {
        List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId())).getHasPermOrgs();
        List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"10");
        if (CadEmptyUtils.isEmpty((List)permOrgIds) && CadEmptyUtils.isEmpty((List)orgIds)) {
            orgIds = OrgUnitServiceHelper.getAllOrg((String)"10");
        }
        return orgIds;
    }
}

