/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.feealloc;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostCalResultRptQuery
extends AbstractReportListDataPlugin {
    private static final String PERIOD = "fperiod";
    private static final String COSTOBJECT = "fcostobject";
    private static final String MATERIAL = "fmaterial";
    private static final String COSTCENTER = "fcostcenter";
    private Boolean isShowSubelement = false;
    private Boolean isShowMaterialDetail = false;

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        QFilter filter = this.getQfilter(reportQueryParam);
        ORM orm = ORM.create();
        String algoKey = ((Object)((Object)this)).getClass().getName() + ".query";
        String selectFields = this.getQueryFields();
        DataSet dataSet = orm.queryDataSet(algoKey, "aca_calcresult", selectFields, new QFilter[]{filter}).orderBy(new String[]{"period DESC", "costcenter ASC", "costobject ASC", "element ASC", "subelement ASC", "submaterial ASC"});
        this.isShowSubelement = this.isShowSubelement(reportQueryParam);
        this.isShowMaterialDetail = this.isShowMaterialDetail(reportQueryParam);
        DataSet costDataSet = dataSet.copy().filter("type = 'finalResult'").filter("material is null or material = 0");
        if (!costDataSet.isEmpty()) {
            DataSet costDataSetCopy = costDataSet.copy();
            ArrayList<Long> ids = new ArrayList<Long>();
            while (costDataSetCopy.hasNext()) {
                ids.add(costDataSetCopy.next().getLong("costobject"));
            }
            QFilter idQf = new QFilter("id", "in", ids);
            DataSet costobjectDatSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_costobject", (String)"id,material materialobject,manuorg AS entrymanuorg,bomversion.name matversionobject,auxpty auxptyobject,material.baseunit  unitobject,material.baseunit.precision AS precobject", (QFilter[])new QFilter[]{idQf}, null);
            String joinLeft = "id,periodid,period,costcenterid,costcenter,costcentername,costobject,producttype,productgroup,type,materialobject material,matversionobject matversion,auxptyobject auxpty,element,subelement,submaterial,submatversion,submatauxpty,unitobject unit,submatunit,precobject prec,subprec,pdstartqty,pdstartamount,startadjqty,startadjamt,pdcurrqty,pdcurramount,pdsumqty,pdsumamount,pdendqty,pdendamount,endadjqty,endadjamt,yearpdsumqty,yearpdsumamount,yeartotalcomqty,yeartotalcomuse,yeartotalcomunitcost,yeartotalcomamount,currcomqty,currcomuse,currcomunitcost,currcomamount,totalcomqty,totalcomuse,totalcomunitcost,totalcomamount";
            String[] split = joinLeft.split(",");
            costDataSet = costDataSet.leftJoin(costobjectDatSet).on("costobject", "id").select(split).finish();
            DataSet detailDataSet = dataSet.filter("type != 'finalResult'").filter("material is not null and material != 0");
            detailDataSet = detailDataSet.filter("!(pdendqty=0 and pdendamount=0 and startadjqty=0 and startadjamt=0 and endadjqty=0 and endadjamt=0 and pdsumqty=0 and pdsumamount=0 and totalcomqty=0 and totalcomamount=0 and currcomqty=0 and currcomamount=0 and pdstartqty=0 and pdstartamount=0 and pdcurrqty=0 and pdcurramount=0 and yearpdsumqty=0 and yearpdsumamount=0 and yeartotalcomqty=0 and yeartotalcomamount=0)");
            if (this.isShowSubelement.booleanValue() && !this.isShowMaterialDetail.booleanValue()) {
                String fileNames = "submaterial,submatversion,submatauxpty,submatunit,subprec,pdstartqty,startadjqty,pdcurrqty,pdsumqty,pdendqty,endadjqty,currcomqty,currcomuse,totalcomqty,totalcomuse,currcomunitcost,totalcomunitcost,yearpdsumqty,yeartotalcomqty,yeartotalcomuse,yeartotalcomunitcost";
                detailDataSet = detailDataSet.groupBy(new String[]{"id", "type", "periodid", "period", "costcenterid", "costcenter", "costcentername", "costobject", "producttype", "productgroup", "material", "matversion", "unit", "prec", "auxpty", "element", "subelement"}).sum("pdstartamount").sum("startadjamt").sum("pdcurramount").sum("pdsumamount").sum("pdendamount").sum("endadjamt").sum("currcomamount").sum("totalcomamount").sum("yearpdsumamount").sum("yeartotalcomamount").finish().addNullField(fileNames.split(",")).select(costDataSet.getRowMeta().getFieldNames());
            }
            dataSet = detailDataSet.union(costDataSet).orderBy(new String[]{"period DESC", "costcenter ASC", "costobject ASC", "element ASC", "subelement ASC", "submaterial ASC"});
        }
        dataSet = dataSet.groupBy(new String[]{"id", "type", "periodid", "period", "costcenterid", "costcenter", "costcentername", "costobject", "producttype", "productgroup", "material", "matversion", "auxpty", "element", "subelement", "subprec", "submaterial", "submatversion", "submatauxpty", "unit", "prec", "submatunit"}).sum("pdstartqty").sum("pdstartamount").sum("startadjqty").sum("startadjamt").sum("pdcurrqty").sum("pdcurramount").sum("pdsumqty").sum("pdsumamount").sum("pdendqty").sum("pdendamount").sum("endadjqty").sum("endadjamt").sum("currcomqty").sum("currcomuse").sum("totalcomqty").sum("totalcomuse").sum("currcomuse").sum("totalcomuse").sum("currcomunitcost").sum("currcomamount").sum("totalcomunitcost").sum("totalcomamount").sum("yearpdsumqty").sum("yeartotalcomqty").sum("yeartotalcomuse").sum("yeartotalcomunitcost").sum("yearpdsumamount").sum("yeartotalcomamount").finish().orderBy(new String[]{"period DESC", "costcenter ASC", "costobject ASC", "element ASC", "subelement ASC", "submaterial ASC"});
        List<Object[]> dataList = this.count(dataSet.iterator());
        DataSet result = Algo.create((String)"macc.aca.CostCalResultRptQuery").createDataSet(dataList.iterator(), this.getRowMeta()).select(this.getSelectFields(this.isShowSubelement, this.isShowMaterialDetail));
        return result;
    }

    protected List<Object[]> count(Iterator<Row> rows) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        Map<Long, Map<Long, List<Row>>> map = this.removeCommon(rows);
        int count = 0;
        BigDecimal tolFirtPdStartAmount = BigDecimal.ZERO;
        BigDecimal tolFirtPdStartQty = BigDecimal.ZERO;
        BigDecimal tolFirtPdCurrAmount = BigDecimal.ZERO;
        BigDecimal tolFirtPdCurrQty = BigDecimal.ZERO;
        BigDecimal tolFirtPdSumAmount = BigDecimal.ZERO;
        BigDecimal tolFirtPdSumQty = BigDecimal.ZERO;
        BigDecimal tolFirtPdEndAmount = BigDecimal.ZERO;
        BigDecimal tolFirtPdEndQty = BigDecimal.ZERO;
        BigDecimal tolFirtCurrComAmount = BigDecimal.ZERO;
        BigDecimal tolFirtCurrComQty = BigDecimal.ZERO;
        BigDecimal tolFirtYearSumAmount = BigDecimal.ZERO;
        BigDecimal tolFirtYearSumQty = BigDecimal.ZERO;
        BigDecimal tolFirtYearTotalAmount = BigDecimal.ZERO;
        BigDecimal tolFirtYearTotalQty = BigDecimal.ZERO;
        BigDecimal tolFirtTotalComAmount = BigDecimal.ZERO;
        BigDecimal tolFirtTotalComQty = BigDecimal.ZERO;
        BigDecimal tolFirtStartAdjAmt = BigDecimal.ZERO;
        BigDecimal tolFirtStartAdjQty = BigDecimal.ZERO;
        BigDecimal tolFirtEndAdjAmt = BigDecimal.ZERO;
        BigDecimal tolFirtEndAdjQty = BigDecimal.ZERO;
        for (Map.Entry<Long, Map<Long, List<Row>>> entrySet : map.entrySet()) {
            int index = 0;
            Map<Long, List<Row>> costCenterMap = entrySet.getValue();
            Object[] firstCountRowData = new Object[this.getRowMeta().getFields().length];
            String periodMsg = costCenterMap.values().iterator().next().get(0).getString("period");
            firstCountRowData[this.getListFieldIndex((String)"period")] = String.format(ResManager.loadKDString((String)"%s\u5c0f\u8ba1", (String)"CostCalResultRptQuery_2", (String)"macc-aca-report", (Object[])new Object[0]), periodMsg == null ? "" : periodMsg);
            BigDecimal sumFirtPdStartAmount = BigDecimal.ZERO;
            BigDecimal sumFirtPdStartQty = BigDecimal.ZERO;
            BigDecimal sumFirtPdCurrAmount = BigDecimal.ZERO;
            BigDecimal sumFirtPdCurrQty = BigDecimal.ZERO;
            BigDecimal sumFirtPdSumAmount = BigDecimal.ZERO;
            BigDecimal sumFirtPdSumQty = BigDecimal.ZERO;
            BigDecimal sumFirtPdEndAmount = BigDecimal.ZERO;
            BigDecimal sumFirtPdEndQty = BigDecimal.ZERO;
            BigDecimal sumFirtCurrComAmount = BigDecimal.ZERO;
            BigDecimal sumFirtCurrComQty = BigDecimal.ZERO;
            BigDecimal sumFirtYearSumAmount = BigDecimal.ZERO;
            BigDecimal sumFirtYearSumQty = BigDecimal.ZERO;
            BigDecimal sumFirtYearTotalAmount = BigDecimal.ZERO;
            BigDecimal sumFirtYearTotalQty = BigDecimal.ZERO;
            BigDecimal sumFirtTotalComAmount = BigDecimal.ZERO;
            BigDecimal sumFirtTotalComQty = BigDecimal.ZERO;
            BigDecimal sumFirtStartAdjAmt = BigDecimal.ZERO;
            BigDecimal sumFirtStartAdjQty = BigDecimal.ZERO;
            BigDecimal sumFirtEndAdjAmt = BigDecimal.ZERO;
            BigDecimal sumFirtEndAdjQty = BigDecimal.ZERO;
            for (Map.Entry<Long, List<Row>> entry : costCenterMap.entrySet()) {
                int i;
                List<Row> items = entry.getValue();
                count = items.size();
                Object[] secdCountRowData = new Object[this.getRowMeta().getFields().length];
                String costcenterMsg = items.get(0).getString("costcenter");
                secdCountRowData[this.getListFieldIndex((String)"costcenter")] = String.format(ResManager.loadKDString((String)"%s\u5c0f\u8ba1", (String)"CostCalResultRptQuery_2", (String)"macc-aca-report", (Object[])new Object[0]), costcenterMsg == null ? "" : costcenterMsg);
                BigDecimal sumSecdPdStartAmount = BigDecimal.ZERO;
                BigDecimal sumSecdPdStartQty = BigDecimal.ZERO;
                BigDecimal sumSecdPdCurrAmount = BigDecimal.ZERO;
                BigDecimal sumSecdPdCurrQty = BigDecimal.ZERO;
                BigDecimal sumSecdPdSumAmount = BigDecimal.ZERO;
                BigDecimal sumSecdPdSumQty = BigDecimal.ZERO;
                BigDecimal sumSecdPdEndAmount = BigDecimal.ZERO;
                BigDecimal sumSecdPdEndQty = BigDecimal.ZERO;
                BigDecimal sumSecdCurrComAmount = BigDecimal.ZERO;
                BigDecimal sumSecdCurrComQty = BigDecimal.ZERO;
                BigDecimal sumSecdTotalComAmount = BigDecimal.ZERO;
                BigDecimal sumSecdTotalComQty = BigDecimal.ZERO;
                BigDecimal sumSecdYearSumAmount = BigDecimal.ZERO;
                BigDecimal sumSecdYearSumQty = BigDecimal.ZERO;
                BigDecimal sumSecdYearTotalAmount = BigDecimal.ZERO;
                BigDecimal sumSecdYearTotalQty = BigDecimal.ZERO;
                BigDecimal sumSecdStartAdjAmt = BigDecimal.ZERO;
                BigDecimal sumSecdStartAdjQty = BigDecimal.ZERO;
                BigDecimal sumSecdFirtEndAdjAmt = BigDecimal.ZERO;
                BigDecimal sumSecdFirtEndAdjQty = BigDecimal.ZERO;
                for (i = 0; i < items.size(); ++i) {
                    Row row = items.get(i);
                    if (!"finalResult".equals(row.getString("type"))) continue;
                    BigDecimal pdstartamount = this.removeNull(row.getBigDecimal("pdstartamount"));
                    BigDecimal pdstartqty = this.removeNull(row.getBigDecimal("pdstartqty"));
                    BigDecimal pdcurramount = this.removeNull(row.getBigDecimal("pdcurramount"));
                    BigDecimal pdcurrqty = this.removeNull(row.getBigDecimal("pdcurrqty"));
                    BigDecimal pdsumamount = this.removeNull(row.getBigDecimal("pdsumamount"));
                    BigDecimal pdsumqty = this.removeNull(row.getBigDecimal("pdsumqty"));
                    BigDecimal pdendamount = this.removeNull(row.getBigDecimal("pdendamount"));
                    BigDecimal pdendqty = this.removeNull(row.getBigDecimal("pdendqty"));
                    BigDecimal yearpdsumamount = this.removeNull(row.getBigDecimal("yearpdsumamount"));
                    BigDecimal yearpdsumqty = this.removeNull(row.getBigDecimal("yearpdsumqty"));
                    BigDecimal yeartotalcomamount = this.removeNull(row.getBigDecimal("yeartotalcomamount"));
                    BigDecimal yeartotalcomqty = this.removeNull(row.getBigDecimal("yeartotalcomqty"));
                    BigDecimal currcomamount = this.removeNull(row.getBigDecimal("currcomamount"));
                    BigDecimal currcomqty = this.removeNull(row.getBigDecimal("currcomqty"));
                    BigDecimal totalcomamount = this.removeNull(row.getBigDecimal("totalcomamount"));
                    BigDecimal totalcomqty = this.removeNull(row.getBigDecimal("totalcomqty"));
                    BigDecimal startadjamt = this.removeNull(row.getBigDecimal("startadjamt"));
                    BigDecimal startadjqty = this.removeNull(row.getBigDecimal("startadjqty"));
                    BigDecimal endadjamt = this.removeNull(row.getBigDecimal("endadjamt"));
                    BigDecimal endadjqty = this.removeNull(row.getBigDecimal("endadjqty"));
                    this.nullDo(new BigDecimal[]{pdstartamount, pdcurramount, pdsumamount, pdendamount, yearpdsumamount, currcomamount, totalcomamount, startadjamt, endadjamt});
                    sumSecdPdStartAmount = sumSecdPdStartAmount.add(pdstartamount);
                    sumSecdPdStartQty = sumSecdPdStartQty.add(pdstartqty);
                    sumSecdPdCurrAmount = sumSecdPdCurrAmount.add(pdcurramount);
                    sumSecdPdCurrQty = sumSecdPdCurrQty.add(pdcurrqty);
                    sumSecdPdSumAmount = sumSecdPdSumAmount.add(pdsumamount);
                    sumSecdPdSumQty = sumSecdPdSumQty.add(pdsumqty);
                    sumSecdPdEndAmount = sumSecdPdEndAmount.add(pdendamount);
                    sumSecdPdEndQty = sumSecdPdEndQty.add(pdendqty);
                    sumSecdCurrComAmount = sumSecdCurrComAmount.add(currcomamount);
                    sumSecdCurrComQty = sumSecdCurrComQty.add(currcomqty);
                    sumSecdYearSumAmount = sumSecdYearSumAmount.add(yearpdsumamount);
                    sumSecdYearSumQty = sumSecdYearSumQty.add(yearpdsumqty);
                    sumSecdYearTotalAmount = sumSecdYearTotalAmount.add(yeartotalcomamount);
                    sumSecdYearTotalQty = sumSecdYearTotalQty.add(yeartotalcomqty);
                    sumSecdTotalComAmount = sumSecdTotalComAmount.add(totalcomamount);
                    sumSecdTotalComQty = sumSecdTotalComQty.add(totalcomqty);
                    sumSecdStartAdjAmt = sumSecdStartAdjAmt.add(startadjamt);
                    sumSecdStartAdjQty = sumSecdStartAdjQty.add(startadjqty);
                    sumSecdFirtEndAdjAmt = sumSecdFirtEndAdjAmt.add(endadjamt);
                    sumSecdFirtEndAdjQty = sumSecdFirtEndAdjQty.add(endadjqty);
                }
                secdCountRowData[this.getListFieldIndex((String)"pdstartamount")] = sumSecdPdStartAmount;
                secdCountRowData[this.getListFieldIndex((String)"pdstartqty")] = sumSecdPdStartQty;
                secdCountRowData[this.getListFieldIndex((String)"pdcurramount")] = sumSecdPdCurrAmount;
                secdCountRowData[this.getListFieldIndex((String)"pdcurrqty")] = sumSecdPdCurrQty;
                secdCountRowData[this.getListFieldIndex((String)"pdsumamount")] = sumSecdPdSumAmount;
                secdCountRowData[this.getListFieldIndex((String)"pdsumqty")] = sumSecdPdSumQty;
                secdCountRowData[this.getListFieldIndex((String)"pdendamount")] = sumSecdPdEndAmount;
                secdCountRowData[this.getListFieldIndex((String)"pdendqty")] = sumSecdPdEndQty;
                secdCountRowData[this.getListFieldIndex((String)"currcomamount")] = sumSecdCurrComAmount;
                secdCountRowData[this.getListFieldIndex((String)"currcomqty")] = sumSecdCurrComQty;
                secdCountRowData[this.getListFieldIndex((String)"yearpdsumamount")] = sumSecdYearSumAmount;
                secdCountRowData[this.getListFieldIndex((String)"yearpdsumqty")] = sumSecdYearSumQty;
                secdCountRowData[this.getListFieldIndex((String)"yeartotalcomamount")] = sumSecdYearTotalAmount;
                secdCountRowData[this.getListFieldIndex((String)"yeartotalcomqty")] = sumSecdYearTotalQty;
                secdCountRowData[this.getListFieldIndex((String)"totalcomamount")] = sumSecdTotalComAmount;
                secdCountRowData[this.getListFieldIndex((String)"totalcomqty")] = sumSecdTotalComQty;
                secdCountRowData[this.getListFieldIndex((String)"startadjamt")] = sumSecdStartAdjAmt;
                secdCountRowData[this.getListFieldIndex((String)"startadjqty")] = sumSecdStartAdjQty;
                secdCountRowData[this.getListFieldIndex((String)"endadjamt")] = sumSecdFirtEndAdjAmt;
                secdCountRowData[this.getListFieldIndex((String)"endadjqty")] = sumSecdFirtEndAdjQty;
                sumFirtPdStartAmount = sumFirtPdStartAmount.add(sumSecdPdStartAmount);
                sumFirtPdStartQty = sumFirtPdStartQty.add(sumSecdPdStartQty);
                sumFirtPdCurrAmount = sumFirtPdCurrAmount.add(sumSecdPdCurrAmount);
                sumFirtPdCurrQty = sumFirtPdCurrQty.add(sumSecdPdCurrQty);
                sumFirtPdSumAmount = sumFirtPdSumAmount.add(sumSecdPdSumAmount);
                sumFirtPdSumQty = sumFirtPdSumQty.add(sumSecdPdSumQty);
                sumFirtPdEndAmount = sumFirtPdEndAmount.add(sumSecdPdEndAmount);
                sumFirtPdEndQty = sumFirtPdEndQty.add(sumSecdPdEndQty);
                sumFirtCurrComAmount = sumFirtCurrComAmount.add(sumSecdCurrComAmount);
                sumFirtCurrComQty = sumFirtCurrComQty.add(sumSecdCurrComQty);
                sumFirtTotalComAmount = sumFirtTotalComAmount.add(sumSecdTotalComAmount);
                sumFirtTotalComQty = sumFirtTotalComQty.add(sumSecdTotalComQty);
                sumFirtYearSumAmount = sumFirtYearSumAmount.add(sumSecdYearSumAmount);
                sumFirtYearSumQty = sumFirtYearSumQty.add(sumSecdYearSumQty);
                sumFirtYearTotalAmount = sumFirtYearTotalAmount.add(sumSecdYearTotalAmount);
                sumFirtYearTotalQty = sumFirtYearTotalQty.add(sumSecdYearTotalQty);
                sumFirtStartAdjAmt = sumFirtStartAdjAmt.add(sumSecdStartAdjAmt);
                sumFirtStartAdjQty = sumFirtStartAdjQty.add(sumSecdStartAdjQty);
                sumFirtEndAdjAmt = sumFirtEndAdjAmt.add(sumSecdFirtEndAdjAmt);
                sumFirtEndAdjQty = sumFirtEndAdjQty.add(sumSecdFirtEndAdjQty);
                for (i = 0; i < items.size(); ++i) {
                    dataList.add(this.getObjectRow(items.get(i), index, i));
                    ++index;
                }
                dataList.add(secdCountRowData);
            }
            firstCountRowData[this.getListFieldIndex((String)"pdstartamount")] = sumFirtPdStartAmount;
            firstCountRowData[this.getListFieldIndex((String)"pdstartqty")] = sumFirtPdStartQty;
            firstCountRowData[this.getListFieldIndex((String)"pdcurramount")] = sumFirtPdCurrAmount;
            firstCountRowData[this.getListFieldIndex((String)"pdcurrqty")] = sumFirtPdCurrQty;
            firstCountRowData[this.getListFieldIndex((String)"pdsumamount")] = sumFirtPdSumAmount;
            firstCountRowData[this.getListFieldIndex((String)"pdsumqty")] = sumFirtPdSumQty;
            firstCountRowData[this.getListFieldIndex((String)"pdendamount")] = sumFirtPdEndAmount;
            firstCountRowData[this.getListFieldIndex((String)"pdendqty")] = sumFirtPdEndQty;
            firstCountRowData[this.getListFieldIndex((String)"currcomamount")] = sumFirtCurrComAmount;
            firstCountRowData[this.getListFieldIndex((String)"currcomqty")] = sumFirtCurrComQty;
            firstCountRowData[this.getListFieldIndex((String)"yearpdsumamount")] = sumFirtYearSumAmount;
            firstCountRowData[this.getListFieldIndex((String)"yearpdsumqty")] = sumFirtYearSumQty;
            firstCountRowData[this.getListFieldIndex((String)"yeartotalcomamount")] = sumFirtYearTotalAmount;
            firstCountRowData[this.getListFieldIndex((String)"yeartotalcomqty")] = sumFirtYearTotalQty;
            firstCountRowData[this.getListFieldIndex((String)"totalcomamount")] = sumFirtTotalComAmount;
            firstCountRowData[this.getListFieldIndex((String)"totalcomqty")] = sumFirtTotalComQty;
            firstCountRowData[this.getListFieldIndex((String)"startadjamt")] = sumFirtStartAdjAmt;
            firstCountRowData[this.getListFieldIndex((String)"startadjqty")] = sumFirtStartAdjQty;
            firstCountRowData[this.getListFieldIndex((String)"endadjamt")] = sumFirtEndAdjAmt;
            firstCountRowData[this.getListFieldIndex((String)"endadjqty")] = sumFirtEndAdjQty;
            tolFirtPdStartAmount = tolFirtPdStartAmount.add(sumFirtPdStartAmount);
            tolFirtPdStartQty = tolFirtPdStartQty.add(sumFirtPdStartQty);
            tolFirtPdCurrAmount = tolFirtPdCurrAmount.add(sumFirtPdCurrAmount);
            tolFirtPdCurrQty = tolFirtPdCurrQty.add(sumFirtPdCurrQty);
            tolFirtPdSumAmount = tolFirtPdSumAmount.add(sumFirtPdSumAmount);
            tolFirtPdSumQty = tolFirtPdSumQty.add(sumFirtPdSumQty);
            tolFirtPdEndAmount = tolFirtPdEndAmount.add(sumFirtPdEndAmount);
            tolFirtPdEndQty = tolFirtPdEndQty.add(sumFirtPdEndQty);
            tolFirtCurrComAmount = tolFirtCurrComAmount.add(sumFirtCurrComAmount);
            tolFirtCurrComQty = tolFirtCurrComQty.add(sumFirtCurrComQty);
            tolFirtYearSumAmount = tolFirtYearSumAmount.add(sumFirtYearSumAmount);
            tolFirtYearSumQty = tolFirtYearSumQty.add(sumFirtYearSumQty);
            tolFirtYearTotalAmount = tolFirtYearTotalAmount.add(sumFirtYearTotalAmount);
            tolFirtYearTotalQty = tolFirtYearTotalQty.add(sumFirtYearTotalQty);
            tolFirtTotalComAmount = tolFirtTotalComAmount.add(sumFirtTotalComAmount);
            tolFirtTotalComQty = tolFirtTotalComQty.add(sumFirtTotalComQty);
            tolFirtStartAdjAmt = tolFirtStartAdjAmt.add(sumFirtStartAdjAmt);
            tolFirtStartAdjQty = tolFirtStartAdjQty.add(sumFirtStartAdjQty);
            tolFirtEndAdjAmt = tolFirtEndAdjAmt.add(sumFirtEndAdjAmt);
            tolFirtEndAdjQty = tolFirtEndAdjQty.add(sumFirtEndAdjQty);
            dataList.add(firstCountRowData);
        }
        if (count > 0) {
            Object[] totalCountRowData = new Object[this.getRowMeta().getFields().length];
            totalCountRowData[this.getListFieldIndex((String)"period")] = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CostCalResultRptQuery_1", (String)"macc-aca-report", (Object[])new Object[0]);
            totalCountRowData[this.getListFieldIndex((String)"pdstartamount")] = tolFirtPdStartAmount;
            totalCountRowData[this.getListFieldIndex((String)"pdstartqty")] = tolFirtPdStartQty;
            totalCountRowData[this.getListFieldIndex((String)"pdcurramount")] = tolFirtPdCurrAmount;
            totalCountRowData[this.getListFieldIndex((String)"pdcurrqty")] = tolFirtPdCurrQty;
            totalCountRowData[this.getListFieldIndex((String)"pdsumamount")] = tolFirtPdSumAmount;
            totalCountRowData[this.getListFieldIndex((String)"pdsumqty")] = tolFirtPdSumQty;
            totalCountRowData[this.getListFieldIndex((String)"pdendamount")] = tolFirtPdEndAmount;
            totalCountRowData[this.getListFieldIndex((String)"pdendqty")] = tolFirtPdEndQty;
            totalCountRowData[this.getListFieldIndex((String)"currcomamount")] = tolFirtCurrComAmount;
            totalCountRowData[this.getListFieldIndex((String)"currcomqty")] = tolFirtCurrComQty;
            totalCountRowData[this.getListFieldIndex((String)"yearpdsumamount")] = tolFirtYearSumAmount;
            totalCountRowData[this.getListFieldIndex((String)"yearpdsumqty")] = tolFirtYearSumQty;
            totalCountRowData[this.getListFieldIndex((String)"yeartotalcomamount")] = tolFirtYearTotalAmount;
            totalCountRowData[this.getListFieldIndex((String)"yeartotalcomqty")] = tolFirtYearTotalQty;
            totalCountRowData[this.getListFieldIndex((String)"totalcomamount")] = tolFirtTotalComAmount;
            totalCountRowData[this.getListFieldIndex((String)"totalcomqty")] = tolFirtTotalComQty;
            totalCountRowData[this.getListFieldIndex((String)"startadjamt")] = tolFirtStartAdjAmt;
            totalCountRowData[this.getListFieldIndex((String)"startadjqty")] = tolFirtStartAdjQty;
            totalCountRowData[this.getListFieldIndex((String)"endadjamt")] = tolFirtEndAdjAmt;
            totalCountRowData[this.getListFieldIndex((String)"endadjqty")] = tolFirtEndAdjQty;
            dataList.add(totalCountRowData);
        }
        return dataList;
    }

    protected List<Field> getRowMetaField(Boolean isshowsubelement, Boolean isshowmaterialdetail) {
        ArrayList<Field> field = new ArrayList<Field>(42);
        field.add(new Field("period", (DataType)DataType.StringType));
        field.add(new Field("costcenter", (DataType)DataType.StringType));
        field.add(new Field("costcentername", (DataType)DataType.StringType));
        field.add(new Field("costobject", (DataType)DataType.LongType));
        field.add(new Field("producttype", (DataType)DataType.StringType));
        field.add(new Field("productgroup", (DataType)DataType.LongType));
        field.add(new Field("costobjectname", (DataType)DataType.StringType));
        field.add(new Field("material", (DataType)DataType.LongType));
        field.add(new Field("materialname", (DataType)DataType.StringType));
        field.add(new Field("modelnum", (DataType)DataType.StringType));
        field.add(new Field("unit", (DataType)DataType.StringType));
        field.add(new Field("matversion", (DataType)DataType.StringType));
        field.add(new Field("auxpty", (DataType)DataType.LongType));
        field.add(new Field("sourcebillnum", (DataType)DataType.StringType));
        field.add(new Field("sourcebillrow", (DataType)DataType.StringType));
        if (isshowsubelement.booleanValue()) {
            field.add(new Field("element", (DataType)DataType.LongType));
            field.add(new Field("elementname", (DataType)DataType.StringType));
            field.add(new Field("subelement", (DataType)DataType.LongType));
            field.add(new Field("subelementname", (DataType)DataType.StringType));
        }
        if (isshowmaterialdetail.booleanValue()) {
            field.add(new Field("submaterial", (DataType)DataType.LongType));
            field.add(new Field("submaterialname", (DataType)DataType.StringType));
            field.add(new Field("submaterialtype", (DataType)DataType.StringType));
            field.add(new Field("submatunit", (DataType)DataType.StringType));
            field.add(new Field("submatversion", (DataType)DataType.StringType));
            field.add(new Field("submatauxpty", (DataType)DataType.StringType));
        }
        field.add(new Field("pdstartqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdstartamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("startadjqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("startadjamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdcurrqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdcurramount", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdsumqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdsumamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdendqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdendamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("yearpdsumqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("yearpdsumamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("yeartotalcomqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("yeartotalcomuse", (DataType)DataType.BigDecimalType));
        field.add(new Field("yeartotalcomunitcost", (DataType)DataType.BigDecimalType));
        field.add(new Field("yeartotalcomamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("endadjqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("endadjamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("currcomqty", (DataType)DataType.BigDecimalType));
        if (isshowmaterialdetail.booleanValue()) {
            field.add(new Field("currcomuse", (DataType)DataType.BigDecimalType));
        }
        field.add(new Field("currcomunitcost", (DataType)DataType.BigDecimalType));
        field.add(new Field("currcomamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalcomqty", (DataType)DataType.BigDecimalType));
        if (isshowmaterialdetail.booleanValue()) {
            field.add(new Field("totalcomuse", (DataType)DataType.BigDecimalType));
        }
        field.add(new Field("totalcomunitcost", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalcomamount", (DataType)DataType.BigDecimalType));
        return field;
    }

    protected Object[] getObjectRow(Row row, int first, int second) {
        Field[] fields = this.getRowMeta().getFields();
        boolean mergeSame = this.getQueryParam().getFilter().getBoolean("mergesame");
        Object[] rowData = new Object[fields.length];
        if (!mergeSame || first == 0) {
            rowData[this.getListFieldIndex((String)"period")] = row.get("period");
        }
        if (!mergeSame || second == 0) {
            rowData[this.getListFieldIndex((String)"costcenter")] = row.get("costcenter");
            rowData[this.getListFieldIndex((String)"costcentername")] = row.get("costcentername");
        }
        if (!mergeSame || "finalResult".equals(row.getString("type"))) {
            rowData[this.getListFieldIndex((String)"costobject")] = row.get("costobject");
            rowData[this.getListFieldIndex((String)"producttype")] = row.get("producttype");
            rowData[this.getListFieldIndex((String)"productgroup")] = row.get("productgroup");
            rowData[this.getListFieldIndex((String)"material")] = row.get("material");
            rowData[this.getListFieldIndex((String)"unit")] = row.get("unit");
            rowData[this.getListFieldIndex((String)"matversion")] = row.get("matversion");
            rowData[this.getListFieldIndex((String)"auxpty")] = row.get("auxpty");
            this.setQty(row, rowData, row.getString("prec"), this.isShowMaterialDetail);
        }
        if ("detail".equals(row.getString("type"))) {
            this.setQty(row, rowData, row.getString("subprec"), this.isShowMaterialDetail);
        }
        if (this.isShowSubelement.booleanValue()) {
            rowData[this.getListFieldIndex((String)"element")] = row.get("element");
            rowData[this.getListFieldIndex((String)"subelement")] = row.get("subelement");
        }
        if (this.isShowMaterialDetail.booleanValue()) {
            rowData[this.getListFieldIndex((String)"submaterial")] = row.get("submaterial");
            rowData[this.getListFieldIndex((String)"submatversion")] = row.get("submatversion");
            rowData[this.getListFieldIndex((String)"submatauxpty")] = row.get("submatauxpty");
            rowData[this.getListFieldIndex((String)"submatunit")] = row.get("submatunit");
        }
        rowData[this.getListFieldIndex((String)"currcomunitcost")] = row.get("currcomunitcost");
        rowData[this.getListFieldIndex((String)"totalcomunitcost")] = row.get("totalcomunitcost");
        rowData[this.getListFieldIndex((String)"pdstartamount")] = row.get("pdstartamount");
        rowData[this.getListFieldIndex((String)"pdcurramount")] = row.get("pdcurramount");
        rowData[this.getListFieldIndex((String)"pdsumamount")] = row.get("pdsumamount");
        rowData[this.getListFieldIndex((String)"pdendamount")] = row.get("pdendamount");
        rowData[this.getListFieldIndex((String)"currcomamount")] = row.get("currcomamount");
        rowData[this.getListFieldIndex((String)"totalcomamount")] = row.get("totalcomamount");
        rowData[this.getListFieldIndex((String)"startadjamt")] = row.get("startadjamt");
        rowData[this.getListFieldIndex((String)"endadjamt")] = row.get("endadjamt");
        rowData[this.getListFieldIndex((String)"yearpdsumqty")] = CadEmptyUtils.isEmpty((BigDecimal)row.getBigDecimal("yearpdsumqty")) ? null : row.getBigDecimal("yearpdsumqty");
        rowData[this.getListFieldIndex((String)"yearpdsumamount")] = CadEmptyUtils.isEmpty((BigDecimal)row.getBigDecimal("yearpdsumamount")) ? BigDecimal.ZERO : row.getBigDecimal("yearpdsumamount");
        rowData[this.getListFieldIndex((String)"yeartotalcomqty")] = CadEmptyUtils.isEmpty((BigDecimal)row.getBigDecimal("yeartotalcomqty")) ? null : row.getBigDecimal("yeartotalcomqty");
        rowData[this.getListFieldIndex((String)"yeartotalcomuse")] = CadEmptyUtils.isEmpty((BigDecimal)row.getBigDecimal("yeartotalcomuse")) ? null : row.getBigDecimal("yeartotalcomuse");
        rowData[this.getListFieldIndex((String)"yeartotalcomunitcost")] = row.get("yeartotalcomunitcost");
        rowData[this.getListFieldIndex((String)"yeartotalcomamount")] = CadEmptyUtils.isEmpty((BigDecimal)row.getBigDecimal("yeartotalcomamount")) ? BigDecimal.ZERO : row.getBigDecimal("yeartotalcomamount");
        return rowData;
    }

    private void setQty(Row row, Object[] rowData, String precision, boolean isshowmaterial) {
        if (precision != null) {
            int prec = Integer.parseInt(precision);
            rowData[this.getListFieldIndex((String)"pdstartqty")] = this.getNotdealNumberToNull(this.removeNull(row.getBigDecimal("pdstartqty")).divide(BigDecimal.valueOf(1L), prec, 4));
            rowData[this.getListFieldIndex((String)"startadjqty")] = this.getNotdealNumberToNull(this.removeNull(row.getBigDecimal("startadjqty")).divide(BigDecimal.valueOf(1L), prec, 4));
            rowData[this.getListFieldIndex((String)"pdcurrqty")] = this.getNotdealNumberToNull(this.removeNull(row.getBigDecimal("pdcurrqty")).divide(BigDecimal.valueOf(1L), prec, 4));
            rowData[this.getListFieldIndex((String)"pdsumqty")] = this.getNotdealNumberToNull(this.removeNull(row.getBigDecimal("pdsumqty")).divide(BigDecimal.valueOf(1L), prec, 4));
            rowData[this.getListFieldIndex((String)"pdendqty")] = this.getNotdealNumberToNull(this.removeNull(row.getBigDecimal("pdendqty")).divide(BigDecimal.valueOf(1L), prec, 4));
            rowData[this.getListFieldIndex((String)"endadjqty")] = this.getNotdealNumberToNull(this.removeNull(row.getBigDecimal("endadjqty")).divide(BigDecimal.valueOf(1L), prec, 4));
            rowData[this.getListFieldIndex((String)"currcomqty")] = this.getNotdealNumberToNull(this.removeNull(row.getBigDecimal("currcomqty")).divide(BigDecimal.valueOf(1L), prec, 4));
            rowData[this.getListFieldIndex((String)"totalcomqty")] = this.getNotdealNumberToNull(this.removeNull(row.getBigDecimal("totalcomqty")).divide(BigDecimal.valueOf(1L), prec, 4));
            if (isshowmaterial) {
                rowData[this.getListFieldIndex((String)"currcomuse")] = this.getNotdealNumberToNull(this.removeNull(row.getBigDecimal("currcomuse")).divide(BigDecimal.valueOf(1L), prec, 4));
                rowData[this.getListFieldIndex((String)"totalcomuse")] = this.getNotdealNumberToNull(this.removeNull(row.getBigDecimal("totalcomuse")).divide(BigDecimal.valueOf(1L), prec, 4));
            }
        } else {
            rowData[this.getListFieldIndex((String)"pdstartqty")] = this.getNotdealNumberToNull(row, "pdstartqty");
            rowData[this.getListFieldIndex((String)"startadjqty")] = this.getNotdealNumberToNull(row, "startadjqty");
            rowData[this.getListFieldIndex((String)"pdcurrqty")] = this.getNotdealNumberToNull(row, "pdcurrqty");
            rowData[this.getListFieldIndex((String)"pdsumqty")] = this.getNotdealNumberToNull(row, "pdsumqty");
            rowData[this.getListFieldIndex((String)"pdendqty")] = this.getNotdealNumberToNull(row, "pdendqty");
            rowData[this.getListFieldIndex((String)"endadjqty")] = this.getNotdealNumberToNull(row, "endadjqty");
            rowData[this.getListFieldIndex((String)"currcomqty")] = this.getNotdealNumberToNull(row, "currcomqty");
            rowData[this.getListFieldIndex((String)"totalcomqty")] = this.getNotdealNumberToNull(row, "totalcomqty");
            if (isshowmaterial) {
                rowData[this.getListFieldIndex((String)"currcomuse")] = this.getNotdealNumberToNull(row, "currcomuse");
                rowData[this.getListFieldIndex((String)"totalcomuse")] = this.getNotdealNumberToNull(row, "totalcomuse");
            }
        }
    }

    private BigDecimal getNotdealNumberToNull(Row row, String fileName) {
        BigDecimal value = row.getBigDecimal(fileName);
        return value == null || BigDecimal.ZERO.compareTo(value) == 0 ? null : value;
    }

    private BigDecimal getNotdealNumberToNull(BigDecimal value) {
        return value == null || BigDecimal.ZERO.compareTo(value) == 0 ? null : value;
    }

    private void nullDo(BigDecimal[] bigDecimals) {
        if (CadEmptyUtils.isEmpty((Object[])bigDecimals)) {
            return;
        }
        for (BigDecimal bigDecimal : bigDecimals) {
            if (bigDecimal != null) continue;
            bigDecimal = new BigDecimal(0);
        }
    }

    private BigDecimal removeNull(BigDecimal bigDecimal) {
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }

    private RowMeta getRowMeta() {
        List<Field> field = this.getRowMetaField(this.isShowSubelement, this.isShowMaterialDetail);
        return new RowMeta(field.toArray(new Field[0]));
    }

    private int getListFieldIndex(String field) {
        Field[] fields = this.getRowMeta().getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!field.equals(fields[i].getName())) continue;
            return i;
        }
        return -1;
    }

    private Map<Long, Map<Long, List<Row>>> removeCommon(Iterator<Row> rows) {
        Object row;
        LinkedHashMap<Long, Map<Long, List<Row>>> map = new LinkedHashMap<Long, Map<Long, List<Row>>>();
        TreeMap rowMap = Maps.newTreeMap();
        if (this.isShowSubelement.booleanValue() || this.isShowMaterialDetail.booleanValue()) {
            while (rows.hasNext()) {
                row = rows.next();
                if (rowMap.containsKey(row.getString("id"))) {
                    ((List)rowMap.get(row.getString("id"))).add(row);
                    continue;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(row);
                rowMap.put(row.getString("id"), arrayList);
            }
            for (Map.Entry entry : rowMap.entrySet()) {
                List rs = (List)entry.getValue();
                Collections.sort(rs, new Comparator<Row>(){

                    @Override
                    public int compare(Row o1, Row o2) {
                        return o2.getString("type").compareTo(o1.getString("type"));
                    }
                });
                for (int i = 0; i < rs.size(); ++i) {
                    Row row2 = (Row)rs.get(i);
                    Map costCenterMap = map.computeIfAbsent(row2.getLong("periodid"), k -> new TreeMap());
                    costCenterMap.computeIfAbsent(row2.getLong("costcenterid"), k -> new ArrayList()).add(row2);
                }
            }
        } else {
            while (rows.hasNext()) {
                row = rows.next();
                if (!"finalResult".equals(row.getString("type"))) continue;
                Map map2 = map.computeIfAbsent(row.getLong("periodid"), k -> new TreeMap());
                map2.computeIfAbsent(row.getLong("costcenterid"), k -> new ArrayList()).add(row);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            Map costCenterMap = (Map)entry.getValue();
            for (Map.Entry ccData : costCenterMap.entrySet()) {
                List value = (List)ccData.getValue();
                value.sort(Comparator.comparing(o -> o.getLong("costobject")));
            }
        }
        return map;
    }

    private QFilter getQfilter(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        Object value = null;
        value = this.getFilterItemValue(filterInfo, "org");
        QFilter filter = new QFilter("org", "=", value);
        value = this.getFilterItemValue(filterInfo, "costaccount");
        filter.and(new QFilter("costaccount", "=", value));
        value = this.getFilterItemValue(filterInfo, "currency");
        filter.and(new QFilter("currency", "in", value));
        value = this.getFilterItemValue(filterInfo, PERIOD);
        filter.and(new QFilter("period", "in", value));
        value = this.getFilterItemValue(filterInfo, "manuorg");
        if (value != null) {
            filter.and(new QFilter("costobject.manuorg", "in", value));
        }
        if ((value = this.getFilterItemValue(filterInfo, COSTCENTER)) != null) {
            filter.and(new QFilter("costcenter", "in", value));
        }
        Object costObjectId = this.getFilterItemValue(filterInfo, COSTOBJECT);
        Object materialId = this.getFilterItemValue(filterInfo, MATERIAL);
        if (costObjectId != null || materialId != null) {
            filter.and(new QFilter("costobject", "in", this.getMainCostobjectIds(filter, costObjectId, materialId)));
        }
        return filter;
    }

    private Set<Long> getMainCostobjectIds(QFilter calResultFilter, Object costObjectIds, Object materialIds) {
        StringBuilder sb;
        List objList;
        HashSet ids = Sets.newHashSetWithExpectedSize((int)16);
        QFilter detailFilter = new QFilter("entryentity.type", "=", (Object)"finalResult");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"costobject", (String)"aca_calcresult", (String)"costobject mainCostObjectId,entryentity.relacostobject costobjectId,entryentity.relacostobject.material materialId", (QFilter[])new QFilter[]{calResultFilter, detailFilter}, (String)"");
        if (costObjectIds != null && !(objList = (List)costObjectIds).isEmpty()) {
            sb = new StringBuilder();
            for (Object o : objList) {
                sb.append(String.valueOf(o)).append(",");
            }
            dataSet = dataSet.filter("costobjectId in(" + sb.toString().substring(0, sb.length() - 1) + ")");
        }
        if (materialIds != null && !(objList = (List)materialIds).isEmpty()) {
            sb = new StringBuilder();
            for (Object o : objList) {
                sb.append(String.valueOf(o)).append(",");
            }
            dataSet = dataSet.filter("materialId in(" + sb.toString().substring(0, sb.length() - 1) + ")");
        }
        for (Row row : dataSet) {
            ids.add(row.getLong("mainCostObjectId"));
        }
        return ids;
    }

    private String getSelectFields(Boolean isshowsubelement, Boolean isshowmaterialdetail) {
        if (isshowsubelement.booleanValue() && isshowmaterialdetail.booleanValue()) {
            return "period,costcenter,costcentername,costobject,producttype,productgroup,material,unit,submatunit,case when submatunit=null then unit else submatunit end unitfield,matversion,auxpty,element,subelement,submaterial,submatversion,submatauxpty,pdstartqty,pdstartamount,startadjqty,startadjamt,pdcurrqty,pdcurramount,pdsumqty,pdsumamount,pdendqty,pdendamount,endadjqty,endadjamt,currcomqty,currcomuse,currcomunitcost,currcomamount,totalcomqty,totalcomuse,totalcomunitcost,totalcomamount,yearpdsumqty,yearpdsumamount,yeartotalcomqty,yeartotalcomuse,yeartotalcomunitcost,yeartotalcomamount";
        }
        if (isshowsubelement.booleanValue()) {
            return "period,costcenter,costcentername,costobject,producttype,productgroup,material,unit,unit as unitfield,matversion,auxpty,element,subelement,pdstartqty,pdstartamount,startadjqty,startadjamt,pdcurrqty,pdcurramount,pdsumqty,pdsumamount,pdendqty,pdendamount,endadjqty,endadjamt,currcomqty,currcomunitcost,currcomamount,totalcomqty,totalcomunitcost,totalcomamount,yearpdsumqty,yearpdsumamount,yeartotalcomqty,yeartotalcomuse,yeartotalcomunitcost,yeartotalcomamount";
        }
        if (isshowmaterialdetail.booleanValue()) {
            return "period,costcenter,costcentername,costobject,producttype,productgroup,material,unit,submatunit,case when submatunit=null then unit else submatunit end unitfield,matversion,auxpty,submaterial,submatversion,submatauxpty,pdstartqty,pdstartamount,startadjqty,startadjamt,pdcurrqty,pdcurramount,pdsumqty,pdsumamount,pdendqty,pdendamount,endadjqty,endadjamt,currcomqty,currcomuse,currcomunitcost,currcomamount,totalcomqty,totalcomuse,totalcomunitcost,totalcomamount,yearpdsumqty,yearpdsumamount,yeartotalcomqty,yeartotalcomuse,yeartotalcomunitcost,yeartotalcomamount";
        }
        return "period,costcenter,costcentername,costobject,producttype,productgroup,material,unit,unit as unitfield,matversion,auxpty,pdstartqty,pdstartamount,startadjqty,startadjamt,pdcurrqty,pdcurramount,pdsumqty,pdsumamount,pdendqty,pdendamount,endadjqty,endadjamt,currcomqty,currcomunitcost,currcomamount,totalcomqty,totalcomunitcost,totalcomamount,yearpdsumqty,yearpdsumamount,yeartotalcomqty,yeartotalcomuse,yeartotalcomunitcost,yeartotalcomamount";
    }

    private String getQueryFields() {
        String files = "billno AS id,period AS periodid,period.name AS period,costcenter AS costcenterid,costcenter.number AS costcenter,costcenter.name AS costcentername,entryentity.relacostobject AS costobject,entryentity.relaproducttype producttype,costobject.productgroup productgroup,entryentity.type AS type,entryentity.material AS material,entryentity.matversion.name AS matversion,entryentity.auxpty AS auxpty,entryentity.element AS element,entryentity.subelement AS subelement,entryentity.submaterial AS submaterial,entryentity.submatversion.name AS submatversion,entryentity.subauxpty AS submatauxpty,entryentity.material.baseunit AS unit,entryentity.submaterial.baseunit AS submatunit,entryentity.material.baseunit.precision AS prec,entryentity.submaterial.baseunit.precision AS subprec,entryentity.pdstartqty AS pdstartqty,entryentity.pdstartamount AS pdstartamount,entryentity.startadjqty AS startadjqty,entryentity.startadjamt AS startadjamt,entryentity.pdcurrqty AS pdcurrqty,entryentity.pdcurramount AS pdcurramount,entryentity.pdsumqty AS pdsumqty,entryentity.pdsumamount AS pdsumamount,entryentity.pdendqty AS pdendqty,entryentity.pdendamount AS pdendamount,entryentity.endadjqty AS endadjqty,entryentity.endadjamt AS endadjamt,entryentity.yearpdsumqty as yearpdsumqty,entryentity.yearpdsumamount as yearpdsumamount,entryentity.yearsumcomqty as yeartotalcomqty,entryentity.yearsumcomuse as yeartotalcomuse,entryentity.yearsumcomunitcost as yeartotalcomunitcost,entryentity.yearsumcomamount as yeartotalcomamount,entryentity.currcomqty AS currcomqty,entryentity.currcomuse AS currcomuse,entryentity.currcomunitcost AS currcomunitcost,entryentity.currcomamount AS currcomamount,entryentity.sumcomqty AS totalcomqty,entryentity.sumcomuse AS totalcomuse,entryentity.sumcomunitcost AS totalcomunitcost,entryentity.sumcomamount AS totalcomamount";
        return files;
    }

    private Boolean isShowSubelement(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        return (Boolean)CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"isshowsubelement");
    }

    private Boolean isShowMaterialDetail(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        return (Boolean)CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"isshowmaterialdetail");
    }

    private Object getFilterItemValue(FilterInfo filterInfo, String propName) {
        FilterItemInfo filterItem = filterInfo.getFilterItem(propName);
        if (filterItem != null && filterItem.getValue() != null) {
            Object value = filterItem.getValue();
            if (value instanceof DynamicObject) {
                return ((DynamicObject)value).getPkValue();
            }
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection values = (DynamicObjectCollection)value;
                return values.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            }
            return value;
        }
        return null;
    }
}

