/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.inout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import org.apache.commons.collections4.CollectionUtils;

public class InputOutputRpt
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        BasedataEdit orgInput = (BasedataEdit)this.getControl("org");
        orgInput.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            listFilterParameter.getQFilters().add(new QFilter("id", "in", (Object)orgIds));
        });
        BasedataEdit manuorgInput = (BasedataEdit)this.getControl("manuorgf");
        manuorgInput.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"InputOutputRpt_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List manuOrgIds = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)((Long)org.getPkValue()), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (CollectionUtils.isNotEmpty((Collection)manuOrgIds)) {
                QFilter filter = new QFilter("id", "in", (Object)manuOrgIds);
                filterParameter.getQFilters().add(filter);
            }
        });
        BasedataEdit costcenterf = (BasedataEdit)this.getControl("costcenterf");
        costcenterf.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"InputOutputRpt_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter showOrgDutyFilter = new QFilter("orgduty", "=", (Object)4L);
            QFilter calorgsFilter = new QFilter("accountorg", "=", (Object)org.getLong("id"));
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(showOrgDutyFilter);
            qFilters.add(calorgsFilter);
        });
        BasedataEdit costAccountInput = (BasedataEdit)this.getControl("costaccount");
        costAccountInput.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"InputOutputRpt_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            Long acctOrgId = org.getLong("id");
            qFilters.add(StartCostHelper.getEnabledCostAccountIdsFilter((Long)acctOrgId, (String)"aca"));
        });
        BasedataEdit period = (BasedataEdit)this.getControl("mulperiod");
        period.addBeforeF7SelectListener(evt -> {
            DynamicObject account;
            DynamicObject accountOrg = this.getModel().getDataEntity().getDynamicObject("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"InputOutputRpt_0", (String)"macc-aca-report", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (CadEmptyUtils.isEmpty((DynamicObject)(account = this.getModel().getDataEntity().getDynamicObject("costaccount")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"InputOutputRpt_1", (String)"macc-aca-report", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                qFilters.add(new QFilter("isadjustperiod", "=", (Object)false));
                qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)Long.valueOf(String.valueOf(accountOrg.getPkValue())), (Long)Long.valueOf(String.valueOf(account.getPkValue()))));
            }
        });
        BasedataEdit costObject = (BasedataEdit)this.getControl("costobjectf");
        costObject.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"InputOutputRpt_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            List<QFilter> costObjectFilter = this.getCostObjectFilter();
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.addAll(costObjectFilter);
        });
    }

    public void beforeBindData(EventObject e) {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org != null) {
            return;
        }
        this.setOrg();
        this.setManuorg();
        this.setCostAccount();
        this.setPeriod();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (name) {
            case "org": {
                this.setManuorg();
                this.getModel().setValue("manuorgf", null);
                this.getModel().setValue("costcenterf", null);
                this.getModel().setValue("costaccount", null);
                this.getModel().setValue("mulperiod", null);
                this.setCostAccount();
                this.setPeriod();
                break;
            }
            case "costaccount": {
                if (newValue == null) {
                    this.getModel().setValue("mulperiod", null);
                }
                this.setPeriod();
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("org");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7", (String)"InputOutputRpt_2", (String)"macc-aca-report", (Object[])new Object[0]));
        }
        DynamicObject costaccount = filter.getDynamicObject("costaccount");
        if (costaccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"InputOutputRpt_3", (String)"macc-aca-report", (Object[])new Object[0]));
        }
        DynamicObjectCollection mulperiod = filter.getDynamicObjectCollection("mulperiod");
        if (mulperiod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6838\u7b97\u671f\u95f4\u201d\u3002", (String)"InputOutputRpt_4", (String)"macc-aca-report", (Object[])new Object[0]));
        }
        return super.verifyQuery(queryParam);
    }

    private void setOrg() {
        if (this.getModel().getValue("org") == null) {
            Long orgId = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
            if (!isAccounting) {
                return;
            }
            this.getModel().setValue("org", (Object)orgId);
            this.getView().updateView("org");
        }
    }

    private void setCostAccount() {
        Long costAccount = this.getCostAccountByAccoutOrg();
        this.getModel().setValue("costaccount", (Object)costAccount);
    }

    private void setManuorg() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        boolean isMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
        this.getView().setVisible(Boolean.valueOf(isMultiFactory), new String[]{"manuorgf"});
    }

    private void setPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
            this.getModel().setValue("mulperiod", null);
            return;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
        if (res != null) {
            Long currentperiod = res.getLong("currentperiod");
            Object[] objects = new Object[]{currentperiod};
            this.getModel().setValue("mulperiod", (Object)objects);
        }
    }

    private Long getCostAccountByAccoutOrg() {
        QFilter appNumQF;
        QFilter[] filters;
        DynamicObjectCollection result;
        Object org = this.getModel().getValue("org");
        if (org == null) {
            return 0L;
        }
        Long accountOrgId = ((DynamicObject)org).getLong("id");
        String fields = "entryentity.costaccount.id id,entryentity.costaccount.name name,entryentity.costaccount.ismainaccount ismainaccount";
        QFilter orgFilter = new QFilter("org", "=", (Object)accountOrgId);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId())) {
            appId = "aca";
        }
        if ((result = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])(filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, enable, appNumQF = new QFilter("appnum", "=", (Object)appId)}), null)) == null || result.isEmpty()) {
            return null;
        }
        DynamicObject costaccount = (DynamicObject)result.get(0);
        return costaccount.getLong("id");
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"InputOutputRpt_5", (String)"macc-aca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u6295\u5165\u4ea7\u51fa\u67e5\u8be2", (String)"InputOutputRpt_6", (String)"macc-aca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"aca_inoutqueryrpt", (IDataModel)this.getModel());
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        for (DynamicObject rowDatum : rowData) {
            DynamicObject costobject = rowDatum.getDynamicObject("costobject");
            if (costobject != null) {
                rowDatum.set("srcbillrow", (Object)costobject.getInt("srcbillrow"));
                continue;
            }
            rowDatum.set("srcbillrow", null);
        }
    }

    private List<QFilter> getCostObjectFilter() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        DynamicObjectCollection rows = (DynamicObjectCollection)this.getModel().getValue("costcenterf");
        HashSet<Long> costCenterIds = new HashSet<Long>();
        for (DynamicObject row : rows) {
            DynamicObject costCenter = row.getDynamicObject("fbasedataid");
            costCenterIds.add((Long)costCenter.getPkValue());
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (org != null) {
            QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
            filters.add(orgFilter);
        }
        if (!CadEmptyUtils.isEmpty(costCenterIds)) {
            QFilter costCenterFilter = new QFilter("costcenter", "in", costCenterIds);
            filters.add(costCenterFilter);
        }
        return filters;
    }
}

