/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.realtime;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.MapFunction;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.aca.algox.utils.DataSetXHelper;
import kd.macc.aca.report.realtime.RealTimeCalcResultParam;
import kd.macc.aca.report.realtime.RealTimeEndDealFunction;
import kd.macc.aca.report.realtime.RealTimeFilterFunction;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class HandleFinalRow
implements IDataXTransform {
    private ReportDataCtx ctx;
    private RealTimeCalcResultParam calcResultParam;

    public HandleFinalRow(RealTimeCalcResultParam calcResultParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.calcResultParam = calcResultParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        if (this.calcResultParam.isShowMatDetail()) {
            List<Long> costObjectIds;
            List<Long> periodIds;
            Long orgId = this.calcResultParam.getOrgId();
            ArrayList<QFilter> commonFilters = new ArrayList<QFilter>(10);
            commonFilters.add(new QFilter("org", "=", (Object)orgId));
            Long costAccountId = this.calcResultParam.getCostAccountId();
            commonFilters.add(new QFilter("costaccount", "=", (Object)costAccountId));
            List<Long> costCenterIds = this.calcResultParam.getCostCenterIds();
            if (!CadEmptyUtils.isEmpty(costCenterIds)) {
                commonFilters.add(new QFilter("costcenter", "in", costCenterIds));
            }
            if (!CadEmptyUtils.isEmpty(periodIds = this.calcResultParam.getPeriodIds())) {
                commonFilters.add(new QFilter("period", "in", periodIds));
            }
            if ((costObjectIds = this.calcResultParam.getCostObjectIds()) != null) {
                commonFilters.add(new QFilter("inventoryentryentity.invcostobject", "in", costObjectIds));
            }
            DataSet calcResult = QueryServiceHelper.queryDataSet((String)"getCalcResult", (String)"aca_realtimecalcresult", (String)"id,period,costcenter,inventoryentryentity.invcostobject costobject,inventoryentryentity.invcostobject.producttype producttype,inventoryentryentity.invcostobject.material.number productnumber,inventoryentryentity.invcostobject.material.name productname,inventoryentryentity.sourcebill srcbillid,inventoryentryentity.sourcebillentry srcbillentryid,inventoryentryentity.inventorysubelement subelement,inventoryentryentity.inventoryqty currcomqty,inventoryentryentity.inventoryamount currcomamount", (QFilter[])commonFilters.toArray(new QFilter[0]), null);
            calcResult = calcResult.groupBy(new String[]{"id", "period", "costcenter", "costobject", "producttype", "productnumber", "productname", "srcbillid", "srcbillentryid", "subelement"}).sum("currcomamount").max("currcomqty").finish().addFields(new String[]{"'detail'", "'2'"}, new String[]{"datatype", "dealtype"});
            DataSet elementDataSet = QueryServiceHelper.queryDataSet((String)"getProCostDataSetInfo", (String)"cad_elementdetail", (String)"subelement,element", null, null);
            calcResult = calcResult.leftJoin(elementDataSet).on("subelement", "subelement").select(calcResult.getRowMeta().getFieldNames(), new String[]{"element"}).finish();
            HashSet billIdSet = new HashSet(128);
            HashSet billEntryIdSet = new HashSet(128);
            calcResult.copy().forEach(s -> {
                billIdSet.add(s.getLong("srcbillid"));
                billEntryIdSet.add(s.getLong("srcbillentryid"));
            });
            QFilter qFilter = new QFilter("costaccount", "=", (Object)costAccountId);
            qFilter.and("entry.bizbillentryid", "in", billEntryIdSet);
            DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)"calCostRecord", (String)"cal_costrecord_subentity", (String)"auditdate,billno,bizbillid as srcBillId,entry.bizbillentryid as srcEntryId", (QFilter[])qFilter.toArray(), null);
            calcResult = calcResult.leftJoin(costRecordDs).on("srcbillid", "srcBillId").on("srcbillentryid", "srcEntryId").select(calcResult.getRowMeta().getFieldNames(), new String[]{"auditdate as syncauditdate", "billno as srcbillno"}).finish();
            DataSetX calcResultDataSetX = this.ctx.getCurrentJob().fromInput((Input)new DataSetInput(calcResult));
            srcData = DataSetXHelper.unionIfRowDiff((DataSetX)srcData, (DataSetX)calcResultDataSetX);
        }
        srcData = srcData.map((MapFunction)new RealTimeEndDealFunction());
        srcData = srcData.groupBy(new String[]{"period", "costcenter", "costobject"}).reduceGroup((GroupReduceFunction)new RealTimeFilterFunction());
        return srcData;
    }
}

