/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.realtime;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.macc.aca.report.realtime.DiyTotalRow;
import kd.macc.aca.report.realtime.HandleFinalRow;
import kd.macc.aca.report.realtime.RealTimeCalcResultParam;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class RealTimeCalcResultRptSourceCf
implements IReportDataHandle {
    private final Log logger = LogFactory.getLog(RealTimeCalcResultRptSourceCf.class);
    private List<String> qczcProps = Lists.newArrayList((Object[])new String[]{"pdstartqty", "pdstartamount"});
    private List<String> bqInProps = Lists.newArrayList((Object[])new String[]{"pdcurrqty", "pdcurramount"});
    private List<String> qmzcProps = Lists.newArrayList((Object[])new String[]{"pdendqty", "pdendamount"});
    private List<String> bqFinishProps = Lists.newArrayList((Object[])new String[]{"currcomqty", "currcomuse", "currcomunitcost", "currcomamount"});
    private List<String> hideProps = Lists.newArrayList((Object[])new String[]{"billno", "linetype", "currencyfield", "type"});
    private RealTimeCalcResultParam calcResultParam;

    public void setupCtx(ReportDataCtx ctx) {
        this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
        this.calcResultParam = (RealTimeCalcResultParam)ctx.getParam(RealTimeCalcResultParam.class.getName());
        ctx.setShowBlockEntity(false);
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        this.logger.info("\u4fee\u6539\u56fa\u5b9a\u6570\u636e\u5757");
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("transFormAfterUnion\u591a\u4e2a\u6570\u636e\u5757union\u5b8c\u6210\u540e\u6267\u884c\uff0c\u53ef\u5728\u6b64\u6dfb\u52a0\u81ea\u5df1\u5b9e\u73b0\u7684IDataXTransform\u5904\u7406\u6570\u636e");
        ctx.logInfo((Object)ResManager.loadKDString((String)"\u5904\u7406\u6570\u636e\u5757\u6570\u636e", (String)"RealTimeCalcResultRptSourceCf_0", (String)"macc-aca-report", (Object[])new Object[0]));
        transCollector.add(new HandleFinalRow(this.calcResultParam, ctx));
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("group\u5b8c\u6210\u540e\u6267\u884c\u6570\u636e\u8f6c\u6362");
    }

    public void beforeAddSumRow(ReportDataCtx ctx) {
        this.logger.info("\u5728\u6dfb\u52a0\u6c47\u603b\u884c\u524d\u8bbe\u7f6e\u6c47\u603b\u65b9\u6848\uff0c\u6216\u8005\u5176\u4ed6\u4e0a\u4e0b\u6587\u8bbe\u7f6e");
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("\u6dfb\u52a0\u5b8c\u6c47\u603b\u884c\u540e\u6267\u884c\u7684\u6570\u636e\u8f6c\u6362");
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("\u751f\u6210\u6700\u7ec8\u7684\u6570\u636e\u5305\u540e\uff0c\u6267\u884c\u7684\u6570\u636e\u8f6c\u6362");
        transCollector.add(new DiyTotalRow(this.calcResultParam));
    }

    private List<QFilter> getFixedFilter() {
        List<Long> periodIds;
        ArrayList<QFilter> commonFilters = new ArrayList<QFilter>(10);
        Long orgId = this.calcResultParam.getOrgId();
        commonFilters.add(new QFilter("org", "=", (Object)orgId));
        Long costAccountId = this.calcResultParam.getCostAccountId();
        commonFilters.add(new QFilter("costaccount", "=", (Object)costAccountId));
        List<Long> costCenterIds = this.calcResultParam.getCostCenterIds();
        if (!CadEmptyUtils.isEmpty(costCenterIds)) {
            commonFilters.add(costCenterIds.size() == 1 ? new QFilter("costcenter", "=", (Object)costCenterIds.get(0)) : new QFilter("costcenter", "in", costCenterIds));
        }
        if (!CadEmptyUtils.isEmpty(periodIds = this.calcResultParam.getPeriodIds())) {
            commonFilters.add(new QFilter("period", "in", periodIds));
        }
        List<Long> costObjectIds = this.calcResultParam.getCostObjectIds();
        List<Long> materialIds = this.calcResultParam.getMaterialIds();
        List<String> proBillNumbers = this.calcResultParam.getProBillNumbers();
        if (costObjectIds != null || materialIds != null || !CadEmptyUtils.isEmpty(proBillNumbers)) {
            Set<Long> mainCostObjectIds = this.getMainCostobjectIds(commonFilters, costObjectIds, materialIds, proBillNumbers);
            this.calcResultParam.setCostObjectIds(new ArrayList<Long>(mainCostObjectIds));
            commonFilters.add(new QFilter("costobject", "in", mainCostObjectIds));
        }
        return commonFilters;
    }

    private Set<Long> getMainCostobjectIds(List<QFilter> commonFilters, List<Long> costObjectIds, List<Long> materialIds, List<String> proBillNumbers) {
        DataSet dataSet;
        ArrayList<QFilter> calResultFilter = new ArrayList<QFilter>(10);
        calResultFilter.addAll(commonFilters);
        HashSet<Long> ids = new HashSet<Long>(16);
        calResultFilter.add(new QFilter("entryentity.type", "=", (Object)"finalResult"));
        if (!CadEmptyUtils.isEmpty(proBillNumbers)) {
            calResultFilter.add(new QFilter("entryentity.relacostobject.srcbillnumber", "in", proBillNumbers));
        }
        if (costObjectIds != null && !costObjectIds.isEmpty()) {
            calResultFilter.add(new QFilter("entryentity.relacostobject", "in", costObjectIds));
        }
        if (materialIds != null && !materialIds.isEmpty()) {
            calResultFilter.add(new QFilter("entryentity.relacostobject.material", "in", materialIds));
        }
        if ((dataSet = QueryServiceHelper.queryDataSet((String)"costobject", (String)"aca_realtimecalcresult", (String)"costobject mainCostObjectId,entryentity.relacostobject costobjectId,entryentity.relacostobject.material materialId", (QFilter[])calResultFilter.toArray(new QFilter[0]), (String)"")) != null && dataSet.hasNext()) {
            for (Row row : dataSet) {
                ids.add(row.getLong("costobjectId"));
            }
        }
        return ids;
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        this.logger.info("\u914d\u7f6e\u5217\u662f\u5426\u663e\u793a");
        boolean showMatDetail = this.calcResultParam.isShowMatDetail();
        ReportColumnGroup pdStartGroup = new ReportColumnGroup();
        pdStartGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u671f\u521d\u6210\u672c", (String)"RealTimeCalcResultRptSourceCf_20", (String)"macc-aca-report", (Object[])new Object[0])));
        pdStartGroup.setFieldKey("pdStartGroup");
        ReportColumnGroup bqtrGroup = new ReportColumnGroup();
        bqtrGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6295\u5165\u6210\u672c", (String)"RealTimeCalcResultRptSourceCf_1", (String)"macc-aca-report", (Object[])new Object[0])));
        bqtrGroup.setFieldKey("bqtrGroup");
        ReportColumnGroup bqwgGroup = new ReportColumnGroup();
        bqwgGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u6210\u672c", (String)"RealTimeCalcResultRptSourceCf_2", (String)"macc-aca-report", (Object[])new Object[0])));
        bqwgGroup.setFieldKey("bqwgGroup");
        ReportColumnGroup qmzcGroup = new ReportColumnGroup();
        qmzcGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5b9e\u65f6\u5728\u5236\u6210\u672c", (String)"RealTimeCalcResultRptSourceCf_3", (String)"macc-aca-report", (Object[])new Object[0])));
        qmzcGroup.setFieldKey("qmzcGroup");
        Iterator<AbstractReportColumn> iterator = cols.iterator();
        while (iterator.hasNext()) {
            ReportColumn repCol = (ReportColumn)iterator.next();
            String fieldKey = repCol.getFieldKey();
            repCol.setNoDisplayScaleZero(false);
            if (this.hideProps.contains(fieldKey)) {
                repCol.setHide(true);
            }
            if (this.qczcProps.contains(fieldKey)) {
                pdStartGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (this.bqInProps.contains(fieldKey)) {
                bqtrGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (this.bqFinishProps.contains(fieldKey)) {
                bqwgGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (this.qmzcProps.contains(fieldKey)) {
                qmzcGroup.getChildren().add(repCol);
                iterator.remove();
            }
            String caption = repCol.getCaption().getLocaleValue();
            if (ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20\u7f16\u7801.\u540d\u79f0", (String)"RealTimeCalcResultRptSourceCf_4", (String)"macc-aca-report", (Object[])new Object[0]).equals(caption)) {
                repCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20\u540d\u79f0", (String)"RealTimeCalcResultRptSourceCf_5", (String)"macc-aca-report", (Object[])new Object[0])));
            }
            if (ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801.\u540d\u79f0", (String)"RealTimeCalcResultRptSourceCf_6", (String)"macc-aca-report", (Object[])new Object[0]).equals(caption)) {
                repCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u540d\u79f0", (String)"RealTimeCalcResultRptSourceCf_7", (String)"macc-aca-report", (Object[])new Object[0])));
            }
            if (ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7f16\u7801.\u6e90\u5355\u5355\u53f7", (String)"RealTimeCalcResultRptSourceCf_8", (String)"macc-aca-report", (Object[])new Object[0]).equals(caption)) {
                repCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5de5\u5355\u5355\u53f7", (String)"RealTimeCalcResultRptSourceCf_9", (String)"macc-aca-report", (Object[])new Object[0])));
            }
            if (ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7f16\u7801.\u6e90\u5355\u884c\u53f7", (String)"RealTimeCalcResultRptSourceCf_10", (String)"macc-aca-report", (Object[])new Object[0]).equals(caption)) {
                repCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5de5\u5355\u884c\u53f7", (String)"RealTimeCalcResultRptSourceCf_11", (String)"macc-aca-report", (Object[])new Object[0])));
            }
            if (ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7f16\u7801.\u4ea7\u54c1\u7ec4.\u540d\u79f0", (String)"RealTimeCalcResultRptSourceCf_12", (String)"macc-aca-report", (Object[])new Object[0]).equals(caption)) {
                repCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ea7\u54c1\u7ec4", (String)"RealTimeCalcResultRptSourceCf_13", (String)"macc-aca-report", (Object[])new Object[0])));
            }
            if (ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801", (String)"RealTimeCalcResultRptSourceCf_14", (String)"macc-aca-report", (Object[])new Object[0]).equals(caption)) {
                repCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"RealTimeCalcResultRptSourceCf_15", (String)"macc-aca-report", (Object[])new Object[0])));
            }
            if ("srcbillno".contains(fieldKey)) {
                repCol.setHyperlink(true);
            }
            if (!showMatDetail && fieldKey.contains("submat")) {
                iterator.remove();
            }
            Set showQtyCols = ctx.getShowQtyCols();
            Set showKeyCols = ctx.getShowKeyCols();
            if (showQtyCols.contains(fieldKey)) {
                repCol.setZeroShow(false);
            }
            if (showKeyCols.contains(fieldKey) || !fieldKey.contains("qty") || !showQtyCols.contains(fieldKey) || !this.calcResultParam.isShowMatDetail()) continue;
            repCol.setMeasureUnitField("unit");
        }
        cols.add((AbstractReportColumn)pdStartGroup);
        cols.add((AbstractReportColumn)bqtrGroup);
        cols.add((AbstractReportColumn)bqwgGroup);
        cols.add((AbstractReportColumn)qmzcGroup);
        return cols;
    }
}

