/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.realtime;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.aca.common.helper.AcaCostAccountHelper;
import kd.macc.aca.common.helper.MatBaseDataFilterHelper;
import kd.macc.aca.common.helper.PermItemCheckHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ReportUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;

public class RealTimeFinishCostRpt
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final String CAL_FPERIOD = "fperiod";
    private static final String[] CLEAR_P = new String[]{"period", "costcenter", "material", "sourcebillentry"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit numberText = (TextEdit)this.getView().getControl("mftbillno");
        numberText.addClickListener((ClickListener)this);
        BasedataEdit costCenter = (BasedataEdit)this.getControl("fcostcenter");
        costCenter.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                Object orgDy = RealTimeFinishCostRpt.this.getModel().getValue("org");
                if (orgDy == null) {
                    RealTimeFinishCostRpt.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"RealTimeFinishCostRpt_0", (String)"macc-aca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter[] costCenterFilter = RealTimeFinishCostRpt.this.getCostCenterFilter();
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter filterParameter = listShowParameter.getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                qFilters.addAll(Arrays.asList(costCenterFilter));
            }
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                Object orgDy = RealTimeFinishCostRpt.this.getModel().getValue("org");
                if (orgDy == null) {
                    RealTimeFinishCostRpt.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"RealTimeFinishCostRpt_0", (String)"macc-aca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter costAccountFilter = RealTimeFinishCostRpt.this.getCostAccountFilter();
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter filterParameter = listShowParameter.getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                qFilters.add(costAccountFilter);
            }
        });
        BasedataEdit calPeriod = (BasedataEdit)this.getControl(CAL_FPERIOD);
        calPeriod.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                Object costAccount = RealTimeFinishCostRpt.this.getModel().getValue("costaccount");
                if (costAccount == null) {
                    RealTimeFinishCostRpt.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"RealTimeFinishCostRpt_1", (String)"macc-aca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter periodFilter = RealTimeFinishCostRpt.this.getPeriodFilter();
                if (periodFilter != null) {
                    ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
                    List qFilters = listFilterParameter.getQFilters();
                    qFilters.add(periodFilter);
                }
            }
        });
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
                List qFilters = listFilterParameter.getQFilters();
                List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId()).getHasPermOrgs();
                List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"10");
                if (!CollectionUtils.isEmpty((Collection)permOrgIds) || !CollectionUtils.isEmpty((Collection)orgIds)) {
                    qFilters.add(new QFilter("id", "in", (Object)orgIds));
                }
            }
        });
        BasedataEdit products = (BasedataEdit)this.getControl("fmaterial");
        products.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject orgObj = this.getModel().getDataEntity().getDynamicObject("org");
            if (orgObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"RealTimeFinishCostRpt_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Long orgId = orgObj.getLong("id");
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(MatBaseDataFilterHelper.getBaseFilter(Collections.singletonList(orgId)));
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private void setOther() {
        this.getModel().setValue("costaccount", null);
        this.getModel().setValue("currency", null);
        this.getModel().setValue("fcostcenter", null);
        this.getModel().setValue("mftbillno", null);
        this.getModel().setValue("fmaterial", null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyname) {
            case "org": {
                this.setOther();
                this.setCostAccount(newValue);
                break;
            }
            case "costaccount": {
                this.setCurrencyAndPeriod(newValue);
            }
        }
    }

    private void setCostAccount() {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Long mainBookId = CostAccountHelper.getCostAccountByAccoutOrg((Long)((DynamicObject)org).getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
        if (mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
        }
        this.getView().updateView("costaccount");
    }

    private void setPeriodAndCurrency() {
        DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
        if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
            this.getModel().setValue("currency", null);
        } else {
            Long costAccountId = costAccountObj.getLong("id");
            DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
            if (curPeriod == null) {
                this.getModel().setValue("currency", null);
            } else {
                this.getModel().setValue("currency", (Object)CurrencyHelper.getCurrency((DynamicObject)costAccountObj));
                this.getModel().setValue(CAL_FPERIOD, (Object)new Object[]{curPeriod.getLong("id")});
            }
        }
    }

    private void setOrg() {
        if (this.getModel().getValue("org") == null) {
            Long orgId = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
            if (!isAccounting) {
                return;
            }
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (orgIds.contains(orgId)) {
                this.getModel().setValue("org", (Object)orgId);
                this.getView().updateView("org");
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setOrg();
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.setCostAccount();
            this.setPeriodAndCurrency();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ReportShowParameter reportShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        String customParams = (String)reportShowParameter.getCustomParams().get("custparam");
        if (customParams != null && !CadEmptyUtils.isEmpty((String)customParams)) {
            JSONObject calcParamJs = JSONObject.fromObject((Object)customParams);
            this.assignQueryValAndSearch(calcParamJs);
            return;
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        if ("mftbillno".equals(fieldKey)) {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"RealTimeFinishCostRpt_0", (String)"macc-aca-report", (Object[])new Object[0]));
                return;
            }
            this.showMftBillNos(fieldKey);
        }
    }

    private void showMftBillNos(String actionId) {
        IReportView view = this.getView();
        Object value = this.getModel().getValue(actionId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setTargetKey(actionId);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("params", value);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("sca_billnos");
        parameter.setCaption(ResManager.loadKDString((String)"\u5165\u5e93\u5355\u636e\u7f16\u53f7", (String)"RealTimeFinishCostRpt_8", (String)"macc-aca-report", (Object[])new Object[0]));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(parameter);
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        if (evt.getRowData() != null && evt.getRowData().containsProperty("entrybizorgname")) {
            String entryBizOrgName = evt.getRowData().getString("entrybizorgname");
            if (ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"RealTimeFinishCostRpt_2", (String)"macc-aca-report", (Object[])new Object[0]), (String)"macc-aca-report").equals(entryBizOrgName) || ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u603b\u8ba1", (String)"RealTimeFinishCostRpt_3", (String)"macc-aca-report", (Object[])new Object[0]), (String)"macc-aca-report").equals(entryBizOrgName)) {
                evt.getNoLinkKey().add(((ReportColumn)evt.getSource()).getFieldKey());
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("mftbillno".equals(e.getActionId()) && e.getReturnData() != null && e.getReturnData() instanceof Map) {
            Map returnData = (Map)e.getReturnData();
            String value = String.valueOf(returnData.get("content"));
            String operateType = String.valueOf(returnData.get("operateType"));
            if ("btnok".equals(operateType)) {
                value = value.replaceAll("\n", ",");
                this.getModel().setValue("mftbillno", (Object)value);
            }
        }
    }

    private void assignQueryValAndSearch(JSONObject customParams) {
        Object costAccount;
        this.getModel().beginInit();
        Object org = customParams.get("orgId");
        if (org != null) {
            this.getModel().setValue("org", org);
        }
        if ((costAccount = customParams.get("costAccountId")) != null) {
            this.getModel().setValue("costaccount", costAccount);
        }
        this.setCurrencyAndPeriod(this.getModel().getDataEntity().getDynamicObject("costaccount"));
        this.getView().updateView("reportfilterap");
        this.getModel().endInit();
        ReportFilter reportFilter = (ReportFilter)this.getControl("reportfilterap");
        reportFilter.search();
    }

    public void afterDoOperation(AfterDoOperationEventArgs evts) {
        String key;
        super.afterDoOperation(evts);
        switch (key = evts.getOperateKey()) {
            case "reset": {
                this.getModel().setValue(CAL_FPERIOD, null);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        ArrayList pros = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "currency", CAL_FPERIOD});
        boolean isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)pros);
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"RealTimeFinishCostRpt_4", (String)"macc-aca-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        Object currency = this.getModel().getValue("currency");
        for (DynamicObject rowDatum : rowData) {
            String lineType = rowDatum.getString("linetype");
            BigDecimal qty = rowDatum.getBigDecimal("qty");
            BigDecimal amount = rowDatum.getBigDecimal("amount");
            BigDecimal price = rowDatum.getBigDecimal("price");
            if ((price == null || price.compareTo(BigDecimal.ZERO) <= 0) && qty != null && qty.compareTo(BigDecimal.ZERO) != 0 && amount != null) {
                rowDatum.set("price", (Object)amount.divide(qty, 23, 4));
            }
            rowDatum.set("currencyfield", currency);
            if (!"2".equals(lineType)) continue;
            DynamicObject subMaterial = rowDatum.getDynamicObject("submaterial");
            String matResourceName = "";
            if (subMaterial != null) {
                matResourceName = subMaterial.getString("name");
            } else {
                DynamicObject subresource = rowDatum.getDynamicObject("subresource");
                if (subresource != null) {
                    matResourceName = subresource.getString("name");
                }
            }
            rowDatum.set("matresourcename", (Object)matResourceName);
            rowDatum.set("billrow", (Object)"");
            rowDatum.set("sourcebillrow", (Object)"");
        }
        ReportUtils.clearFileNameValue((String[])CLEAR_P, (DynamicObjectCollection)rowData, (String[])CLEAR_P);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        if ("exportexcel".equals(operateKey) && !PermItemCheckHelper.isPerm((String)"aca_realtimefinishcostrpt", (String)"47150e89000000ac", (Long)org.getLong("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5b9e\u65f6\u6210\u672c\u5b8c\u5de5\u5165\u5e93\u6210\u672c\u8868\u201d\u7684\u201c\u5f15\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RealTimeFinishCostRpt_5", (String)"macc-aca-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    private void setCostAccount(Object org) {
        if (org == null) {
            return;
        }
        DynamicObject orgDO = (DynamicObject)org;
        Long mainBookId = AcaCostAccountHelper.getCostAccountByAccoutOrg((Long)orgDO.getLong("id"), (String)"aca");
        if (mainBookId != null && mainBookId != 0L) {
            boolean isnit = StartCostHelper.isInit((Long)mainBookId, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
            if (isnit) {
                this.getModel().setValue("costaccount", (Object)mainBookId);
            }
        } else {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue(CAL_FPERIOD, null);
        }
    }

    private void setCurrencyAndPeriod(Object costAccount) {
        if (costAccount == null) {
            return;
        }
        DynamicObject costAccountDO = (DynamicObject)costAccount;
        Long currency = CalcRptHelper.getCurrency((DynamicObject)costAccountDO);
        this.getModel().setValue("currency", (Object)currency);
        this.setPeriod();
    }

    private void setPeriod() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        DynamicObject costaccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        if (org == null || costaccount == null) {
            return;
        }
        long orgId = org.getLong("id");
        long costaccountId = costaccount.getLong("id");
        Long currPeriod = CalcRptHelper.getCurrPeriod((Long)orgId, (Long)costaccountId);
        if (currPeriod != null && currPeriod != 0L) {
            this.getModel().setValue(CAL_FPERIOD, (Object)new Object[]{currPeriod});
        }
    }

    private QFilter[] getCostCenterFilter() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        QFilter orgFilter = new QFilter("accountorg", "=", org.getPkValue());
        QFilter orgdutyFilter = new QFilter("orgduty", "=", (Object)4L);
        orgdutyFilter.and("enable", "=", (Object)"1");
        return new QFilter[]{orgFilter, orgdutyFilter};
    }

    private QFilter getPeriodFilter() {
        DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null || costAccount == null) {
            return null;
        }
        long orgId = org.getLong("id");
        long costAccountId = costAccount.getLong("id");
        QFilter periodFilter = StartCostHelper.getPeriodTypeFilter((String)"aca", (Long)orgId, (Long)costAccountId);
        return periodFilter;
    }

    private QFilter getCostAccountFilter() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        List orgUseCostAccountIds = CostAccountHelper.getOrgStdCostAccount((Long)((Long)org.getPkValue()), (String)"aca");
        QFilter costAccountFilter = new QFilter("id", "in", (Object)orgUseCostAccountIds.toArray());
        return costAccountFilter;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"RealTimeFinishCostRpt_6", (String)"macc-aca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u5b9e\u65f6\u6210\u672c\u5b8c\u5de5\u5165\u5e93\u6210\u672c\u67e5\u8be2", (String)"RealTimeFinishCostRpt_7", (String)"macc-aca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"aca_realtimefinishcostrpt", (IDataModel)this.getModel());
    }
}

