/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.wipcostcheck;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class TerminalWipMatCheckQueryPlugin
extends AbstractReportListDataPlugin {
    private static final String[] addNullSmallFile = new String[]{"orgcol", "periodcol", "costaccountcol", "costcenternum", "costcentername", "srcbillnumber", "srcbillrow", "material", "matversion", "auxpty", "costobject", "source", "entryid"};
    private static final String[] addNullSumFile = new String[]{"orgcol", "periodcol", "costaccountcol", "costcenter", "costcenternum", "costcentername", "srcbillnumber", "srcbillrow", "material", "matversion", "auxpty", "costobject", "source", "entryid", "costaccount"};
    private static final String[] groupEntryIdFile = new String[]{"costaccount", "costcenter", "unit", "checktype", "entryid"};
    private static final String[] groupCenterFile = new String[]{"costaccount", "costcenter", "unit", "checktype"};
    private static final String[] groupCostAccountFile = new String[]{"costaccount", "unit", "checktype"};
    private static final String[] addNullCostAccountFile = new String[]{"orgcol", "periodcol", "costaccountcol", "costcenter", "costcenternum", "costcentername", "srcbillnumber", "srcbillrow", "material", "matversion", "auxpty", "costobject", "source", "entryid"};

    public DataSet query(ReportQueryParam param, Object object) throws Throwable {
        Object entryids = param.getCustomParam().get("entryids");
        List<Object> queryFilter = new ArrayList<QFilter>(10);
        if (entryids != null) {
            queryFilter.add(new QFilter("entryid", "in", entryids));
        } else {
            FilterInfo filterInfo = param.getFilter();
            queryFilter = this.getQueryFilter(filterInfo);
            Object ids = param.getCustomParam().get("ids");
            if (ids != null) {
                DataSet rows = QueryServiceHelper.queryDataSet((String)"getentryIds", (String)"aca_terminalwipmatcheck", (String)"entryentity.id as entryid", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, null);
                HashSet<Long> entryIdsSet = new HashSet<Long>();
                while (rows.hasNext()) {
                    Row row = rows.next();
                    entryIdsSet.add(row.getLong("entryid"));
                }
                queryFilter.add(new QFilter("entryid", "in", entryIdsSet));
            }
        }
        String selectSql = this.getQuerySql();
        DataSet allocDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("query"), (String)"aca_terminalwipmatallco", (String)selectSql, (QFilter[])queryFilter.toArray(new QFilter[0]), null);
        DataSet smallSumDataSet = allocDataSet.groupBy(groupEntryIdFile).avg("qty").avg("amount").sum("calqty").finish().groupBy(groupCenterFile).sum("qty").sum("amount").sum("calqty").finish();
        DataSet costAccountDataSet = smallSumDataSet.groupBy(groupCostAccountFile).avg("qty").avg("amount").sum("calqty").finish().addField("2", "orderby").addNullField(addNullCostAccountFile);
        smallSumDataSet = smallSumDataSet.addField("1", "orderby").addNullField(addNullSmallFile);
        DataSet sumLineDataSet = smallSumDataSet.groupBy(new String[]{"unit", "checktype"}).sum("qty").sum("amount").sum("calqty").finish().addField("3", "orderby").addNullField(addNullSumFile);
        String[] fieldNames = allocDataSet.getRowMeta().getFieldNames();
        allocDataSet = allocDataSet.union(new DataSet[]{smallSumDataSet.select(fieldNames), costAccountDataSet.select(fieldNames)}).orderBy(new String[]{"costaccount", "costcenter desc", "orderby", "srcbillnumber", "srcbillrow", "costobject", "unit"}).union(sumLineDataSet.select(fieldNames));
        return allocDataSet;
    }

    private String getQuerySql() {
        return "org.name as orgcol,period.name as periodcol,costaccount,costaccount.name as costaccountcol,costcenter,costcenter.number as costcenternum,costcenter.name as costcentername,srcbillnumber,srcbillrow,material,matversion,auxpty,unit,qty,amount,costobject,calqty,source,entryid,checktype,0 as orderby";
    }

    protected String getAlgoKey(String methodName) {
        return ((Object)((Object)this)).getClass().getName() + "." + methodName;
    }

    private List<QFilter> getQueryFilter(FilterInfo filterInfo) {
        DynamicObjectCollection costobjectf;
        DynamicObjectCollection materials;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        DynamicObject accountorg = filterInfo.getDynamicObject("accountorg");
        qFilters.add(new QFilter("org", "=", accountorg.getPkValue()));
        DynamicObject costaccount = filterInfo.getDynamicObject("costaccount");
        qFilters.add(new QFilter("costaccount", "=", costaccount.getPkValue()));
        DynamicObject period = filterInfo.getDynamicObject("period");
        qFilters.add(new QFilter("period", "=", period.getPkValue()));
        DynamicObjectCollection costCenters = filterInfo.getDynamicObjectCollection("costcenter");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costCenters)) {
            List costCenterIds = costCenters.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            qFilters.add(new QFilter("costcenter", "in", costCenterIds));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(materials = filterInfo.getDynamicObjectCollection("materials")))) {
            List materialIds = materials.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            qFilters.add(new QFilter("material", "in", materialIds));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(costobjectf = filterInfo.getDynamicObjectCollection("costobjectf")))) {
            List costobjectIds = costobjectf.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            qFilters.add(new QFilter("costobject", "in", costobjectIds));
        }
        return qFilters;
    }
}

