/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.common.helper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.operate.MutexHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.CostTypeHelper;

public class AcaCalcMutexHelper {
    public static final String ENTITY_ACA_TERMINALCALCWIZARDS = "aca_TerminalCalcWizards";
    private static final Map<String, List<String>> typeMap = new HashMap<String, List<String>>();
    public static final String PDEND = "pdend";

    public static void releaseMuteInFinally(String type, boolean enableMulFactory, Long acctId, String lockStr) {
        if (enableMulFactory) {
            AcaCalcMutexHelper.releaseXMutex(type, String.valueOf(acctId).hashCode());
            AcaCalcMutexHelper.releaseXMutex(type, lockStr.hashCode());
        } else {
            AcaCalcMutexHelper.releaseXMutex(type, acctId);
        }
    }

    public static String checkAndRequireXMutex(String type, Object lockStr) {
        String checkErr = null;
        Iterator<String> iterator = typeMap.keySet().iterator();
        while (iterator.hasNext()) {
            String typeKey;
            switch (typeKey = iterator.next()) {
                case "pdend": {
                    checkErr = AcaCalcMutexHelper.enableReentrant(PDEND, lockStr);
                }
            }
            if (!StringUtils.isNotEmpty(checkErr)) continue;
            return checkErr;
        }
        if (!AcaCalcMutexHelper.requireXMutex(type, lockStr)) {
            return AcaCalcMutexHelper.getErrTips(type);
        }
        return null;
    }

    public static synchronized boolean releaseXMutex(String type, Object uniqueKey) {
        return MutexHelper.release((String)typeMap.get(type).get(0), (String)typeMap.get(type).get(1), (String)String.valueOf(uniqueKey));
    }

    public static synchronized String enableReentrant(String type, Object uniqueKey) {
        if (!MutexHelper.enableReentrant((String)typeMap.get(type).get(0), (Object)uniqueKey, (String)typeMap.get(type).get(1))) {
            return AcaCalcMutexHelper.getErrTips(type);
        }
        return null;
    }

    public static synchronized String enableReentrant(String type, Set<Long> costTypeIds) {
        for (Long costTypeId : costTypeIds) {
            if (MutexHelper.enableReentrant((String)typeMap.get(type).get(0), (Object)costTypeId, (String)typeMap.get(type).get(1))) continue;
            String tips = AcaCalcMutexHelper.getErrTips(type);
            return String.format(tips, AcaCalcMutexHelper.getName(Long.parseLong(((Object)costTypeId).toString())));
        }
        return null;
    }

    private static String getName(Long id) {
        DynamicObject dy = CostTypeHelper.getCostType((Long)id, (String)"name");
        if (dy == null) {
            QFilter filter = new QFilter("id", "=", (Object)id);
            dy = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (String)"name", (QFilter[])new QFilter[]{filter});
        }
        return dy.getLocaleString("name").getLocaleValue();
    }

    public static String getErrTips(String type) {
        switch (type) {
            case "pdend": {
                return ResManager.loadKDString((String)"\u201c%s\u201d\u6b63\u5728\u8fdb\u884c\u671f\u672b\u5728\u4ea7\u54c1\u8ba1\u7b97\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"AcaCalcMutexHelper_0", (String)"macc-aca-common", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static String getCostTypeIdBy(Object acctId) {
        QFilter filter = new QFilter("id", "=", acctId);
        DynamicObject acct = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"costobject", (QFilter[])new QFilter[]{filter});
        return acct.getString("costobject");
    }

    public static String checkAndRequireXMutexAll(String type, Set<Long> costAcctIds) {
        String checkErr = null;
        Iterator<String> iterator = typeMap.keySet().iterator();
        while (iterator.hasNext()) {
            String typeKey;
            switch (typeKey = iterator.next()) {
                case "pdend": {
                    checkErr = AcaCalcMutexHelper.enableReentrantAll(PDEND, costAcctIds);
                }
            }
            if (!StringUtils.isNotEmpty(checkErr)) continue;
            return checkErr;
        }
        if (!AcaCalcMutexHelper.requireXMutex(type, costAcctIds)) {
            return AcaCalcMutexHelper.getErrTips(type);
        }
        return null;
    }

    private static synchronized boolean requireXMutex(String type, Object costTypeId) {
        StringBuilder errMsg = new StringBuilder();
        return MutexHelper.require((String)typeMap.get(type).get(0), (Object)costTypeId, (String)typeMap.get(type).get(1), (boolean)true, (StringBuilder)errMsg);
    }

    private static synchronized boolean requireXMutex(String type, Set<Long> costTypeIds) {
        StringBuilder errMsg = new StringBuilder();
        boolean allLock = true;
        for (Long costObject : costTypeIds) {
            allLock = MutexHelper.require((String)typeMap.get(type).get(0), (Object)costObject, (String)typeMap.get(type).get(1), (boolean)true, (StringBuilder)errMsg);
            if (allLock) continue;
            break;
        }
        if (!allLock) {
            AcaCalcMutexHelper.releaseXMutex(type, costTypeIds);
        }
        return allLock;
    }

    public static synchronized String enableReentrantAll(String type, Set<Long> costAcctIds) {
        for (Long costAcctId : costAcctIds) {
            if (!MutexHelper.enableReentrant((String)typeMap.get(type).get(0), (Object)costAcctId, (String)typeMap.get(type).get(1))) {
                String tips = AcaCalcMutexHelper.getErrTips(type);
                return String.format(tips, AcaCalcMutexHelper.getName(Long.parseLong(costAcctId.toString())));
            }
            if (MutexHelper.enableReentrant((String)typeMap.get(type).get(0), (Object)String.valueOf(costAcctId).hashCode(), (String)typeMap.get(type).get(1))) continue;
            String tips = AcaCalcMutexHelper.getErrTips(type);
            return String.format(tips, AcaCalcMutexHelper.getName(Long.parseLong(costAcctId.toString())));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkMutexAndLock(String type, boolean enableMulFactory, Long acctId, String lockStr) {
        boolean releaseFlag = true;
        String lockErr = AcaCalcMutexHelper.checkAndRequireXMutex(type, acctId);
        try {
            if (StringUtils.isNotEmpty((String)lockErr)) {
                releaseFlag = false;
                String string = lockErr;
                return string;
            }
            if (enableMulFactory) {
                lockErr = AcaCalcMutexHelper.checkAndRequireXMutex(type, String.valueOf(acctId).hashCode());
                if (StringUtils.isNotEmpty((String)lockErr)) {
                    lockErr = AcaCalcMutexHelper.checkAndRequireXMutex(type, lockStr.hashCode());
                    if (StringUtils.isNotEmpty((String)lockErr)) {
                        String string = lockErr;
                        return string;
                    }
                } else {
                    AcaCalcMutexHelper.checkAndRequireXMutex(type, lockStr.hashCode());
                }
            }
        }
        finally {
            if (enableMulFactory && releaseFlag) {
                AcaCalcMutexHelper.releaseXMutex(type, acctId);
            }
        }
        return null;
    }

    static {
        typeMap.put(PDEND, Arrays.asList(ENTITY_ACA_TERMINALCALCWIZARDS, "calculate"));
    }
}

