/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class VoucherHelper {
    private static final Log logger = LogFactory.getLog(VoucherHelper.class);

    public static List<Object> getExistVoucherBillIds(List<Long> sourceIds) {
        QFilter filter = new QFilter("bizbillid", "in", sourceIds);
        filter.and(new QFilter("isfivoucher", "=", (Object)Boolean.TRUE));
        DynamicObjectCollection costRecords = QueryServiceHelper.query((String)"cal_costrecord_subentity", (String)"bizbillid", (QFilter[])new QFilter[]{filter});
        return DynamicObjectHelper.getFieldList(costRecords, "bizbillid");
    }

    public static String writeBackVoucherToCostRecord(DataSet voucherParamDataSet, Long costAccountId, String operateType) {
        String resStr = "";
        if (voucherParamDataSet.isEmpty()) {
            return resStr;
        }
        ArrayList paramList = new ArrayList(10);
        while (voucherParamDataSet.hasNext()) {
            Row row = voucherParamDataSet.next();
            String billno = row.getString("billno");
            Long bizbillId = row.getLong("bizbillid");
            Long voucherId = row.getLong("voucherid");
            String voucherNum = row.getString("vouchernum");
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("billNo", billno);
            map.put("bizBillId", String.valueOf(bizbillId));
            map.put("voucherId", String.valueOf(voucherId));
            map.put("voucherNum", voucherNum);
            paramList.add(map);
        }
        try {
            logger.info("\u5b58\u8d27\u51ed\u8bc1\u53cd\u5199\u63a5\u53e3\uff0c\u5165\u53c2\uff1a\u64cd\u4f5c\u7c7b\u578b\uff1a{}\uff1b\u6210\u672c\u8d26\u7c3f\uff1a{}\uff0c\u53c2\u6570\u4e2a\u6570\uff1a{}", new Object[]{operateType, costAccountId, paramList.size()});
            List resultMap = (List)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"AcaVoucherSynService", (String)"voucherSynProcess", (Object[])new Object[]{operateType, costAccountId, paramList});
            logger.info("\u5b58\u8d27\u51ed\u8bc1\u53cd\u5199\u63a5\u53e3\uff0c\u8fd4\u56de\u7684\u7ed3\u679c\u4e2a\u6570\uff1a{}", (Object)resultMap.size());
            if (CadEmptyUtils.isEmpty((List)resultMap)) {
                return resStr;
            }
            for (Map resMap : resultMap) {
                String status = (String)resMap.get("status");
                if ("1".equals(status)) continue;
                if (CadEmptyUtils.isEmpty((String)resStr)) {
                    resStr = (String)resMap.get("msg");
                    continue;
                }
                resStr = resStr + "," + (String)resMap.get("msg");
            }
        }
        catch (Exception e) {
            logger.info("\u51ed\u8bc1\u53cd\u5199\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5931\u8d25\u3002\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e);
        }
        return resStr;
    }

    public static DataSet getVoucherParamDataSet(String entity, Set<Long> ids, String opType) {
        QFilter filter = new QFilter("id", "in", ids);
        HashSet<Long> resIds = new HashSet<Long>(10);
        HashSet<String> voucherNums = new HashSet<String>(10);
        DataSet dataSet = null;
        switch (entity) {
            case "aca_finishcosttranfer": {
                dataSet = QueryServiceHelper.queryDataSet((String)"getFinishCostTransBills", (String)entity, (String)"billno,org,period,costaccount,sourcebill bizbillid,vouchernum", (QFilter[])new QFilter[]{filter}, null);
                DataSet copyDataSet = dataSet.copy();
                while (copyDataSet.hasNext()) {
                    Row row = copyDataSet.next();
                    Long sourcecalid = row.getLong("bizbillid");
                    String vouchernum = row.getString("vouchernum");
                    if (!CadEmptyUtils.isEmpty((Long)sourcecalid)) {
                        resIds.add(sourcecalid);
                    }
                    if (CadEmptyUtils.isEmpty((String)vouchernum)) continue;
                    voucherNums.add(vouchernum);
                }
                logger.info("\u5b8c\u5de5\u6210\u672c\u7ed3\u8f6c\u5355-\u6838\u7b97\u6210\u672c\u8bb0\u5f55id\u96c6\u5408\uff1a{}", (Object)SerializationUtils.toJsonString(resIds));
                logger.info("\u5b8c\u5de5\u6210\u672c\u7ed3\u8f6c\u5355-\u751f\u6210\u51ed\u8bc1\u7684\u51ed\u8bc1\u53f7\uff1a{}", (Object)SerializationUtils.toJsonString(voucherNums));
                if ("0".equals(opType)) {
                    filter = new QFilter("billno", "in", voucherNums);
                    DataSet voucherDataSet = QueryServiceHelper.queryDataSet((String)"getFinishCostTransBills", (String)"gl_voucher", (String)"id as voucherid,billno", (QFilter[])new QFilter[]{filter}, null);
                    dataSet = dataSet.join(voucherDataSet, JoinType.INNER).on("vouchernum", "billno").select(dataSet.getRowMeta().getFieldNames(), new String[]{"voucherid"}).finish();
                    break;
                }
                dataSet = dataSet.addField("0L", "voucherid");
                break;
            }
            case "aca_matalloc": {
                dataSet = QueryServiceHelper.queryDataSet((String)"getVoucherParamDataSet", (String)entity, (String)"billno,org,costaccount,period,sourcebillid bizbillid,vouchernum", (QFilter[])new QFilter[]{filter}, null);
                DataSet copyDataSet = dataSet.copy();
                while (copyDataSet.hasNext()) {
                    Row row = copyDataSet.next();
                    Long sourcebillid = row.getLong("bizbillid");
                    String vouchernum = row.getString("vouchernum");
                    if (!CadEmptyUtils.isEmpty((Long)sourcebillid)) {
                        resIds.add(sourcebillid);
                    }
                    if (CadEmptyUtils.isEmpty((String)vouchernum)) continue;
                    voucherNums.add(vouchernum);
                }
                logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5355-\u6838\u7b97\u6210\u672c\u8bb0\u5f55id\u96c6\u5408\uff1a{}", (Object)SerializationUtils.toJsonString(resIds));
                logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5355-\u751f\u6210\u51ed\u8bc1\u7684\u51ed\u8bc1\u53f7\uff1a{}", (Object)SerializationUtils.toJsonString(voucherNums));
                if ("0".equals(opType)) {
                    filter = new QFilter("billno", "in", voucherNums);
                    DataSet voucherDataSet = QueryServiceHelper.queryDataSet((String)"getVoucherParamDataSet", (String)"gl_voucher", (String)"id as voucherid,billno", (QFilter[])new QFilter[]{filter}, null);
                    dataSet = dataSet.join(voucherDataSet, JoinType.INNER).on("vouchernum", "billno").select(dataSet.getRowMeta().getFieldNames(), new String[]{"voucherid"}).finish();
                    break;
                }
                dataSet = dataSet.addField("0L", "voucherid");
                break;
            }
        }
        if (dataSet == null) {
            return null;
        }
        return dataSet.distinct();
    }

    public static List<String> lock(List<Long> sourceIds) {
        ArrayList<String> successLockKeys = new ArrayList<String>(10);
        for (Long sourceId : sourceIds) {
            String lockField = "Voucher@" + sourceId;
            DLock lock = DLock.create((String)lockField, (String)ResManager.loadKDString((String)"\u6210\u672c-\u751f\u6210\u51ed\u8bc1\u9501", (String)"VoucherHelper_0", (String)"macc-aca-common", (Object[])new Object[0]));
            boolean isLocked = lock.tryLock();
            if (!isLocked) continue;
            successLockKeys.add(lockField);
        }
        return successLockKeys;
    }

    public static void unLock(List<String> successLockKeys) {
        if (CadEmptyUtils.isEmpty(successLockKeys)) {
            return;
        }
        for (String successLockKey : successLockKeys) {
            DLock lock = DLock.create((String)successLockKey, (String)ResManager.loadKDString((String)"\u6210\u672c-\u751f\u6210\u51ed\u8bc1\u9501", (String)"VoucherHelper_0", (String)"macc-aca-common", (Object[])new Object[0]));
            if (lock == null) continue;
            lock.close();
        }
    }
}

