/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.mservice.impl;

import java.util.HashMap;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.realtime.RealTimeCostCalcArgs;
import kd.macc.aca.algox.realtime.RealTimeCostCalcEngine;
import kd.macc.aca.algox.realtime.RealTimeCostCalcResult;
import kd.macc.aca.mservice.RealTimeCalcService;

public class RealTimeCalcServiceImpl
implements RealTimeCalcService {
    private static final Log logger = LogFactory.getLog(RealTimeCalcServiceImpl.class);

    public String actRealTimeCalc(String actCostCalcArgs) {
        long start = System.currentTimeMillis();
        RealTimeCostCalcArgs args = RealTimeCostCalcArgs.fromJSONString((String)actCostCalcArgs);
        RealTimeCostCalcEngine costCalcEngine = new RealTimeCostCalcEngine();
        RealTimeCostCalcResult calcResult = null;
        try {
            calcResult = costCalcEngine.actRealTimeCalc(args);
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
        }
        logger.info("\u5b9e\u65f6\u6210\u672c\u8ba1\u7b97\u603b\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        return this.buildResultMap(calcResult);
    }

    private String buildResultMap(RealTimeCostCalcResult calcResult) {
        String result = "";
        if (calcResult == null) {
            return result;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        boolean isSuccess = calcResult.isAllSuccess();
        if (isSuccess) {
            QFilter idQFilter = new QFilter("id", "=", (Object)calcResult.getCalcLogId());
            idQFilter.and("entryentity.status", "=", (Object)"2");
            boolean isExistsErr = QueryServiceHelper.exists((String)"aca_realtimecalclog", (QFilter[])idQFilter.toArray());
            if (isExistsErr) {
                isSuccess = false;
            }
        }
        resultMap.put("isSuccess", isSuccess);
        resultMap.put("errorMsg", calcResult.getErrorTip());
        resultMap.put("successMsg", calcResult.getSuccessTip());
        resultMap.put("successSize", calcResult.getSuccessSize());
        resultMap.put("calcLogId", calcResult.getCalcLogId());
        return SerializationUtils.toJsonString(resultMap);
    }
}

