/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.aca.formplugin.base.BaseListPlugin;
import kd.macc.cad.common.helper.ClickEventHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public abstract class BaseOrgAndCostCenterFilterList
extends BaseListPlugin {
    protected static final String COSTCENTER = "costcenter";
    protected static final String ACCTORG = "org";
    protected static final String MANUORG = "manuorg";
    private volatile boolean orgClick = false;

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initClickEvent(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            ComboItem item;
            CommonFilterColumn commonFilterColumn;
            String fieldName;
            long currentOrgId;
            boolean isaccount;
            String orgId = this.getPageCache().get(this.ORG_FIELD);
            if (StringUtils.isEmpty((String)orgId) && CadEmptyUtils.isEmpty((String)(orgId = this.getCustomParam(ACCTORG))) && (isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)(currentOrgId = RequestContext.getOrCreate().getOrgId()), (String)"10"))) {
                orgId = String.valueOf(currentOrgId);
            }
            if ((fieldName = (commonFilterColumn = (CommonFilterColumn)filterColumn).getFieldName()).startsWith(String.format("%s.", this.ORG_FIELD))) {
                List listcomitem = commonFilterColumn.getComboItems();
                listcomitem.clear();
                List<ComboItem> acctOrgs = this.getORGComboItemList();
                if (!CollectionUtils.isEmpty(acctOrgs)) {
                    commonFilterColumn.setComboItems(acctOrgs);
                    item = acctOrgs.get(0);
                    String string = orgId = StringUtils.isEmpty((String)orgId) ? item.getValue() : orgId;
                }
                if (StringUtils.isNotEmpty((String)orgId)) {
                    commonFilterColumn.setDefaultValue(orgId);
                    this.getPageCache().put(this.ORG_FIELD, orgId);
                    this.getPageCache().remove(COSTCENTER);
                } else {
                    this.getPageCache().put(this.ORG_FIELD, "0");
                }
            }
            if (!fieldName.startsWith("costcenter.")) continue;
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            List<ComboItem> comboItems = this.getCostCenterComboItemList(orgId);
            if (CollectionUtils.isEmpty(comboItems)) continue;
            commonFilterColumn.setComboItems(comboItems);
            item = comboItems.get(0);
            String defVal = ACCTORG.equals(this.ORG_FIELD) ? "" : item.getValue();
            commonFilterColumn.setDefaultValue(defVal);
            this.getPageCache().put(COSTCENTER, defVal);
        }
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs e) {
        Map filterValues;
        List customfilter;
        super.filterContainerSearchClick(e);
        if (this.orgClick) {
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"costcenter.id");
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"costaccount.id");
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"period.id");
        }
        if ((customfilter = (List)(filterValues = e.getSearchClickEvent().getFilterValues()).get("customfilter")) == null || customfilter.isEmpty()) {
            return;
        }
        for (int i = 0; i < customfilter.size(); ++i) {
            List vals;
            Map map = (Map)customfilter.get(i);
            List names = (List)map.get("FieldName");
            if (String.format("%s.id", this.ORG_FIELD).equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (vals == null || vals.isEmpty()) continue;
                String orgId = String.valueOf(vals.get(0));
                this.getPageCache().put(this.ORG_FIELD, StringUtils.isEmpty((String)orgId) ? "0" : orgId);
                this.getPageCache().remove(COSTCENTER);
                this.filterContainerInit(this.filterContainerInitArgs);
            }
            if ("costcenter.id".equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (vals == null || vals.isEmpty()) continue;
                this.getPageCache().put(COSTCENTER, String.valueOf(vals.get(0)));
            }
            if (!"manuorg.id".equals(String.valueOf(names.get(0))) || (vals = (List)map.get("Value")) == null || vals.isEmpty()) continue;
            this.getPageCache().put(MANUORG, String.valueOf(vals.get(0)));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        List<ComboItem> acctOrgs;
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith(String.format("%s.", this.ORG_FIELD)) && CadEmptyUtils.isEmpty(acctOrgs = this.getORGComboItemList())) {
            args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
        }
        if (fieldName.startsWith("costcenter.")) {
            long currentOrgId;
            boolean isaccount;
            String orgId = this.getPageCache().get(this.ORG_FIELD);
            if (StringUtils.isEmpty((String)orgId) && CadEmptyUtils.isEmpty((String)(orgId = this.getCustomParam(ACCTORG))) && (isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)(currentOrgId = RequestContext.getOrCreate().getOrgId()), (String)"10"))) {
                orgId = String.valueOf(currentOrgId);
            }
            if (CadEmptyUtils.isEmpty((String)orgId)) {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            } else {
                QFilter filter = new QFilter("accountorg", "=", (Object)Long.valueOf(orgId));
                filter.and("enable", "=", (Object)Boolean.TRUE);
                filter.and("orgduty", "=", (Object)4L);
                args.getQfilters().add(filter);
            }
        } else if (fieldName.startsWith("period")) {
            DynamicObject sysCtrlEntity;
            args.getQfilters().add(new QFilter("isadjustperiod", "=", (Object)false));
            String costAccoutId = this.getPageCache().get("costaccount");
            if (!CadEmptyUtils.isEmpty((String)costAccoutId) && (sysCtrlEntity = this.getPeriodSetDynamicObject(Long.valueOf(costAccoutId))) != null) {
                Long startPeriod = sysCtrlEntity.getLong("startperiod");
                QFilter idQf = new QFilter("id", ">=", (Object)startPeriod);
                idQf.and("periodtype", "=", (Object)sysCtrlEntity.getLong("periodtype"));
                args.getQfilters().add(idQf);
            }
        }
    }

    private DynamicObject getPeriodSetDynamicObject(Long costaccountId) {
        QFilter costaccountFilter = new QFilter("entry.costaccount", "=", (Object)costaccountId);
        return QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"id,entry.startperiod startperiod,entry.currentperiod currentperiod,entry.calpolicy.periodtype periodtype", (QFilter[])new QFilter[]{costaccountFilter});
    }

    private void initClickEvent(FilterContainerInitArgs args) {
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Iterator var3 = filterColumns.iterator();
        String org = this.getPageCache().get(this.ORG_FIELD);
        while (var3.hasNext()) {
            FilterColumn filterColumn = (FilterColumn)var3.next();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List selectValue = (List)ClickEventHelper.getSelectValue(commonFilterColumn.getClass(), (Object)commonFilterColumn);
            boolean selNotNull = selectValue != null && selectValue.size() > 0;
            String defaultValue = "";
            if (selNotNull) {
                defaultValue = selectValue.get(0);
            }
            if (!fieldName.startsWith("org.") || org == null || "".equals(org)) continue;
            if (!defaultValue.equals(org)) {
                this.orgClick = true;
                continue;
            }
            this.orgClick = false;
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter bsp = e.getParameter();
        String acctOrg = this.getPageCache().get(this.ORG_FIELD);
        String costCenter = this.getPageCache().get(COSTCENTER);
        String manuorg = this.getPageCache().get(MANUORG);
        bsp.setCustomParam(this.ORG_FIELD, (Object)acctOrg);
        bsp.setCustomParam(COSTCENTER, (Object)costCenter);
        bsp.setCustomParam(MANUORG, (Object)manuorg);
    }

    protected List<ComboItem> getCostCenterComboItemList(String orgId) {
        return this.getCostCenterComboItemListBy(orgId);
    }

    protected QFilter getCostCenterFilter() {
        String orgId;
        List<ComboItem> costCenterComboItems;
        QFilter qfCostCenter = null;
        String costCenterId = this.getPageCache().get(COSTCENTER);
        if (StringUtils.isEmpty((String)costCenterId) && !CollectionUtils.isEmpty(costCenterComboItems = this.getCostCenterComboItemListBy(orgId = this.getPageCache().get(this.ORG_FIELD)))) {
            ArrayList<Long> costCenterIds = new ArrayList<Long>(16);
            for (ComboItem combo : costCenterComboItems) {
                costCenterIds.add(Long.valueOf(combo.getValue()));
            }
            qfCostCenter = new QFilter(COSTCENTER, "in", costCenterIds);
        }
        return qfCostCenter;
    }

    protected List<ComboItem> getManuOrgComboItemsList(Long orgId) {
        return ImportServiceHelper.getPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
    }
}

