/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.macc.aca.formplugin.base.QuerySchemeHolder;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class SchemeSettingPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String SAVE_SCHEME_OP_KEY = "savescheme";
    private static final String DELETE_SCHEME_OP_KEY = "deletescheme";
    private static final String ADD_SCHEME_OP_KEY = "addscheme";
    private static final String RESET_SCHEME_OP_KEY = "resetcheme";
    protected static final String SCHEME_ENTRY_KEY = "scheme_entry";
    protected static final String SCHEME_CUT_KEY = "scheme_cut";
    private static final String BUTTONAP_KEY = "buttonap";
    private Set<String> removeEntities = new HashSet<String>(10);
    private Set<String> notSaveFields = new HashSet<String>(10);
    private boolean changeTip = true;

    public SchemeSettingPlugin() {
    }

    public SchemeSettingPlugin(Collection<String> removeEntities, Collection<String> notSaveEntities, boolean changeTip) {
        if (removeEntities != null) {
            this.removeEntities.addAll(removeEntities);
        }
        if (notSaveEntities != null) {
            this.notSaveFields.addAll(notSaveEntities);
        }
        this.changeTip = changeTip;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        QuerySchemeHolder holder = this.getSchemeQueryHolder();
        holder.initSchemesList();
        this.reloadPageDyn();
    }

    protected QuerySchemeHolder getSchemeQueryHolder() {
        QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
        if (!CadEmptyUtils.isEmpty(this.notSaveFields)) {
            for (String entity : this.notSaveFields) {
                holder.addNotSaveFields(entity);
            }
        }
        if (!CadEmptyUtils.isEmpty(this.removeEntities)) {
            holder.addRemoveEntities(new ArrayList<String>(this.removeEntities));
        }
        return holder;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        QuerySchemeHolder holder = this.getSchemeQueryHolder();
        holder.setDefaultScheme();
        this.afterSelScheme();
        this.getView().getModel().setDataChanged(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(SCHEME_ENTRY_KEY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        Button defaultBtn = (Button)this.getView().getControl(BUTTONAP_KEY);
        defaultBtn.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (BUTTONAP_KEY.equals(source.getKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(SCHEME_ENTRY_KEY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length < 1) {
                return;
            }
            entryGrid.selectRows(selectRows[0]);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        if (event.getOperationResult() == null || !event.getOperationResult().isSuccess()) {
            return;
        }
        String opKey = event.getOperateKey();
        if (SAVE_SCHEME_OP_KEY.equals(opKey)) {
            QuerySchemeHolder holder = this.getSchemeQueryHolder();
            holder.saveScheme();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"SchemeSettingPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        } else if (DELETE_SCHEME_OP_KEY.equals(opKey)) {
            int[] selectRows = ((EntryGrid)this.getView().getControl(SCHEME_ENTRY_KEY)).getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u65b9\u6848\u3002", (String)"SchemeSettingPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                event.getOperationResult().setShowMessage(false);
                return;
            }
            QuerySchemeHolder holder = this.getSchemeQueryHolder();
            holder.deleteScheme();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"SchemeSettingPlugin_2", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        } else if (ADD_SCHEME_OP_KEY.equals(opKey)) {
            QuerySchemeHolder holder = this.getSchemeQueryHolder();
            holder.addScheme();
            this.reloadPageDyn();
        } else if (RESET_SCHEME_OP_KEY.equals(opKey)) {
            QuerySchemeHolder holder = this.getSchemeQueryHolder();
            holder.resetScheme();
            this.reloadPageDyn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entryRowClick(RowClickEvent e) {
        String key = ((EntryGrid)e.getSource()).getKey();
        if (SCHEME_ENTRY_KEY.equals(key)) {
            try {
                this.getPageCache().put(SCHEME_CUT_KEY, "1");
                QuerySchemeHolder holder = this.getSchemeQueryHolder();
                holder.setScheme(e.getRow());
            }
            finally {
                this.getPageCache().put(SCHEME_CUT_KEY, "0");
            }
            this.afterSelScheme();
            this.getView().getModel().setDataChanged(false);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        MessageBoxResult result = e.getResult();
        if (e.getCallBackId().equals("close")) {
            boolean isClose = true;
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getView().getPageCache().put("isclose", String.valueOf(true));
                this.getView().close();
            } else if (MessageBoxResult.Cancel.equals((Object)result)) {
                isClose = false;
            }
            this.getView().getPageCache().put("isclose", String.valueOf(isClose));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (!this.changeTip) {
            return;
        }
        boolean isDataChange = this.getModel().getDataChanged();
        boolean isClose = "true".equals(this.getView().getPageCache().get("isclose"));
        if (isDataChange && !isClose) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SchemeSettingPlugin_3", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SchemeSettingPlugin_4", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("close", (IFormPlugin)this);
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SchemeSettingPlugin_5", (String)"macc-aca-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, this.getModel().getChangeDesc(), options, ConfirmTypes.Save, callBackListener, btnNameMaps);
            e.setCancel(true);
        }
    }

    protected void reloadPageDyn() {
    }

    protected void afterSelScheme() {
    }
}

