/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.basedata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FlexEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.common.helper.AcaCostAccountHelper;
import kd.macc.aca.formplugin.utils.AcaUtil;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import org.apache.commons.lang3.StringUtils;

public class ProductExtraPriceEditPlugin
extends AbstractBillPlugIn {
    public void beforeBindData(EventObject e) {
        boolean add;
        super.beforeBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        if (fsp.getCustomParam("add") != null && (add = ((Boolean)fsp.getCustomParam("add")).booleanValue())) {
            Object costAccountId;
            Object orgId = fsp.getCustomParam("orgId");
            if (orgId != null) {
                this.getModel().setValue("org", orgId);
            }
            if ((costAccountId = fsp.getCustomParam("costaccountId")) != null) {
                this.getModel().setValue("costaccount", costAccountId);
                this.bindCurrency();
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"matversion", "auxpty", "bar_change"});
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        boolean isAdd;
        String manuorgId;
        String costCenterId;
        DynamicObject costAccount;
        super.afterBindData(e);
        this.changManuorgStatus();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object costAccountObj = fsp.getCustomParam("costaccountId");
        String costAccountId = null;
        if (costAccountObj != null && StringUtils.isBlank((CharSequence)(costAccountId = String.valueOf(costAccountObj))) && (costAccount = (DynamicObject)this.getModel().getValue("costaccount")) != null) {
            costAccountId = String.valueOf(costAccount.getLong("id"));
        }
        if (StringUtils.isNotBlank((CharSequence)(costCenterId = (String)fsp.getCustomParam("costcenterId")))) {
            this.getModel().setValue("costcenter", (Object)costCenterId);
        }
        if (StringUtils.isNotBlank((CharSequence)(manuorgId = (String)fsp.getCustomParam("manuorgId")))) {
            this.getModel().setValue("manuorg", (Object)manuorgId);
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"costaccount"});
        AcaUtil.ctrlVerAndAuxpty(this.getView());
        if (fsp.getCustomParam("add") != null && !(isAdd = ((Boolean)fsp.getCustomParam("add")).booleanValue())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"material"});
            if (StringUtils.isNotBlank((CharSequence)costAccountId)) {
                if (this.samePeriod(costAccountId)) {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"price", "subelement", "matversion", "auxpty", "btn_entry_del", "btn_entry_insert", "btn_entry_add"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_change"});
                } else {
                    Date currentStartDate = AcaCostAccountHelper.getCurrentPeriodStartDateByCostAccountId((long)Long.parseLong(costAccountId));
                    Date startDate = (Date)this.getModel().getValue("startdate");
                    if (startDate != null && startDate.compareTo(currentStartDate) >= 0) {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_change"});
                    } else if (this.getModel().getValue("endperiod") != null) {
                        if (startDate != null && startDate.compareTo((Date)this.getModel().getValue("enddate")) < 0) {
                            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_change"});
                        } else {
                            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_change"});
                        }
                    } else {
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_change"});
                    }
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save"});
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_entry_del", "btn_entry_insert", "btn_entry_add"});
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"remark"});
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"matversion", "auxpty"});
                    DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
                    for (int i = 0; i < entry.size(); ++i) {
                        this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"subelement"});
                        this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"price"});
                    }
                }
            }
        }
        this.getModel().setDataChanged(false);
    }

    private boolean samePeriod(String costAccountId) {
        if (this.getModel().getValue("startperiod") != null) {
            DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
            Long startPeriodId = startPeriod.getLong("id");
            return startPeriodId.equals(AcaCostAccountHelper.getCurrentPeriodByCostAccountId((String)costAccountId));
        }
        return false;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit manuorgCtrl = (BasedataEdit)this.getControl("manuorg");
        manuorgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"ProductExtraPriceEditPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                return;
            }
            List manuOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)((Long)org.getPkValue()), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            DynamicObject manuorg = (DynamicObject)this.getModel().getValue("manuorg");
            if (!ObjectUtils.isEmpty((Object)manuorg) && !CollectionUtils.isEmpty((Collection)manuOrg)) {
                manuOrg.remove((Long)manuorg.getPkValue());
            }
            ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = parameter.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(new QFilter("id", "in", (Object)manuOrg));
        });
        BasedataEdit costcenterCtrl = (BasedataEdit)this.getControl("costcenter");
        costcenterCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"ProductExtraPriceEditPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = parameter.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(new QFilter("orgduty", "=", (Object)4L));
            qFilters.add(new QFilter("accountorg", "=", org.getPkValue()));
        });
        BasedataEdit materialCtrl = (BasedataEdit)this.getControl("material");
        materialCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"ProductExtraPriceEditPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                return;
            }
        });
        BasedataEdit subElementCtrl = (BasedataEdit)this.getControl("subelement");
        subElementCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = showParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            qList.add(new QFilter("id", "in", this.getUsingSubElement()));
        });
        BasedataEdit matVersionCtrl = (BasedataEdit)this.getControl("matversion");
        matVersionCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject mat = (DynamicObject)this.getModel().getValue("material");
            if (mat != null) {
                ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter filterParameter = parameter.getListFilterParameter();
                List qList = filterParameter.getQFilters();
                qList.add(new QFilter("material", "=", mat.getPkValue()));
            }
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private List<Long> getCheckedSubElement() {
        DynamicObjectCollection entryTable = this.getModel().getEntryEntity("entryentity");
        ArrayList<Long> checkedSubIds = new ArrayList<Long>(entryTable.size());
        for (DynamicObject dynamicObject : entryTable) {
            Long id = dynamicObject.getLong("subelement".concat(".id"));
            checkedSubIds.add(id);
        }
        return checkedSubIds;
    }

    private List<Long> getUsingSubElement() {
        String selectedFields = "id";
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_subelement", (String)selectedFields, (QFilter[])new QFilter[]{qFilter});
        ArrayList<Long> subElementIds = new ArrayList<Long>(dynamicObjects.size());
        dynamicObjects.forEach(dynamicObject -> subElementIds.add(dynamicObject.getLong("id")));
        subElementIds.removeAll(this.getCheckedSubElement());
        return subElementIds;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "material": {
                AcaUtil.ctrlVerAndAuxpty(this.getView());
                break;
            }
            case "subelement": {
                this.setElement(e);
                break;
            }
            case "price": {
                this.checkAndCal(e);
                break;
            }
            case "org": {
                this.changManuorgStatus();
                break;
            }
        }
    }

    private void checkAndCal(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object object = this.getView().getModel().getValue("price", rowIndex);
        if (object != null) {
            BigDecimal price = (BigDecimal)object;
            if (price.compareTo(BigDecimal.ZERO) < 0) {
                this.getModel().setValue("price", (Object)BigDecimal.ZERO, rowIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9a\u989d\u5355\u4ef7\u5e94\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"ProductExtraPriceEditPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            } else {
                this.setAmount();
            }
        }
    }

    private void setAmount() {
        DynamicObjectCollection entryTable = this.getModel().getEntryEntity("entryentity");
        BigDecimal amount = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : entryTable) {
            BigDecimal price = dynamicObject.getBigDecimal("price");
            if (price.compareTo(BigDecimal.ZERO) <= 0) continue;
            amount = amount.add(price);
        }
        this.getModel().setValue("amount", (Object)amount);
    }

    private void setElement(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject subElement = (DynamicObject)this.getView().getModel().getValue("subelement", rowIndex);
        if (subElement == null) {
            return;
        }
        Long subElementId = subElement.getLong("id");
        QFilter qfSubElement = new QFilter("subelement", "=", (Object)subElementId);
        DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{qfSubElement});
        if (dySubElement != null) {
            this.getView().getModel().setValue("element", (Object)dySubElement.getLong("element"), rowIndex);
        }
    }

    private void setEnableAuxpty() {
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        boolean enable = material.getBoolean("isuseauxpty");
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{"auxpty"});
        FlexEdit auxpty = (FlexEdit)this.getControl("auxpty");
        auxpty.setMustInput(true);
        this.getView().setVisible(Boolean.valueOf(enable), new String[]{"auxpty"});
    }

    private void bindCurrency() {
        if (this.getModel().getValue("currency") == null) {
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
            if (costAccount == null) {
                return;
            }
            QFilter qFilter = new QFilter("id", "=", (Object)costAccount.getLong("id"));
            String selectFields = "calpolicy.currency";
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
            this.getModel().setValue("currency", (Object)dynamicObject.getLong("calpolicy.currency.id"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)opKey, (CharSequence)"deleteentry")) {
            this.setAmount();
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"bar_change")) {
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
            DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
            Long currentId = AcaCostAccountHelper.getCurrentPeriodByCostAccountId((String)String.valueOf(costAccount.getLong("id")));
            DynamicObject currentPeriod = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currentId)});
            Date beginDate = startPeriod.getDate("begindate");
            Date currentBeginDate = currentPeriod.getDate("begindate");
            if (currentBeginDate.compareTo(beginDate) < 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u542f\u7528\u671f\u95f4\u5c0f\u4e8e\u5f53\u524d\u5355\u7684\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"ProductExtraPriceEditPlugin_2", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"bar_change")) {
            this.productExtraPriceChange();
        }
    }

    private void productExtraPriceChange() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_change"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_save"});
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_entry_add", "btn_entry_insert", "btn_entry_del"});
        DynamicObjectCollection entryTable = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryTable.size(); ++i) {
            this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"subelement", "price"});
        }
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        Long periodId = AcaCostAccountHelper.getCurrentPeriodByCostAccountId((String)String.valueOf(costAccount.getLong("id")));
        this.getModel().setValue("startperiod", (Object)periodId);
        this.getModel().setDataChanged(false);
    }

    private void changManuorgStatus() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)accountorg.getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }
}

