/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.basedata;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.aca.common.helper.AcaCostAccountHelper;
import kd.macc.aca.formplugin.base.BaseManuorgListPlugin;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ClickEventHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ProductExtraPriceListPlugin
extends BaseManuorgListPlugin {
    private FilterContainerInitArgs filterContainerInitArgs;
    private volatile boolean orgClick = false;
    private boolean add = false;

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        for (QFilter qFilter : qFilters) {
            String property = qFilter.getProperty();
            Object val = qFilter.getValue();
            if (!"startperiod.id".equals(property)) continue;
            qFilter.__setCP("<=");
            QFilter endPeriodQf = new QFilter("endperiod.id", ">=", val);
            endPeriodQf.or("endperiod", "=", (Object)0);
            qFilter.and(endPeriodQf);
        }
        e.setOrderBy("org.number,costaccount.number,material.number");
        String orgId = this.getPageCache().get("orgId");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orgId)) {
            qFilters.add(new QFilter("org", "=", (Object)0L));
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columns = args.getListColumns();
        ArrayList defaultHiddenColumns = Lists.newArrayList((Object[])new String[]{"org.number", "costaccount.number", "matversion.name", "auxpty", "remark", "creator.name", "createtime", "modifier.name", "modifytime"});
        columns.forEach(column -> {
            if (defaultHiddenColumns.contains(column.getListFieldKey())) {
                column.setVisible(0);
            }
        });
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initClickEvent(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        this.setOrg();
        this.initFilterItem(args);
    }

    private void initClickEvent(FilterContainerInitArgs args) {
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Iterator var3 = filterColumns.iterator();
        String org = this.getPageCache().get("orgId");
        while (var3.hasNext()) {
            FilterColumn filterColumn = (FilterColumn)var3.next();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List selectValue = (List)ClickEventHelper.getSelectValue(commonFilterColumn.getClass(), (Object)commonFilterColumn);
            boolean selNotNull = selectValue != null && selectValue.size() > 0;
            String defaultValue = "";
            if (selNotNull) {
                defaultValue = selectValue.get(0);
            }
            if (!fieldName.startsWith("org.") || org == null || "".equals(org)) continue;
            if (!defaultValue.equals(org)) {
                this.orgClick = true;
                continue;
            }
            this.orgClick = false;
        }
    }

    private void setOrg() {
        List acctOrgs = OrgHelper.getAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (CadEmptyUtils.isEmpty((List)acctOrgs)) {
            return;
        }
        String orgId = this.getPageCache().get("orgId");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orgId)) {
            Long currAcctOrg = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)currAcctOrg, (String)"10");
            if (isAccounting) {
                orgId = String.valueOf(currAcctOrg);
            } else {
                ComboItem comboItem = (ComboItem)acctOrgs.get(0);
                orgId = comboItem.getValue();
            }
            this.getPageCache().put("orgId", orgId);
        }
    }

    private void initFilterItem(FilterContainerInitArgs args) {
        String orgId = this.getPageCache().get("orgId");
        List costaccountItems = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orgId) ? new ArrayList() : AcaCostAccountHelper.getCostAccountItems((String)orgId);
        block14: for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List listcomitem = commonFilterColumn.getComboItems();
            switch (fieldName) {
                case "org.name": {
                    if (CadEmptyUtils.isEmpty((List)listcomitem)) break;
                    listcomitem.clear();
                    commonFilterColumn.setComboItems(OrgHelper.getAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId()));
                    commonFilterColumn.setDefaultValue(orgId);
                    break;
                }
                case "costcenter.name": {
                    if (CadEmptyUtils.isEmpty((List)listcomitem)) break;
                    listcomitem.clear();
                    commonFilterColumn.setComboItems(this.getCostCenterComboItemListBy(orgId));
                    break;
                }
                case "manuorg.name": {
                    if (CadEmptyUtils.isEmpty((List)listcomitem)) break;
                    listcomitem.clear();
                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orgId)) break;
                    commonFilterColumn.setComboItems(ImportServiceHelper.getPermProOrgsByAccOrg((Long)Long.parseLong(orgId), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId()));
                    break;
                }
                case "costaccount.name": {
                    if (CadEmptyUtils.isEmpty((List)listcomitem)) break;
                    listcomitem.clear();
                    commonFilterColumn.setComboItems(costaccountItems);
                    if (costaccountItems == null || costaccountItems.size() <= 0) break;
                    commonFilterColumn.setDefaultValue(((ComboItem)costaccountItems.get(0)).getValue());
                    this.getPageCache().put("costaccountId", ((ComboItem)costaccountItems.get(0)).getValue());
                    break;
                }
                case "startperiod.name": {
                    listcomitem.clear();
                    if (CadEmptyUtils.isEmpty((String)this.getPageCache().get("costaccountId"))) break;
                    List<ComboItem> startPeriodItems = this.getPeriodComboItemsByLast(Long.valueOf(this.getPageCache().get("costaccountId")));
                    commonFilterColumn.setComboItems(startPeriodItems);
                    if (CadEmptyUtils.isEmpty(startPeriodItems)) continue block14;
                    commonFilterColumn.setDefaultValue(startPeriodItems.get(0).getValue());
                    break;
                }
            }
        }
    }

    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    private void filterContainerInit(FilterContainerInitArgs args, String initName) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            String orgId;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (StringUtils.isNotEmpty((String)initName) && !fieldName.contains(initName)) continue;
            if (fieldName.startsWith("costcenter")) {
                orgId = this.getPageCache().get("orgId");
                this.resetCostCenter(commonFilterColumn, orgId);
            }
            if (fieldName.startsWith("costaccount")) {
                orgId = this.getPageCache().get("orgId");
                this.resetCostAccount(commonFilterColumn, orgId);
            }
            if (!fieldName.startsWith("startperiod")) continue;
            String costAccountStr = this.getPageCache().get("costaccountId");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)costAccountStr)) {
                this.resetPeriod(commonFilterColumn, 0L);
                continue;
            }
            Long costAccountId = Long.valueOf(costAccountStr);
            this.resetPeriod(commonFilterColumn, costAccountId);
        }
    }

    private void resetCostCenter(CommonFilterColumn commonFilterColumn, String orgId) {
        List<ComboItem> costCenterComboItemList = this.getCostCenterComboItemListBy(orgId);
        if (costCenterComboItemList.isEmpty()) {
            commonFilterColumn.setComboItems(costCenterComboItemList);
            this.getPageCache().put("costcenterId", "");
            return;
        }
        commonFilterColumn.setComboItems(costCenterComboItemList);
        commonFilterColumn.setDefaultValue(costCenterComboItemList.get(0).getValue());
        this.getPageCache().put("costcenterId", costCenterComboItemList.get(0).getValue());
    }

    private void resetCostAccount(CommonFilterColumn commonFilterColumn, String orgId) {
        List costAccountItems = AcaCostAccountHelper.getCostAccountItems((String)orgId);
        if (costAccountItems.isEmpty()) {
            commonFilterColumn.setComboItems(costAccountItems);
            this.getPageCache().put("costaccountId", "");
            return;
        }
        commonFilterColumn.setComboItems(costAccountItems);
        commonFilterColumn.setDefaultValue(((ComboItem)costAccountItems.get(0)).getValue());
        this.getPageCache().put("costaccountId", ((ComboItem)costAccountItems.get(0)).getValue());
    }

    protected void resetPeriod(CommonFilterColumn commonFilterColumn, Long costAccountId) {
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        List<ComboItem> comboItems = this.getPeriodComboItemsByLast(costAccountId);
        if (CollectionUtils.isEmpty(comboItems)) {
            commonFilterColumn.setComboItems(comboItems);
            this.getPageCache().put("period", "");
            return;
        }
        commonFilterColumn.setComboItems(comboItems);
        commonFilterColumn.setDefaultValue(comboItems.get(0).getValue());
        this.getPageCache().put("period", comboItems.get(0).getValue());
    }

    protected List<ComboItem> getCostCenterComboItemListBy(String orgId) {
        QFilter orgdutyFilter;
        QFilter enableFilter;
        QFilter filter = null;
        filter = !CadEmptyUtils.isEmpty((String)orgId) ? new QFilter("accountorg", "=", (Object)Long.valueOf(orgId)) : new QFilter("accountorg", "=", (Object)0L);
        DynamicObjectCollection ccs = QueryServiceHelper.query((String)"bos_costcenter", (String)"id,name", (QFilter[])new QFilter[]{filter, enableFilter = new QFilter("enable", "=", (Object)"1"), orgdutyFilter = new QFilter("orgduty", "=", (Object)4L)});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)ccs)) {
            return Lists.newArrayList();
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ccs.forEach(cc -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(cc.getString("name")));
            item.setValue(cc.getString("id"));
            if (!acctItems.contains(item)) {
                acctItems.add(item);
            }
        });
        return acctItems;
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues;
        List customfilter;
        super.filterContainerSearchClick(args);
        if (this.orgClick) {
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)args, (String)"costaccount.id");
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)args, (String)"startperiod.id");
        }
        if (args.getCurrentCommonFilter() != null && "costaccount.id".equals(((List)args.getCurrentCommonFilter().get("FieldName")).get(0))) {
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)args, (String)"startperiod.id");
        }
        if ((customfilter = (List)(filterValues = args.getSearchClickEvent().getFilterValues()).get("customfilter")) == null || customfilter.isEmpty()) {
            return;
        }
        String orgId = "";
        for (int i = 0; i < customfilter.size(); ++i) {
            Map filter = (Map)customfilter.get(i);
            List listFieldName = (List)filter.get("FieldName");
            List listValue = (List)filter.get("Value");
            if (CadEmptyUtils.isEmpty((List)listValue)) continue;
            block13: for (int j = 0; j < listFieldName.size(); ++j) {
                String fieldName;
                switch (fieldName = (String)listFieldName.get(j)) {
                    case "org.id": {
                        orgId = (String)listValue.get(j);
                        this.getPageCache().put("orgId", orgId);
                        this.filterContainerInit(this.filterContainerInitArgs, "costcenter");
                        this.filterContainerInit(this.filterContainerInitArgs, "costaccount");
                        this.filterContainerInit(this.filterContainerInitArgs, "startperiod");
                        continue block13;
                    }
                    case "manuorg.id": {
                        String manuOrgId = (String)listValue.get(j);
                        this.getPageCache().put("manuorgId", manuOrgId);
                        continue block13;
                    }
                    case "costcenter.id": {
                        String costcenterId = (String)listValue.get(j);
                        this.getPageCache().put("costcenterId", costcenterId);
                        continue block13;
                    }
                    case "costaccount.id": {
                        String costaccountId = (String)listValue.get(j);
                        this.getPageCache().put("costaccountId", costaccountId);
                        this.filterContainerInit(this.filterContainerInitArgs, "period");
                        continue block13;
                    }
                }
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("costaccount")) {
            String orgId = this.getPageCache().get("orgId");
            if (!CadEmptyUtils.isEmpty((String)orgId)) {
                QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnabledCostAccountIdsFilter((Long)Long.valueOf(orgId), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
                args.getQfilters().add(enabledCostAccountIdsFilter);
            } else {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            }
        } else if (fieldName.startsWith("org.")) {
            List acctOrgs = OrgHelper.getAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (CadEmptyUtils.isEmpty((List)acctOrgs)) {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            }
        } else if (fieldName.startsWith("costcenter.")) {
            String orgId = this.getPageCache().get("orgId");
            if (!CadEmptyUtils.isEmpty((String)orgId)) {
                QFilter filter = new QFilter("accountorg", "=", (Object)Long.valueOf(orgId));
                filter.and("enable", "=", (Object)"1");
                filter.and("orgduty", "=", (Object)4L);
                args.getQfilters().add(filter);
            } else {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            }
        } else if (fieldName.startsWith("startperiod")) {
            String costAccountStr = this.getPageCache().get("costaccountId");
            if (CadEmptyUtils.isEmpty((String)costAccountStr)) {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            } else {
                QFilter costaccountFilter = new QFilter("entry.costaccount", "=", (Object)Long.valueOf(costAccountStr));
                DynamicObject sysCtrlEntity = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"id,entry.startperiod startperiod,entry.currentperiod currentperiod,entry.calpolicy.periodtype periodtype", (QFilter[])new QFilter[]{costaccountFilter});
                if (sysCtrlEntity != null) {
                    Long startPeriod = sysCtrlEntity.getLong("startperiod");
                    QFilter idQf = new QFilter("id", ">=", (Object)startPeriod);
                    idQf.and("periodtype", "=", (Object)sysCtrlEntity.getLong("periodtype"));
                    args.getQfilters().add(idQf);
                    args.getQfilters().add(new QFilter("isadjustperiod", "=", (Object)false));
                }
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String costCenterId;
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        String orgId = this.getPageCache().get("orgId");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProductExtraPriceListPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
        params.put("orgId", orgId);
        String costAccountId = this.getPageCache().get("costaccountId");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)costAccountId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"ProductExtraPriceListPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
        params.put("costaccountId", costAccountId);
        String manuorgId = this.getPageCache().get("manuorgId");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)manuorgId)) {
            params.put("manuorgId", manuorgId);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(costCenterId = this.getPageCache().get("costcenterId")))) {
            params.put("costcenterId", costCenterId);
        }
        params.put("add", this.add);
        e.getParameter().setCustomParams(params);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        this.add = false;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.itemClick((ItemClickEvent)evt);
        block4 : switch (evt.getItemKey()) {
            case "tblnew": {
                String costAccountId = this.getPageCache().get("costaccountId");
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)costAccountId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u672a\u627e\u5230\u6210\u672c\u8d26\u7c3f\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"ProductExtraPriceListPlugin_2", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                this.add = true;
                break;
            }
            case "tbldel": {
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection rows = billList.getSelectedRows();
                for (Object row : rows.getPrimaryKeyValues()) {
                    boolean isEnableDelete = MutexHelper.enableReentrant((String)this.getBillEntityId(), (Object)row, (String)"delete");
                    if (isEnableDelete) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002\u6240\u9009\u5355\u636e\u5355\u636e\u5df2\u5728\u5176\u4ed6\u9875\u7b7e\u4e2d\u6253\u5f00\uff0c\u5982\u9700\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5173\u95ed\u5355\u636e\u540e\u91cd\u8bd5\uff0c\u6216\u91cd\u65b0\u767b\u5f55\u540e\uff0c\u518d\u6b21\u5c1d\u8bd5\u3002", (String)"ProductExtraPriceListPlugin_3", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break block4;
                }
                break;
            }
        }
    }

    private List<ComboItem> getPeriodComboItemsByLast(Long costAccountId) {
        ArrayList<ComboItem> periodComboItems = new ArrayList<ComboItem>();
        DynamicObject curPeriodAndEnAblePeriod = PeriodHelper.getCurrentPeriodAndEnAblePeriod((Long)costAccountId);
        if (curPeriodAndEnAblePeriod == null) {
            return periodComboItems;
        }
        DynamicObject currentperiod = curPeriodAndEnAblePeriod.getDynamicObject("currentperiod");
        if (currentperiod == null) {
            return periodComboItems;
        }
        Long startperiodId = 0L;
        DynamicObject startperiod = curPeriodAndEnAblePeriod.getDynamicObject("startperiod");
        if (startperiod != null) {
            startperiodId = startperiod.getLong("id");
        }
        this.addCombItem(periodComboItems, null, currentperiod);
        if (Long.compare(startperiodId, currentperiod.getLong("id")) == 0) {
            return periodComboItems;
        }
        DynamicObject prePeriod = PeriodHelper.getPreviousPeriod((Object)currentperiod.getPkValue());
        if (prePeriod == null) {
            return periodComboItems;
        }
        this.addCombItem(periodComboItems, null, prePeriod);
        if (Long.compare(startperiodId, prePeriod.getLong("id")) == 0) {
            return periodComboItems;
        }
        DynamicObject prePrePeriod = PeriodHelper.getPreviousPeriod((Object)prePeriod.getPkValue());
        if (prePrePeriod == null) {
            return periodComboItems;
        }
        this.addCombItem(periodComboItems, null, prePrePeriod);
        return periodComboItems;
    }

    private void addCombItem(List<ComboItem> periodComboItems, String caption, DynamicObject period) {
        if (null == period) {
            return;
        }
        ComboItem item = new ComboItem();
        String periodId = period.getString("id");
        if (StringUtils.isEmpty((String)caption)) {
            item.setCaption(new LocaleString(period.getString("name")));
        } else {
            item.setCaption(new LocaleString(caption));
        }
        item.setValue(periodId);
        periodComboItems.add(item);
    }
}

