/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.calc;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.StartCostHelper;

public class CalcParamEdit
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initFilter();
    }

    private void initFilter() {
        BasedataEdit costAccountInput = (BasedataEdit)this.getControl("costaccount");
        costAccountInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            List<QFilter> qFilters = this.getInputQFilters(evt);
            if (AcaAlgoxEmptyOrZeroUtils.isEmpty((DynamicObject)org)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
                return;
            }
            QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnabledCostAccountIdsFilter((Long)org.getLong("id"), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
            qFilters.add(enabledCostAccountIdsFilter);
            Set<Object> costAccoutIds = this.getUsedCostAccoutIds();
            if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(costAccoutIds)) {
                qFilters.add(new QFilter("id", "not in", costAccoutIds));
            }
        });
    }

    private Set<Object> getUsedCostAccoutIds() {
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("org", "=", (Object)orgId));
        String currCostAccoutId = this.getPageCache().get("currcostaccount");
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty((String)currCostAccoutId)) {
            qfList.add(new QFilter("costaccount", "not in", (Object)currCostAccoutId));
        }
        DynamicObjectCollection costAccoutIdCollec = QueryServiceHelper.query((String)"aca_calcparam", (String)"costaccount", (QFilter[])qfList.toArray(new QFilter[0]));
        return DynamicObjectHelper.getFieldSet((DynamicObjectCollection)costAccoutIdCollec, (String)"costaccount");
    }

    private List<QFilter> getInputQFilters(BeforeF7SelectEvent evt) {
        ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
        return filterParameter.getQFilters();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long id = (Long)this.getModel().getValue("id");
        if (id != null && id != 0L) {
            String costAccoutId = this.getModel().getDataEntity().getString("costaccount.id");
            this.getPageCache().put("currcostaccount", costAccoutId);
        }
        this.initByListData();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"fieldsetpanelap"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
    }

    private void initByListData() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object orgId = fsp.getCustomParam("orgId");
        this.getModel().setValue("org", orgId);
    }
}

