/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.calc;

import com.google.common.collect.Sets;
import java.lang.constant.Constable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.aca.algox.enums.AcaMutexEnum;
import kd.macc.aca.algox.utils.AcaMutexHelper;
import kd.macc.cad.common.check.CalcCheckHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.InstanceAliveHelper;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.time.DateFormatUtils;

public class CalcReportEdit
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(CalcReportEdit.class);

    public void initialize() {
        BillShowParameter param = (BillShowParameter)this.getView().getFormShowParameter();
        String custparam = (String)this.getView().getFormShowParameter().getCustomParam("custparam");
        if (!CadEmptyUtils.isEmpty((String)custparam)) {
            JSONObject custparamJs = JSONObject.fromObject((Object)custparam);
            if (custparamJs.containsKey((Object)"checkResultId") && custparamJs.get("checkResultId") != null) {
                param.setPkId((Object)custparamJs.getLong("checkResultId"));
            }
        } else {
            Object calcRecordId = this.getView().getFormShowParameter().getCustomParam("calcrecordid");
            if (calcRecordId != null) {
                param.setPkId(calcRecordId);
            }
        }
        param.setStatus(OperationStatus.VIEW);
        super.initialize();
    }

    public void beforeBindData(EventObject e) {
        boolean isAlive;
        super.beforeBindData(e);
        String billType = (String)this.getModel().getValue("billtype");
        String showCalScheme = CadBgParamUtils.getCadBgParamForString((String)"showCalScheme", (String)"0");
        this.getView().setVisible(Boolean.valueOf("1".equals(showCalScheme) && "2".equals(billType)), new String[]{"calscheme"});
        String type = this.getModel().getDataEntity().getString("type");
        String instanceid = this.getModel().getDataEntity().getString("instanceid");
        if (("2".equals(type) || "0".equals(type)) && !StringUtils.isEmpty((String)instanceid) && !(isAlive = InstanceAliveHelper.isAlive((String)instanceid))) {
            DynamicObject costaccount;
            if ("true".equals(CadBgParamUtils.getCadBgParamForString((String)"serverIsAliveTest", (String)"true")) && (costaccount = this.getModel().getDataEntity().getDynamicObject("costaccount")) != null) {
                this.updateReportStatus();
                DynamicObject reportPeriod = this.getModel().getDataEntity().getDynamicObject("period");
                DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costaccount.getLong("id"));
                if (period != null && reportPeriod != null && period.getLong("id") == reportPeriod.getLong("id")) {
                    AcaMutexHelper.releaseMutex((AcaMutexEnum)AcaMutexEnum.CALC_CALCULATE, (long)costaccount.getLong("id"));
                }
            }
            this.getView().showMessage(ResManager.loadKDString((String)"\u76d1\u63a7\u5230\u5bb9\u5668\u5728\u8ba1\u7b97\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e86\u91cd\u542f\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"CalcReportEdit_8", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        }
    }

    private void updateReportStatus() {
        DynamicObject calcReport;
        Long calcReportId = this.getModel().getDataEntity().getLong("id");
        if (calcReportId != null && !CadEmptyUtils.isEmpty((String)calcReportId.toString()) && (calcReport = BusinessDataServiceHelper.loadSingle((Object)calcReportId, (String)"aca_calcreport", (String)"id,type")) != null) {
            calcReport.set("type", (Object)"9");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcReport});
            this.getView().invokeOperation("refresh");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        JSONObject jsonObject;
        String jsonString;
        Object entryId;
        String billType = (String)this.getModel().getValue("billtype");
        if (arg0.getRowIndex() == 0 && "2".equals(billType)) {
            String param = String.valueOf(this.getModel().getValue("param", arg0.getRowIndex()));
            if (CadEmptyUtils.isEmpty((String)param)) {
                return;
            }
            JSONObject checkDescJs = JSONObject.fromObject((Object)param);
            Object checkResultId = checkDescJs.get("checkResultId");
            if (!QueryServiceHelper.exists((String)"aca_calcreport", (Object)checkResultId)) {
                return;
            }
            BillShowParameter formShowParameter = new BillShowParameter();
            formShowParameter.setFormId("aca_calcreport");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("custparam", (Object)param);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5\u62a5\u544a", (String)"CalcReportEdit_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
        if (QueryServiceHelper.exists((String)"aca_calcreportdetail", (Object)(entryId = ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(arg0.getRowIndex())).getPkValue()))) {
            BillShowParameter formShowParameter = new BillShowParameter();
            formShowParameter.setFormId("aca_calcreportdetail");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("entryId", entryId);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            if ("2".equals(billType)) {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97\u68c0\u67e5\u7ed3\u679c\u660e\u7ec6\u62a5\u544a", (String)"CalcReportEdit_7", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            } else {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5\u7ed3\u679c\u660e\u7ec6\u62a5\u544a", (String)"CalcReportEdit_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            }
            this.getView().showForm((FormShowParameter)formShowParameter);
            return;
        }
        String subnextentity = ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(arg0.getRowIndex())).getString("subnextentity");
        if (StringUtils.isNotEmpty((String)subnextentity) && "cal_calculateoutrpt".equals(subnextentity)) {
            jsonString = ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(arg0.getRowIndex())).getString("subparam");
            jsonObject = JSONObject.fromObject((Object)jsonString);
            List idList = null;
            try {
                SimpleDateFormat df = new SimpleDateFormat(DateFormatUtils.ISO_DATETIME_FORMAT.getPattern());
                Date startTime = df.parse(jsonObject.getString("startTime"));
                Date endTime = df.parse(jsonObject.getString("endTime"));
                Long orgId = jsonObject.getLong("orgId");
                Long costaccountId = jsonObject.getLong("costaccountId");
                QFilter filter = new QFilter("calorg", "=", (Object)orgId);
                filter.and("costaccount", "=", (Object)costaccountId);
                filter.and("calstatus", "=", (Object)"B");
                filter.and("caltime", ">=", (Object)startTime);
                filter.and("caltime", "<=", (Object)endTime);
                idList = QueryServiceHelper.queryPrimaryKeys((String)"cal_calculateoutrpt", (QFilter[])filter.toArray(), null, (int)-1);
            }
            catch (ParseException e) {
                logger.error("\u65e5\u671f\u89e3\u6790\u5931\u8d25", (Throwable)e);
                return;
            }
            if (idList == null || idList.size() == 0) {
                return;
            }
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("cal_calculateoutrpt");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            for (Object object : idList) {
                showParameter.addLinkQueryPkId(object);
            }
            this.getView().showForm((FormShowParameter)showParameter);
            return;
        }
        if (StringUtils.isNotEmpty((String)subnextentity) && ("aca_matcalcanalrpt".equals(subnextentity) || "aca_mfgcocalcanalrpt".equals(subnextentity))) {
            jsonString = ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(arg0.getRowIndex())).getString("subparam");
            jsonObject = JSONObject.fromObject((Object)jsonString);
            Long orgId = jsonObject.getLong("orgId");
            Long costaccountId = jsonObject.getLong("costaccountId");
            Long periodId = jsonObject.getLong("periodId");
            String formId = subnextentity;
            ReportShowParameter showParameter = new ReportShowParameter();
            ReportQueryParam queryParam = new ReportQueryParam();
            HashMap<String, Constable> map = new HashMap<String, Constable>(16);
            map.put("org", orgId);
            map.put("costaccount", costaccountId);
            map.put("period", periodId);
            map.put("showsubelement", Boolean.TRUE);
            map.put("onlyshowdiff", Boolean.TRUE);
            map.put("showmatdetail", Boolean.TRUE);
            showParameter.setFormId(formId);
            showParameter.setCustomParams(map);
            showParameter.setQueryParam(queryParam);
            showParameter.setHasRight(true);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
            return;
        }
        String DIFF_COSTOBJECTANDSOURCEBILL = ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5f52\u96c6\u4e0e\u6e90\u5355\u5b58\u5728\u5dee\u5f02", (String)"CalcReportEdit_2", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        String DIFF_PLANOUTPUTANDSOURCEBILL = ResManager.loadKDString((String)"\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u4e0e\u6e90\u5355\u5b58\u5728\u5dee\u5f02", (String)"CalcReportEdit_3", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        String DIFF_FACTOUTPUTANDSOURCEBILL = ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u4e0e\u6e90\u5355\u5b58\u5728\u5dee\u5f02\u3002", (String)"CalcReportEdit_4", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        String DIFF_MATUSECOLLECTANDSOURCEBILL = ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5f52\u96c6\u4e0e\u6e90\u5355\u5b58\u5728\u5dee\u5f02\u3002", (String)"CalcReportEdit_5", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        String DIFF_RESUSECOLLECTANDSOURCEBILL = ResManager.loadKDString((String)"\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5355\u4e0e\u6e90\u5355\u5b58\u5728\u5dee\u5f02", (String)"CalcReportEdit_6", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        String appNum = this.getView().getFormShowParameter().getAppId();
        DynamicObject accountOrg = (DynamicObject)this.getModel().getValue("org");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        String taskName = String.valueOf(this.getModel().getValue("item", arg0.getRowIndex()));
        logger.info("\u94fe\u63a5\u70b9\u51fb{}\uff0c{}\uff0c{}\uff0c{}\uff0c{}\uff0c{}", new Object[]{taskName, DIFF_COSTOBJECTANDSOURCEBILL, DIFF_PLANOUTPUTANDSOURCEBILL, DIFF_FACTOUTPUTANDSOURCEBILL, DIFF_MATUSECOLLECTANDSOURCEBILL, DIFF_RESUSECOLLECTANDSOURCEBILL});
        if ((DIFF_COSTOBJECTANDSOURCEBILL.startsWith(taskName) || DIFF_PLANOUTPUTANDSOURCEBILL.startsWith(taskName) || DIFF_FACTOUTPUTANDSOURCEBILL.startsWith(taskName) || DIFF_MATUSECOLLECTANDSOURCEBILL.startsWith(taskName) || DIFF_RESUSECOLLECTANDSOURCEBILL.startsWith(taskName)) && accountOrg != null && period != null) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            Long org = accountOrg.getLong("id");
            Boolean isMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)org);
            ReportShowParameter showParameter = new ReportShowParameter();
            ReportQueryParam queryParam = new ReportQueryParam();
            map.put("org", org);
            map.put("startdate", period.getDate("begindate"));
            map.put("enddate", period.getDate("enddate"));
            if (DIFF_COSTOBJECTANDSOURCEBILL.startsWith(taskName)) {
                Set bizOrgs = CalcCheckHelper.getManuOrgIdsByEntity((IDataModel)this.getModel(), (Long)org, (String)"cad_costobject", (Boolean)isMulFactory, (String)appNum);
                showParameter.setFormId("cad_costobjectlogarithm");
                map.put("mulbizorg", bizOrgs);
            } else if (DIFF_PLANOUTPUTANDSOURCEBILL.startsWith(taskName)) {
                showParameter.setFormId("cad_collectnumcheck");
                map.put("multargetbill", "B");
            } else if (DIFF_FACTOUTPUTANDSOURCEBILL.startsWith(taskName)) {
                showParameter.setFormId("cad_collectnumcheck");
                map.put("multargetbill", "C");
            } else if (DIFF_MATUSECOLLECTANDSOURCEBILL.startsWith(taskName)) {
                showParameter.setFormId("cad_collectnumcheck");
                map.put("multargetbill", "E");
            } else if (DIFF_RESUSECOLLECTANDSOURCEBILL.startsWith(taskName)) {
                showParameter.setFormId("cad_collectnumcheck");
                map.put("multargetbill", "D");
            } else {
                return;
            }
            map.put("entryIds", this.getEntryId(org, true));
            map.put("entryIdSearchType", "1");
            showParameter.setCustomParams(map);
            showParameter.setQueryParam(queryParam);
            showParameter.setHasRight(true);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private Set<Long> getEntryId(Long org, boolean isGetJoinSide) {
        Object nextpageparaTag = this.getModel().getValue("nextpagepara_tag");
        if (nextpageparaTag != null) {
            try {
                ArrayList<Long> costobjectIds = new ArrayList<Long>(10);
                JSONObject jsonObject = JSONObject.fromObject((Object)nextpageparaTag);
                if (jsonObject.containsKey((Object)"checkCostObjectRange")) {
                    JSONArray arr = jsonObject.getJSONArray("checkCostObjectRange");
                    for (int i = 0; i < arr.size(); ++i) {
                        costobjectIds.add(Long.parseLong(String.valueOf(arr.get(i))));
                    }
                }
                if (!costobjectIds.isEmpty()) {
                    HashSet entryIds = Sets.newHashSetWithExpectedSize((int)10);
                    QFilter filter = new QFilter("id", "in", costobjectIds);
                    DataSet costObjects = QueryServiceHelper.queryDataSet((String)"cadcostobject", (String)"cad_costobject", (String)"probill,productgroup,id", (QFilter[])filter.toArray(), null);
                    HashSet mainObjects = Sets.newHashSet();
                    for (Row costObject : costObjects) {
                        Long productgroup;
                        Long proBill = costObject.getLong("probill");
                        if (!CadEmptyUtils.isEmpty((Long)proBill)) {
                            entryIds.add(proBill);
                        }
                        if (CadEmptyUtils.isEmpty((Long)(productgroup = costObject.getLong("productgroup")))) continue;
                        mainObjects.add(costObject.getLong("id"));
                    }
                    if (!mainObjects.isEmpty() && isGetJoinSide) {
                        filter = new QFilter("org", "=", (Object)org);
                        filter.and("producttype", "!=", (Object)"C");
                        filter.and("mainproobj", "in", (Object)mainObjects);
                        DataSet costobjectDs = QueryServiceHelper.queryDataSet((String)"ColDiffRptBase.queryObj", (String)"cad_costobject", (String)"probill", (QFilter[])filter.toArray(), null);
                        for (Row costObject : costobjectDs) {
                            Long proBill = costObject.getLong("probill");
                            if (CadEmptyUtils.isEmpty((Long)proBill)) continue;
                            entryIds.add(proBill);
                        }
                    }
                    return entryIds;
                }
            }
            catch (Exception ex) {
                logger.error("\u83b7\u53d6\u8303\u56f4\u6570\u636e\u62a5\u9519", (Throwable)ex);
            }
        }
        return null;
    }
}

