/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.calc;

import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CalcReportList
extends AbstractListPlugin {
    private FilterContainerInitArgs filterContainerInitArgs = null;

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        List acctOrgs = OrgHelper.getAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (acctOrgs.size() == 0) {
            return;
        }
        String orgId = this.getCurrOrgId(acctOrgs);
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            if (CadEmptyUtils.isEmpty((List)acctOrgs)) break;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List listcomitem = commonFilterColumn.getComboItems();
            switch (fieldName) {
                case "org.id": {
                    listcomitem.clear();
                    commonFilterColumn.setComboItems(acctOrgs);
                    commonFilterColumn.setDefaultValue(orgId);
                }
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("period")) {
            args.getQfilters().add(new QFilter("isadjustperiod", "=", (Object)false));
        }
    }

    private String getCurrOrgId(List<ComboItem> acctOrgs) {
        String orgId = this.getPageCache().get("orgId");
        if (orgId == null || "".equals(orgId)) {
            Object org = this.getView().getFormShowParameter().getCustomParam("orgId");
            if (org != null && !CadEmptyUtils.isEmpty((String)org.toString())) {
                orgId = org.toString();
            } else {
                Long currAcctOrg = RequestContext.get().getOrgId();
                boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)currAcctOrg, (String)"10");
                if (isAccounting) {
                    orgId = currAcctOrg + "";
                } else {
                    ComboItem comboItem = acctOrgs.get(0);
                    orgId = comboItem.getValue();
                }
            }
            this.getPageCache().put("orgId", orgId);
        }
        return orgId;
    }

    private String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customfilter = (List)filterValues.get("customfilter");
        if (customfilter == null || customfilter.isEmpty()) {
            return;
        }
        String accountorgId = "";
        for (int i = 0; i < customfilter.size(); ++i) {
            Map filter = (Map)customfilter.get(i);
            List listFieldName = (List)filter.get("FieldName");
            List listValue = (List)filter.get("Value");
            for (int j = 0; j < listFieldName.size(); ++j) {
                String fieldName;
                switch (fieldName = (String)listFieldName.get(j)) {
                    case "org.id": {
                        if (listValue == null || listValue.isEmpty()) {
                            return;
                        }
                        accountorgId = (String)listValue.get(j);
                        this.getPageCache().put("orgId", accountorgId);
                        this.filterContainerInit(this.filterContainerInitArgs);
                    }
                }
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter parameter = e.getParameter();
        Object pkId = parameter.getPkId();
        DynamicObject report = QueryServiceHelper.queryOne((String)"aca_calcreport", (String)"billtype", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
        if (report == null) {
            return;
        }
        if ("1".equals(report.getString("billtype"))) {
            parameter.setCaption(ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5\u62a5\u544a", (String)"CalcReportList_2", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        } else {
            parameter.setCaption(ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97\u62a5\u544a", (String)"CalcReportList_3", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        }
    }
}

