/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.calc;

import java.lang.reflect.Constructor;
import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.enums.AcaMutexEnum;
import kd.macc.aca.algox.task.TaskRunning;
import kd.macc.aca.algox.utils.AcaMutexHelper;
import kd.macc.cad.common.thread.TaskType;
import kd.macc.cad.common.thread.ThreadHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.InstanceAliveHelper;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class TaskRunningFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(TaskRunningFormPlugin.class);
    private static final String CHECKTASK_CLASS = "kd.macc.aca.algox.task.CheckTask";
    private static final String RUN_PROGRESSBARAP = "acaclacprogressbarap";
    private static final String CANCEL = "cancel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(RUN_PROGRESSBARAP);
        progressBar.addProgressListener((ProgresssListener)this);
        Button cancelBtn = (Button)this.getView().getControl(CANCEL);
        cancelBtn.addClickListener((ClickListener)this);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String itemKey = ((Control)evt.getSource()).getKey();
        if (CANCEL.equals(itemKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8f6c\u540e\u53f0\u8ba1\u7b97\u540e\u9700\u8981\u5728\u6210\u672c\u8ba1\u7b97\u62a5\u544a\u4e2d\u67e5\u8be2\u8ba1\u7b97\u7ed3\u679c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TaskRunningFormPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("aca_TaskRunningFormPlugin-close"));
            evt.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("aca_TaskRunningFormPlugin-close".equals(callBackId)) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes.getValue() == result.getValue()) {
                this.getView().close();
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String runningParaJS = this.getView().getFormShowParameter().getCustomParam("calcParam").toString();
        String taskConfigId = this.getView().getFormShowParameter().getCustomParam("taskConfigId").toString();
        this.start(runningParaJS, taskConfigId);
        String taskReocrdId = this.getPageCache().get("taskRecordId");
        DynamicObject taskRecord = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(taskReocrdId), (String)"sca_taskrecord");
        this.buildRunningParam(taskRecord);
    }

    public void onProgress(ProgressEvent paramProgressEvent) {
        String instanceId;
        String taskReocrdId = this.getPageCache().get("taskRecordId");
        DynamicObject taskRecord = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(taskReocrdId), (String)"sca_taskrecord", (String)"id,taskname,progress,status,nextpage,nextpagepara,entryentity.subname,entryentity.substarttime,entryentity.subtime,entryentity.substatus");
        paramProgressEvent.setProgress(taskRecord.getInt("progress"));
        this.buildRunningParam(taskRecord);
        int progress = taskRecord.getInt("progress");
        if ("3".equals(taskRecord.getString("status")) || "4".equals(taskRecord.getString("status")) || progress >= 100) {
            this.getView().close();
            this.nextpage(taskRecord);
        }
        if (!StringUtils.isEmpty((CharSequence)(instanceId = this.getPageCache().get("instanceId")))) {
            try {
                boolean isAlive = InstanceAliveHelper.isAlive((String)instanceId);
                if (!isAlive) {
                    Object calcReportId;
                    this.getView().close();
                    String costAccountId = this.getPageCache().get("costAccountId");
                    if (!CadEmptyUtils.isEmpty((String)costAccountId) && (calcReportId = this.getView().getFormShowParameter().getCustomParam("calcReportId")) != null && !CadEmptyUtils.isEmpty((String)calcReportId.toString())) {
                        DynamicObject calcReport = BusinessDataServiceHelper.loadSingle((Object)calcReportId, (String)"aca_calcreport", (String)"id,type");
                        if (calcReport != null && !"9".equals(calcReport.getString("type"))) {
                            calcReport.set("type", (Object)"9");
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcReport});
                        }
                        AcaMutexHelper.releaseMutex((AcaMutexEnum)AcaMutexEnum.CALC_CALCULATE, (long)Long.parseLong(costAccountId));
                    }
                    this.getView().showMessage(ResManager.loadKDString((String)"\u76d1\u63a7\u5230\u5bb9\u5668\u5728\u8ba1\u7b97\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e86\u91cd\u542f\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"TaskRunningFormPlugin_8", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Throwable e) {
                logger.error("TaskRunningFormPlugin error", e);
            }
        }
    }

    private void start(String runningParaJS, String taskConfigId) {
        String classpath;
        String taskRecordId = this.getView().getFormShowParameter().getCustomParam("taskRecordId").toString();
        String taskParam = this.getView().getFormShowParameter().getCustomParam("calcParam").toString();
        Object calcReportId = this.getView().getFormShowParameter().getCustomParam("calcReportId");
        this.getPageCache().put("taskRecordId", taskRecordId);
        this.getPageCache().put("taskConfigId", taskConfigId);
        if (calcReportId != null) {
            this.getPageCache().put("calcReportId", calcReportId.toString());
        }
        JSONObject taskParamJs = JSONObject.fromObject((Object)taskParam);
        taskParamJs.accumulate("taskRecordId", (Object)taskRecordId);
        taskParamJs.accumulate("calcReportId", calcReportId);
        taskParamJs.accumulate("appNum", (Object)this.getView().getFormShowParameter().getAppId());
        if (taskParamJs.get("costaccount") != null) {
            this.getPageCache().put("costAccountId", taskParamJs.getString("costaccount"));
        }
        if (taskParamJs.get("manuOrgId") != null) {
            this.getPageCache().put("manuOrgId", taskParamJs.getString("manuOrgId"));
        }
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(taskConfigId));
        DynamicObject taskConfig = BusinessDataServiceHelper.loadSingle((String)"sca_taskconfig", (String)"class", (QFilter[])new QFilter[]{filter});
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(RUN_PROGRESSBARAP);
        progressBar.setPercent(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c ...", (String)"TaskRunningFormPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        progressBar.start();
        String string = classpath = taskConfig == null ? CHECKTASK_CLASS : taskConfig.getString("class");
        if (CadEmptyUtils.isEmpty((String)classpath)) {
            return;
        }
        try {
            DynamicObject calcReport;
            Class<?> doClass = Class.forName(classpath);
            Constructor<?> con = doClass.getDeclaredConstructor(String.class);
            TaskRunning taskRunning = (TaskRunning)con.newInstance(taskParamJs.toString());
            String instanceId = Instance.getInstanceId();
            if ("true".equals(CadBgParamUtils.getCadBgParamForString((String)"serverIsAliveTest", (String)"true"))) {
                this.getPageCache().put("instanceId", instanceId);
            }
            if (calcReportId != null && !CadEmptyUtils.isEmpty((String)calcReportId.toString()) && (calcReport = BusinessDataServiceHelper.loadSingle((Object)calcReportId, (String)"aca_calcreport", (String)"id,instanceid")) != null) {
                calcReport.set("instanceid", (Object)instanceId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcReport});
            }
            ThreadHelper.execute((Runnable)taskRunning, (TaskType)TaskType.ACA_CALC_PROCESS);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private void buildRunningParam(DynamicObject taskRecord) {
        String taskname = taskRecord.getString("taskname");
        int doneStep = 0;
        String doingStep = ResManager.loadKDString((String)"\u6267\u884c\u4e2d", (String)"TaskRunningFormPlugin_2", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        DynamicObjectCollection taskRecordEntrys = taskRecord.getDynamicObjectCollection("entryentity");
        JSONArray taskDetailInfos = new JSONArray();
        for (DynamicObject entry : taskRecordEntrys) {
            JSONObject taskDetailInfo = new JSONObject();
            String status = entry.getString("substatus");
            if ("7".equals(entry.getString("substatus"))) {
                status = "4";
            }
            taskDetailInfo.accumulate("status", (Object)status);
            taskDetailInfo.accumulate("name", entry.get("subname"));
            if ("3".equals(entry.getString("substatus")) || "4".equals(entry.getString("substatus")) || "7".equals(entry.getString("substatus"))) {
                ++doneStep;
            }
            if ("2".equals(entry.getString("substatus"))) {
                doingStep = entry.getString("subname");
                break;
            }
            taskDetailInfos.add((Object)taskDetailInfo);
        }
        CustomControl taskRunningUI = (CustomControl)this.getView().getControl("tasksteps");
        JSONObject taskRunningUIPara = new JSONObject();
        taskRunningUIPara.accumulate("doneStep", doneStep);
        taskRunningUIPara.accumulate("totalStep", taskRecordEntrys.size());
        taskRunningUIPara.accumulate("doingStep", (Object)doingStep);
        taskRunningUIPara.accumulate("taskname", (Object)taskname);
        taskRunningUIPara.accumulate("taskDetailInfos", (Object)taskDetailInfos.toString());
        taskRunningUI.setData((Object)taskRunningUIPara.toString());
        Label currstep = (Label)this.getView().getControl("currsteplab");
        currstep.setText(doneStep + "/" + taskRecordEntrys.size() + doingStep);
    }

    private void nextpage(DynamicObject taskRecord) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)taskRecord.getString("nextpage"));
        Object lsp = null;
        lsp = mainEntityType instanceof BillEntityType ? new BillShowParameter() : new FormShowParameter();
        String calcRecordId = this.getPageCache().get("calcReportId");
        String nextPageFormId = taskRecord.getString("nextpage");
        lsp.setFormId(nextPageFormId);
        lsp.setCaption(this.getCaption(nextPageFormId));
        lsp.setCustomParam("custparam", (Object)taskRecord.getString("nextpagepara"));
        lsp.setCustomParam("calcrecordid", (Object)calcRecordId);
        lsp.setCustomParam("checkResultId", (Object)taskRecord.getLong("id"));
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private String getCaption(String formId) {
        String caption = ResManager.loadKDString((String)"\u62a5\u544a", (String)"TaskRunningFormPlugin_5", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        switch (formId) {
            case "aca_terminalcalcend": {
                caption = ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97\u62a5\u544a", (String)"TaskRunningFormPlugin_6", (String)"macc-aca-formplugin", (Object[])new Object[0]);
                break;
            }
            case "aca_calcreport": {
                caption = ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5\u62a5\u544a", (String)"TaskRunningFormPlugin_7", (String)"macc-aca-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return caption;
    }
}

