/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.calc;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.aca.algox.constants.TerminalCalcCheck;
import kd.macc.aca.algox.enums.AcaMutexEnum;
import kd.macc.aca.algox.utils.AcaAlgoxTimeUtils;
import kd.macc.aca.algox.utils.AcaMutexHelper;
import kd.macc.aca.algox.utils.TaskHelper;
import kd.macc.aca.common.enums.TerminalCalcEnum;
import kd.macc.aca.common.helper.AcaCloseAccountHelper;
import kd.macc.aca.common.helper.AcaCostAccountHelper;
import kd.macc.aca.formplugin.base.SchemeSettingPlugin;
import kd.macc.cad.common.enums.ValidityCheckTypeEnum;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import net.sf.json.JSONObject;

public class TerminalCalcWizards
extends SchemeSettingPlugin {
    public TerminalCalcWizards() {
        super(null, Arrays.asList("org", "costaccount", "period", "manuorg", "currency"), false);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgControl = (BasedataEdit)this.getControl("org");
        orgControl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
            List<Long> hasPermAccountOrgIds = this.getHasPermAccountOrgIds();
            QFilter orgIdsFilter = new QFilter("id", "in", hasPermAccountOrgIds);
            listFilterParameter.setFilter(orgIdsFilter);
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List filters = filterParameter.getQFilters();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"TerminalCalcWizards_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            filters.add(StartCostHelper.getEndInitCostAccountIdsFilter((Long)((Long)org.getPkValue()), (String)"aca"));
        });
        BasedataEdit manuOrg = (BasedataEdit)this.getControl("manuorg");
        manuOrg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            List manuIdList = Lists.newArrayList();
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"TerminalCalcWizards_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            manuIdList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId(), (String)"4730fc9f000025ae", (String)this.getView().getFormShowParameter().getAppId());
            qList.add(new QFilter("id", "in", (Object)manuIdList));
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initData();
        this.initCalpolicy();
        this.changManuorgStatus();
        this.initScheme();
    }

    private void initScheme() {
        String showCalScheme = CadBgParamUtils.getCadBgParamForString((String)"showCalScheme", (String)"0");
        this.getView().setVisible(Boolean.valueOf("1".equals(showCalScheme)), new String[]{"calscheme"});
    }

    private void initCalpolicy() {
        DynamicObject dyo = (DynamicObject)this.getModel().getValue("costaccount");
        if (dyo != null) {
            BasedataEdit manuorgEdit = (BasedataEdit)this.getControl("manuorg");
            if (CostAccountHelper.isEnableMulFactory((Long)dyo.getLong("id"))) {
                manuorgEdit.setMustInput(true);
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"manuorg"});
            } else {
                manuorgEdit.setMustInput(false);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"manuorg"});
                this.getModel().setValue("manuorg", null);
                this.getView().updateView("manuorg");
            }
        }
    }

    protected String getBillEntityId() {
        return this.getView().getEntityId();
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            switch (e.getOperateKey()) {
                case "calc": {
                    this.doCalc();
                    break;
                }
                case "check": {
                    this.doCheck();
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName;
        super.propertyChanged(e);
        switch (proName = e.getProperty().getName()) {
            case "org": {
                this.initData();
                this.initCalpolicy();
                this.changManuorgStatus();
                break;
            }
            case "costaccount": {
                this.setOrgByCostAccount();
                this.setCurrency();
                this.setPeriod();
                this.initCalpolicy();
            }
        }
    }

    private void doCalc() {
        if (!this.conditionVilidator(TerminalCalcEnum.TERMINAL_CALC)) {
            return;
        }
        this.setPeriod();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        String orgName = org.getLocaleString("name").getLocaleValue();
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        Long costAccountId = costAccount.getLong("id");
        boolean enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)costAccountId);
        DynamicObject manuorg = (DynamicObject)this.getModel().getValue("manuorg");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        long manuOrgId = 0L;
        String manuStr = "";
        String lockStr = "";
        if (enableMulFactory) {
            if (manuorg == null) {
                return;
            }
            manuStr = String.valueOf(manuorg.getLong("id"));
            lockStr = costAccountId + manuStr;
            manuOrgId = manuorg.getLong("id");
            List closeAccounts = AcaCloseAccountHelper.isCloseAccount((Long)org.getLong("id"), (Long)costAccountId, (Long)manuOrgId, (Long)period.getLong("id"), (String)this.getBillEntityId());
            if (closeAccounts != null && closeAccounts.size() > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3001\u6210\u672c\u8d26\u7c3f\u3001\u751f\u4ea7\u7ec4\u7ec7\u5728\u5f53\u524d\u671f\u95f4\u5df2\u5173\u8d26\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"TerminalCalcWizards_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        try {
            String lockErrStr = AcaMutexHelper.requireMutex((AcaMutexEnum)AcaMutexEnum.CALC_CALCULATE, (long)costAccountId);
            if (StringUtils.isNotEmpty((String)lockErrStr)) {
                this.getView().showErrorNotification(String.format(lockErrStr, orgName));
                return;
            }
            String calcParam = this.buildCalcParam();
            if (CadEmptyUtils.isEmpty((String)calcParam)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6838\u7b97\u8303\u56f4\uff0c\u4e0d\u80fd\u7ee7\u7eed\u671f\u672b\u6210\u672c\u7ed3\u7b97\u3002", (String)"TerminalCalcWizards_2", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                return;
            }
            JSONObject calcParamJs = JSONObject.fromObject((Object)calcParam);
            Long calcTaskConfigId = TerminalCalcCheck.CALCTASKID;
            calcParamJs.accumulate("checkConfigId", (Object)TerminalCalcCheck.CALCCHECKCONFIGID);
            TaskHelper.startTask((IFormView)this.getView(), (IDataModel)this.getModel(), (Long)calcTaskConfigId, (String)calcParamJs.toString(), (String)"2");
        }
        catch (Exception e) {
            AcaMutexHelper.releaseMutex((AcaMutexEnum)AcaMutexEnum.CALC_CALCULATE, (long)costAccountId);
            throw new KDBizException(e.getMessage());
        }
    }

    private void doCheck() {
        if (!this.conditionVilidator(TerminalCalcEnum.TERMINAL_CHECK)) {
            return;
        }
        String checkParam = this.buildCalcParam();
        if (CadEmptyUtils.isEmpty((String)checkParam)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6838\u7b97\u8303\u56f4\uff0c\u4e0d\u80fd\u7ee7\u7eed\u5408\u6cd5\u6027\u68c0\u67e5\u3002", (String)"TerminalCalcWizards_3", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId("cad_checktasksetting");
        lsp.setCustomParam("checktype", (Object)ValidityCheckTypeEnum.CHECK_TER.getValue());
        lsp.setCustomParam("calcParam", (Object)checkParam);
        lsp.setCustomParam("calType", (Object)"aca_terminalcalwizards");
        lsp.setCaption(ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"TerminalCalcWizards_14", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(lsp);
    }

    private String buildCalcParam() {
        DynamicObject manuOrg;
        JSONObject calcParamJs = new JSONObject();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        calcParamJs.accumulate("org", org.getLong("masterid"));
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        calcParamJs.accumulate("costaccount", costAccount.getLong("id"));
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        if (period != null) {
            calcParamJs.accumulate("period", period.getLong("id"));
            calcParamJs.accumulate("startDate", (Object)AcaAlgoxTimeUtils.formatDate((Date)period.getDate("begindate"), (String)"yyyy-MM-dd HH:mm:ss"));
            calcParamJs.accumulate("endDate", (Object)AcaAlgoxTimeUtils.formatDate((Date)period.getDate("enddate"), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if ((manuOrg = (DynamicObject)this.getModel().getValue("manuorg")) != null) {
            calcParamJs.accumulate("manuOrgId", manuOrg.getLong("id"));
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        calcParamJs.accumulate("currencyId", currency.getLong("masterid"));
        calcParamJs.accumulate("allinvmatcalout", this.getModel().getValue("allinvmatcalout"));
        calcParamJs.accumulate("calcreduct", this.getModel().getValue("calcreduct"));
        calcParamJs.accumulate("calccmpanal", this.getModel().getValue("calccmpanal"));
        calcParamJs.accumulate("conversionsubdetail", this.getModel().getValue("conversionsubdetail"));
        calcParamJs.accumulate("nestmatcheck", this.getModel().getValue("nestmatcheck"));
        calcParamJs.accumulate("matlevelonecalout", this.getModel().getValue("matlevelonecalout"));
        calcParamJs.accumulate("nestmatautorework", this.getModel().getValue("nestmatautorework"));
        calcParamJs.accumulate("importfacttransfer", this.getModel().getValue("importfacttransfer"));
        calcParamJs.accumulate("calcsize", this.getModel().getValue("calcsize"));
        calcParamJs.accumulate("negaunitpricedeal", this.getModel().getValue("negaunitpricedeal"));
        DynamicObject calScheme = (DynamicObject)this.getModel().getValue("calscheme");
        if (calScheme != null) {
            calcParamJs.accumulate("calSchemeId", calScheme.getLong("id"));
        }
        calcParamJs.accumulate("onlycheckresult", this.getModel().getValue("onlycheckresult"));
        return calcParamJs.toString();
    }

    private boolean conditionVilidator(TerminalCalcEnum terminalType) {
        String operationName = "";
        operationName = TerminalCalcEnum.TERMINAL_CALC.getValue().equals(terminalType.getValue()) ? ResManager.loadKDString((String)"\u8ba1\u7b97\u5931\u8d25\u3002", (String)"TerminalCalcWizards_4", (String)"macc-aca-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\u5931\u8d25\u3002", (String)"TerminalCalcWizards_5", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"TerminalCalcWizards_10", (String)"macc-aca-formplugin", (Object[])new Object[0]), operationName));
            return false;
        }
        DynamicObject acct = this.getModel().getDataEntity().getDynamicObject("costaccount");
        if (acct == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u6210\u672c\u8d26\u7c3f\u4e3a\u7a7a\u3002", (String)"TerminalCalcWizards_11", (String)"macc-aca-formplugin", (Object[])new Object[0]), operationName));
            return false;
        }
        DynamicObject costaccountDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)acct.getLong("id"), (String)"cal_bd_costaccount");
        if (costaccountDyn == null || !costaccountDyn.getBoolean("enable")) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u8d26\u7c3f\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TerminalCalcWizards_15", (String)"macc-aca-formplugin", (Object[])new Object[0]), operationName));
            return false;
        }
        boolean isInit = StartCostHelper.isInit((Long)((Long)acct.getPkValue()), (String)this.getView().getFormShowParameter().getAppId());
        if (!isInit) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u8d26\u7c3f\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"TerminalCalcWizards_12", (String)"macc-aca-formplugin", (Object[])new Object[0]), operationName));
            return false;
        }
        DynamicObject period = this.getModel().getDataEntity().getDynamicObject("period");
        if (period == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u6838\u7b97\u671f\u95f4\u4e3a\u7a7a\u3002", (String)"TerminalCalcWizards_13", (String)"macc-aca-formplugin", (Object[])new Object[0]), operationName));
            return false;
        }
        return true;
    }

    private void setPeriod() {
        DynamicObject periodDyn;
        QFilter qfCostAccount;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (org == null || costaccount == null) {
            return;
        }
        QFilter qfOrg = new QFilter("org", "=", (Object)org.getLong("id"));
        DynamicObject sysCtrlEntity = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"id, entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costaccount.getLong("id"))});
        if (sysCtrlEntity != null && ((periodDyn = this.getModel().getDataEntity().getDynamicObject("period")) == null || sysCtrlEntity.getLong("currentperiod") != periodDyn.getLong("id"))) {
            this.getModel().setValue("period", (Object)sysCtrlEntity.getLong("currentperiod"));
        }
    }

    private void setOrgByCostAccount() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            return;
        }
        DynamicObject account = (DynamicObject)this.getModel().getValue("costaccount");
        if (account == null) {
            return;
        }
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingle((Object)account.getPkValue(), (String)"cal_bd_costaccount");
        this.getModel().setValue("org", costAccount != null ? Long.valueOf(costAccount.getLong("calorg.id")) : null);
    }

    private void initData() {
        Long accountOrgId = this.getDefaultOrg();
        this.getModel().setValue("org", (Object)accountOrgId);
        Long costAccountId = AcaCostAccountHelper.getCostAccountByAccoutOrgId((Long)accountOrgId);
        if (costAccountId != 0L) {
            this.getModel().setValue("costaccount", (Object)costAccountId);
        } else {
            this.getModel().setValue("costaccount", null);
        }
        DynamicObject periodId = PeriodHelper.getCurrentPeriod((Long)costAccountId);
        this.getModel().setValue("period", (Object)periodId);
        this.setCurrency();
        this.setCloseAccount();
    }

    private void setCloseAccount() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            return;
        }
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        if (period == null) {
            return;
        }
        Long calsystem = costAccount.getLong("calsystem.id");
        QFilter qfOrg = new QFilter("bizorgentry.bizorg", "<>", (Object)0L);
        qfOrg.and("bizorgentry.bizacctorg", "=", org.getPkValue());
        DynamicObject accSys = BusinessDataServiceHelper.loadSingle((Object)calsystem, (String)"bd_accountingsys");
        if (accSys == null) {
            return;
        }
        Long ownerIds = accSys.getLong("bizorgentry.bizorg");
        QFilter q = new QFilter("owner", "=", (Object)ownerIds);
        q.and("isleaf", "=", (Object)Boolean.TRUE);
        DynamicObject infos = BusinessDataServiceHelper.loadSingle((String)"cal_closeaccounttable", (String)"owner,closedate", (QFilter[])new QFilter[]{q});
        if (infos == null) {
            return;
        }
        Date colseDate = infos.getDate("closedate");
        if (colseDate == null) {
            return;
        }
        if (period.getDate("begindate").compareTo(colseDate) <= 0) {
            this.getView().getModel().setValue("closeaccount", (Object)Boolean.TRUE);
        }
    }

    private void setCurrency() {
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costaccount == null) {
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
    }

    private Long getDefaultOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return org.getLong("masterid");
        }
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        if (isaccount) {
            return currentOrgId;
        }
        return 0L;
    }

    private List<Long> getHasPermAccountOrgIds() {
        List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId())).getHasPermOrgs();
        List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"10");
        if (CadEmptyUtils.isEmpty((List)permOrgIds) && CadEmptyUtils.isEmpty((List)orgIds)) {
            orgIds = OrgUnitServiceHelper.getAllOrg((String)"10");
        }
        return orgIds;
    }

    private void changManuorgStatus() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)accountorg.getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }
}

