/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.calc;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.aca.algox.utils.TaskHelper;
import kd.macc.cad.common.utils.WriteLogUtils;
import net.sf.json.JSONObject;

public class TerminalCheckItem
extends AbstractBillPlugIn {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.bindCheckItem();
    }

    private void bindCheckItem() {
        this.getModel().deleteEntryData("entryentity");
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object checkType = fsp.getCustomParam("checktype");
        if (checkType == null) {
            return;
        }
        QFilter fnumber = new QFilter("number", "=", (Object)"Aca-TerminalCalcCheck");
        DynamicObjectCollection checkConfig = QueryServiceHelper.query((String)"sca_taskconfig", (String)"id,entryentity.subname desc", (QFilter[])new QFilter[]{fnumber});
        for (DynamicObject config : checkConfig) {
            int curIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("desc", (Object)config.getString("desc"), curIndex);
        }
        this.getView().updateView("entryentity");
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty((DynamicObjectCollection)checkConfig)) {
            this.getPageCache().put("taskConfigId", ((DynamicObject)checkConfig.get(0)).getString("id"));
            this.getPageCache().put("checkConfigId", ((DynamicObject)checkConfig.get(0)).getString("id"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            switch (e.getOperateKey()) {
                case "check": {
                    this.doCheck();
                }
            }
        }
    }

    private void doCheck() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        JSONObject checkParamJs = JSONObject.fromObject((Object)fsp.getCustomParam("checkParam").toString());
        checkParamJs.accumulate("checktype", fsp.getCustomParam("checktype"));
        checkParamJs.accumulate("checkConfigId", (Object)this.getPageCache().get("checkConfigId"));
        Long calcTaskConfigId = Long.valueOf(this.getPageCache().get("taskConfigId"));
        TaskHelper.startTask((IFormView)this.getView(), (Long)calcTaskConfigId, (String)checkParamJs.toString());
        String opType = ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5", (String)"TerminalCheckItem_0", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u671f\u672c\u6210\u672c\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"TerminalCheckItem_1", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"aca_checkitem", (IDataModel)this.getModel());
    }
}

